package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author Danny.Wang
 * @title SalesmanInfoRepo
 * @Date2023/2/21 16:08
 */
@Repository
public interface SalesmanInfoRepo extends JpaRepository<SalesmanInfoDO, Long>, QuerydslPredicateExecutor<SalesmanInfoDO> {

    SalesmanInfoDO findBySalesmanNo(String salesmanNo);

    List<SalesmanInfoDO> findBySalesmanNoIn(List<String> salesmanNos);

    SalesmanInfoDO findByLoginAccount(String loginAccount);

    List<SalesmanInfoDO> findByLoginAccountIn(List<String> loginAccount);

    List<SalesmanInfoDO> findBySalesmanType(String type);


}
