package com.elitesland.yst.production.sale.rmi.ystsystem;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysTaxRateRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 系统域通用模块接口
 *
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/3 9:48 上午
 */
@Component
@Slf4j
public class RmiCommonService {

    @Autowired
    private SysCurrencyRpcService sysCurrencyRpcService;

    @Autowired
    private SysTaxRateRpcService sysTaxRateRpcService;

    /**
     * 获取税率信息列表
     */
    public List<SysTaxRateRespDTO> queryList(SysTaxRateQueryDTO sysTaxRateQueryDTO) {
        try {
            ApiResult<List<SysTaxRateRespDTO>> sysTaxRateRespDTOListApiResult = sysTaxRateRpcService.queryList(sysTaxRateQueryDTO);
            Assert.notNull(sysTaxRateRespDTOListApiResult,"调用税率查询失败");
            Assert.isTrue(sysTaxRateRespDTOListApiResult.isSuccess(),"调用税率查询失败");
            return sysTaxRateRespDTOListApiResult.getData();
        }catch (Exception e) {
            log.error("远程调用系统域税率相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用系统域税率相关服务异常"+e,e);
        }
    }


//    @DubboReference(check = false, timeout = 10000)
//    private ComCurrRpcService comCurrRpcService;
//    @DubboReference(check = false, timeout = 10000)
//    private ComTaxRateRpcService comTaxRateRpcService;

//    /**
//     * 获取币种信息列表
//     * @param param
//     * @return
//     */
//    public List<ComCurrRpcDTO> findCurrDtoByParam(ComCurrRpcDtoParam param){
//        try {
//         //   return comCurrRpcService.findRpcDtoByParam(param);
//            return null;
//        }catch (Exception e) {
//            log.error("远程调用系统域货币相关服务异常:{}", e.getMessage());
//            throw new BusinessException("远程调用系统域货币相关服务异常"+e,e);
//        }
//    }
//
//    /**
//     * 获取币种信息列表
//     */
//    public List<ComCurrRpcDTO> findCurrDtoList(List<String> currCodes){
//        if (CollUtil.isNotEmpty(currCodes)) {
//            var comCurrRpcDtoParam = new ComCurrRpcDtoParam();
//            comCurrRpcDtoParam.setCurrCodes(currCodes);
//            return findCurrDtoByParam(comCurrRpcDtoParam);
//        }
//        return new ArrayList<>(0);
//    }
//
//    /**
//     * 获取币种信息列表
//     */
//    public List<ComCurrRpcDTO> findCurrDto2List(List<String> currNames){
//        if (CollUtil.isNotEmpty(currNames)) {
//            var comCurrRpcDtoParam = new ComCurrRpcDtoParam();
//            comCurrRpcDtoParam.setCurrNames(currNames);
//            return findCurrDtoByParam(comCurrRpcDtoParam);
//        }
//        return new ArrayList<>(0);
//    }
//
//    /**
//     * 获取税率信息列表
//     * @param param
//     * @return
//     */
//    public List<ComTaxRateRpcDTO> findTaxRateRpcDtoByParam(ComTaxRateRpcDtoParam param) {
//        try {
// //           return comTaxRateRpcService.findTaxRateRpcDtoByParam(param);
//            return null;
//        }catch (Exception e) {
//            log.error("远程调用系统域税率相关服务异常:{}", e.getMessage());
//            throw new BusinessException("远程调用系统域税率相关服务异常"+e,e);
//        }
//    }
//
//    /**
//     * 获取税率信息列表
//     * @param taxRateNos
//     * @return
//     */
//    public List<ComTaxRateRpcDTO> findTaxRateList(List<String> taxRateNos) {
//        if (CollUtil.isEmpty(taxRateNos)) {
//            return new ArrayList<>(0);
//        }
//        ComTaxRateRpcDtoParam comTaxRateRpcDtoParam = new ComTaxRateRpcDtoParam();
//        comTaxRateRpcDtoParam.setTaxRateNos(taxRateNos);
//        return this.findTaxRateRpcDtoByParam(comTaxRateRpcDtoParam);
//    }
//
//    /**
//     * 获取税率信息列表
//     * @param taxRates
//     * @return
//     */
//    public List<ComTaxRateRpcDTO> findTaxCodeList(List<BigDecimal> taxRates) {
//        if (CollUtil.isEmpty(taxRates)) {
//            return new ArrayList<>(0);
//        }
//        ComTaxRateRpcDtoParam comTaxRateRpcDtoParam = new ComTaxRateRpcDtoParam();
//        List<Double> doubleTaxRate = taxRates.stream().map(tax -> tax.doubleValue()).collect(Collectors.toList());
//        comTaxRateRpcDtoParam.setTaxRates(doubleTaxRate);
//        return this.findTaxRateRpcDtoByParam(comTaxRateRpcDtoParam);
//    }

    /**
     * 获取币种信息列表
     */
    public List<SysCurrencyRespDTO> listByCodes(Set<String> currNames) {
        ApiResult<List<SysCurrencyRespDTO>> sysCurrencyRespDTOListApiResult = sysCurrencyRpcService.listByCodes(currNames);
        Assert.notNull(sysCurrencyRespDTOListApiResult,"查询币种失败");
        Assert.isTrue(sysCurrencyRespDTOListApiResult.isSuccess(),"查询币种失败");
        return sysCurrencyRespDTOListApiResult.getData();
    }



}
