package com.elitesland.yst.production.sale.search.bean;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.DbType;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/07/06
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "经销商销售业绩")
@SearchBean(tables = "sale_statistics_dealer sd",
        autoMapTo = "sd"
        ,groupBy = "sd.item_type3,sd.vehicle_type,yearMonthInt"

)
public class StatisticsDealerAppDetailsSearchBean extends BasicsBean{

    private static final long serialVersionUID = -7520712483220937029L;

    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;
    @ApiModelProperty("统计月份(yyyy-MM)")
    @DbField(value = "DATE_FORMAT(sd.doc_time, '%Y-%m')", alias = "docMonth")
    private String docMonth;
    @ApiModelProperty("统计日期(yyyy-MM-dd)")
    @DbField(value = "DATE_FORMAT(sd.doc_time, '%Y-%m-%d')", alias = "docDate")
    private String docDate;
    /* @ApiModelProperty("统计月份(yyyyMM)")
     @DbField(value = "DATE_FORMAT(sd.doc_time, '%Y%m')", alias="yearMonth",type= DbType.INT)
     private String yearMonth;*/
    @ApiModelProperty("统计月份(yyyyMM)")
    @DbField(value = "DATE_FORMAT(sd.doc_time, '%Y%m')", alias = "yearMonthInt", type = DbType.INT)
    private Integer yearMonthInt;


    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    @ApiModelProperty("区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    @DbIgnore
    private String regionName;

    @ApiModelProperty("类型")
    @SysCode(sys = "yst-sale", mod = "STATISTICS_TYPE")
    private String type;
    @DbIgnore
    private String typeName;

    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    @ApiModelProperty("车型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String vehicleType;
    @DbIgnore
    private String vehicleTypeName;

    @ApiModelProperty("出货量")
    private BigDecimal shipQty;
    @ApiModelProperty("汇总出货量")
    @DbField("sum(sd.ship_qty)")
    private BigDecimal shipTotalQty;

    @ApiModelProperty("订货量")
    private BigDecimal orderQty;
    @ApiModelProperty("汇总订货量")
    @DbField("sum(sd.order_qty)")
    private BigDecimal orderTotalQty;

    @ApiModelProperty("客户类型")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    @DbIgnore
    private String custTypeName;

    @ApiModelProperty("整车类型")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    @DbIgnore
    private String itemType3Name;


    /******************************************/
    /*@ApiModelProperty("关联id")
    @DbField("ssd.mas_id")
    private Long masId;

    @ApiModelProperty("层级：  0——默认是客户所属的业务员  1、2、...——依次往上查询上级赋值")
    @DbField("ssd.level")
    private String level;

    @ApiModelProperty("业务员编码")
    @DbField("ssd.code")
    private String code;

    @ApiModelProperty("业务员名称")
    @DbField("ssd.name")
    private String name;

    @ApiModelProperty("用户id")
    @DbField("ssd.user_id")
    private Long userId;*/
}
