package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.sale.api.service.CrmCustOuService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustOuParamVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuParamSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuSaveVO;
import com.elitesland.yst.production.sale.convert.CrmCustOuConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.CrmCustOuDO;
import com.elitesland.yst.production.sale.entity.QCrmCustOuDO;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepo;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepoProc;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/27 12:47
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustOuServiceImpl extends BaseServiceImpl implements CrmCustOuService {

    private static final QCrmCustOuDO Q_CRM_CUST_OUDO = QCrmCustOuDO.crmCustOuDO;

    private final RmiOrgEmpService rmiOrgEmpService;

    private final CrmCustOuRepo crmCustOuRepo;

    private final CrmCustRepoProc crmCustRepoProc;

    private final CrmCustOuRepoProc crmCustOuRepoProc;

    @Override
    public List<CrmCustOuSaveVO> search(CrmCustOuParamVO searchParam) {
        var jpaQuery = this.select(searchParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return new ArrayList<>();
        }
        // 添加分页和排序
        List<CrmCustOuSaveVO> respVoS = jpaQuery.fetch();
        // 补充数据
        if (StringUtils.isEmpty(searchParam.getIfTrans()) || Boolean.TRUE.equals(searchParam.getIfTrans())){
            this.translatePage(respVoS);
        }
        return respVoS;
    }

    private void translatePage(List<CrmCustOuSaveVO> respVOList) {

        List<Long> agentEmpIds = respVOList.stream().map(CrmCustOuSaveVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<OrgEmpRpcDTO> empDtoByParam = new ArrayList<>();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            try {
                empDtoByParam = rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            } catch (Exception e) {
                log.error("dubbo访问emp查询接口失败：" + e.getMessage());
                throw new BusinessException("dubbo服务调用支持域查询员工接口出错");
            }
        }

        List<OrgEmpRpcDTO> finalEmpDtoByParam = empDtoByParam;
        respVOList.forEach(emp -> finalEmpDtoByParam.stream().filter(empDto -> empDto.getId().equals(emp.getAgentEmpId()))
                .findFirst()
                .ifPresent(empName -> emp.setAgentEmpName(empName.getEmpName())));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> save(CrmCustOuParamSaveVO saveVo) {
        //全删数据
        crmCustOuRepo.deleteByCustCode(saveVo.getCustCode());
        //全插数据
        if (!CollectionUtils.isEmpty(saveVo.getCrmCustOuSaveVOS())) {
            List<CrmCustOuSaveVO> crmCustOuSaveVoS = saveVo.getCrmCustOuSaveVOS();
            List<Long> ouIdList = crmCustOuSaveVoS.stream().map(CrmCustOuSaveVO::getOuId).distinct().collect(Collectors.toList());
            Assert.isFalse(ouIdList.size() != crmCustOuSaveVoS.size(), "请不要同时添加相同的公司");
            crmCustOuSaveVoS.forEach(save -> {
                save.setCustCode(saveVo.getCustCode());
                Assert.isFalse(crmCustRepoProc.existsCodeAndOuId(saveVo.getCustCode(), save.getOuId()), "该客户已经属于" + save.getOuName() + "公司");
                Assert.isFalse(crmCustOuRepoProc.existsCodeAndOuId(saveVo.getCustCode(), save.getOuId()), "该公司已经存在于表中");
            });
            List<CrmCustOuDO> crmCustOuDoS = crmCustOuSaveVoS.stream().map(CrmCustOuConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
            crmCustOuRepo.saveAll(crmCustOuDoS);
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> deleteById(Long id) {
        crmCustOuRepo.deleteById(id);
        return ApiResult.ok();
    }

    public JPAQuery<CrmCustOuSaveVO> select(CrmCustOuParamVO searchParam) {
        if (ObjectUtils.isEmpty(searchParam)) {
            return new JPAQuery<>();
        }
        val jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustOuSaveVO.class,
                Q_CRM_CUST_OUDO.id,
                Q_CRM_CUST_OUDO.ouId,
                Q_CRM_CUST_OUDO.ouCode,
                Q_CRM_CUST_OUDO.custCode,
                Q_CRM_CUST_OUDO.ouName,
                Q_CRM_CUST_OUDO.buId,
                Q_CRM_CUST_OUDO.buCode,
                Q_CRM_CUST_OUDO.buName,
                Q_CRM_CUST_OUDO.agentEmpId

        )).from(Q_CRM_CUST_OUDO);
        jpaQuery.where(where(searchParam));
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(CrmCustOuParamVO param) {

        Predicate predicate = Q_CRM_CUST_OUDO.isNotNull();
        if (!StringUtils.isEmpty(param.getCustCode())) {
            predicate = ExpressionUtils.and(predicate, Q_CRM_CUST_OUDO.custCode.eq(param.getCustCode()));
        }
        if (!StringUtils.isEmpty(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, Q_CRM_CUST_OUDO.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getAgentEmpId())) {
            predicate = ExpressionUtils.and(predicate, Q_CRM_CUST_OUDO.agentEmpId.eq(param.getAgentEmpId()));
        }
        if (!CollectionUtils.isEmpty(param.getAgentEmpIds())) {
            predicate = ExpressionUtils.and(predicate, Q_CRM_CUST_OUDO.agentEmpId.in(param.getAgentEmpIds()));
        }
        return predicate;
    }
}
