package com.elitesland.yst.production.sale.service;


import cn.hutool.core.collection.IterUtil;
import com.elitesland.yst.production.sale.api.service.FirstSpecialItemService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.special.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.FirstSpecialItemVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.FirstSpecialVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.BusFirstMenuConfDRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialItemRepo;
import com.elitesland.yst.production.sale.repo.FirstSpecialRepo;
import com.elitesland.yst.production.sale.repo.ZoneSettingDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 首单特惠
 * </p>
 *
 * @author
 * @since
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class FirstSpecialItemServiceImpl implements FirstSpecialItemService {

    private final FirstSpecialItemRepo firstSpecialItemRepo;

    private final OrgEmpRpcService orgEmpRpcService;

    private final BipItemRepo bipItemRepo;

    private final BipItemAppService bipItemAppService;

    private final FirstSpecialRepo firstSpecialRepo;

    private final ZoneSettingDRepo zoneSettingDRepo;

    private final BusFirstMenuConfDRepo busFirstMenuConfDRepo;

    private final BipOrderService bipOrderService;

    private final BipCartRepoProc bipCartRepoProc;

    private final BipOrderRepo bipOrderRepo;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> save(FirstSpecialItemSaveParam param) {
        OrgUserEmpInfoRpcDTO orgUserEmpInfoRpcDTO = getCurrentEmpInfo();
        if(null != param){
            //新增
            if(null == param.getId() || param.getId() < 0){
                FirstSpecialDO firstSpecialDO = new FirstSpecialDO();
                BeanUtils.copyProperties(param,firstSpecialDO);
                firstSpecialDO.setOuId(orgUserEmpInfoRpcDTO.getOuId());
                firstSpecialDO.setOuCode(orgUserEmpInfoRpcDTO.getOuCode());
                firstSpecialDO.setOuName(orgUserEmpInfoRpcDTO.getOuName());
                firstSpecialDO = firstSpecialRepo.save(firstSpecialDO);
                if(null != param.getList() && !param.getList().isEmpty()){
                    List<FirstSpecialItemVO> list = param.getList();
                    FirstSpecialDO finalFirstSpecialDO = firstSpecialDO;
                    list.stream().forEach(l ->{
                        FirstSpecialItemDO firstSpecialItemDO = new FirstSpecialItemDO();
                        BeanUtils.copyProperties(l,firstSpecialItemDO);
                        firstSpecialItemDO.setSpecialId(finalFirstSpecialDO.getId());
                        firstSpecialItemDO.setOuId(orgUserEmpInfoRpcDTO.getOuId());
                        firstSpecialItemDO.setOuCode(orgUserEmpInfoRpcDTO.getOuCode());
                        firstSpecialItemDO.setOuName(orgUserEmpInfoRpcDTO.getOuName());
                        firstSpecialItemRepo.save(firstSpecialItemDO);
                    });
                }
            }else {
                //修改
                Optional<FirstSpecialDO> optional = firstSpecialRepo.findById(param.getId());
                if(optional.isPresent()){
                    FirstSpecialDO firstSpecialDO = optional.get();
                    BeanUtils.copyProperties(param,firstSpecialDO);
                    firstSpecialRepo.save(firstSpecialDO);
                    //删除明细
                    List<FirstSpecialItemDO> lists = getItemListBySpecialId(param.getId());
                    if(!lists.isEmpty()){
                        lists.stream().forEach(l ->{
                            l.setDeleteFlag(1);
                            firstSpecialItemRepo.save(l);
                        });
                    }
                    if(null != param.getList() && !param.getList().isEmpty()){
                        List<FirstSpecialItemVO> list = param.getList();
                        FirstSpecialDO finalFirstSpecialDO = firstSpecialDO;
                        list.stream().forEach(l ->{
                            FirstSpecialItemDO firstSpecialItemDO = new FirstSpecialItemDO();
                            BeanUtils.copyProperties(l,firstSpecialItemDO);
                            firstSpecialItemDO.setSpecialId(finalFirstSpecialDO.getId());
                            firstSpecialItemDO.setOuId(orgUserEmpInfoRpcDTO.getOuId());
                            firstSpecialItemDO.setOuCode(orgUserEmpInfoRpcDTO.getOuCode());
                            firstSpecialItemDO.setOuName(orgUserEmpInfoRpcDTO.getOuName());
                            firstSpecialItemRepo.save(firstSpecialItemDO);
                        });
                    }
                }
            }
        }
        return ApiResult.ok();
    }


    public List<FirstSpecialItemDO> getItemListBySpecialId(Long specialId){
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq(0).and(qFirstSpecialItemDO.specialId.eq(specialId));
        Iterable<FirstSpecialItemDO> iterables = firstSpecialItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            return Lists.newArrayList(iterables);
        }
        return null;
    }

    public void delByOuId(Long ouId){
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq(0).and(qFirstSpecialItemDO.ouId.eq(ouId));
        Iterable<FirstSpecialItemDO> iterables = firstSpecialItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<FirstSpecialItemDO> list = new ArrayList<>();
            List<FirstSpecialItemDO> resList = Lists.newArrayList(iterables);
            resList.stream().forEach(r ->{
                r.setDeleteFlag(1);
                list.add(r);
            });
            firstSpecialItemRepo.saveAll(list);
        }
    }

    @Override
    public Object del(List<Long> ids) {
        if(!ids.isEmpty()){
            ids.stream().forEach(id ->{
                Optional<FirstSpecialDO> optional = firstSpecialRepo.findById(id);
                if(optional.isPresent()){
                    FirstSpecialDO firstSpecialItemDO = optional.get();
                    firstSpecialItemDO.setDeleteFlag(1);
                    firstSpecialRepo.save(firstSpecialItemDO);
                }
            });
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Object closeOrActive(FirstSpecialStatusParam param) {
        if(!param.getIds().isEmpty() && StringUtils.isNotBlank(param.getStatus())){
            QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
            param.getIds().stream().forEach(id ->{
                Optional<FirstSpecialDO> optional = firstSpecialRepo.findById(id);
                if(optional.isPresent()){
                    FirstSpecialDO firstSpecialDO = optional.get();
                    if(param.getStatus().equals(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode())){
                        //上架时候查询商品上架状态
                        Optional<BipItemDO> o = bipItemRepo.findById(firstSpecialDO.getItemId());
                        if(!o.isEmpty()){
                            BipItemDO bipItemDO = o.get();
                            if(bipItemDO.getOnShelf() == false){
                                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "未上架商品不能激活");
                            }
                        }
                        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq(0).and(qFirstSpecialDO.ouId.eq(firstSpecialDO.getOuId())).and(qFirstSpecialDO.itemId.eq(firstSpecialDO.getItemId())).and(qFirstSpecialDO.status.eq(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode()));
                        Iterable<FirstSpecialDO> iterables = firstSpecialRepo.findAll(expression);
                        if(!IterUtil.isEmpty(iterables)){
                            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "相同商品只能激活一个");
                        }
                    }
                    firstSpecialDO.setStatus(param.getStatus());
                    firstSpecialRepo.save(firstSpecialDO);
                }
            });
        }
        return null;
    }


    @Override
    @SysCodeProc
    public PagingVO<FirstSpecialVO> searchAll(FirstSpecialItemQueryParam param) {
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq(0);
        if(StringUtils.isNotBlank(param.getItemCode())){
            expression = expression.and(qFirstSpecialDO.itemCode.like("%" + param.getItemCode() + "%" ));
        }
        if(StringUtils.isNotBlank(param.getItemName())){
            expression = expression.and(qFirstSpecialDO.itemName.like("%" + param.getItemName() + "%"));
        }
        if(StringUtils.isNotBlank(param.getStatus())){
            expression = expression.and(qFirstSpecialDO.status.eq(param.getStatus()));
        }
        expression = expression.and(DataAuthJpaUtil.dataAuthJpaPredicate(qFirstSpecialDO.getMetadata()));
        Page<FirstSpecialDO> pageDo = firstSpecialRepo.findAll(expression,param.getPageRequest());
        List<FirstSpecialVO> list = new ArrayList<>();
        if(!pageDo.getContent().isEmpty()){
            pageDo.getContent().stream().forEach(d ->{
                FirstSpecialVO firstSpecialVO = new FirstSpecialVO();
                BeanUtils.copyProperties(d,firstSpecialVO);
                list.add(firstSpecialVO);
            });
        }
        return PagingVO.<FirstSpecialVO>builder()
                .total(pageDo.getTotalElements())
                .records(list)
                .build();
    }


    @Override
    @SysCodeProc
    public PagingVO<FirstSpecialItemAppVO> searchAppFirstSpecial(FirstSpecialItemAppParam param) {
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq(0).and(qFirstSpecialDO.status.eq(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode())).and(qFirstSpecialDO.ouId.eq(param.getOuId()));
        Page<FirstSpecialDO> pageDo = firstSpecialRepo.findAll(expression,param.getPageRequest());
        List<FirstSpecialItemAppVO> list = new ArrayList<>();
        if(!pageDo.getContent().isEmpty()){
            pageDo.getContent().stream().forEach(d ->{
                FirstSpecialItemAppVO firstSpecialItemAppVO = new FirstSpecialItemAppVO();
                BeanUtils.copyProperties(d,firstSpecialItemAppVO);
                //通过商品ID查询商品好评率和销量
                BipItemDO item = getByItemId(d.getItemId());
                if(null != item){
                    firstSpecialItemAppVO.setRateEvalGood(item.getRateEvalGood());
                    firstSpecialItemAppVO.setNumSale(item.getNumSale());
                    firstSpecialItemAppVO.setMainPicUrl(item.getMainPicUrl());
                    firstSpecialItemAppVO.setMainPicFileCode(item.getMainPicFileCode());
                    firstSpecialItemAppVO.setTitle(item.getTitle());
                }
                List<FirstSpecialItemDO> items = getItemListBySpecialId(d.getId());
                if(null != items && !items.isEmpty()){
                    List<FirstSpecialItemVO> vos = new ArrayList<>();
                    List<BigDecimal> basePrices = new ArrayList<>();
                    List<BigDecimal> preferentialPrices = new ArrayList<>();
                    items.stream().forEach(i ->{
                        FirstSpecialItemVO firstSpecialItemVO = new FirstSpecialItemVO();
                        BeanUtils.copyProperties(i,firstSpecialItemVO);
                        basePrices.add(i.getBasePrice());
                        preferentialPrices.add(i.getPreferentialPrice());
                      //  vos.add(firstSpecialItemVO);
                    });
                    if(null != basePrices && !basePrices.isEmpty()){
                        Optional<BigDecimal> basePrice = basePrices.stream().min(BigDecimal::compareTo);
                        if(!basePrice.isEmpty()){
                            firstSpecialItemAppVO.setBasePrice(basePrice.get());
                        }
                    }
                    if(null != preferentialPrices && !preferentialPrices.isEmpty()){
                        Optional<BigDecimal> preferentialPrice = preferentialPrices.stream().min(BigDecimal::compareTo);
                        if(!preferentialPrice.isEmpty()){
                            firstSpecialItemAppVO.setPreferentialPrice(preferentialPrice.get());
                        }
                    }

//                    firstSpecialItemAppVO.setList(vos);
                }
//                //商品详情
//                ApiResult<BipItemDetailAppRespVO> res = bipItemAppService.getDetail(d.getItemId());
//                if(null != res && res.getCode() == 200 && null != res.getData()){
//                    BipItemDetailAppRespVO vo = res.getData();
//                    firstSpecialItemAppVO.setBipItemDetailAppRespVO(vo);
//                }else {
//                    firstSpecialItemAppVO.setBipItemDetailAppRespVO(new BipItemDetailAppRespVO());
//                }
                list.add(firstSpecialItemAppVO);
            });
            return PagingVO.<FirstSpecialItemAppVO>builder()
                    .total(pageDo.getTotalElements())
                    .records(list)
                    .build();
        }
            return new PagingVO<>();
        }

    @Override
    @SysCodeProc
    public FirstSpecialItemSaveParam getItemList(Long specialId){
        Optional<FirstSpecialDO> optional = firstSpecialRepo.findById(specialId);
        FirstSpecialItemSaveParam vo = new FirstSpecialItemSaveParam();
        if(optional.isPresent()){
            FirstSpecialDO firstSpecialDO = optional.get();
            BeanUtils.copyProperties(firstSpecialDO,vo);
            List<FirstSpecialItemVO> vos = new ArrayList<>();
            List<FirstSpecialItemDO> items = getItemListBySpecialId(specialId);
            items.stream().forEach(i ->{
                FirstSpecialItemVO firstSpecialItemVO = new FirstSpecialItemVO();
                BeanUtils.copyProperties(i,firstSpecialItemVO);
                vos.add(firstSpecialItemVO);
            });
            vo.setList(vos);
        }
        return vo;
    }


    @Override
    public Boolean isAddShop(FirstIsAddShopParam param) {
        //查询用户是否为新用户
        Boolean isPay = bipOrderService.isFirstOrder(param.getUserId(),"ps");
        if(!isPay){
            //新用户
            return true;
            }
        return false;
    }



    public BipItemDO getByItemId(Long itemId){
        Optional<BipItemDO> optional = bipItemRepo.findById(itemId);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }


    @Override
    @SysCodeProc
    public List<FirstSpecialItemVO> searchList() {
        QFirstSpecialItemDO qFirstSpecialItemDO = QFirstSpecialItemDO.firstSpecialItemDO;
        BooleanExpression expression = qFirstSpecialItemDO.deleteFlag.eq(0).and(DataAuthJpaUtil.dataAuthJpaPredicate(qFirstSpecialItemDO.getMetadata()));
        Iterable<FirstSpecialItemDO> iterables = firstSpecialItemRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<FirstSpecialItemVO> list = new ArrayList<>();
            iterables.forEach(d ->{
                FirstSpecialItemVO vo = new FirstSpecialItemVO();
                BeanUtils.copyProperties(d,vo);
                list.add(vo);
            });
            return list;
        }
        return null;
    }



    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }


    @Override
    public void updateItemState(List<Long> ids) {
        if(null !=ids && !ids.isEmpty()){
            //首单商品下架的操作
            excuteFirstSpecial(ids);
            //专区商品下架
            excuteZoneSetting(ids);
            //菜单商品下架
            excuteFirstMenu(ids);
        }
    }

    /**
     * 菜单商品下架
     * @param ids
     */
    public void excuteFirstMenu(List<Long> ids){
        QBusFirstMenuConfDDO qBusFirstMenuConfDDO = QBusFirstMenuConfDDO.busFirstMenuConfDDO;
        BooleanExpression expression = qBusFirstMenuConfDDO.deleteFlag.eq(0).and(qBusFirstMenuConfDDO.itemId.in(ids));
        Iterable<BusFirstMenuConfDDO> iterables = busFirstMenuConfDRepo.findAll(expression);
        if(null != iterables && !IterUtil.isEmpty(iterables)){
            List<BusFirstMenuConfDDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l->{
                l.setDeleteFlag(1);
                busFirstMenuConfDRepo.save(l);
            });
        }
    }

    /**
     * 专区商品下架
     * @param ids
     */
    public void excuteZoneSetting(List<Long> ids){
        QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;
        BooleanExpression expression = qZoneSettingDDO.deleteFlag.eq(0).and(qZoneSettingDDO.itemId.in(ids));
        Iterable<ZoneSettingDDO> iterables = zoneSettingDRepo.findAll(expression);
        if(null != iterables && !IterUtil.isEmpty(iterables)){
            List<ZoneSettingDDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                l.setDeleteFlag(1);
                zoneSettingDRepo.save(l);
            });
        }
    }

    /**
     * 首单商品下架的操作
     * @param ids
     */
    public void excuteFirstSpecial(List<Long> ids){
        QFirstSpecialDO qFirstSpecialDO = QFirstSpecialDO.firstSpecialDO;
        BooleanExpression expression = qFirstSpecialDO.deleteFlag.eq(0).and(qFirstSpecialDO.status.eq(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_ACTIVE.getValueCode())).and(qFirstSpecialDO.itemId.in(ids));
        Iterable<FirstSpecialDO> iterables = firstSpecialRepo.findAll(expression);
        if(null != iterables && !IterUtil.isEmpty(iterables)){
            List<FirstSpecialDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                l.setStatus(UdcEnum.FIRST_SPECIAL_ITEM_STATUS_CLOSED.getValueCode());
                firstSpecialRepo.save(l);
            });
        }
    }

}
