package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.pur.dto.PurPriceBaseDTO;
import com.elitesland.yst.production.pur.dto.PurPriceBatchParamDTO;
import com.elitesland.yst.production.pur.dto.PurPriceDetailParamDTO;
import com.elitesland.yst.production.sale.api.dto.BipCustPriceDTO;
import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.vo.param.pri.*;
import com.elitesland.yst.production.sale.api.vo.resp.pri.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsCache;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.PriSalePriceConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.PriSalePriceDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceDO;
import com.elitesland.yst.production.sale.rmi.ystpur.RmiPurPriceService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiPriMainPriceService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemUomConvRpcDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 5:23 下午
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PriSalePriceServiceImpl extends BaseServiceImpl implements PriSalePriceService {

    private final QPriSalePriceDO qPriSalePriceDO = QPriSalePriceDO.priSalePriceDO;
    private final CrmCustService crmCustService;
  //  private final RmiItemService rmiItemService;
    private final RmiPriMainPriceService rmiPriMainPriceService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiCommonService rmiComService;
    private final RmiPurPriceService rmiPurPriceService;
    private final RmiSysUserService rmiSysUserService;

    // 四种价格类型
    public static final String TYPE_BASE = UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode();
    public static final String TYPE_CUST = UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode();
    public static final String TYPE_GROUP = UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode();
    public static final String TYPE_CROSS = UdcEnum.PRI_SALE_PRICE_TYPE_CROSS.getValueCode();

    @Override
    @SysCodeProc
    public PagingVO<PriSalePricePageRespVO> query(PriSalePricePagingParam param) {
        // ------------- 构造查询参数，若参数含有客户号、客户名称、商品名称，则需要先进行反查操作  -------------
//        if (StrUtil.isNotBlank(param.getCustCode()) || StrUtil.isNotBlank(param.getCustName())) {
//            var crmCustQueryParamVO = new CrmCustQueryParamVO();
//            crmCustQueryParamVO.setTransFlag(false);
//            crmCustQueryParamVO.setCustCode(StrUtil.isNotBlank(param.getCustCode()) ? param.getCustCode().trim() : null);
//            crmCustQueryParamVO.setCustName(StrUtil.isNotBlank(param.getCustName()) ? param.getCustName().trim() : null);
//            List<CrmCustPageRespVO> crmCust = crmCustService.searchList(crmCustQueryParamVO);
//            if (CollUtil.isEmpty(crmCust)) {
//                return PagingVO.<PriSalePricePageRespVO>builder().build();
//            }
//            param.setCustIds(crmCust.stream().map(CrmCustPageRespVO::getId).collect(Collectors.toList()));
//        }
//        if (StrUtil.isNotBlank(param.getItemName())) {
//            List<ItmItemRpcPagingDTO> itemList = rmiItemService.findItemList(param.getItemName());
//            if (CollUtil.isEmpty(itemList)) {
//                return PagingVO.<PriSalePricePageRespVO>builder().build();
//            }
//            param.setItemIds(itemList.stream().map(ItmItemRpcPagingDTO::getId).collect(Collectors.toList()));
//        }
//        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(buildPageSearchCondition(param));
//        long total = jpaQuery.fetchCount();
//        if (total == 0) {
//            return PagingVO.<PriSalePricePageRespVO>builder().build();
//        }
//        // 添加分页和排序
//        var pageRequest = wrapperPageRequest(param.getPageRequest(), null);
//        appendPageAndSort(jpaQuery, pageRequest, qPriSalePriceDO);
//        List<PriSalePriceDO> dataList = jpaQuery.fetch();
//        PriSalePriceConvert convert = PriSalePriceConvert.INSTANCE;
//        List<PriSalePricePageRespVO> pageResult = dataList.stream().map(convert::doToPageRespVo).collect(Collectors.toList());
//
//        // ---------------  查询结果，填充相关内容 ----------------
//        // 反查商品相关信息、商品主数据价格
//        List<Long> itemIds = pageResult.stream().map(PriSalePricePageRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemList(itemIds, null);
// //       List<PriMainPriceRpcDTO> priceRpcResult = rmiPriMainPriceService.findMainPriceDtoList(itemIds, null);
//        // 获取采购价
//        Map<Long, List<PriSalePricePageRespVO>> ouGroup = pageResult.stream().collect(Collectors.groupingBy(p -> p.getOuId()));
//        ouGroup.forEach((k, v) -> {
//            PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
//            purPriceParam.setOuId(k);
//            purPriceParam.setValidDate(LocalDate.now());
//            List<PurPriceDetailParamDTO> collect = v.stream().map(vi -> {
//                PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
//                detail.setItemId(vi.getItemId());
//                detail.setUom(vi.getUom());
//                detail.setCurrCode(vi.getCurrCode());
//                return detail;
//            }).collect(Collectors.toList());
//            purPriceParam.setPurPriceDetailParamDtoList(collect);
//            List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
//            // 循环填充采购价
//            v.forEach(vi -> purPriRpcResult.stream().filter(p -> p.getItemId().equals(vi.getItemId()) &&
//                            p.getCurrCode().equals(vi.getCurrCode()) && p.getToUom().equals(vi.getUom())).findFirst()
//                    .ifPresent(pri -> vi.setFloorPrice(pri.getPrice())));
//        });
//
//        // 反查币种信息
//        List<String> currCodes = pageResult.stream().map(PriSalePricePageRespVO::getCurrCode).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ComCurrRpcDTO> currRpcResult = rmiComService.findCurrDtoList(currCodes);
//
//        // 反查公司相关信息
//        List<Long> ouIds = pageResult.stream().map(PriSalePricePageRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<OrgOuRpcDTO> ouRpcResult = rmiOrgOuService.findOuDtoList(ouIds, null);
//
//        // 若是客户价，则需要反查客户
//        List<Long> custIds = pageResult.stream().filter(d -> StrUtil.equalsAny(d.getPriceType(), TYPE_CUST, TYPE_CROSS))
//                .map(PriSalePricePageRespVO::getCustId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        var custQueryParamVO = new CrmCustQueryParamVO();
//        custQueryParamVO.setTransFlag(false);
//        custQueryParamVO.setCustIds(custIds);
//        List<CrmCustPageRespVO> custList = crmCustService.searchList(custQueryParamVO);
//
//        // 反查税率
//        List<String> taxRateNos = pageResult.stream().map(PriSalePricePageRespVO::getTaxRateNo).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
//        List<ComTaxRateRpcDTO> taxRateRpcResult = rmiComService.findTaxRateList(taxRateNos);
//
//        // 反查当前登录人名称
//        List<Long> createIds = pageResult.stream().map(PriSalePricePageRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<Long> updateIds = pageResult.stream().map(PriSalePricePageRespVO::getModifyUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        createIds.addAll(updateIds);
//        List<Long> userIds = createIds.stream().distinct().collect(Collectors.toList());
//        List<SysUserVO> users = rmiSysUserService.getUsers(userIds);
//        // 循环处理数据
//        for (PriSalePricePageRespVO r : pageResult) {
//            // 回填商品属性
//            itemRpcResult.stream().filter(item -> item.getId().equals(r.getItemId())).findFirst().ifPresent(i -> {
//                r.setBarcode(i.getBarCode());
//                r.setItemName(i.getItemName());
//                r.setItemSpec(i.getSpec());
//            });
//            // 回填商品价格
////            priceRpcResult.stream().filter(price -> price.getItemId().equals(r.getItemId())).findFirst().ifPresent(p -> {
////                r.setMarketPrice(Objects.isNull(p.getPrice1()) ? BigDecimal.ZERO : p.getPrice1());
////                r.setGuidePrice(Objects.isNull(p.getPrice2()) ? BigDecimal.ZERO : p.getPrice2());
////                // 销售底价根据采购价计算：销售底价 = 采购价 /（1 - 毛利控制率） price4
////                if (Objects.nonNull(p.getPrice4()) && Objects.nonNull(r.getFloorPrice())) {
////                    r.setFloorPrice(r.getFloorPrice().divide(BigDecimal.ONE.subtract(p.getPrice4()), 4, RoundingMode.HALF_UP));
////                } else {
////                    r.setFloorPrice(null);
////                }
////            });
//            // 回填公司名称
//            ouRpcResult.stream().filter(ou -> ou.getId().equals(r.getOuId())).findFirst().ifPresent(ou -> r.setOuName(ou.getOuName()));
//            // 客户价格需要构造客户信息
//            if (StrUtil.equalsAny(r.getPriceType(), TYPE_CUST, TYPE_CROSS) && Objects.nonNull(r.getCustId())) {
//                custList.stream().filter(cust -> cust.getId().equals(r.getCustId())).findFirst().ifPresent(cust -> {
//                    r.setCustCode(cust.getCustCode());
//                    r.setCustName(cust.getCustName());
//                });
//            }
//            // 价格有效无效
//            r.setPriceStatus(UdcEnum.COM_STATUS_ACTIVEORNO_INACTIVE.getValueCode());
//            r.setPriceStatusName("无效");
//            var nowTime = LocalDateTime.now();
//            if ((nowTime.isEqual(r.getValidFrom()) || nowTime.isAfter(r.getValidFrom())) && nowTime.isBefore(r.getValidTo())) {
//                r.setPriceStatus(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode());
//                r.setPriceStatusName("有效");
//            }
//            // 回填币种名称
//            currRpcResult.stream().filter(curr -> curr.getCurrCode().equals(r.getCurrCode())).findFirst()
//                    .ifPresent(c -> r.setCurrName(c.getCurrName()));
//            // 回填税率描述
//            taxRateRpcResult.stream().filter(taxRate -> (StrUtil.isNotBlank(r.getTaxRateNo()) && r.getTaxRateNo().equals(taxRate.getTaxRateNo()))).findFirst()
//                    .ifPresent(t -> r.setTaxRateDesc(t.getTaxRateDesc()));
//
//            // 返回人员名称
//            users.stream().filter(user -> (!ObjectUtils.isEmpty(r.getCreateUserId()) && r.getCreateUserId().equals(user.getId()))).findFirst()
//                    .ifPresent(u -> r.setCreator(u.getFirstName()));
//            users.stream().filter(user -> (!ObjectUtils.isEmpty(r.getModifyUserId()) && r.getModifyUserId().equals(user.getId()))).findFirst()
//                    .ifPresent(u -> r.setUpdater(u.getFirstName()));
//        }
//        return PagingVO.<PriSalePricePageRespVO>builder().total(total).records(pageResult).build();
        return null;
    }

    @Override
    public List<PriSalePricePageRespVO> queryExistPrice(Long ouId, List<Long> custIds, String custGroup, List<Long> itemIds, String priceType) {
        Predicate predicate = qPriSalePriceDO.ouId.eq(ouId);
        if (StrUtil.isNotBlank(priceType)) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.eq(priceType));
        }
        if (CollUtil.isNotEmpty(itemIds)) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.in(itemIds));
        }
        // 客户价格
        if (StrUtil.equalsAny(priceType, TYPE_CUST, TYPE_CROSS) && CollUtil.isNotEmpty(custIds)) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custId.in(custIds));
        }
        // 客户等级（客户组）价格
        else if (TYPE_GROUP.equals(priceType) && StrUtil.isNotBlank(custGroup)) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custGroup.eq(custGroup));
        }
        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(predicate);
        PriSalePriceConvert convert = PriSalePriceConvert.INSTANCE;
        List<PriSalePriceDO> priSalePriceDOS = jpaQuery.fetch();
        return priSalePriceDOS.stream().map(convert::doToPageRespVo).collect(Collectors.toList());
    }

    @Override
    public List<PriSalePricePageRespVO> queryExistPrice(List<Long> ouIds, List<Long> itemIds) {
        Predicate predicate = qPriSalePriceDO.ouId.in(ouIds);
        if (CollUtil.isNotEmpty(itemIds)) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.in(itemIds));
        }
        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(predicate);
        PriSalePriceConvert convert = PriSalePriceConvert.INSTANCE;
        List<PriSalePriceDO> priSalePriceDOS = jpaQuery.fetch();
        return priSalePriceDOS.stream().map(convert::doToPageRespVo).collect(Collectors.toList());
    }

    @Override
    public ApiResult<PriSalePriceRespVO> querySalePrice(PriSalePriceQueryParam param) {
//        List<PriSaleItemQueryParam> items = param.getItems().stream().distinct().collect(Collectors.toList());
//        List<Long> itemIds = items.stream().map(PriSaleItemQueryParam::getItemId).distinct().collect(Collectors.toList());
//
//        // 查询【销售公司 + 商品 + 币种】除【内部结算价】的所有类型价格，直接先筛选出三种价格
//        List<PriSalePriceDO> salePriceList = doQueryPrice(false, param.getOuId(), param.getCurrCode(), itemIds);
//        List<PriSalePriceDO> basePriceList = salePriceList.stream().filter(p -> TYPE_BASE.equals(p.getPriceType())).collect(Collectors.toList());
//        List<PriSalePriceDO> custPriceList = salePriceList.stream().filter(p -> TYPE_CUST.equals(p.getPriceType())).collect(Collectors.toList());
//        List<PriSalePriceDO> groupPriceList = salePriceList.stream().filter(p -> TYPE_GROUP.equals(p.getPriceType())).collect(Collectors.toList());
//
//        // 获取客户等级、商品主数据、商品价格、计量单位转换关系相关辅助信息
//        CrmCustDetailRespVO crmCust = crmCustService.get(param.getCustId());
//        String custLevel = "NO_LEVEL";
//        if (!Objects.isNull(crmCust)) {
//            custLevel = crmCust.getCustLevel();
////            return ApiResult.fail("客户[" + param.getCustId() + "]不存在");
//        }
//        List<ItmItemRpcDTO> itemRpcList = rmiItemService.findItemList(itemIds, null);
// //       List<PriMainPriceRpcDTO> priceRpcResult = rmiPriMainPriceService.findMainPriceDtoList(itemIds, null);
//        List<ItmItemUomConvRpcDTO> itemUomConvRpcResult = rmiItemService.findItemUomConvDtoList(itemIds);
//
//        // 获取采购价
//        PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
//        purPriceParam.setOuId(param.getOuId());
//        purPriceParam.setValidDate(LocalDate.now());
//        List<PurPriceDetailParamDTO> collect = param.getItems().stream().map(vi -> {
//            PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
//            detail.setItemId(vi.getItemId());
//            detail.setUom(vi.getUom());
//            detail.setCurrCode(param.getCurrCode());
//            return detail;
//        }).collect(Collectors.toList());
//        purPriceParam.setPurPriceDetailParamDtoList(collect);
//        List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
//
//        var result = PriSalePriceConvert.INSTANCE.paramToVo(param);
//        var errorJoiner = new StringJoiner(",");
//        List<PriSalePriceRespInVO> priceList = new ArrayList<>(items.size());
//        // 循环构造数据
//        for (PriSaleItemQueryParam req : items) {
//            var priRespInVO = new PriSalePriceRespInVO();
//            priRespInVO.setItemId(req.getItemId());
//            priRespInVO.setUom(req.getUom());
//
//            // 获取销售指导价
//            BigDecimal guidePrice = null;
//            Optional<ItmItemRpcDTO> io = itemRpcList.stream().filter(it -> it.getId().equals(req.getItemId())).findFirst();
//            if (io.isPresent()) {
//                priRespInVO.setItemCode(io.get().getItemCode());
//
//                // 获取采购价
//                purPriRpcResult.stream().filter(p -> p.getItemId().equals(priRespInVO.getItemId())
//                                && p.getToUom().equals(priRespInVO.getUom())
//                                && p.getCurrCode().equals(param.getCurrCode()))
//                        .findFirst().ifPresent(pri -> priRespInVO.setFloorPrice(pri.getPrice()));
//
//                // 获取指导价、销售底价
//        //        Optional<PriMainPriceRpcDTO> mpo = priceRpcResult.stream().filter(price -> req.getItemId().equals(price.getItemId())).findFirst();
////                if (mpo.isPresent()) {
////                    guidePrice = mpo.get().getPrice2();
////                    // 根据采购价计算销售底价：销售底价 = 采购价 /（1 - 毛利控制率） price4
////                    if (Objects.nonNull(mpo.get().getPrice4()) && Objects.nonNull(priRespInVO.getFloorPrice())) {
////                        priRespInVO.setFloorPrice(priRespInVO.getFloorPrice().divide(BigDecimal.ONE.subtract(mpo.get().getPrice4()), 4, RoundingMode.HALF_UP));
////                    } else {
////                        priRespInVO.setFloorPrice(null);
////                    }
////                }
//
//                // 临时记录最终获取到的价格计量单位
//                String priceUom = null;
//                // 先维护返回值中的基础价格：
//                // 若查询到的基础价单位与请求单位不一致，需要进行转换。若未找到转换系数，则以未查找到基础价处理，返回null
//                Optional<PriSalePriceDO> bpo = basePriceList.stream().filter(sp -> req.getItemId().equals(sp.getItemId())).findFirst();
//                if (bpo.isPresent()) {
//                    PriSalePriceDO basePrice = bpo.get();
//                    if ((!ObjectUtils.isEmpty(basePrice.getPromDateF()) && (basePrice.getPromDateF().isBefore(LocalDateTime.now()) || basePrice.getPromDateF().isEqual(LocalDateTime.now())))
//                            && (!ObjectUtils.isEmpty(basePrice.getPromDateT()) && (basePrice.getPromDateT().isAfter(LocalDateTime.now()) || basePrice.getPromDateT().isEqual(LocalDateTime.now())))){
//                        priRespInVO.setBasePrice(basePrice.getPromotionPrice());
//                    }else{
//                        priRespInVO.setBasePrice(basePrice.getPrice());
//                    }
//                    priRespInVO.setTaxRate(basePrice.getTaxRate());
//                    priceUom = basePrice.getUom();
//                    if (!req.getUom().equals(priceUom)) {
//                        BigDecimal ratio = this.getItemUomConvRatio(itemUomConvRpcResult, req.getItemId(), req.getUom(), priceUom);
//                        if (Objects.isNull(ratio)) {
//                            priRespInVO.setBasePrice(null);
//                            priRespInVO.setTaxRate(null);
//                        }
//                    }
//                }
//                // 1.先获取客户价格
//                Optional<PriSalePriceDO> cpo = custPriceList.stream()
//                        .filter(cp -> req.getItemId().equals(cp.getItemId()) && param.getCustId().equals(cp.getCustId())).findFirst();
//                if (cpo.isPresent()) {
//                    PriSalePriceDO custPrice = cpo.get();
//                    priRespInVO.setSalePrice(custPrice.getPrice());
//                    priRespInVO.setTaxRate(custPrice.getTaxRate());
//                    priceUom = custPrice.getUom();
//                } else {
//                    // 2.客户价格不存在，则获取客户等级价格进行赋值
//                    String finalCustLevel = custLevel;
//                    Optional<PriSalePriceDO> gpo = groupPriceList.stream()
//                            .filter(gp -> req.getItemId().equals(gp.getItemId()) && finalCustLevel.equals(gp.getCustGroup())).findFirst();
//                    if (gpo.isPresent()) {
//                        PriSalePriceDO groupPrice = gpo.get();
//                        priRespInVO.setSalePrice(groupPrice.getPrice());
//                        priRespInVO.setTaxRate(groupPrice.getTaxRate());
//                        priceUom = groupPrice.getUom();
//                    } else {
//                        // 3.客户等级价格不存在，则获取基础价格进行赋值
//                        priRespInVO.setSalePrice(priRespInVO.getBasePrice());
//                        // 4.基础价格也为空，则获取销售指导价进行赋值，且此时税率为商品主档税率
//                        if (Objects.isNull(priRespInVO.getSalePrice())) {
//                            priRespInVO.setSalePrice(guidePrice);
//                            priRespInVO.setTaxRate(io.get().getTaxRate2());
//                            priceUom = io.get().getUom();
//                        }
//                    }
//                }
//
//                // 最终未查询到销售价格，则返回异常信息
//                if (Objects.isNull(priRespInVO.getSalePrice())) {
//                    priRespInVO.setTaxRate(null);
//                    priRespInVO.setErrorMsg("未维护销售价格");
//                    errorJoiner.add("商品[CODE=" + priRespInVO.getItemCode() + "]" + priRespInVO.getErrorMsg());
//                } else {
//                    // 若查询到价格，则需要校验计量单位与请求计量单位是否一致，不一致需要进行转换处理
//                    if (!req.getUom().equals(priceUom)) {
//                        BigDecimal ratio = this.getItemUomConvRatio(itemUomConvRpcResult, req.getItemId(), req.getUom(), priceUom);
//                        if (Objects.isNull(ratio)) {
//                            priRespInVO.setSalePrice(null);
//                            priRespInVO.setTaxRate(null);
//                            priRespInVO.setErrorMsg("未维护计量单位" + req.getUom() + "->" + priceUom + "转化关系");
//                            errorJoiner.add("商品[CODE=" + priRespInVO.getItemCode() + "]" + priRespInVO.getErrorMsg());
//                        } else {
//                            priRespInVO.setSalePrice(priRespInVO.getSalePrice().multiply(ratio));
//                        }
//                    }
//                }
//                priceList.add(priRespInVO);
//            } else {
//                priRespInVO.setErrorMsg("商品不存在");
//                errorJoiner.add("商品[ID=" + req.getItemId() + "]不存在");
//            }
//        }
//        result.setPriceList(priceList);
//        // 校验是否存在errorMsg，且调用方直接返回错误，若存在直接返回失败
//        if (StrUtil.isNotBlank(errorJoiner.toString()) && (Objects.nonNull(param.getFailFast()) && param.getFailFast())) {
//            return ApiResult.fail("商品[" + errorJoiner.toString() + "]未获取到销售价格");
//        }
//        return ApiResult.ok(result);
        return null;
    }

    @Override
    public ApiResult<PriCrossPriceRespVO> queryCrossPrice(PriCrossPriceQueryParam param) {
//        List<PriSaleItemQueryParam> items = param.getItems().stream().distinct().collect(Collectors.toList());
////        List<Long> itemIds = items.stream().map(PriSaleItemQueryParam::getItemId).collect(Collectors.toList());
////        // 查询【销售公司 + 商品 + 币种】所有内部结算价
////        List<PriSalePriceDO> crossPriceList = doQueryPrice(true, param.getOuId(), param.getCurrCode(), itemIds);
////        // 查询商品信息及计量单位转换率
////        List<ItmItemRpcDTO> itmRpcResult = rmiItemService.findItemList(itemIds, null);
////        List<ItmItemUomConvRpcDTO> itmUomConvRpcResult = rmiItemService.findItemUomConvDtoList(itemIds);
////
////        var result = PriSalePriceConvert.INSTANCE.paramToVo(param);
////
////        // 循环构造数据
////        List<PriCrossPriceRespInVO> priceList = new ArrayList<>(items.size());
////        for (PriSaleItemQueryParam req : items) {
////            var priRespInVO = new PriCrossPriceRespInVO();
////            priRespInVO.setItemId(req.getItemId());
////            priRespInVO.setUom(req.getUom());
////            Optional<ItmItemRpcDTO> io = itmRpcResult.stream().filter(i -> i.getId().equals(req.getItemId())).findFirst();
////            if (io.isPresent()) {
////                priRespInVO.setItemCode(io.get().getItemCode());
////                priRespInVO.setItemName(io.get().getItemName());
////                // 1.先查找客户的（custId不为空，saleRegion为空）
////                Optional<PriSalePriceDO> cco = crossPriceList.stream().filter(cp -> cp.getItemId().equals(req.getItemId())
////                        && Objects.nonNull(cp.getCustId()) && cp.getCustId().equals(param.getCustId())
////                        && StrUtil.isBlank(cp.getSaleRegion())).findFirst();
////                if (cco.isPresent()) {
////                    if ((!ObjectUtils.isEmpty(cco.get().getPromDateF()) && (cco.get().getPromDateF().isBefore(LocalDateTime.now()) || cco.get().getPromDateF().isEqual(LocalDateTime.now())))
////                            && (!ObjectUtils.isEmpty(cco.get().getPromDateT()) && (cco.get().getPromDateT().isAfter(LocalDateTime.now()) || cco.get().getPromDateT().isEqual(LocalDateTime.now())))){
////                        priRespInVO.setOriginPrice(cco.get().getPromotionPrice());
////                    }else{
////                        priRespInVO.setOriginPrice(cco.get().getPrice());
////                    }
//////                    priRespInVO.setOriginPrice(cco.get().getPrice());
////                    priRespInVO.setTaxRate(cco.get().getTaxRate());
////                    priRespInVO.setPriceUom(cco.get().getUom());
////                } else {
////                    // 2.客户未找到，找区域的（custId为空，saleRegion不为空）
////                    Optional<PriSalePriceDO> rco = crossPriceList.stream().filter(cp -> cp.getItemId().equals(req.getItemId())
////                            && StrUtil.isNotBlank(cp.getSaleRegion()) && cp.getSaleRegion().equals(param.getRegion())
////                            && Objects.isNull(cp.getCustId())).findFirst();
////                    if (rco.isPresent()) {
////                        if ((!ObjectUtils.isEmpty(rco.get().getPromDateF()) && (rco.get().getPromDateF().isBefore(LocalDateTime.now()) || rco.get().getPromDateF().isEqual(LocalDateTime.now())))
////                                && (!ObjectUtils.isEmpty(rco.get().getPromDateT()) && (rco.get().getPromDateT().isAfter(LocalDateTime.now()) || rco.get().getPromDateT().isEqual(LocalDateTime.now())))){
////                            priRespInVO.setOriginPrice(rco.get().getPromotionPrice());
////                        }else{
////                            priRespInVO.setOriginPrice(cco.get().getPrice());
////                        }
//////                        priRespInVO.setOriginPrice(rco.get().getPrice());
////                        priRespInVO.setTaxRate(rco.get().getTaxRate());
////                        priRespInVO.setPriceUom(rco.get().getUom());
////                    } else {
////                        // 3.区域未找到，找公司的（custId和saleRegion都为空）
////                        Optional<PriSalePriceDO> co = crossPriceList.stream().filter(cp -> cp.getItemId().equals(req.getItemId())
////                                && Objects.isNull(cp.getCustId()) && StrUtil.isBlank(cp.getSaleRegion())).findFirst();
////                        if (co.isPresent()) {
////                            if ((!ObjectUtils.isEmpty(co.get().getPromDateF()) && (co.get().getPromDateF().isBefore(LocalDateTime.now()) || co.get().getPromDateF().isEqual(LocalDateTime.now())))
////                                    && (!ObjectUtils.isEmpty(co.get().getPromDateT()) && (co.get().getPromDateT().isAfter(LocalDateTime.now()) || co.get().getPromDateT().isEqual(LocalDateTime.now())))){
////                                priRespInVO.setOriginPrice(co.get().getPromotionPrice());
////                            }else{
////                                priRespInVO.setOriginPrice(co.get().getPrice());
////                            }
////                            PriSalePriceDO crossPrice = co.get();
////                            priRespInVO.setTaxRate(crossPrice.getTaxRate());
//////                            priRespInVO.setOriginPrice(crossPrice.getPrice());
////                            priRespInVO.setPriceUom(co.get().getUom());
////                        } else {
////                            priRespInVO.setErrorMsg("未维护内部结算价");
////                        }
////                    }
////                }
////                // 若查询到价格，则需要校验计量单位与请求计量单位是否一致，不一致需要进行转换处理
////                if (Objects.nonNull(priRespInVO.getOriginPrice())) {
////                    if (!req.getUom().equals(priRespInVO.getPriceUom())) {
////                        BigDecimal ratio = this.getItemUomConvRatio(itmUomConvRpcResult, req.getItemId(), req.getUom(), priRespInVO.getPriceUom());
////                        if (Objects.isNull(ratio)) {
////                            priRespInVO.setPrice(null);
////                            priRespInVO.setErrorMsg("未维护计量单位转化关系");
////                        } else {
////                            priRespInVO.setPrice(priRespInVO.getOriginPrice().multiply(ratio));
////                        }
////                    } else {
////                        priRespInVO.setPrice(priRespInVO.getOriginPrice());
////                    }
////                }
////            } else {
////                priRespInVO.setErrorMsg("商品不存在");
////            }
////            priceList.add(priRespInVO);
////        }
////        result.setPriceList(priceList);
////        return ApiResult.ok(result);
        return null;
    }

    /**
     * 查询价格
     */
    private List<PriSalePriceDO> doQueryPrice(boolean crossType, Long ouId, String currCode, List<Long> itemIds) {
        Predicate predicate = qPriSalePriceDO.ouId.eq(ouId);
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.currCode.eq(currCode));
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.in(itemIds));
        if (crossType) {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.eq(TYPE_CROSS));
        } else {
            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.notIn(TYPE_CROSS));
        }
        predicate = this.addValidTimeCondition(predicate);
        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(predicate);
        return jpaQuery.fetch();
    }

    @Override
    @SysCodeProc
    public PriSalePriceDetailVO queryOnePrice(PriSalePriceQueryOneParam param) {
//        String targetPriceType = param.getPriceType();  // 目标查询价格类型
//        // 客户价格，客户ID不得为空
//        if (TYPE_CUST.equals(param.getPriceType()) && Objects.isNull(param.getCustId())) {
//            throw new BusinessException("客户ID不得为空");
//        }
//        // 客户等级价格，客户等级不得为空
//        if (TYPE_GROUP.equals(param.getPriceType()) && StrUtil.isBlank(param.getCustGroup())) {
//            throw new BusinessException("客户等级不得为空");
//        }
//        // 查询结果
//        var result = new PriSalePriceDetailVO();
//
//        // 查询 ouId + itemId 已经存在的且有效价格
//        Predicate predicate = qPriSalePriceDO.ouId.eq(param.getOuId());
//        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.eq(param.getItemId()));
//        predicate = this.addValidTimeCondition(predicate);
//        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(predicate);
//        List<PriSalePriceDO> priceList = jpaQuery.fetch();
//
//        // 只有非内部结算价才构造基础价
//        if (!TYPE_CROSS.equals(targetPriceType)) {
//            priceList.stream().filter(p -> TYPE_BASE.equals(p.getPriceType())).findFirst().ifPresent(bp -> {
//                if ((!ObjectUtils.isEmpty(bp.getPromDateF()) && (bp.getPromDateF().isBefore(LocalDateTime.now()) || bp.getPromDateF().isEqual(LocalDateTime.now())))
//                    && (!ObjectUtils.isEmpty(bp.getPromDateT()) && (bp.getPromDateT().isAfter(LocalDateTime.now()) || bp.getPromDateT().isEqual(LocalDateTime.now())))){
//                    result.setBasePrice(bp.getPromotionPrice());
//                }else{
//                    result.setBasePrice(bp.getPrice());
//                }
//                if (TYPE_BASE.equals(param.getPriceType())) {
//                    result.setTaxRateNo(bp.getTaxRateNo());
//                    result.setTaxRate(bp.getTaxRate());
//                    result.setValidFrom(bp.getValidFrom());
//                    result.setValidTo(bp.getValidTo());
//                }
//            });
//        }
//
//        // 获取的是某个商品的客户，则构造客户价
//        if (TYPE_CUST.equals(targetPriceType)) {
//            priceList.stream().filter(p -> TYPE_CUST.equals(p.getPriceType()) && param.getCustId().equals(p.getCustId()))
//                    .findFirst().ifPresent(bp -> {
//                        result.setCustPrice(bp.getPrice());
//                        result.setTaxRateNo(bp.getTaxRateNo());
//                        result.setTaxRate(bp.getTaxRate());
//                        result.setValidFrom(bp.getValidFrom());
//                        result.setValidTo(bp.getValidTo());
//                    });
//
//            // 获取已存在的客户价的同时需要获取当前客户客户组价格，若当前客户没有所属客户组，则赋值为0
//            var custQueryParam = new CrmCustQueryParamVO();
//            custQueryParam.setCustIds(Lists.newArrayList(param.getCustId()));
//            custQueryParam.setTransFlag(false);
//            List<CrmCustPageRespVO> crmCustList = crmCustService.searchList(custQueryParam);
//            if (CollUtil.isEmpty(crmCustList)) {
//                throw new BusinessException("当前客户不存在");
//            }
//            String custLevel = crmCustList.get(0).getCustLevel();
//            if (StrUtil.isNotEmpty(custLevel)) {
//                priceList.stream().filter(p -> TYPE_GROUP.equals(p.getPriceType()) && custLevel.equals(p.getCustGroup()))
//                        .findFirst().ifPresent(bp -> result.setCustGroupPrice(bp.getPrice()));
//            }
//        }
//        // 获取客户等级价
//        if (TYPE_GROUP.equals(targetPriceType)) {
//            priceList.stream().filter(p -> TYPE_GROUP.equals(p.getPriceType()) && param.getCustGroup().equals(p.getCustGroup()))
//                    .findFirst().ifPresent(bp -> {
//                        result.setCustGroupPrice(bp.getPrice());
//                        result.setTaxRateNo(bp.getTaxRateNo());
//                        result.setTaxRate(bp.getTaxRate());
//                        result.setValidFrom(bp.getValidFrom());
//                        result.setValidTo(bp.getValidTo());
//                    });
//        }
//        // 获取内部结算价，存在三种情况（custId和saleRegion都为空，custId不为空saleRegion为空，custId为空saleRegion不为空）
//        if (TYPE_CROSS.equals(targetPriceType)) {
//            Optional<PriSalePriceDO> crossOptional;
//            if (Objects.isNull(param.getCustId()) && StrUtil.isBlank(param.getSaleRegion())) {
//                crossOptional = priceList.stream().filter(p -> TYPE_CROSS.equals(p.getPriceType()) &&
//                        (Objects.isNull(p.getCustId()) && StrUtil.isBlank(p.getSaleRegion()))).findFirst();
//            } else if (Objects.nonNull(param.getCustId()) && StrUtil.isBlank(param.getSaleRegion())) {
//                crossOptional = priceList.stream().filter(p -> TYPE_CROSS.equals(p.getPriceType()) &&
//                        (Objects.nonNull(p.getCustId()) && StrUtil.isBlank(p.getSaleRegion()))).findFirst();
//            } else {
//                crossOptional = priceList.stream().filter(p -> TYPE_CROSS.equals(p.getPriceType()) &&
//                        (Objects.isNull(p.getCustId()) && StrUtil.isNotBlank(p.getSaleRegion()))).findFirst();
//            }
//            crossOptional.ifPresent(cp -> {
//                if ((!ObjectUtils.isEmpty(cp.getPromDateF()) && (cp.getPromDateF().isBefore(LocalDateTime.now()) || cp.getPromDateF().isEqual(LocalDateTime.now())))
//                        && (!ObjectUtils.isEmpty(cp.getPromDateT()) && (cp.getPromDateT().isAfter(LocalDateTime.now()) || cp.getPromDateT().isEqual(LocalDateTime.now())))){
//                    result.setCrossPrice(cp.getPromotionPrice());
//                }else{
//                    result.setCrossPrice(cp.getPrice());
//                }
////                result.setCrossPrice(cp.getPrice());
//                result.setTaxRateNo(cp.getTaxRateNo());
//                result.setTaxRate(cp.getTaxRate());
//                result.setValidFrom(cp.getValidFrom());
//                result.setValidTo(cp.getValidTo());
//            });
//        }
//
//        // 调用支撑域商品服务，反查商品相关详情及主数据价格，填充结果对应内容
//        List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemList(Lists.newArrayList(param.getItemId()), null);
//        itemRpcResult.stream().filter(item -> item.getId().equals(param.getItemId())).findFirst().ifPresent(itmItem -> {
//            result.setItemId(itmItem.getId());
//            result.setItemCode(itmItem.getItemCode());
//            result.setBarcode(itmItem.getBarCode());
//            result.setItemName(itmItem.getItemName());
//            result.setItemSpec(itmItem.getSpec());
//            result.setItemCateCode(itmItem.getItemCateCode());
//            result.setUom(itmItem.getUom());
//            if (TYPE_CROSS.equals(targetPriceType)) {
//                result.setUom(itmItem.getPurcUom());
//                result.setTaxRateNo(itmItem.getTaxCode2());
//                result.setTaxRate(itmItem.getTaxRate2());
//            }
//            if (Objects.isNull(result.getTaxRate()) || StrUtil.isBlank(result.getTaxRateNo())) {
//                result.setTaxRateNo(itmItem.getTaxCode2());
//                result.setTaxRate(itmItem.getTaxRate2());
//            }
//        });
//
//        // 获取采购价格
//        PurPriceBatchParamDTO purPriceParam = new PurPriceBatchParamDTO();
//        purPriceParam.setOuId(param.getOuId());
//        purPriceParam.setValidDate(LocalDate.now());
//        PurPriceDetailParamDTO detail = new PurPriceDetailParamDTO();
//        detail.setItemId(result.getItemId());
//        detail.setUom(result.getUom());
//        detail.setCurrCode(param.getCurrCode());
//        purPriceParam.setPurPriceDetailParamDtoList(Lists.newArrayList(detail));
//        List<PurPriceBaseDTO> purPriRpcResult = rmiPurPriceService.getPriceListByParam(purPriceParam);
//
//        purPriRpcResult.stream().filter(p -> p.getItemId().equals(result.getItemId()) && p.getToUom().equals(result.getUom())).findFirst()
//                .ifPresent(pri -> result.setFloorPrice(pri.getPrice()));
//
//        // 填充相关价格
// //       List<PriMainPriceRpcDTO> priceRpcResult = rmiPriMainPriceService.findMainPriceDtoList(Lists.newArrayList(param.getItemId()), null);
////        priceRpcResult.stream().filter(price -> param.getItemId().equals(price.getItemId())).findFirst().ifPresent(p -> {
////            result.setMarketPrice(p.getPrice1());
////            result.setGuidePrice(p.getPrice2());
////            // 根据采购价计算销售底价：销售底价 = 采购价 /（1 - 毛利控制率） price4
////            if (Objects.nonNull(p.getPrice4()) && Objects.nonNull(result.getFloorPrice())) {
////                result.setFloorPrice(result.getFloorPrice().divide(BigDecimal.ONE.subtract(p.getPrice4()), 4, RoundingMode.HALF_UP));
////            } else {
////                result.setFloorPrice(null);
////            }
////        });
//        // 税率名称
//        if (StrUtil.isNotBlank(result.getTaxRateNo())) {
//            List<ComTaxRateRpcDTO> taxRateRpcResult = rmiComService.findTaxRateList(Lists.newArrayList(result.getTaxRateNo()));
//            taxRateRpcResult.stream().filter(taxRate -> result.getTaxRateNo().equals(taxRate.getTaxRateNo()))
//                    .findFirst().ifPresent(t -> result.setTaxRateDesc(t.getTaxRateDesc()));
//        }
//        return result;
        return null;
    }

    @Override
    public PriSalePriceTypeRespVO queryPrice(PriSalePriceTypeQueryParam param) {
//        Predicate predicate = qPriSalePriceDO.isNotNull();
//        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.ouId.eq(param.getOuId()));
//        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.eq(param.getItemId()));
//        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.currCode.eq(param.getCurrCode()));
//        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.eq(param.getPriceType()));
//        if (TYPE_CUST.equals(param.getPriceType())) {
//            Assert.notNull(param.getCustId(), "查询客户价，客户ID不得为空");
//            predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custId.eq(param.getCustId()));
//        }
//        if (TYPE_GROUP.equals(param.getPriceType())) {
//            Assert.notEmpty(param.getCustLevel(), "查询客户等级价，客户等级不得为空");
//             predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custGroup.eq(param.getCustLevel()));
//         //   if(!StringUtils.isEmpty(param.getCustLevel())){
//          //      predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custGroup.eq(param.getCustLevel()));
//       //     }else {
//                //客户等级为空取基础价格 SALE_PRICE_TYPE
//            //    predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.eq(UdcEnum.PRI_SALE_PRICE_TYPE_BASE.getValueCode()));
//     //       }
//        }
//        this.addValidTimeCondition(predicate);
//        // 获取查询结果
//        var jpaQuery = jpaQueryFactory.selectFrom(qPriSalePriceDO).where(predicate);
//        PriSalePriceDO queryResult = jpaQuery.fetchOne();
//        if (Objects.nonNull(queryResult)) {
//            // 判断是否基本价格
//            if (TYPE_BASE.equals(queryResult.getPriceType()) || TYPE_CROSS.equals(queryResult.getPriceType())){
//                if ((!ObjectUtils.isEmpty(queryResult.getPromDateF()) && (queryResult.getPromDateF().isBefore(LocalDateTime.now()) || queryResult.getPromDateF().isEqual(LocalDateTime.now())))
//                        && (!ObjectUtils.isEmpty(queryResult.getPromDateT()) && (queryResult.getPromDateT().isAfter(LocalDateTime.now()) || queryResult.getPromDateT().isEqual(LocalDateTime.now())))){
//                    queryResult.setPrice(queryResult.getPromotionPrice());
//                    queryResult.setNetPrice(queryResult.getPromotionNetPrice());
//                }else{
//                    queryResult.setPrice(queryResult.getPrice());
//                    queryResult.setNetPrice(queryResult.getNetPrice());
//                }
//            }
//            // 判断单位是否一致
//            if (!param.getUom().equals(queryResult.getUom())) {
//                List<ItmItemUomConvRpcDTO> uomConvert = rmiItemService.findItemUomConvDtoList(Lists.newArrayList(param.getItemId()));
//                BigDecimal ratio = this.getItemUomConvRatio(uomConvert, param.getItemId(), param.getUom(), queryResult.getUom());
//                if (Objects.nonNull(ratio) && Objects.nonNull(queryResult.getPrice())) {
//                    queryResult.setPrice(queryResult.getPrice().multiply(ratio));
//                    queryResult.setNetPrice(queryResult.getNetPrice().multiply(ratio));
//                    return PriSalePriceConvert.INSTANCE.doToTypeVo(queryResult);
//                }
//            } else {
//                return PriSalePriceConvert.INSTANCE.doToTypeVo(queryResult);
//            }
//        }
        return null;
    }

    @Cacheable(value = ConstantsCache.CUST_PRICE, key = "'all'", unless = "#result.success == false")
    @Override
    public ApiResult<List<BipCustPriceDTO>> queryCustPrice(Long itemId) {
        var priceList = jpaQueryFactory.select(Projections.bean(BipCustPriceDTO.class,
                        qPriSalePriceDO.priceType,
                        qPriSalePriceDO.itemId,
                        qPriSalePriceDO.itemCode,
                        qPriSalePriceDO.custId,
                        qPriSalePriceDO.custGroup,
                        qPriSalePriceDO.price,
                        qPriSalePriceDO.netPrice,
                        qPriSalePriceDO.validFrom,
                        qPriSalePriceDO.validTo
                )).from(qPriSalePriceDO)
                .where(qPriSalePriceDO.itemId.eq(itemId)
                        // 价格类型
                        .and(qPriSalePriceDO.priceType.in(UdcEnum.PRI_SALE_PRICE_TYPE_CUST.getValueCode(), UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode()))
                        // 价格状态
                        .and(qPriSalePriceDO.priceStatus.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode()))
                ).fetch();
        if (priceList == null) {
            priceList = Collections.emptyList();
        }
        return ApiResult.ok(priceList);
    }

    /**
     * 获取商品从fromUom到toUom的转化率
     */
    private BigDecimal getItemUomConvRatio(List<ItmItemUomConvRpcDTO> itmUomConvRpcResult, Long itemId, String fromUom, String toUom) {
        Optional<ItmItemUomConvRpcDTO> uo = itmUomConvRpcResult.stream().filter(u -> u.getItemId().equals(itemId)
                && fromUom.equals(u.getFromUom()) && toUom.equals(u.getToUom())).findFirst();
        return uo.map(ItmItemUomConvRpcDTO::getRatio).orElse(null);
    }

    @Override
    @SysCodeProc
    public List<BipInvItemDTO> queryItemByItemCode(List<String> sku) {
        List<BipInvItemDTO> fetch = jpaQueryFactory.select(Projections.bean(BipInvItemDTO.class,
                qPriSalePriceDO.itemCode,
                qPriSalePriceDO.itemName,
                qPriSalePriceDO.itemSpec,
                qPriSalePriceDO.uom,
                qPriSalePriceDO.netPrice,
                qPriSalePriceDO.taxRateNo,
                qPriSalePriceDO.taxRate,
                qPriSalePriceDO.price
        )).from(qPriSalePriceDO).where(qPriSalePriceDO.itemCode.in(sku)).fetch();

        if (fetch == null) {
            fetch = Collections.emptyList();
        }
        return fetch;
    }


    @SysCodeProc
    @Override
    public List<BipInvItemDTO> queryBasePriceByItemCode(String sku) {
        List<PriSalePricePageRespVO> fetch = jpaQueryFactory.select(Projections.bean(PriSalePricePageRespVO.class,
                qPriSalePriceDO.itemCode,
                qPriSalePriceDO.itemName,
                qPriSalePriceDO.itemSpec,
                qPriSalePriceDO.uom,
                qPriSalePriceDO.netPrice,
                qPriSalePriceDO.taxRateNo,
                qPriSalePriceDO.taxRate,
                qPriSalePriceDO.price,
                qPriSalePriceDO.promotionPrice,
                qPriSalePriceDO.promotionNetPrice,
                qPriSalePriceDO.promDateF,
                qPriSalePriceDO.promDateT
        )).from(qPriSalePriceDO).where(qPriSalePriceDO.itemCode.in(sku).and(qPriSalePriceDO.priceType.eq(TYPE_BASE))
        .and(qPriSalePriceDO.validFrom.before(LocalDateTime.now())
        .and(qPriSalePriceDO.validTo.after(LocalDateTime.now())
       ))).fetch();

        if (fetch == null) {
            fetch = Collections.emptyList();
        }
        return this.dateHandle(fetch);
    }

    private List<BipInvItemDTO> dateHandle(List<PriSalePricePageRespVO> fetch){
        return fetch.stream().map(bip ->{
            BipInvItemDTO bipInvItemDTO = new BipInvItemDTO();
            if ((!ObjectUtils.isEmpty(bip.getPromDateF()) && (bip.getPromDateF().isBefore(LocalDateTime.now()) || bip.getPromDateF().isEqual(LocalDateTime.now())))
                    && (!ObjectUtils.isEmpty(bip.getPromDateT()) && (bip.getPromDateT().isAfter(LocalDateTime.now()) || bip.getPromDateT().isEqual(LocalDateTime.now())))){
                bipInvItemDTO.setPrice(bip.getPromotionPrice());
                bipInvItemDTO.setNetPrice(bip.getPromotionNetPrice());
            }else{
                bipInvItemDTO.setPrice(bip.getPrice());
                bipInvItemDTO.setNetPrice(bip.getNetPrice());
            }
            bipInvItemDTO.setItemCode(bip.getItemCode());
            bipInvItemDTO.setItemName(bip.getItemName());
            bipInvItemDTO.setItemSpec(bip.getItemSpec());
            bipInvItemDTO.setUom(bip.getUom());
            bipInvItemDTO.setTaxRate(bip.getTaxRate());
            bipInvItemDTO.setTaxRateNo(bip.getTaxRateNo());
            return bipInvItemDTO;
        }).collect(Collectors.toList());
    }

    /**
     * 添加统一的校验时间查询条件：生效时间 <= 当前时间 <= 失效时间
     */
    private Predicate addValidTimeCondition(Predicate predicate) {
        var nowTime = LocalDateTime.now(); // 当前时间
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validFrom.before(nowTime).or(qPriSalePriceDO.validFrom.eq(nowTime)));
        predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validTo.after(nowTime).or(qPriSalePriceDO.validTo.eq(nowTime)));
        return predicate;
    }

    /**
     * 拼接分页查询条件
     */
    private Predicate buildPageSearchCondition(PriSalePricePagingParam param) {
        Predicate predicate = qPriSalePriceDO.isNotNull();
        if (Objects.nonNull(param)) {
            if (!StringUtils.isEmpty(param.getItemCode())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemCode.like("%" + param.getItemCode() + "%"));
            }
            if (CollUtil.isNotEmpty(param.getItemIds())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemId.in(param.getItemIds()));
            }
            // 生效时间范围查询
            if (Objects.nonNull(param.getValidFromStart())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validFrom.after(param.getValidFromStart())
                        .or(qPriSalePriceDO.validFrom.eq(param.getValidFromStart())));
            }
            if (Objects.nonNull(param.getValidFromEnd())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validFrom.before(param.getValidFromEnd())
                        .or(qPriSalePriceDO.validFrom.eq(param.getValidFromEnd())));
            }
            // 失效时间范围查询
            if (Objects.nonNull(param.getValidToStart())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validTo.after(param.getValidToStart())
                        .or(qPriSalePriceDO.validTo.eq(param.getValidToStart())));
            }
            if (Objects.nonNull(param.getValidToEnd())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validTo.before(param.getValidToEnd())
                        .or(qPriSalePriceDO.validTo.eq(param.getValidToEnd())));
            }
            if (!StringUtils.isEmpty(param.getItemCateCode())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.itemCateCode.eq(param.getItemCateCode()));
            }
            if (!StringUtils.isEmpty(param.getSaleRegion())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.saleRegion.eq(param.getSaleRegion()));
            }
            if (!StringUtils.isEmpty(param.getPriceType())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.priceType.eq(param.getPriceType()));
            }
            if (!CollectionUtils.isEmpty(param.getCustIds())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custId.in(param.getCustIds()));
            }
            if (StrUtil.isNotBlank(param.getCustGroup())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.custGroup.eq(param.getCustGroup()));
            }
            if (Objects.nonNull(param.getOuId())) {
                predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.ouId.eq(param.getOuId()));
            }
            if (Objects.nonNull(param.getPriceStatus2())){
                LocalDateTime now = LocalDateTime.now();
                if (param.getPriceStatus2()){
                    predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validFrom.loe(now).and(qPriSalePriceDO.validTo.gt(now)));
                } else {
                    predicate = ExpressionUtils.and(predicate, qPriSalePriceDO.validFrom.gt(now).or(qPriSalePriceDO.validTo.loe(now)));
                }
            }
        }
        // 添加权限查询
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qPriSalePriceDO.getMetadata()));
        log.info("价格主表权限过滤sql" + predicate);
        return predicate;
    }


}
