/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.sal;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SalCommissionRuleService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionBatchParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleImportVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalCommissionRuleParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalCommissionRuleVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitesland.yst.production.sale.core.util.excel.support.ExportColumnParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/commission"})
@Api(value="\u4e1a\u7ee9\u63d0\u6210\u89c4\u5219", tags={"\u4e1a\u7ee9\u63d0\u6210\u89c4\u5219"})
public class SalCommissionRuleController
extends BaseController {
    private final SalCommissionRuleService salCommissionRuleService;

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u67e5\u8be2")
    @ApiOperationSupport(order=1)
    ApiResult<SalCommissionRuleVO> findIdOne(@PathVariable Long id) {
        return this.salCommissionRuleService.findIdOne(id);
    }

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=2)
    public ApiResult<PagingVO<SalCommissionRuleVO>> search(@RequestBody SalCommissionRuleParam param) {
        PagingVO ret = this.salCommissionRuleService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @ApiOperationSupport(order=3)
    public ApiResult<Object> createOne(@RequestBody SalCommissionRuleCreateParam param) {
        return ApiResult.ok((Object)this.salCommissionRuleService.createOne(param));
    }

    @PostMapping(value={"/createBatch"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6570\u636e")
    @ApiOperationSupport(order=4)
    public ApiResult<String> createBatch(@RequestBody SalCommissionBatchParam param) {
        this.salCommissionRuleService.createBatch(param);
        return ApiResult.ok();
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @ApiOperationSupport(order=5)
    public ApiResult<Object> update(@RequestBody SalCommissionBatchParam param) {
        this.salCommissionRuleService.update(param);
        return ApiResult.ok();
    }

    @PutMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @ApiOperationSupport(order=6)
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        this.salCommissionRuleService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @ApiOperationSupport(order=7)
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        this.salCommissionRuleService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/ImportData"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @ApiOperationSupport(order=8)
    public ApiResult<String> importCommissionData(MultipartFile file) {
        List<?> parseData = null;
        try {
            parseData = this.importExcel(file, SalCommissionRuleImportVO.class, 2, 2);
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u539f\u59cb\u6a21\u677f\u6570\u636e\u683c\u5f0f\u8fdb\u884c\u5bfc\u5165");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            this.salCommissionRuleService.importData(parseData);
        }
        return ApiResult.ok();
    }

    @PostMapping(value={"/exportData"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e")
    @ApiOperationSupport(order=9)
    public void exportRule(HttpServletResponse response, @RequestBody SalCommissionRuleParam pagingParamVO) {
        ArrayList<ExportColumnParam> columnParamList = new ArrayList<ExportColumnParam>(10);
        columnParamList.add(new ExportColumnParam("ouId", "\u516c\u53f8ID"));
        columnParamList.add(new ExportColumnParam("ouCode", "\u516c\u53f8\u7f16\u53f7"));
        columnParamList.add(new ExportColumnParam("ouName", "\u516c\u53f8\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("cateCodeName", "\u54c1\u7c7b\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("itemCode", "\u5546\u54c1\u7f16\u53f7"));
        columnParamList.add(new ExportColumnParam("itemName", "\u5546\u54c1\u540d\u79f0"));
        columnParamList.add(new ExportColumnParam("commissionRuleName", "\u63d0\u6210\u89c4\u5219"));
        columnParamList.add(new ExportColumnParam("percentage", "\u63d0\u6210\u767e\u5206\u6bd4"));
        columnParamList.add(new ExportColumnParam("pieceWage", "\u8ba1\u4ef6\u63d0\u6210"));
        columnParamList.add(new ExportColumnParam("createDate", "\u521b\u5efa\u65e5\u671f"));
        try {
            this.export(response, "\u63d0\u6210\u89c4\u5219\u5bfc\u51fa\u6570\u636e", columnParamList, arg_0 -> ((SalCommissionRuleService)this.salCommissionRuleService).search(arg_0), pagingParamVO);
        }
        catch (Exception e) {
            throw new BusinessException("\u5bfc\u51fa\u5931\u8d25");
        }
    }

    public SalCommissionRuleController(SalCommissionRuleService salCommissionRuleService) {
        this.salCommissionRuleService = salCommissionRuleService;
    }
}

