/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class BipItemSkuRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QBipItemSkuDO DO = QBipItemSkuDO.bipItemSkuDO;

    public BipItemSkuRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    public void updateLimitBuy(List<Long> bipItemIds, Integer limitBuy) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemSkuRepoProc.DO.limitBuy, (Object)limitBuy).where(new Predicate[]{BipItemSkuRepoProc.DO.bipItemId.in(bipItemIds)}).execute();
    }

    public void updateStock(Long id, Integer stock) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemSkuRepoProc.DO.stock, (Object)stock).where(new Predicate[]{BipItemSkuRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void updatePrice(Long id, BigDecimal price, BigDecimal priceOld) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemSkuRepoProc.DO.price, (Object)price).set(BipItemSkuRepoProc.DO.priceOld, (Object)priceOld).where(new Predicate[]{BipItemSkuRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void incrementStock(Long id, Integer increment) {
        this.jpaQueryFactory.update((EntityPath)DO).set(BipItemSkuRepoProc.DO.stock, (Expression)BipItemSkuRepoProc.DO.stock.add((Number)increment)).where(new Predicate[]{BipItemSkuRepoProc.DO.id.eq((Object)id)}).execute();
    }

    public void deleteByBipItemId(Long bipItemId) {
        this.jpaQueryFactory.delete((EntityPath)DO).where(new Predicate[]{BipItemSkuRepoProc.DO.bipItemId.eq((Object)bipItemId)}).execute();
    }

    public void deleteByBipItemId(List<Long> bipItemIds) {
        this.jpaQueryFactory.delete((EntityPath)DO).where(new Predicate[]{BipItemSkuRepoProc.DO.bipItemId.in(bipItemIds)}).execute();
    }

    public Long getBipItemId(Long id) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemSkuRepoProc.DO.bipItemId).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public Map<String, Long> getSkuCode(Long bipItemId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipItemSkuRepoProc.DO.id, BipItemSkuRepoProc.DO.skuCode}).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.eq((Object)bipItemId))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BipItemSkuRepoProc.DO.skuCode), t -> (Long)t.get(BipItemSkuRepoProc.DO.id), (t1, t2) -> t1));
    }

    public Integer getStock(Long id) {
        return (Integer)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemSkuRepoProc.DO.stock).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public List<String> getskuCodes(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)BipItemSkuRepoProc.DO.skuCode).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.in(ids))).fetch();
    }

    public Map<Long, Integer> getStock(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipItemSkuRepoProc.DO.id, BipItemSkuRepoProc.DO.stock}).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.in(ids))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(BipItemSkuRepoProc.DO.id), t -> (Integer)t.get(BipItemSkuRepoProc.DO.stock), (t1, t2) -> t1));
    }

    public List<Long> getSpuIds(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemSkuRepoProc.DO.bipItemId).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.in(ids))).fetch();
    }

    public Map<Long, Integer> getStockByBipItemId(Long bipItemId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipItemSkuRepoProc.DO.id, BipItemSkuRepoProc.DO.stock}).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.eq((Object)bipItemId))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get(BipItemSkuRepoProc.DO.id), t -> (Integer)t.get(BipItemSkuRepoProc.DO.stock), (t1, t2) -> t1));
    }

    public boolean existsLackStockByBipItemId(Long bipItemId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemSkuRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.eq((Object)bipItemId).and((Predicate)BipItemSkuRepoProc.DO.stock.loe((Number)0)))).limit(1L)).fetchOne() != null;
    }

    public boolean existsLackStock(Long id) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(BipItemSkuRepoProc.DO.id).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.in((Object[])new Long[]{(Long)((JPQLQuery)JPAExpressions.select(BipItemSkuRepoProc.DO.bipItemId).from(new EntityPath[]{DO}).where(new Predicate[]{BipItemSkuRepoProc.DO.id.eq((Object)id)})).fetchOne()}).and((Predicate)BipItemSkuRepoProc.DO.stock.loe((Number)0)))).limit(1L)).fetchOne() != null;
    }

    public List<BipItemSkuDO> queryByBipItemId(Long bipItemId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.eq((Object)bipItemId))).fetch();
    }

    public List<BipItemSkuDO> queryByBipItemIdFreeze(Long bipItemId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.eq((Object)bipItemId).and((Predicate)BipItemSkuRepoProc.DO.freeze.eq(Boolean.valueOf(false))))).fetch();
    }

    public List<BipItemSkuDO> queryByBipItemId(List<Long> bipItemIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.in(bipItemIds))).fetch();
    }

    public Map<Long, BigDecimal> getPrice(List<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BipItemSkuRepoProc.DO.id, BipItemSkuRepoProc.DO.price}).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.in(ids))).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get(BipItemSkuRepoProc.DO.id), tuple -> (BigDecimal)ObjectUtil.defaultIfNull((Object)((BigDecimal)tuple.get(BipItemSkuRepoProc.DO.price)), (Object)BigDecimal.ZERO), (t1, t2) -> t1));
    }

    public List<BipItemSkuDO> findSkuByCode(String skuCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.skuCode.eq((Object)skuCode))).fetch();
    }

    public Boolean findFreezeStatus(Long skuId) {
        Boolean freeze = (Boolean)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)BipItemSkuRepoProc.DO.freeze).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.id.eq((Object)skuId))).limit(1L)).fetchOne();
        return freeze == null || freeze != false;
    }

    public Map<Long, List<BipItemSkuDO>> findAllByItemIDS(List<Long> bipItemIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)DO).from((EntityPath)DO)).where((Predicate)BipItemSkuRepoProc.DO.bipItemId.in(bipItemIds))).fetch().stream().collect(Collectors.groupingBy(BipItemSkuDO::getBipItemId));
    }

    public BipItemSkuDO findSkuOnOuId(Long ouId, String skuCode) {
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
        return (BipItemSkuDO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipItemSkuDO).from((EntityPath)qBipItemDO)).leftJoin((EntityPath)qBipItemSkuDO)).on((Predicate)qBipItemDO.id.eq(qBipItemSkuDO.bipItemId))).where((Predicate)qBipItemDO.ouId.eq((Object)ouId).and((Predicate)qBipItemSkuDO.skuCode.eq((Object)skuCode)))).limit(1L)).fetchOne();
    }

    public List<BipItemSkuDO> findSkuOnMenu(Long ouId, String spuCode) {
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipItemSkuDO).from((EntityPath)qBipItemDO)).leftJoin((EntityPath)qBipItemSkuDO)).on((Predicate)qBipItemDO.id.eq(qBipItemSkuDO.bipItemId))).where((Predicate)qBipItemDO.ouId.eq((Object)ouId).and((Predicate)qBipItemDO.itemCode.eq((Object)spuCode)).and((Predicate)qBipItemSkuDO.freeze.eq(Boolean.valueOf(false))))).fetch();
    }

    public List<BipItemDO> findSkuOnRotation(Long ouId, List<String> skuCodes) {
        QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qBipItemDO).from((EntityPath)qBipItemDO)).leftJoin((EntityPath)qBipItemSkuDO)).on((Predicate)qBipItemDO.id.eq(qBipItemSkuDO.bipItemId))).where((Predicate)qBipItemDO.ouId.eq((Object)ouId).and((Predicate)qBipItemSkuDO.skuCode.in(skuCodes)).and((Predicate)qBipItemSkuDO.freeze.eq(Boolean.valueOf(false))))).fetch();
    }
}

