/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.CrmScustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmScustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.CrmScustConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.CrmScustDO;
import com.elitesland.yst.production.sale.entity.QCrmScustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.CrmScustRepo;
import com.elitesland.yst.production.sale.repo.CrmScustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CrmScustServiceImpl
extends BaseServiceImpl
implements CrmScustService {
    private static final Logger log = LoggerFactory.getLogger(CrmScustServiceImpl.class);
    private final QCrmScustDO qCrmScustDO = QCrmScustDO.crmScustDO;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final CrmScustRepo crmScustRepo;
    private final CrmScustRepoProc crmScustRepoProc;
    private final CrmCustRepoProc crmCustRepoProc;
    private final CrmCustService crmCustService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgBuService rmiOrgBuService;

    @SysCodeProc
    public PagingVO<CrmScustPageRespVO> search(CrmScustQueryParamVO searchParam) {
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setContPerson(searchParam.getContPerson());
        orgAddressRpcDtoParam.setMobile(searchParam.getMobile());
        List<Object> addrNos = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)orgAddressRpcDtoParam)) {
            try {
                List<OrgAddressRpcDTO> addrAddressRpcDtoByParam = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
                addrNos = addrAddressRpcDtoByParam.stream().map(OrgAddressRpcDTO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95ee\u5730\u5740\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("dubbo\u670d\u52a1\u8c03\u7528\u652f\u6491\u57df\u57df\u5730\u5740\u63a5\u53e3\u51fa\u9519");
            }
            searchParam.setAddrNos(addrNos);
        }
        PagingVO<CrmScustPageRespVO> respVOPagingVO = this.searching(searchParam);
        List scustPageRespVOS = respVOPagingVO.getRecords();
        this.translatePage(scustPageRespVOS);
        return new PagingVO().setTotal(respVOPagingVO.getTotal()).setRecords(scustPageRespVOS);
    }

    private void translatePage(List<CrmScustPageRespVO> respVOList) {
        List agentEmpIds = respVOList.stream().map(CrmScustPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empDtoByParam = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            try {
                empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95eeemp\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("dubbo\u670d\u52a1\u8c03\u7528\u652f\u6301\u57df\u67e5\u8be2\u5458\u5de5\u63a5\u53e3\u51fa\u9519");
            }
        }
        List addrNos = respVOList.stream().map(CrmScustPageRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        List<Object> addressRpcDto = new ArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty(addrNos)) {
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            try {
                addressRpcDto = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95ee\u5730\u5740\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("dubbo\u670d\u52a1\u8c03\u7528\u652f\u6301\u57df\u5730\u5740\u63a5\u53e3\u51fa\u9519");
            }
        }
        List<Object> finalEmpDtoByParam = empDtoByParam;
        ArrayList finalAddressRpcDto = addressRpcDto;
        respVOList.forEach(respVo -> {
            if (!org.springframework.util.StringUtils.isEmpty((Object)respVo.getAddrNo())) {
                finalAddressRpcDto.stream().filter(addr -> addr.getAddrNo().equals(respVo.getAddrNo())).findFirst().ifPresent(addrDto -> {
                    respVo.setContPerson(addrDto.getContPerson());
                    respVo.setEmail(addrDto.getEmail());
                    respVo.setMobile(addrDto.getMobile());
                    respVo.setDetailAddr(addrDto.getDetailAddr());
                });
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)respVo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(emp -> emp.getId().equals(respVo.getAgentEmpId())).findFirst().ifPresent(agentEmp -> respVo.setAgentEmpName(agentEmp.getEmpName()));
            }
            respVo.setAddrDetail(respVo.getDetailAddr());
        });
    }

    private PagingVO<CrmScustPageRespVO> searching(CrmScustQueryParamVO paramVO) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qCrmScustDO.id, this.qCrmScustDO.custCode, this.qCrmScustDO.custName, this.qCrmScustDO.custName2, this.qCrmScustDO.custAbbr, this.qCrmScustDO.addrNo, this.qCrmScustDO.custType, this.qCrmScustDO.custStatus, this.qCrmScustDO.agentEmpId, this.qCrmScustDO.ouId, this.qCrmScustDO.buId, this.qCrmScustDO.custIndustry, this.qCrmScustDO.custSource, this.qCrmScustDO.intentLevel, this.qCrmScustDO.lastFollowupDate, this.qCrmScustDO.region, this.qCrmScustDO.agentEmpId, this.qCrmScustDO.compScale, this.qCrmScustDO.compTurnover, this.qCrmScustDO.taxRegNo, this.qCrmScustDO.icRegisterNo, this.qCrmScustDO.buName, this.qCrmScustDO.ouName, this.qCrmScustDO.es2}).from((EntityPath)this.qCrmScustDO)).where(this.searchWhere(paramVO));
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(paramVO.getPageRequest(), Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{this.qCrmScustDO.modifyTime.getMetadata().getName()}));
        this.appendPageAndSort(jpaQuery, pageRequest, this.qCrmScustDO);
        List voList = jpaQuery.fetch().stream().map(tuple -> {
            CrmScustPageRespVO vo = new CrmScustPageRespVO();
            vo.setId((Long)tuple.get(this.qCrmScustDO.id));
            vo.setCustCode((String)tuple.get((Expression)this.qCrmScustDO.custCode));
            vo.setCustName((String)tuple.get((Expression)this.qCrmScustDO.custName));
            vo.setCustName2((String)tuple.get((Expression)this.qCrmScustDO.custName2));
            vo.setAddrNo((Long)tuple.get(this.qCrmScustDO.addrNo));
            vo.setOuId((Long)tuple.get(this.qCrmScustDO.ouId));
            vo.setBuId((Long)tuple.get(this.qCrmScustDO.buId));
            vo.setIcRegisterNo((String)tuple.get((Expression)this.qCrmScustDO.icRegisterNo));
            vo.setTaxRegNo((String)tuple.get((Expression)this.qCrmScustDO.taxRegNo));
            vo.setCustAbbr((String)tuple.get((Expression)this.qCrmScustDO.custAbbr));
            vo.setCustType((String)tuple.get((Expression)this.qCrmScustDO.custType));
            vo.setCustSource((String)tuple.get((Expression)this.qCrmScustDO.custSource));
            vo.setCustStatus((String)tuple.get((Expression)this.qCrmScustDO.custStatus));
            vo.setCustIndustry((String)tuple.get((Expression)this.qCrmScustDO.custIndustry));
            vo.setIntentLevel((String)tuple.get((Expression)this.qCrmScustDO.intentLevel));
            vo.setLastFollowupDate((LocalDateTime)tuple.get(this.qCrmScustDO.lastFollowupDate));
            vo.setRegion((String)tuple.get((Expression)this.qCrmScustDO.region));
            vo.setAgentEmpId((Long)tuple.get(this.qCrmScustDO.agentEmpId));
            vo.setCompScale((String)tuple.get((Expression)this.qCrmScustDO.compScale));
            vo.setCompTurnover((String)tuple.get((Expression)this.qCrmScustDO.compTurnover));
            vo.setBuName((String)tuple.get((Expression)this.qCrmScustDO.buName));
            vo.setOuName((String)tuple.get((Expression)this.qCrmScustDO.ouName));
            vo.setEs2((String)tuple.get((Expression)this.qCrmScustDO.es2));
            return vo;
        }).collect(Collectors.toList());
        return PagingVO.builder().records(voList).total(jpaQuery.fetchCount()).build();
    }

    public Predicate searchWhere(CrmScustQueryParamVO param) {
        BooleanExpression predicate = this.qCrmScustDO.deleteFlag.eq((Object)0).or((Predicate)this.qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty((Object)param.getCustIds()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.id.in((Collection)param.getCustIds()));
        predicate = StringUtils.isEmpty((Object)param.getBuId()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.buId.eq((Object)param.getBuId()));
        predicate = StringUtils.isEmpty((Object)param.getAgentEmpId()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.agentEmpId.eq((Object)param.getAgentEmpId()));
        predicate = StringUtils.isEmpty((Object)param.getCustAbbr()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.custAbbr.like("%" + param.getCustAbbr() + "%"));
        predicate = StringUtils.isEmpty((Object)param.getCustCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.custCode.like("%" + param.getCustCode() + "%"));
        predicate = StringUtils.isEmpty((Object)param.getCustName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.custName.like("%" + param.getCustName() + "%"));
        predicate = StringUtils.isEmpty((Object)param.getOuId()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.ouId.eq((Object)param.getOuId()));
        predicate = CollectionUtils.isEmpty((Collection)param.getAddrNos()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.addrNo.in((Collection)param.getAddrNos()));
        predicate = StringUtils.isEmpty((Object)param.getTaxRegNo()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qCrmScustDO.taxRegNo.like("%" + param.getTaxRegNo() + "%"));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qCrmScustDO.getMetadata()));
        return predicate;
    }

    @Transactional(rollbackFor={Exception.class})
    public void empAssign(CrmEmpAssignParamVO crmEmpAssignParamVO) {
        Assert.notNull((Object)crmEmpAssignParamVO, (String)"\u66f4\u65b0\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        this.crmScustRepo.updateScustAgentEmp(crmEmpAssignParamVO.getAgentEmpId(), crmEmpAssignParamVO.getCustIds());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<CrmScustDetailRespVO> save(CrmScustSaveVO saveVO) {
        if (StringUtils.isEmpty((Object)saveVO.getCustCode())) {
            try {
                String custCode = this.rmiSysNextNumberService.generateCode("yst-sale", "C", new ArrayList<String>());
                saveVO.setCustCode(custCode);
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95ee\u53d1\u53f7\u5668\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                return ApiResult.fail((String)"dubbo\u8bbf\u95ee\u53d1\u53f7\u5668\u63a5\u53e3\u5931\u8d25");
            }
        }
        this.checkForSave(saveVO);
        log.info("\u6d4b\u8bd53");
        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        param.setAddrNo(saveVO.getAddrNo());
        param.setAddrName(saveVO.getCustName());
        param.setAddrType(UdcEnum.ORG_ADDR_TYPE_SCUST.getValueCode());
        ArrayList<OrgAddrAddressRpcSaveParam> addrAddressRpcSaveParams = new ArrayList<OrgAddrAddressRpcSaveParam>();
        OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = new OrgAddrAddressRpcSaveParam();
        orgAddrAddressRpcSaveParam.setEmail(saveVO.getEmail());
        orgAddrAddressRpcSaveParam.setMobile(saveVO.getMobile());
        orgAddrAddressRpcSaveParam.setContPerson(saveVO.getContPerson());
        orgAddrAddressRpcSaveParam.setDetailAddr(saveVO.getDetailAddr());
        orgAddrAddressRpcSaveParam.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
        orgAddrAddressRpcSaveParam.setDefaultFlag(Boolean.valueOf(true));
        addrAddressRpcSaveParams.add(orgAddrAddressRpcSaveParam);
        param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
        log.info("\u6d4b\u8bd54");
        if (StringUtils.isEmpty((Object)saveVO.getId())) {
            saveVO.setCustStatus(UdcEnum.CRM_SCUST_STATUS_A.getValueCode());
        }
        CrmScustDO crmScustDO = this.saveVoDo(saveVO);
        crmScustDO.setSecBuId(saveVO.getBuId());
        crmScustDO.setSecOuId(saveVO.getOuId());
        crmScustDO.setSecUserId(saveVO.getAgentEmpId());
        ApiResult<Long> addrNo1 = this.rmiOrgAddrService.orgAddrSaveOrUpdate(param);
        log.info("\u5730\u5740\u4fdd\u5b58\u8fd4\u56de\u53c2\u6570:{}", (Object)JSONObject.toJSONString(addrNo1));
        Assert.isFalse((!addrNo1.isSuccess() ? 1 : 0) != 0, (String)addrNo1.getMsg(), (Object[])new Object[0]);
        Long addrNo = (Long)addrNo1.getData();
        crmScustDO.setAddrNo(addrNo);
        log.info("\u6d4b\u8bd55");
        CrmScustConvert crmScustConvert = CrmScustConvert.INSTANCE;
        CrmScustDetailRespVO crmScustDetailRespVO = crmScustConvert.doToDetailRespVO((CrmScustDO)this.crmScustRepo.save(crmScustDO));
        return ApiResult.ok((Object)crmScustDetailRespVO);
    }

    @SysCodeProc
    public CrmScustDetailRespVO findScustById(Long id) {
        if (id == null) {
            return null;
        }
        CrmScustDO crmScustDO = this.crmScustRepo.findById(id).orElse(null);
        if (crmScustDO == null) {
            throw new BusinessException("\u8be5\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        CrmScustDetailRespVO respVO = CrmScustConvert.INSTANCE.doToDetailRespVO(crmScustDO);
        this.translateDetail(respVO);
        return respVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateScustStatus(Long id) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        String scuteStatus = UdcEnum.CRM_SCUST_STATUS_B.getValueCode();
        this.crmScustRepo.updateScustStatus(scuteStatus, ids);
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> conScustImportData(List<CrmScustImportSaveVO> parseData) {
        this.importDataHadle(parseData);
        List crmScustDOS = parseData.stream().map(CrmScustConvert.INSTANCE::importToDO).collect(Collectors.toList());
        ArrayList crmScustDOS1 = new ArrayList();
        parseData.forEach(i -> {
            String custCode = this.rmiSysNextNumberService.generateCode("yst-sale", "C", new ArrayList<String>());
            CrmScustDO crmScustDO = crmScustDOS.stream().filter(cust -> cust.getCustName().equals(i.getCustName())).findFirst().get();
            OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
            param.setAddrNo(i.getAddrNo());
            param.setAddrName(i.getCustName());
            param.setAddrType(UdcEnum.ORG_ADDR_TYPE_SCUST.getValueCode());
            ArrayList<OrgAddrAddressRpcSaveParam> addrAddressRpcSaveParams = new ArrayList<OrgAddrAddressRpcSaveParam>();
            OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = new OrgAddrAddressRpcSaveParam();
            orgAddrAddressRpcSaveParam.setEmail(i.getEmail());
            orgAddrAddressRpcSaveParam.setMobile(i.getMobile());
            orgAddrAddressRpcSaveParam.setContPerson(i.getContPerson());
            orgAddrAddressRpcSaveParam.setDetailAddr(i.getDetailAddr());
            orgAddrAddressRpcSaveParam.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
            orgAddrAddressRpcSaveParam.setDefaultFlag(Boolean.valueOf(true));
            addrAddressRpcSaveParams.add(orgAddrAddressRpcSaveParam);
            param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
            ApiResult<Long> addrNo1 = this.rmiOrgAddrService.orgAddrSaveOrUpdate(param);
            log.info("\u5730\u5740\u4fdd\u5b58\u8fd4\u56de\u53c2\u6570:{}", (Object)JSONObject.toJSONString(addrNo1));
            Assert.isFalse((!addrNo1.isSuccess() ? 1 : 0) != 0, (String)addrNo1.getMsg(), (Object[])new Object[0]);
            Long addrNo = (Long)addrNo1.getData();
            crmScustDO.setAddrNo(addrNo);
            crmScustDO.setCustCode(custCode);
            crmScustDO.setSecBuId(i.getBuId());
            crmScustDO.setSecOuId(i.getOuId());
            crmScustDO.setSecUserId(i.getAgentEmpId());
            crmScustDO.setLastFollowupDate(i.getLastFollowupDate() == null ? null : i.getLastFollowupDate().atStartOfDay());
            if (!ObjectUtils.isEmpty((Object)crmScustDO.getEs2()) && crmScustDO.getEs2().equals("\u662f")) {
                crmScustDO.setEs2("1");
            } else if (!ObjectUtils.isEmpty((Object)crmScustDO.getEs2()) && crmScustDO.getEs2().equals("\u5426")) {
                crmScustDO.setEs2("0");
            }
            crmScustDOS1.add(crmScustDO);
        });
        this.crmScustRepo.saveAll(crmScustDOS1);
        return ApiResult.ok();
    }

    private void importDataHadle(List<CrmScustImportSaveVO> parseData) {
    }

    private String udcDataHandle(List<SysUdcComboVO> sysUdcComboVOS, String custName, String udcField, String msg) {
        return sysUdcComboVOS.stream().filter(install -> install.getValDesc().equals(udcField)).findFirst().orElseThrow(new BusinessException("\u5bfc\u5165\u6570\u636e,\u5ba2\u6237\u540d\u79f0\u4e3a:" + custName + "\u7684\u6570\u636e" + msg + "\u586b\u5199\u9519\u8bef\u8bf7\u68c0\u67e5")).getUdcVal();
    }

    private void translateDetail(CrmScustDetailRespVO respVO) {
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        if (!org.springframework.util.StringUtils.isEmpty((Object)respVO.getAgentEmpId())) {
            List<OrgEmpRpcDTO> empDtoByParam;
            ArrayList<Long> agentEmpId = new ArrayList<Long>();
            agentEmpId.add(respVO.getAgentEmpId());
            orgEmpRpcDtoParam.setEmpIds(agentEmpId);
            try {
                empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95eeemp\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("dubbo\u670d\u52a1\u8c03\u7528\u652f\u6301\u57df\u67e5\u8be2\u5458\u5de5\u63a5\u53e3\u51fa\u9519");
            }
            empDtoByParam.stream().filter(emp -> emp.getId().equals(respVO.getAgentEmpId())).findFirst().ifPresent(empD -> respVO.setAhentEmpIdName(empD.getEmpName()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)respVO.getAddrNo())) {
            ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo;
            try {
                rpcDtoByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(respVO.getAddrNo());
                Assert.isFalse((!rpcDtoByAddrNo.isSuccess() ? 1 : 0) != 0, (String)rpcDtoByAddrNo.getMsg(), (Object[])new Object[0]);
            }
            catch (Exception e) {
                log.error("dubbo\u8bbf\u95ee\u5730\u5740\u7c3f\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("dubbo\u670d\u52a1\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u63a5\u53e3\u51fa\u9519");
            }
            OrgAddrDetailsRpcDTO orgAddr = (OrgAddrDetailsRpcDTO)rpcDtoByAddrNo.getData();
            if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrAddressVos())) {
                orgAddr.getOrgAddrAddressVos().stream().findFirst().ifPresent(addr -> {
                    respVO.setContPerson(addr.getContPerson());
                    respVO.setEmail(addr.getEmail());
                    respVO.setMobile(addr.getMobile());
                    respVO.setDetailAddr(addr.getDetailAddr());
                });
            }
        }
    }

    private void checkForSave(CrmScustSaveVO saveVO) {
        Boolean exists2;
        Boolean exists;
        Assert.notNull((Object)saveVO, (String)"\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustName()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)saveVO.getBuId()), (String)"\u4fdd\u5b58\u6570\u636e\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)saveVO.getOuId()), (String)"\u4fdd\u5b58\u6570\u636e\u516c\u53f8\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)saveVO.getRegion()), (String)"\u4fdd\u5b58\u6570\u636e\u533a\u57df\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustName())) {
            exists = this.crmScustRepoProc.exists(saveVO.getCustName(), saveVO.getId());
            Assert.isFalse((boolean)exists, (String)"\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728\u4e8e\u6f5c\u5728\u5ba2\u6237\u8868,\u8bf7\u5728\u6f5c\u5728\u5ba2\u6237\u67e5\u8be2\u9875\u9762\u67e5\u8be2\u6b64\u5ba2\u6237", (Object[])new Object[0]);
            exists2 = this.crmCustRepoProc.exists(saveVO.getCustName(), null);
            Assert.isFalse((boolean)exists2, (String)"\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728\u4e8e\u6b63\u5f0f\u5ba2\u6237\u8868\u4e2d,\u8bf7\u5728\u6b63\u5f0f\u5ba2\u6237\u67e5\u8be2\u754c\u9762\u67e5\u8be2\u6b64\u5ba2\u6237", (Object[])new Object[0]);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)saveVO.getTaxRegNo())) {
            exists = this.crmCustRepoProc.existsTaxRegNo(saveVO.getTaxRegNo(), null, null);
            Assert.isFalse((boolean)exists, (String)"\u8be5\u7a0e\u52a1\u53f7\u6240\u5c5e\u5ba2\u6237\u5df2\u5b58\u5728\u6b63\u5f0f\u5ba2\u6237\u8868\u4e2d,\u8bf7\u5728\u6b63\u5f0f\u5ba2\u6237\u67e5\u8be2\u9875\u9762\u67e5\u8be2\u8be5\u5ba2\u6237", (Object[])new Object[0]);
            exists2 = this.crmScustRepoProc.existsTaxRegNo(saveVO.getTaxRegNo(), saveVO.getId());
            Assert.isFalse((boolean)exists2, (String)"\u8be5\u7a0e\u52a1\u53f7\u6240\u5c5e\u5ba2\u6237\u5df2\u5b58\u5728\u6f5c\u5728\u5ba2\u6237\u8868\u4e2d,\u8bf7\u5728\u6f5c\u5728\u5ba2\u6237\u67e5\u8be2\u9875\u9762\u67e5\u8be2\u8be5\u5ba2\u6237", (Object[])new Object[0]);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustCode())) {
            Boolean aBoolean = this.crmScustRepoProc.existsCode(saveVO.getCustCode(), saveVO.getId());
            Assert.isFalse((boolean)aBoolean, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728\u6f5c\u5728\u5ba2\u6237\u8868\u4e2d,\u8bf7\u5728\u6f5c\u5728\u5ba2\u6237\u67e5\u8be2\u67e5\u8be2\u8be5\u5ba2\u6237", (Object[])new Object[0]);
        }
    }

    private CrmScustDO saveVoDo(CrmScustSaveVO saveVO) {
        CrmScustDO crmScustDO = saveVO.getId() == null ? new CrmScustDO() : (CrmScustDO)this.crmScustRepo.findById(saveVO.getId()).orElseThrow();
        CrmScustConvert.INSTANCE.copyVoToDo(saveVO, crmScustDO);
        return crmScustDO;
    }

    public CrmScustServiceImpl(RmiOrgAddrService rmiOrgAddrService, RmiOrgEmpService rmiOrgEmpService, RmiSysNextNumberService rmiSysNextNumberService, CrmScustRepo crmScustRepo, CrmScustRepoProc crmScustRepoProc, CrmCustRepoProc crmCustRepoProc, CrmCustService crmCustService, RmiOrgOuService rmiOrgOuService, RmiOrgBuService rmiOrgBuService) {
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.crmScustRepo = crmScustRepo;
        this.crmScustRepoProc = crmScustRepoProc;
        this.crmCustRepoProc = crmCustRepoProc;
        this.crmCustService = crmCustService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiOrgBuService = rmiOrgBuService;
    }
}

