/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.task.delay.common.DelayTaskSender;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipItemMngService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemApproveQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemOffShelfQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemOnShelfQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemToShelfQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemApproveRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemOffShelfRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemOnShelfRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemPicContentRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemPicRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemQueryRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSpecRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemToShelfRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemUomConvertRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemApproveSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemLimitBuySaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemPicContentSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemPicSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemShelfOffSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemShelfOnSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemSkuSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemSkuUpdateVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemStockSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemUpdateVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipCompanyManageDO;
import com.elitesland.yst.production.sale.entity.BipItemCategoryDO;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemExtDO;
import com.elitesland.yst.production.sale.entity.BipItemPicDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.QBipItemDO;
import com.elitesland.yst.production.sale.entity.QBipItemExtDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.elitesland.yst.production.sale.event.ItemShelfEvent;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemCategoryRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemExtRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemExtRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemPicRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemPicRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class BipItemMngServiceImpl
extends BaseServiceImpl
implements BipItemMngService {
    private static final Logger log = LoggerFactory.getLogger(BipItemMngServiceImpl.class);
    private final BipItemRepo itemRepo;
    private final BipItemRepoProc itemRepoProc;
    private final BipItemExtRepo itemExtRepo;
    private final BipItemExtRepoProc itemExtRepoProc;
    private final BipItemPicRepo itemPicRepo;
    private final BipItemPicRepoProc itemPicRepoProc;
    private final BipItemSkuRepo itemSkuRepo;
    private final BipItemSkuRepoProc itemSkuRepoProc;
    private final BipItemSkuRepoProc bipItemSkuRepoProc;
    private final BipItemCategoryRepoProc itemCategoryRepoProc;
    private final BipCompanyManageRepoProc bipCompanyManageRepoProc;
    private final DelayTaskSender delayTaskSender;
    private final BipItemService bipItemService;
    private final RmiSysNextNumberService sysNextNumberService;
    @Autowired
    private UdcProvider udcProvider;
    private static final BipItemConvert CONVERT = BipItemConvert.INSTANCE;
    private static final QBipItemDO ITEM_DO = QBipItemDO.bipItemDO;
    private static final Set<String> STATE_APPLY_SHELF_ON = new HashSet<String>(8);
    private static final Set<String> STATE_APPLY_SHELF_OFF;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(BipItemSaveVO saveVO) {
        try {
            this.validateForSave(saveVO);
        }
        catch (IllegalArgumentException e) {
            log.info("\u5546\u54c1\u4fdd\u5b58\u6821\u9a8c\u4e0d\u901a\u8fc7", (Throwable)e);
            return ApiResult.fail((String)("\u5546\u54c1\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        BipItemDO itemDO = CONVERT.saveVO2DO(saveVO);
        itemDO.setState(UdcEnum.BIP_ITEM_STATE_DRAFT.getValueCode());
        this.itemRepo.save(itemDO);
        this.saveSku(itemDO, saveVO.getSkuList());
        this.saveItemPic(itemDO, saveVO.getPicList());
        this.saveItemExt(itemDO, saveVO);
        itemDO.setShelfCode(this.generateCode());
        this.itemRepo.save(itemDO);
        return ApiResult.ok((Object)itemDO.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> update(Long id, BipItemUpdateVO updateVO) {
        try {
            this.validateForUpdate(id, updateVO);
        }
        catch (IllegalArgumentException e) {
            log.info("\u5546\u54c1\u4fee\u6539\u6821\u9a8c\u4e0d\u901a\u8fc7", (Throwable)e);
            return ApiResult.fail((String)("\u5546\u54c1\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        BipItemDO itemDO = (BipItemDO)this.itemRepo.findById(id).orElseThrow(new BusinessException("\u4fee\u6539\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
        CONVERT.copyUpdateVO2DO(updateVO, itemDO);
        this.itemRepo.save(itemDO);
        this.updateSku(itemDO, updateVO.getSkuList());
        this.itemPicRepoProc.deleteByBipItemId(id);
        this.saveItemPic(itemDO, updateVO.getPicList());
        this.updateItemExt(itemDO, updateVO);
        this.itemRepo.save(itemDO);
        return ApiResult.ok((Object)itemDO.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> updateShelf(List<Long> ids, boolean onShelf) {
        Map<Long, String> stateMap = this.itemRepoProc.getState(ids);
        if (stateMap.isEmpty()) {
            return ApiResult.ok(ids);
        }
        List<Long> idsTemp = stateMap.entrySet().stream().filter(t -> onShelf ? this.filterForOnShelf((String)t.getValue()) : this.filterForOffShelf((String)t.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (idsTemp.isEmpty()) {
            return ApiResult.fail((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u72b6\u6001\u7684\u8bb0\u5f55");
        }
        if (onShelf) {
            this.checkFreezeOnShelf(idsTemp);
            this.checkItemImage(idsTemp);
        }
        this.itemRepoProc.updateState(idsTemp, UdcEnum.BIP_ITEM_STATE_APPR.getValueCode());
        this.itemExtRepoProc.updateToApprove(ids);
        return ApiResult.ok(ids);
    }

    private void checkItemImage(List<Long> idsTemp) {
        List items = this.itemRepo.findAllById(idsTemp);
        for (BipItemDO item : items) {
            BipItemPicDO mainImage = this.itemPicRepo.findFirstByBipItemIdAndPicAndMain(item.getId(), true, true);
            if (mainImage == null) {
                throw new BusinessException("\u5546\u54c1\u3010" + item.getItemCode() + "\u3011\u7f3a\u5c11\u4e3b\u56fe");
            }
            BipItemExtDO itemExtDO = (BipItemExtDO)this.itemExtRepo.findById(item.getExtId()).orElseThrow(new BusinessException("\u5546\u54c1\u4fe1\u606f\u5f02\u5e38"));
            List<BipItemPicContentRespVO> contentRespVOS = this.convert2List(itemExtDO.getContent(), BipItemPicContentRespVO.class);
            Assert.isTrue((contentRespVOS.size() > 0 ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + item.getItemCode() + "\u3011\u7f3a\u5c11\u56fe\u6587\u8be6\u60c5"), (Object[])new Object[0]);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> updateOnShelfTiming(BipItemShelfOnSaveVO shelfSaveVO) {
        Map<Long, String> stateMap = this.itemRepoProc.getState(shelfSaveVO.getIdList());
        List<Long> ids = stateMap.entrySet().stream().filter(t -> STATE_APPLY_SHELF_ON.contains(t.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (ids.isEmpty()) {
            return ApiResult.fail((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8bb0\u5f55");
        }
        this.checkItemImage(ids);
        this.itemRepoProc.updateState(ids, UdcEnum.BIP_ITEM_STATE_APPR.getValueCode());
        this.itemExtRepoProc.updateToApprove(ids, shelfSaveVO.getTimeOnShelf(), shelfSaveVO.getTimeOffShelf());
        return ApiResult.ok(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> updateOffShelfTiming(BipItemShelfOffSaveVO shelfSaveVO) {
        Map<Long, String> stateMap = this.itemRepoProc.getState(shelfSaveVO.getIdList());
        List<Long> ids = stateMap.entrySet().stream().filter(t -> STATE_APPLY_SHELF_OFF.contains(t.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (ids.isEmpty()) {
            return ApiResult.fail((String)"\u6ca1\u6709\u53ef\u66f4\u65b0\u7684\u8bb0\u5f55");
        }
        this.itemRepoProc.updateState(ids, UdcEnum.BIP_ITEM_STATE_APPR.getValueCode());
        this.itemExtRepoProc.updateToApprove(ids, shelfSaveVO.getTimeOffShelf());
        return ApiResult.ok(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateOnShelfByTask(Long id) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateOffShelfByTask(Long id) {
        LocalDateTime planTime;
        BipItemDO item = this.itemRepo.findById(id).orElse(null);
        if (item == null) {
            return ApiResult.fail((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (!StrUtil.equals((CharSequence)item.getState(), (CharSequence)UdcEnum.BIP_ITEM_STATE_TO_OFF.getValueCode())) {
            return ApiResult.fail((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u4e0b\u67b6");
        }
        LocalDateTime nowTime = LocalDateTime.now();
        if (nowTime.isBefore(planTime = this.itemExtRepoProc.getTimeOffShelfPlan(item.getExtId()))) {
            return ApiResult.fail((String)"\u672a\u5230\u4e0b\u67b6\u65f6\u95f4");
        }
        item.setState(UdcEnum.BIP_ITEM_STATE_OFF.getValueCode());
        item.setOnShelf(false);
        item.setTimeOnShelf(null);
        item.setTimeOffShelf(nowTime);
        item.setOffShelfReason(UdcEnum.BIP_ITEM_OFF_SHELF_AUTO.getValueCode());
        this.itemRepo.save(item);
        this.itemExtRepoProc.updateToOffShelf(item.getExtId());
        this.publishEventAsync(new ItemShelfEvent(this, false, id));
        return ApiResult.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> updateApprove(BipItemApproveSaveVO approveSaveVO) {
        List itemList = this.itemRepo.findAllById(approveSaveVO.getIdList());
        if (itemList.isEmpty()) {
            return ApiResult.ok((Object)approveSaveVO.getIdList());
        }
        if (Boolean.TRUE.equals(approveSaveVO.getPass())) {
            this.updateOnShelfByApprove(itemList, approveSaveVO);
            this.updateOffShelfByApprove(itemList, approveSaveVO);
            return ApiResult.ok((Object)approveSaveVO.getIdList());
        }
        this.itemRepoProc.updateState(approveSaveVO.getIdList(), UdcEnum.BIP_ITEM_STATE_REJECT.getValueCode());
        List extIds = itemList.stream().map(BipItemDO::getExtId).collect(Collectors.toList());
        List itemExtList = this.itemExtRepo.findAllById(extIds);
        LocalDateTime nowTime = LocalDateTime.now();
        for (BipItemExtDO ext : itemExtList) {
            ext.setTimeApproved(nowTime);
            ext.setApproverId(approveSaveVO.getApproverId());
            ext.setApproverName(approveSaveVO.getApproverName());
            ext.setApproveOpinion(approveSaveVO.getOpinion());
            ext.setApproved(approveSaveVO.getPass());
        }
        this.itemExtRepo.saveAll(itemExtList);
        return ApiResult.ok((Object)approveSaveVO.getIdList());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> updateLimitBuy(BipItemLimitBuySaveVO limitBuySaveVO) {
        this.itemSkuRepoProc.updateLimitBuy(limitBuySaveVO.getIdList(), limitBuySaveVO.getLimitBuy());
        return ApiResult.ok((Object)limitBuySaveVO.getIdList());
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateSkuStock(Long id, List<BipItemStockSaveVO> stockSaveVOList) {
        for (BipItemStockSaveVO itemStock : stockSaveVOList) {
            this.bipItemService.updateStock(itemStock.getSkuId(), itemStock.getStock());
        }
        return ApiResult.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateSale(Long id, Long num, Long num90) {
        if (num == null || num90 == null) {
            return ApiResult.fail((String)"\u5546\u54c1\u9500\u91cf\u4e3a\u7a7a");
        }
        this.itemRepoProc.updateSale(id, num, num90);
        return ApiResult.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEval(Long id, Long numTotal, Long numGood) {
        if (numTotal == null || numGood == null) {
            return ApiResult.fail((String)"\u5546\u54c1\u8bc4\u4ef7\u6570\u91cf\u4e3a\u7a7a");
        }
        BigDecimal evalRate = BigDecimal.ZERO;
        if (numTotal != 0L && numGood != 0L) {
            evalRate = BigDecimal.valueOf((double)numGood.longValue() * 1.0 / (double)numTotal.longValue());
        }
        this.itemRepoProc.updateRateEvalGood(id, numTotal, numGood, evalRate);
        return ApiResult.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEvalScore(Long id, BigDecimal evalScore) {
        if (evalScore == null) {
            return ApiResult.fail((String)"\u8bc4\u5206\u4e3a\u7a7a");
        }
        this.itemRepoProc.updateScoreEval(id, evalScore);
        return ApiResult.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> executeCheckStock(Long id) {
        Map<Long, Integer> itemStocks = this.itemSkuRepoProc.getStockByBipItemId(id);
        if (itemStocks.isEmpty()) {
            return ApiResult.ok((Object)true);
        }
        long zeroNum = itemStocks.values().stream().filter(t -> t != null && t == 0).count();
        if (zeroNum == 0L) {
            return ApiResult.ok((Object)true);
        }
        if (zeroNum != (long)itemStocks.size()) {
            this.itemRepoProc.updateLackStock(id, true);
            return ApiResult.ok((Object)false);
        }
        BipItemDO item = (BipItemDO)this.itemRepo.findById(id).orElseThrow(new BusinessException("\u5546\u54c1\u4e0d\u5b58\u5728"));
        if (BooleanUtil.isFalse((Boolean)item.getOnShelf())) {
            return ApiResult.ok((Object)false);
        }
        item.setState(UdcEnum.BIP_ITEM_STATE_OFF.getValueCode());
        item.setOnShelf(false);
        item.setTimeOnShelf(null);
        item.setTimeOffShelf(LocalDateTime.now());
        item.setOffShelfReason(UdcEnum.BIP_ITEM_OFF_SHELF_STOCK.getValueCode());
        this.itemRepo.save(item);
        return ApiResult.ok((Object)false);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        boolean exists = this.itemRepoProc.existsById(id);
        if (!exists) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        Boolean shelf = this.itemRepoProc.getShelf(id);
        if (Boolean.TRUE.equals(shelf)) {
            throw new BusinessException("\u4e0a\u67b6\u8fc7\u7684\u5546\u54c1\u4e0d\u53ef\u5220\u9664");
        }
        this.itemRepoProc.delete(id);
        this.itemExtRepoProc.deleteByBipItemId(id);
        this.itemPicRepoProc.deleteByBipItemId(id);
        this.itemSkuRepoProc.deleteByBipItemId(id);
        return ApiResult.ok((Object)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> delete(List<Long> ids) {
        Map<Long, Boolean> shelfMap = this.itemRepoProc.getShelf(ids);
        if (shelfMap.isEmpty()) {
            return ApiResult.ok(ids);
        }
        ArrayList<Long> idsDel = new ArrayList<Long>(ids.size());
        ArrayList<Long> idsDelFake = new ArrayList<Long>(ids.size());
        for (Map.Entry<Long, Boolean> entry : shelfMap.entrySet()) {
            if (entry.getValue().booleanValue()) {
                idsDelFake.add(entry.getKey());
                continue;
            }
            idsDel.add(entry.getKey());
        }
        if (!idsDel.isEmpty()) {
            this.itemRepoProc.delete(idsDel);
            this.itemExtRepoProc.deleteByBipItemId(idsDel);
            this.itemPicRepoProc.deleteByBipItemId(idsDel);
            this.itemSkuRepoProc.deleteByBipItemId(idsDel);
        }
        if (!idsDelFake.isEmpty()) {
            throw new BusinessException("\u4e0a\u67b6\u8fc7\u7684\u5546\u54c1\u4e0d\u53ef\u5220\u9664");
        }
        return ApiResult.ok(ids);
    }

    public ApiResult<BipItemDetailRespVO> get(Long id) {
        log.info("\u5546\u54c1id:---------" + id);
        BipItemDO itemDO = this.itemRepo.findById(id).orElse(null);
        if (itemDO == null) {
            log.info("\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728--------------------");
            return ApiResult.fail((String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BipItemExtDO itemExtDO = (BipItemExtDO)this.itemExtRepo.findById(itemDO.getExtId()).orElseThrow(new BusinessException("\u5546\u54c1\u4fe1\u606f\u5f02\u5e38"));
        log.info("\u5546\u54c1\u4fe1\u606f\uff1a--------" + JSON.toJSONString((Object)itemExtDO));
        BipItemDetailRespVO respVO = CONVERT.itemDO2DetailVO(itemDO);
        respVO.setSkuList(this.querySkuDetail(id));
        respVO.setSpecList(this.convert2List(itemExtDO.getSpec(), BipItemSpecRespVO.class));
        respVO.setPicList(this.queryItemPic(id));
        respVO.setContentPicList(this.convert2List(itemExtDO.getContent(), BipItemPicContentRespVO.class));
        if (StrUtil.isNotBlank((CharSequence)itemExtDO.getUnit())) {
            respVO.setUnit(itemExtDO.getUnit());
            respVO.setUnitName(this.convertUdc(UdcEnum.COM_UOM_BX).get(itemExtDO.getUnit()));
        }
        log.info("\u5546\u54c1\u4fe1\u606f:-------" + JSON.toJSONString((Object)respVO));
        return ApiResult.ok((Object)respVO);
    }

    public ApiResult<List<BipItemSkuRespVO>> getSku(Long id) {
        List<BipItemSkuRespVO> skuList = this.querySkuDetail(id);
        return ApiResult.ok(skuList);
    }

    public ApiResult<Integer> getStockBySku(Long skuId) {
        Integer stock = this.itemSkuRepoProc.getStock(skuId);
        return ApiResult.ok((Object)stock);
    }

    public ApiResult<Long> getIdBySkuId(Long skuId) {
        Long id = this.itemSkuRepoProc.getBipItemId(skuId);
        return ApiResult.ok((Object)id);
    }

    public ApiResult<List<BipItemUomConvertRespVO>> queryItemUomConvert(List<Long> itemIds) {
        return null;
    }

    public ApiResult<PagingVO<BipItemToShelfRespVO>> queryForToShelf(BipItemToShelfQueryParamVO queryParamVO) {
        PagingVO<BipItemDO> pagingDO = this.queryItems(queryParamVO);
        if (CollUtil.isEmpty((Collection)pagingDO.getRecords())) {
            return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(Collections.emptyList()).build());
        }
        Map<String, String> stateNameMap = this.convertUdc(UdcEnum.BIP_ITEM_STATE_DRAFT);
        List dataList = pagingDO.getRecords().stream().map(t -> {
            BipItemToShelfRespVO vo = CONVERT.itemDO2ToShelfVO((BipItemDO)t);
            vo.setStateName((String)stateNameMap.get(t.getState()));
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(dataList).build());
    }

    public ApiResult<PagingVO<BipItemApproveRespVO>> queryForApprove(BipItemApproveQueryParamVO queryParamVO) {
        PagingVO<BipItemDO> pagingDO = this.queryItems(queryParamVO);
        if (CollUtil.isEmpty((Collection)pagingDO.getRecords())) {
            return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(Collections.emptyList()).build());
        }
        List extIds = pagingDO.getRecords().stream().map(BipItemDO::getExtId).collect(Collectors.toList());
        Map<Long, BipItemExtDO> extMap = this.itemExtRepo.findAllById(extIds).stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        Map<String, String> stateNameMap = this.convertUdc(UdcEnum.BIP_ITEM_STATE_DRAFT);
        List dataList = pagingDO.getRecords().stream().map(t -> {
            BipItemApproveRespVO vo = CONVERT.itemDO2ToApproveVO((BipItemDO)t);
            vo.setStateName((String)stateNameMap.get(t.getState()));
            vo.setShelf(Boolean.valueOf(t.getOnShelf() == false));
            CONVERT.do2ApproveVO((BipItemExtDO)extMap.get(t.getExtId()), vo);
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(dataList).build());
    }

    public ApiResult<PagingVO<BipItemOnShelfRespVO>> queryForOnShelf(BipItemOnShelfQueryParamVO queryParamVO) {
        PagingVO<BipItemDO> pagingDO = this.queryItems(queryParamVO);
        if (CollUtil.isEmpty((Collection)pagingDO.getRecords())) {
            return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(Collections.emptyList()).build());
        }
        Map<String, String> stateNameMap = this.convertUdc(UdcEnum.BIP_ITEM_STATE_DRAFT);
        List dataList = pagingDO.getRecords().stream().map(t -> {
            BipItemOnShelfRespVO vo = CONVERT.itemDO2OnShelfVO((BipItemDO)t);
            vo.setStateName((String)stateNameMap.get(t.getState()));
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(dataList).build());
    }

    public ApiResult<PagingVO<BipItemOffShelfRespVO>> queryForOffShelf(BipItemOffShelfQueryParamVO queryParamVO) {
        PagingVO<BipItemDO> pagingDO = this.queryItems(queryParamVO);
        if (CollUtil.isEmpty((Collection)pagingDO.getRecords())) {
            return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(Collections.emptyList()).build());
        }
        Map<String, String> stateNameMap = this.convertUdc(UdcEnum.BIP_ITEM_STATE_DRAFT);
        Map<String, String> offShelfReasonNameMap = this.convertUdc(UdcEnum.BIP_ITEM_OFF_SHELF_MANUAL);
        List dataList = pagingDO.getRecords().stream().map(t -> {
            BipItemOffShelfRespVO vo = CONVERT.itemDO2OffShelfVO((BipItemDO)t);
            vo.setStateName((String)stateNameMap.get(t.getState()));
            vo.setOffShelfReasonName((String)offShelfReasonNameMap.get(t.getOffShelfReason()));
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)PagingVO.builder().total(pagingDO.getTotal()).records(dataList).build());
    }

    public ApiResult<PagingVO<BipItemQueryRespVO>> query(BipItemQueryParamVO queryParam) {
        PagingVO<BipItemQueryRespVO> result = this.querySku(queryParam);
        return ApiResult.ok(result);
    }

    public ApiResult<List<BipItemQueryRespVO>> queryByCategory(Long ouId, String categoryCode, Boolean onShelf) {
        if (CharSequenceUtil.isBlank((CharSequence)categoryCode)) {
            return ApiResult.ok(Collections.emptyList());
        }
        PagingVO<BipItemQueryRespVO> result = this.querySkuByCategoryCode(ouId, categoryCode, onShelf);
        return ApiResult.ok((Object)result.getRecords());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePrice(Long id, BigDecimal price, BigDecimal priceOld) {
        this.bipItemSkuRepoProc.updatePrice(id, price, priceOld);
    }

    @Transactional(rollbackFor={Exception.class})
    public void handleImage(File file, String ouCode) {
        BipCompanyManageDO ou = this.bipCompanyManageRepoProc.findByOuCode(ouCode);
        Assert.notNull((Object)ou, (String)("\u516c\u53f8\u3010" + ouCode + "\u3011\u4e0d\u5b58\u5728!"), (Object[])new Object[0]);
        for (File first : file.listFiles()) {
            BipItemPicSaveVO picSaveVO;
            FileObjRespVO data;
            com.el.coordinator.core.common.api.ApiResult result;
            BipItemDO itemDO;
            String itemCode;
            if (first.getName().startsWith("\u4e3b")) {
                for (File spu : first.listFiles()) {
                    itemCode = spu.getName();
                    itemDO = this.itemRepoProc.getItemForImage(itemCode, ouCode);
                    Assert.notNull((Object)itemDO, (String)("\u516c\u53f8\u3010" + ouCode + "\u3011\u4e0d\u5b58\u5728\u5546\u54c1\u3010" + itemCode + "\u3011"), (Object[])new Object[0]);
                    Assert.isTrue(((itemDO.getOnShelf() == null || Boolean.FALSE.equals(itemDO.getOnShelf())) && StringUtils.isEmpty((Object)itemDO.getOffShelfReason()) ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + itemDO.getItemCode() + "\u3011\u4e0d\u5728\u5f85\u4e0a\u67b6\u5217\u8868\u4e2d\uff0c\u4e0d\u80fd\u4e0a\u4f20\u56fe\u7247\uff01"), (Object[])new Object[0]);
                    ArrayList<BipItemPicSaveVO> picSaveVOS = new ArrayList<BipItemPicSaveVO>();
                    for (File image : spu.listFiles()) {
                        result = this.fileService.upload(image);
                        data = (FileObjRespVO)result.getData();
                        picSaveVO = new BipItemPicSaveVO();
                        picSaveVO.setFileCode(data.getFileCode());
                        picSaveVO.setFileName(data.getOriginalName());
                        picSaveVO.setMimeType(data.getMimeType());
                        picSaveVO.setUrl(data.getUrl());
                        picSaveVO.setFileSize(data.getFileSize());
                        picSaveVO.setMain(Boolean.valueOf(false));
                        if (image.getName().split("\\.")[0].equals(itemCode)) {
                            picSaveVO.setMain(Boolean.valueOf(true));
                        }
                        picSaveVOS.add(picSaveVO);
                    }
                    this.itemPicRepoProc.deleteByBipItemId(itemDO.getId());
                    this.saveItemPic(itemDO, picSaveVOS);
                    this.itemRepo.save(itemDO);
                }
            }
            if (!first.getName().startsWith("\u8be6\u60c5")) continue;
            for (File spu : first.listFiles()) {
                itemCode = spu.getName();
                itemDO = this.itemRepoProc.getItemForImage(itemCode, ouCode);
                Assert.notNull((Object)itemDO, (String)("\u516c\u53f8\u3010" + ouCode + "\u3011\u4e0d\u5b58\u5728\u5546\u54c1\u3010" + itemCode + "\u3011"), (Object[])new Object[0]);
                Assert.isTrue(((itemDO.getOnShelf() == null || Boolean.FALSE.equals(itemDO.getOnShelf())) && StringUtils.isEmpty((Object)itemDO.getOffShelfReason()) ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + itemDO.getItemCode() + "\u3011\u4e0d\u5728\u5f85\u4e0a\u67b6\u5217\u8868\u4e2d\uff0c\u4e0d\u80fd\u4e0a\u4f20\u56fe\u7247\uff01"), (Object[])new Object[0]);
                ArrayList<BipItemPicSaveVO> contentPicList = new ArrayList<BipItemPicSaveVO>();
                for (File image : spu.listFiles()) {
                    result = this.fileService.upload(image);
                    data = (FileObjRespVO)result.getData();
                    picSaveVO = new BipItemPicContentSaveVO();
                    picSaveVO.setFileCode(data.getFileCode());
                    picSaveVO.setFileName(data.getOriginalName());
                    picSaveVO.setMimeType(data.getMimeType());
                    picSaveVO.setUrl(data.getUrl());
                    contentPicList.add(picSaveVO);
                }
                this.itemExtRepo.findById(itemDO.getExtId()).ifPresentOrElse(extDO -> {
                    extDO.setContent(this.convertObj2Str(contentPicList));
                    this.itemExtRepo.save(extDO);
                }, () -> {
                    throw new BusinessException("\u5546\u54c1\u3010" + itemCode + "\u3011\u4e0d\u5b58\u5728\u6269\u5c55\u4fe1\u606f");
                });
            }
        }
    }

    private String generateCode() {
        String code = this.sysNextNumberService.generateCode("yst-sale", "SAL_ITEM_SHELF_CODE", new ArrayList<String>());
        if (this.itemRepoProc.existsByShelfCode(code)) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return code;
    }

    private boolean filterForOnShelf(String state) {
        return state != null && STATE_APPLY_SHELF_ON.contains(state);
    }

    private boolean filterForOffShelf(String state) {
        return state != null && STATE_APPLY_SHELF_OFF.contains(state);
    }

    private void updateOnShelfByApprove(List<BipItemDO> itemList, BipItemApproveSaveVO approveSaveVO) {
        List items = itemList.stream().filter(t -> UdcEnum.BIP_ITEM_STATE_APPR.getValueCode().equals(t.getState()) && Boolean.FALSE.equals(t.getOnShelf())).collect(Collectors.toList());
        if (items.isEmpty()) {
            return;
        }
        List extIds = items.stream().map(BipItemDO::getExtId).collect(Collectors.toList());
        List itemExtList = this.itemExtRepo.findAllById(extIds);
        Map<Long, BipItemExtDO> itemExtMap = itemExtList.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        LocalDateTime nowTime = LocalDateTime.now();
        HashSet<BipItemExtDO> timingItems = new HashSet<BipItemExtDO>(64);
        HashSet<Long> onShelfNowIds = new HashSet<Long>(64);
        for (BipItemDO item : items) {
            BipItemExtDO ext = itemExtMap.get(item.getExtId());
            if (ext.getTimeOnShelfPlan() != null) {
                item.setState(UdcEnum.BIP_ITEM_STATE_TO_SHELF.getValueCode());
                timingItems.add(ext);
                continue;
            }
            item.setState(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode());
            item.setShelf(true);
            item.setOnShelf(true);
            item.setTimeOnShelf(nowTime);
            item.setTimeOffShelf(null);
            item.setOffShelfReason(null);
            onShelfNowIds.add(item.getId());
        }
        this.checkFreezeOnShelf(new ArrayList<Long>(onShelfNowIds));
        this.itemRepo.saveAll(items);
        if (approveSaveVO != null) {
            for (BipItemExtDO ext : itemExtList) {
                ext.setTimeApproved(nowTime);
                ext.setApproverId(approveSaveVO.getApproverId());
                ext.setApproverName(approveSaveVO.getApproverName());
                ext.setApproveOpinion(approveSaveVO.getOpinion());
                ext.setApproved(approveSaveVO.getPass());
            }
            this.itemExtRepo.saveAll(itemExtList);
        }
        if (!timingItems.isEmpty()) {
            for (BipItemExtDO ext : timingItems) {
                String id = ext.getBipItemId().toString();
                this.delayTaskSender.send("bip_item_onShelf", id, (Serializable)ext.getBipItemId(), ext.getTimeOnShelfPlan());
                if (ext.getTimeOffShelfPlan() == null) continue;
                this.delayTaskSender.send("bip_item_offShelf", id, (Serializable)ext.getBipItemId(), ext.getTimeOffShelfPlan());
            }
        }
        if (!onShelfNowIds.isEmpty()) {
            for (Long bipItemId : onShelfNowIds) {
                this.publishEventSync(new ItemShelfEvent(this, true, bipItemId));
            }
        }
    }

    private void checkFreezeOnShelf(List<Long> idList) {
    }

    private void updateOffShelfByApprove(List<BipItemDO> itemList, BipItemApproveSaveVO approveSaveVO) {
        List items = itemList.stream().filter(t -> UdcEnum.BIP_ITEM_STATE_APPR.getValueCode().equals(t.getState()) && Boolean.TRUE.equals(t.getOnShelf())).collect(Collectors.toList());
        if (items.isEmpty()) {
            return;
        }
        List extIds = items.stream().map(BipItemDO::getExtId).collect(Collectors.toList());
        List itemExtList = this.itemExtRepo.findAllById(extIds);
        Map<Long, BipItemExtDO> itemExtMap = itemExtList.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        LocalDateTime nowTime = LocalDateTime.now();
        HashSet<BipItemExtDO> timingItems = new HashSet<BipItemExtDO>(64);
        HashSet<Long> offShelfNowIds = new HashSet<Long>(64);
        for (BipItemDO item : items) {
            BipItemExtDO ext = itemExtMap.get(item.getExtId());
            if (ext.getTimeOffShelfPlan() != null) {
                item.setState(UdcEnum.BIP_ITEM_STATE_TO_OFF.getValueCode());
                timingItems.add(ext);
                continue;
            }
            item.setState(UdcEnum.BIP_ITEM_STATE_OFF.getValueCode());
            item.setOnShelf(false);
            item.setTimeOnShelf(null);
            item.setTimeOffShelf(nowTime);
            item.setOffShelfReason(UdcEnum.BIP_ITEM_OFF_SHELF_MANUAL.getValueCode());
            offShelfNowIds.add(item.getId());
        }
        this.itemRepo.saveAll(items);
        if (approveSaveVO != null) {
            for (BipItemExtDO ext : itemExtList) {
                ext.setTimeApproved(nowTime);
                ext.setApproverId(approveSaveVO.getApproverId());
                ext.setApproverName(approveSaveVO.getApproverName());
                ext.setApproveOpinion(approveSaveVO.getOpinion());
                ext.setApproved(approveSaveVO.getPass());
            }
            this.itemExtRepo.saveAll(itemExtList);
        }
        if (!timingItems.isEmpty()) {
            for (BipItemExtDO ext : timingItems) {
                String id = ext.getBipItemId().toString();
                this.delayTaskSender.send("bip_item_offShelf", id, (Serializable)ext.getBipItemId(), ext.getTimeOffShelfPlan());
            }
        }
        if (!offShelfNowIds.isEmpty()) {
            for (Long bipItemId : offShelfNowIds) {
                this.publishEventSync(new ItemShelfEvent(this, false, bipItemId));
            }
        }
    }

    private PagingVO<BipItemDO> queryItems(BipItemToShelfQueryParamVO queryParamVO) {
        BooleanExpression condition = ITEM_DO.isNotNull();
        if (queryParamVO.getCategoryId1() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId1.eq((Object)queryParamVO.getCategoryId1()));
        }
        if (queryParamVO.getCategoryId2() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId2.eq((Object)queryParamVO.getCategoryId2()));
        }
        if (queryParamVO.getCategoryId3() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId3.eq((Object)queryParamVO.getCategoryId3()));
        }
        if (queryParamVO.getOuId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getState())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.state.eq((Object)queryParamVO.getState()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getShelfCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.shelfCode.eq((Object)queryParamVO.getShelfCode()));
        }
        if (queryParamVO.getCreateUserId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.createUserId.eq((Object)queryParamVO.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getItemCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.itemCode.eq((Object)queryParamVO.getItemCode()));
        }
        if (queryParamVO.getFareFree() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.fareFree.eq(queryParamVO.getFareFree()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getItemName())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.itemName.like("%" + queryParamVO.getItemName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getCreator())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.creator.like("%" + queryParamVO.getCreator() + "%"));
        }
        condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(false)).and((Predicate)BipItemMngServiceImpl.ITEM_DO.offShelfReason.isNull()).and((Predicate)BipItemMngServiceImpl.ITEM_DO.deleteFlag.eq((Object)0)));
        PageRequest pageRequest = queryParamVO.getPageRequest();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ITEM_DO).from((EntityPath)ITEM_DO)).where((Predicate)condition);
        long count = jpaQuery.fetchCount();
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrder(pageRequest, ITEM_DO, new OrderSpecifier[]{new OrderSpecifier(Order.DESC, BipItemMngServiceImpl.ITEM_DO.createTime)}))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch();
        return PagingVO.builder().total(count).records(dataList).build();
    }

    private PagingVO<BipItemDO> queryItems(BipItemApproveQueryParamVO queryParamVO) {
        BooleanExpression condition = ITEM_DO.isNotNull();
        if (queryParamVO.getCategoryId1() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId1.eq((Object)queryParamVO.getCategoryId1()));
        }
        if (queryParamVO.getCategoryId2() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId2.eq((Object)queryParamVO.getCategoryId2()));
        }
        if (queryParamVO.getCategoryId3() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId3.eq((Object)queryParamVO.getCategoryId3()));
        }
        if (queryParamVO.getOuId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getShelfCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.shelfCode.eq((Object)queryParamVO.getShelfCode()));
        }
        if (queryParamVO.getCreateUserId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.createUserId.eq((Object)queryParamVO.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getItemCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.itemCode.eq((Object)queryParamVO.getItemCode()));
        }
        if (queryParamVO.getFareFree() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.fareFree.eq(queryParamVO.getFareFree()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getItemName())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.itemName.like("%" + queryParamVO.getItemName() + "%"));
        }
        if (queryParamVO.getShelf() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(queryParamVO.getShelf() == false)));
        }
        condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.state.eq((Object)UdcEnum.BIP_ITEM_STATE_APPR.getValueCode()).and((Predicate)BipItemMngServiceImpl.ITEM_DO.deleteFlag.eq((Object)0)));
        PageRequest pageRequest = queryParamVO.getPageRequest();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ITEM_DO).from((EntityPath)ITEM_DO)).where((Predicate)condition);
        long count = jpaQuery.fetchCount();
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrder(pageRequest, ITEM_DO, new OrderSpecifier[]{new OrderSpecifier(Order.DESC, BipItemMngServiceImpl.ITEM_DO.createTime)}))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch();
        return PagingVO.builder().total(count).records(dataList).build();
    }

    private PagingVO<BipItemDO> queryItems(BipItemOnShelfQueryParamVO queryParamVO) {
        BooleanExpression condition = ITEM_DO.isNotNull();
        if (queryParamVO.getCategoryId1() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId1.eq((Object)queryParamVO.getCategoryId1()));
        }
        if (queryParamVO.getCategoryId2() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId2.eq((Object)queryParamVO.getCategoryId2()));
        }
        if (queryParamVO.getCategoryId3() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.categoryId3.eq((Object)queryParamVO.getCategoryId3()));
        }
        if (queryParamVO.getOuId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getState())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.state.eq((Object)queryParamVO.getState()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getShelfCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.shelfCode.eq((Object)queryParamVO.getShelfCode()));
        }
        if (queryParamVO.getCreateUserId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.createUserId.eq((Object)queryParamVO.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getItemCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.itemCode.eq((Object)queryParamVO.getItemCode()));
        }
        if (queryParamVO.getFareFree() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.fareFree.eq(queryParamVO.getFareFree()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getItemName())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.itemName.like("%" + queryParamVO.getItemName() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getCreator())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.creator.like("%" + queryParamVO.getCreator() + "%"));
        }
        condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(true)).and((Predicate)BipItemMngServiceImpl.ITEM_DO.deleteFlag.eq((Object)0)));
        PageRequest pageRequest = queryParamVO.getPageRequest();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ITEM_DO).from((EntityPath)ITEM_DO)).where((Predicate)condition);
        long count = jpaQuery.fetchCount();
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrder(pageRequest, ITEM_DO, new OrderSpecifier[]{new OrderSpecifier(Order.DESC, BipItemMngServiceImpl.ITEM_DO.createTime)}))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch();
        return PagingVO.builder().total(count).records(dataList).build();
    }

    private PagingVO<BipItemDO> queryItems(BipItemOffShelfQueryParamVO queryParamVO) {
        BooleanExpression condition = ITEM_DO.isNotNull();
        if (queryParamVO.getOuId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getState())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.state.eq((Object)queryParamVO.getState()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getShelfCode())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.shelfCode.eq((Object)queryParamVO.getShelfCode()));
        }
        if (queryParamVO.getCreateUserId() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.createUserId.eq((Object)queryParamVO.getCreateUserId()));
        }
        if (queryParamVO.getOffShelfReason() != null) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.offShelfReason.eq((Object)queryParamVO.getOffShelfReason()));
        }
        if (StrUtil.isNotBlank((CharSequence)queryParamVO.getCreator())) {
            condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.creator.like("%" + queryParamVO.getCreator() + "%"));
        }
        condition = ExpressionUtils.and((Predicate)condition, (Predicate)BipItemMngServiceImpl.ITEM_DO.onShelf.eq(Boolean.valueOf(false)).and((Predicate)BipItemMngServiceImpl.ITEM_DO.offShelfReason.isNotNull()).and((Predicate)BipItemMngServiceImpl.ITEM_DO.deleteFlag.eq((Object)0)));
        PageRequest pageRequest = queryParamVO.getPageRequest();
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)ITEM_DO).from((EntityPath)ITEM_DO)).where((Predicate)condition);
        long count = jpaQuery.fetchCount();
        List dataList = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrder(pageRequest, ITEM_DO, new OrderSpecifier[]{new OrderSpecifier(Order.DESC, BipItemMngServiceImpl.ITEM_DO.createTime)}))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch();
        return PagingVO.builder().total(count).records(dataList).build();
    }

    private PagingVO<BipItemQueryRespVO> querySkuByCategoryCode(Long ouId, String bipCategoryCode, Boolean onShelf) {
        BipItemCategoryDO category = this.itemCategoryRepoProc.getByCode(bipCategoryCode);
        if (category == null) {
            return PagingVO.builder().total(0L).records(Collections.emptyList()).build();
        }
        NumberPath<Long> itemCatPath = this.itemRepoProc.getCategory(category.getLevel());
        BooleanExpression condition = itemCatPath.eq((Object)category.getId()).and((Predicate)BipItemMngServiceImpl.ITEM_DO.deleteFlag.ne((Object)1));
        if (ouId != null) {
            condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.ouId.eq((Object)ouId));
        }
        if (onShelf != null) {
            condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.onShelf.eq(onShelf));
        }
        return this.queryItemAndSku((Predicate)condition, PageRequest.of((int)0, (int)Integer.MAX_VALUE));
    }

    private PagingVO<BipItemQueryRespVO> querySku(BipItemQueryParamVO queryParamVO) {
        QBipItemSkuDO qSku = QBipItemSkuDO.bipItemSkuDO;
        BooleanExpression condition = null;
        if (queryParamVO.getOuId() != null) {
            condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        if (queryParamVO.getOnShelf() != null) {
            condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.onShelf.eq(queryParamVO.getOnShelf()));
        }
        condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.deleteFlag.ne((Object)1));
        if (CharSequenceUtil.isNotBlank((CharSequence)queryParamVO.getItemCode())) {
            condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.itemCode.like("%" + queryParamVO.getItemCode() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)queryParamVO.getItemName())) {
            condition = this.appendAndCondition(condition, BipItemMngServiceImpl.ITEM_DO.itemName.like("%" + queryParamVO.getItemName() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)queryParamVO.getSkuCode())) {
            condition = this.appendAndCondition(condition, qSku.skuCode.like("%" + queryParamVO.getSkuCode() + "%"));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)queryParamVO.getSkuName())) {
            condition = this.appendAndCondition(condition, qSku.itemName.like("%" + queryParamVO.getSkuName() + "%"));
        }
        return this.queryItemAndSku((Predicate)condition, queryParamVO.getPageRequest());
    }

    private PagingVO<BipItemQueryRespVO> queryItemAndSku(Predicate condition, PageRequest pageRequest) {
        QBipItemSkuDO qSku = QBipItemSkuDO.bipItemSkuDO;
        QBipItemExtDO qExt = QBipItemExtDO.bipItemExtDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BipItemQueryRespVO.class, (Expression[])new Expression[]{qSku.bipItemId, qSku.id.as("skuId"), qSku.skuCode, qSku.itemName.as("skuName"), BipItemMngServiceImpl.ITEM_DO.categoryId1, BipItemMngServiceImpl.ITEM_DO.categoryName1, BipItemMngServiceImpl.ITEM_DO.categoryId2, BipItemMngServiceImpl.ITEM_DO.categoryName2, BipItemMngServiceImpl.ITEM_DO.categoryId3, BipItemMngServiceImpl.ITEM_DO.categoryName3, BipItemMngServiceImpl.ITEM_DO.itemCode, BipItemMngServiceImpl.ITEM_DO.itemName, BipItemMngServiceImpl.ITEM_DO.itemId, qSku.price, qExt.unit})).from((EntityPath)qSku)).leftJoin((EntityPath)ITEM_DO)).on((Predicate)qSku.bipItemId.eq(BipItemMngServiceImpl.ITEM_DO.id))).leftJoin((EntityPath)qExt)).on((Predicate)qExt.id.eq(qSku.bipItemId))).where(condition);
        long count = jpaQuery.fetchCount();
        if (count == 0L) {
            return PagingVO.builder().total(count).records(Collections.emptyList()).build();
        }
        OrderSpecifier[] defaultOrders = new OrderSpecifier[]{BipItemMngServiceImpl.ITEM_DO.createTime.desc()};
        List records = ((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.orderBy(this.obtainOrder(pageRequest, qSku, defaultOrders))).offset(pageRequest.getOffset())).limit((long)pageRequest.getPageSize())).fetch();
        if (records.isEmpty()) {
            return PagingVO.builder().total(count).records(Collections.emptyList()).build();
        }
        Map<String, String> unitMap = this.convertUdc(UdcEnum.COM_UOM_BX);
        for (BipItemQueryRespVO item : records) {
            item.setUnitName(unitMap.get(item.getUnit()));
        }
        return PagingVO.builder().total(count).records(records).build();
    }

    private List<BipItemPicRespVO> queryItemPic(Long bipItemId) {
        List<BipItemPicDO> picDOList = this.itemPicRepoProc.queryByBipItemId(bipItemId);
        if (picDOList.isEmpty()) {
            return Collections.emptyList();
        }
        return picDOList.stream().map(CONVERT::itemPic2DetailRespVO).collect(Collectors.toList());
    }

    private List<BipItemSkuRespVO> querySkuDetail(Long bipItemId) {
        List<BipItemSkuDO> skuDOList = this.itemSkuRepoProc.queryByBipItemId(bipItemId);
        if (skuDOList.isEmpty()) {
            return Collections.emptyList();
        }
        Map itemTypeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "ITEM_TYPE");
        Map itemType2UdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "ITEM_TYPE2");
        return skuDOList.stream().map(t -> {
            BipItemSkuRespVO vo = CONVERT.sku2DetailRespVO((BipItemSkuDO)t);
            vo.setAttrList(this.convert2List(t.getAttr(), BipItemSkuAttrRespVO.class));
            if (StringUtils.hasLength((String)vo.getType())) {
                vo.setTypeName((String)itemTypeUdcMap.get(vo.getType()));
            }
            if (StringUtils.hasLength((String)vo.getMateriel())) {
                vo.setMaterielName((String)itemType2UdcMap.get(vo.getMateriel()));
            }
            return vo;
        }).collect(Collectors.toList());
    }

    private void validateForSave(BipItemSaveVO saveVO) {
        boolean exists = false;
        exists = this.itemCategoryRepoProc.existsById(saveVO.getCategoryId3());
        Assert.isTrue((boolean)exists, (String)"\u5546\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        exists = this.itemRepoProc.existsByItemId(saveVO.getItemId());
        Assert.isFalse((boolean)exists, (String)"\u5546\u54c1\u5df2\u5b58\u5728", (Object[])new Object[0]);
        this.validateForSaveSku(saveVO.getSkuList());
        if (Boolean.FALSE.equals(saveVO.getFareFree())) {
            Assert.notNull((Object)saveVO.getFareTmplId(), (String)"\u8fd0\u8d39\u6a21\u677f\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateForUpdate(Long id, BipItemUpdateVO updateVO) {
        boolean exists = this.itemRepoProc.existsById(id);
        Assert.isTrue((boolean)exists, (String)"\u4fee\u6539\u7684\u5546\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        String state = this.itemRepoProc.getState(id);
        if (!StrUtil.equals((CharSequence)state, (CharSequence)UdcEnum.BIP_ITEM_STATE_DRAFT.getValueCode()) && !StrUtil.equals((CharSequence)state, (CharSequence)UdcEnum.BIP_ITEM_STATE_OFF.getValueCode())) {
            Long itemIdOld = this.itemRepoProc.getItemId(id);
            Assert.isTrue((updateVO.getItemId().longValue() == itemIdOld.longValue() ? 1 : 0) != 0, (String)"\u5546\u54c1\u5df2\u4e0d\u53ef\u66f4\u6539", (Object[])new Object[0]);
        }
        exists = this.itemCategoryRepoProc.existsById(updateVO.getCategoryId3());
        Assert.isTrue((boolean)exists, (String)"\u5546\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.validateForUpdateSku(id, updateVO.getSkuList());
        if (Boolean.FALSE.equals(updateVO.getFareFree())) {
            Assert.notNull((Object)updateVO.getFareTmplId(), (String)"\u8fd0\u8d39\u6a21\u677f\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateForSaveSku(List<BipItemSkuSaveVO> skuSaveVOList) {
        int skuNum = skuSaveVOList.size();
        HashSet<String> skuCodes = new HashSet<String>(skuNum);
        for (BipItemSkuSaveVO sku : skuSaveVOList) {
            Assert.isFalse((boolean)skuCodes.contains(sku.getSkuCode()), (String)"SKU\u7f16\u7801\u3010{}\u3011\u91cd\u590d", (Object[])new Object[]{sku.getSkuCode()});
            skuCodes.add(sku.getSkuCode());
            sku.setShipOne((Boolean)ObjectUtil.defaultIfNull((Object)sku.getShipOne(), (Object)false));
            sku.setStock((Integer)ObjectUtil.defaultIfNull((Object)sku.getStock(), (Object)0));
            sku.setLimitBuy((Integer)ObjectUtil.defaultIfNull((Object)sku.getLimitBuy(), (Object)1));
            if (skuNum <= 1) continue;
            Assert.notEmpty((Iterable)sku.getAttrList(), (String)"\u8d85\u8fc7\u4e00\u4e2aSKU\u65f6\uff0c\u9500\u552e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateForUpdateSku(Long id, List<BipItemSkuUpdateVO> skuUpdateVOList) {
        Map<String, Long> existsCodeMap = this.itemSkuRepoProc.getSkuCode(id);
        int skuNum = skuUpdateVOList.size();
        HashSet<String> skuCodes = new HashSet<String>(skuNum);
        for (BipItemSkuUpdateVO sku : skuUpdateVOList) {
            Assert.isFalse((boolean)skuCodes.contains(sku.getSkuCode()), (String)"SKU\u7f16\u7801\u3010{}\u3011\u91cd\u590d", (Object[])new Object[]{sku.getSkuCode()});
            skuCodes.add(sku.getSkuCode());
            Assert.isTrue((boolean)ObjectUtil.equal((Object)existsCodeMap.get(sku.getSkuCode()), (Object)sku.getId()), (String)"SKU\u7f16\u7801\u3010{}\u3011\u5df2\u5b58\u5728", (Object[])new Object[]{sku.getSkuCode()});
            sku.setShipOne((Boolean)ObjectUtil.defaultIfNull((Object)sku.getShipOne(), (Object)false));
            sku.setStock((Integer)ObjectUtil.defaultIfNull((Object)sku.getStock(), (Object)0));
            sku.setLimitBuy((Integer)ObjectUtil.defaultIfNull((Object)sku.getLimitBuy(), (Object)1));
            if (skuNum <= 1) continue;
            Assert.notEmpty((Iterable)sku.getAttrList(), (String)"\u8d85\u8fc7\u4e00\u4e2aSKU\u65f6\uff0c\u9500\u552e\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void updateSku(BipItemDO itemDO, List<BipItemSkuUpdateVO> skuUpdateVOList) {
        Map<Long, BipItemSkuDO> oldSkuMap = this.itemSkuRepoProc.queryByBipItemId(itemDO.getId()).stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        int i = 0;
        ArrayList<BipItemSkuDO> doList = new ArrayList<BipItemSkuDO>(skuUpdateVOList.size());
        BigDecimal minPrice = null;
        BipItemSkuDO skuDO = null;
        for (BipItemSkuUpdateVO vo : skuUpdateVOList) {
            if (vo.getId() == null) {
                skuDO = CONVERT.skuUpdateVO2DO(vo);
            } else {
                skuDO = oldSkuMap.get(vo.getId());
                CONVERT.copySkuVO2DO(vo, skuDO);
            }
            skuDO.setBipItemId(itemDO.getId());
            skuDO.setSortNo(i++);
            skuDO.setAttr(CollUtil.isEmpty((Collection)vo.getAttrList()) ? "" : this.convertObj2Str(vo.getAttrList()));
            minPrice = minPrice == null ? vo.getPrice() : NumberUtil.min((BigDecimal[])new BigDecimal[]{minPrice, vo.getPrice()});
            doList.add(skuDO);
        }
        this.itemSkuRepo.saveAll(doList);
        itemDO.setPrice(minPrice);
    }

    private void saveSku(BipItemDO itemDO, List<BipItemSkuSaveVO> skuSaveVOList) {
        int i = 0;
        ArrayList<BipItemSkuDO> doList = new ArrayList<BipItemSkuDO>(skuSaveVOList.size());
        BigDecimal minPrice = null;
        BipItemSkuDO skuDO = null;
        for (BipItemSkuSaveVO vo : skuSaveVOList) {
            skuDO = CONVERT.skuSaveVO2DO(vo);
            skuDO.setBipItemId(itemDO.getId());
            skuDO.setSortNo(i++);
            skuDO.setAttr(CollUtil.isEmpty((Collection)vo.getAttrList()) ? "" : this.convertObj2Str(vo.getAttrList()));
            minPrice = minPrice == null ? vo.getPrice() : NumberUtil.min((BigDecimal[])new BigDecimal[]{minPrice, vo.getPrice()});
            doList.add(skuDO);
        }
        this.itemSkuRepo.saveAll(doList);
        itemDO.setPrice(minPrice);
    }

    private void saveItemPic(BipItemDO itemDO, List<BipItemPicSaveVO> picSaveVOList) {
        int i = 1;
        ArrayList<BipItemPicDO> doList = new ArrayList<BipItemPicDO>(picSaveVOList.size());
        BipItemPicDO picDO = null;
        BipItemPicDO mainPicDO = null;
        for (BipItemPicSaveVO vo : picSaveVOList) {
            picDO = CONVERT.itemPicSaveVO2DO(vo);
            picDO.setBipItemId(itemDO.getId());
            picDO.setSortNo(i++);
            picDO.setPic(this.isImage(vo.getMimeType()));
            if (Boolean.TRUE.equals(vo.getMain())) {
                mainPicDO = picDO;
                mainPicDO.setSortNo(0);
            }
            doList.add(picDO);
        }
        if (mainPicDO != null) {
            itemDO.setMainPicId(mainPicDO.getId());
            itemDO.setMainPicFileCode(mainPicDO.getFileCode());
            itemDO.setMainPicUrl(mainPicDO.getUrl());
        }
        this.itemPicRepo.saveAll(doList);
    }

    private void saveItemExt(BipItemDO itemDO, BipItemSaveVO itemSaveVO) {
        BipItemExtDO extDO = new BipItemExtDO();
        extDO.setBipItemId(itemDO.getId());
        extDO.setContent(this.convertObj2Str(itemSaveVO.getContentPicList()));
        extDO.setSpec(CollUtil.isEmpty((Collection)itemSaveVO.getSpecList()) ? "" : this.convertObj2Str(itemSaveVO.getSpecList()));
        extDO.setUnit(itemSaveVO.getUnit());
        extDO.setTimeOnShelfPlan(null);
        extDO.setTimeOffShelfPlan(null);
        this.itemExtRepo.save(extDO);
        itemDO.setExtId(extDO.getId());
    }

    private void updateItemExt(BipItemDO itemDO, BipItemUpdateVO itemUpdateVO) {
        Long extId = itemDO.getExtId();
        BipItemExtDO extDO = this.itemExtRepo.findById(extId).orElse(new BipItemExtDO());
        extDO.setId(extId);
        extDO.setContent(this.convertObj2Str(itemUpdateVO.getContentPicList()));
        extDO.setSpec(CollUtil.isEmpty((Collection)itemUpdateVO.getSpecList()) ? "" : this.convertObj2Str(itemUpdateVO.getSpecList()));
        extDO.setUnit(itemUpdateVO.getUnit());
        extDO.setTimeOnShelfPlan(null);
        extDO.setTimeOffShelfPlan(null);
        this.itemExtRepo.save(extDO);
    }

    private boolean isImage(String mimeType) {
        return mimeType != null && mimeType.toLowerCase().startsWith("image/");
    }

    public BipItemMngServiceImpl(BipItemRepo itemRepo, BipItemRepoProc itemRepoProc, BipItemExtRepo itemExtRepo, BipItemExtRepoProc itemExtRepoProc, BipItemPicRepo itemPicRepo, BipItemPicRepoProc itemPicRepoProc, BipItemSkuRepo itemSkuRepo, BipItemSkuRepoProc itemSkuRepoProc, BipItemSkuRepoProc bipItemSkuRepoProc, BipItemCategoryRepoProc itemCategoryRepoProc, BipCompanyManageRepoProc bipCompanyManageRepoProc, DelayTaskSender delayTaskSender, BipItemService bipItemService, RmiSysNextNumberService sysNextNumberService) {
        this.itemRepo = itemRepo;
        this.itemRepoProc = itemRepoProc;
        this.itemExtRepo = itemExtRepo;
        this.itemExtRepoProc = itemExtRepoProc;
        this.itemPicRepo = itemPicRepo;
        this.itemPicRepoProc = itemPicRepoProc;
        this.itemSkuRepo = itemSkuRepo;
        this.itemSkuRepoProc = itemSkuRepoProc;
        this.bipItemSkuRepoProc = bipItemSkuRepoProc;
        this.itemCategoryRepoProc = itemCategoryRepoProc;
        this.bipCompanyManageRepoProc = bipCompanyManageRepoProc;
        this.delayTaskSender = delayTaskSender;
        this.bipItemService = bipItemService;
        this.sysNextNumberService = sysNextNumberService;
    }

    static {
        STATE_APPLY_SHELF_ON.add(UdcEnum.BIP_ITEM_STATE_DRAFT.getValueCode());
        STATE_APPLY_SHELF_ON.add(UdcEnum.BIP_ITEM_STATE_OFF.getValueCode());
        STATE_APPLY_SHELF_ON.add(UdcEnum.BIP_ITEM_STATE_REJECT.getValueCode());
        STATE_APPLY_SHELF_OFF = new HashSet<String>(8);
        STATE_APPLY_SHELF_OFF.add(UdcEnum.BIP_ITEM_STATE_SHELF.getValueCode());
        STATE_APPLY_SHELF_OFF.add(UdcEnum.BIP_ITEM_STATE_REJECT.getValueCode());
    }
}

