/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.task.delay.common.DelayTaskSender;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.order.param.SalDoSignUserInfoDto;
import com.elitesland.yst.production.order.param.SalSoSignReqDto;
import com.elitesland.yst.production.sale.api.dto.BipCustPriceDTO;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponCustService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderDParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipAddressVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderPayVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderDSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.common.model.UserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCouponDO;
import com.elitesland.yst.production.sale.entity.BipCouponItemDO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipOrderBackDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.ext.cpcn.resp.CPCN5011Resp;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipCouponItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCouponRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepo;
import com.elitesland.yst.production.sale.repo.shop.MktGiftRepoProc;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoRpcService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.service.shop.BipAddressServiceImpl;
import com.elitesland.yst.production.sale.service.shop.BipCartServiceImpl;
import com.elitesland.yst.production.sale.service.shop.BipOrdeDServiceimpl;
import com.elitesland.yst.production.sale.service.shop.BipOrderToOmsServiceimpl;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBankAccRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipOrderServiceimpl
extends BaseServiceImpl
implements BipOrderService {
    private static final Logger log = LoggerFactory.getLogger(BipOrderServiceimpl.class);
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderBackDRepo bipOrderBackDRepo;
    @Autowired
    private BipCartServiceImpl bipCartService;
    @Autowired
    private BipOrdeDServiceimpl bipOrderDService;
    @Autowired
    private BipAddressServiceImpl bipAddressService;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    @Autowired
    private BipCouponItemRepo bipCouponItemRepo;
    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;
    @Autowired
    private BipCouponRepo bipCouponRepo;
    @Autowired
    private BipOrderDRepoProc bipOrderDRepoProc;
    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;
    @Autowired
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    @Autowired
    private RmiOrgOuService rmiOrgOuService;
    @Autowired
    private BipItemService bipItemService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final QBipOrderDO qBipOrderDo = QBipOrderDO.bipOrderDO;
    private final PriSalePriceService salePriceService;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final BipItemAppService bipItemAppService;
    @Autowired
    private BipCompanyManageService bipCompanyManageService;
    @Autowired
    private BipOrderToOmsServiceimpl bipOrderToOmsServiceimpl;
    @Autowired
    private BipCartRepoProc bipCartRepoProc;
    @Autowired
    private RmiOrgEmpService rmiOrgEmpService;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;
    @Autowired
    private RmiDoRpcService rmiDoRpcService;
    @Autowired
    private BipCouponCustService bipCouponCustService;
    @Autowired
    private final DelayTaskSender delayTaskSender;
    @Autowired
    private MktGiftRepo mktGiftRepo;
    private final QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
    private final MktGiftRepoProc mktGiftRepoProc;
    private String appid;
    private String secret;
    private String grantType;
    private String payMentNoticrl;
    private static final HashMap<String, String> statusMap = new HashMap(8);
    private static final HashMap<String, String> payStatusMap = new HashMap(8);

    @Transactional(rollbackFor={Exception.class})
    public CPCN5011Resp createOrder(BipAppOrderSaveVO bipAppOrderSaveVO, Map hashMap) {
        LocalDateTime nowDateTime = LocalDateTime.now();
        log.info("\u8ba2\u5355\u751f\u6210---" + JSON.toJSONString((Object)bipAppOrderSaveVO));
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        Long custId = bipCustUserBindDO.getCustId();
        if (custId == null) {
            throw new BusinessException("\u8bf7\u5148\u7ed1\u5b9a\u516c\u53f8!");
        }
        BipOrderDO bipOrderDo = new BipOrderDO();
        bipOrderDo.setOuId(bipAppOrderSaveVO.getOuId());
        bipOrderDo.setSecOuId(bipAppOrderSaveVO.getOuId());
        this.fillOrderCustInfo(bipCustUserBindDO, bipOrderDo);
        bipOrderDo.setRemark(bipAppOrderSaveVO.getRemark());
        this.bipOrderRepo.saveAndFlush(bipOrderDo);
        List<BipOrderDDO> bipOrderDDOS = new ArrayList<BipOrderDDO>();
        List cartIds = bipAppOrderSaveVO.getCartIds();
        if (Objects.nonNull(cartIds)) {
            BipCartSettleParmVO bipCartSettleParmVO = new BipCartSettleParmVO();
            bipCartSettleParmVO.setCartIds(cartIds);
            bipCartSettleParmVO.setAddressId(bipAppOrderSaveVO.getAddressId());
            bipCartSettleParmVO.setCouponId(bipAppOrderSaveVO.getCouponId());
            bipCartSettleParmVO.setOuId(bipAppOrderSaveVO.getOuId());
            bipCartVo = this.bipCartService.findMyCartEable(bipCartSettleParmVO);
            bipOrderDo.setCouponId(bipCartVo.getCouponId());
            log.info("\u8d2d\u7269\u8f66\u751f\u5355\u4f18\u60e0\u5238id--" + bipCartVo.getCouponId());
            log.info("\u8ba2\u5355\u751f\u6210\u8d2d\u7269\u8f66\u4fe1\u606f---" + JSON.toJSONString((Object)bipCartVo));
            bipCartItemRespVOs = bipCartVo.getItemList();
            if (bipAppOrderSaveVO.getGiftIdList() != null && bipAppOrderSaveVO.getGiftIdList().size() > 0) {
                bipCartItemRespVOs.forEach(item -> bipAppOrderSaveVO.getGiftIdList().forEach(gift -> {
                    if (gift.get(item.getSkuId()) != null && ((List)gift.get(item.getSkuId())).size() > 0) {
                        item.setGiftCodes(String.join((CharSequence)",", (Iterable)gift.get(item.getSkuId())));
                    }
                }));
            }
            bipOrderDDOS = this.bipOrderDService.createOrder(bipCartItemRespVOs);
            this.bipCartRepoProc.deleteCartByIds(cartIds);
        } else if (Objects.nonNull(bipAppOrderSaveVO.getItemId())) {
            if (bipAppOrderSaveVO.getItemNum() <= 0L || bipAppOrderSaveVO.getItemNum() == null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0!");
            }
            BipBuyNowSettleParmVO bipBuyNowSettleParmVO = new BipBuyNowSettleParmVO();
            bipBuyNowSettleParmVO.setItemId(bipAppOrderSaveVO.getItemId());
            bipBuyNowSettleParmVO.setSkuId(bipAppOrderSaveVO.getSkuId());
            bipBuyNowSettleParmVO.setItemNum(bipAppOrderSaveVO.getItemNum());
            bipBuyNowSettleParmVO.setFirstItemFlag(bipAppOrderSaveVO.getFirstItemFlag());
            bipBuyNowSettleParmVO.setCouponId(bipAppOrderSaveVO.getCouponId());
            bipBuyNowSettleParmVO.setOuId(bipAppOrderSaveVO.getOuId());
            bipBuyNowSettleParmVO.setAddressId(bipAppOrderSaveVO.getAddressId());
            log.info("\u7acb\u5373\u8d2d\u4e70\u53c2\u6570---" + JSON.toJSONString((Object)bipBuyNowSettleParmVO));
            bipCartVo = this.bipCartService.findBuyNowOrderPer(bipBuyNowSettleParmVO);
            log.info("\u7acb\u5373\u8d2d\u4e70\u751f\u5355\u4f18\u60e0\u5238id--" + bipCartVo.getCouponId());
            bipOrderDo.setCouponId(bipCartVo.getCouponId());
            log.info("\u8ba2\u5355\u751f\u6210\u7acb\u5373\u8d2d\u4e70\u4fe1\u606f---" + JSON.toJSONString((Object)bipCartVo));
            bipCartItemRespVOs = bipCartVo.getItemList();
            if (bipAppOrderSaveVO.getGiftIdList() != null && bipAppOrderSaveVO.getGiftIdList().size() > 0) {
                bipCartItemRespVOs.forEach(item -> bipAppOrderSaveVO.getGiftIdList().forEach(gift -> {
                    if (gift.get(item.getSkuId()) != null && ((List)gift.get(item.getSkuId())).size() > 0) {
                        item.setGiftCodes(String.join((CharSequence)",", (Iterable)gift.get(item.getSkuId())));
                    }
                }));
            }
            bipOrderDDOS = this.bipOrderDService.createOrder(bipCartItemRespVOs);
        }
        String docNo = this.rmiSysNextNumberService.generateCode("yst-sale", "ORDER_DOC_NO", new ArrayList<String>());
        bipOrderDo.setDocNo(docNo);
        bipOrderDo.setPayMethodName(bipAppOrderSaveVO.getPayWay());
        bipOrderDo.setStatus("unpaid");
        bipOrderDo.setOrderTime(LocalDateTime.now());
        bipOrderDDOS.stream().forEach(bipOrderDDo -> {
            bipOrderDDo.setOuId(bipOrderDo.getOuId());
            bipOrderDDo.setOuCode(bipOrderDo.getOuCode());
            bipOrderDo.setOuName(bipOrderDo.getOuName());
            bipOrderDDo.setOrderId(bipOrderDo.getId());
            bipOrderDDo.setOrderDocNo(bipOrderDo.getDocNo());
            bipOrderDDo.setAllowBackNum(bipOrderDDo.getBuyQty());
        });
        this.bulidOrderAmtInfo(bipOrderDo, bipOrderDDOS);
        if (bipOrderDo.getFareAmt().compareTo(BigDecimal.ZERO) > 0) {
            bipOrderDo.setFreeFare(false);
        }
        this.buildCouponInfo(bipOrderDo, bipOrderDDOS);
        log.info("\u8ba2\u5355\u751f\u6210\u5b50\u5355\u4fe1\u606f---" + JSON.toJSONString(bipOrderDDOS));
        this.bipOrderDRepo.saveAll(bipOrderDDOS);
        bipOrderDo.setAdressId(bipAppOrderSaveVO.getAddressId());
        if (null != bipAppOrderSaveVO.getAddressId()) {
            BipAddressVO bipAddressVO = this.bipAddressService.findById(bipAppOrderSaveVO.getAddressId());
            bipOrderDo.setCity(bipAddressVO.getCity());
            bipOrderDo.setCityName(bipAddressVO.getCityName());
            bipOrderDo.setCounty(bipAddressVO.getCounty());
            bipOrderDo.setCountyName(bipAddressVO.getCountyName());
            bipOrderDo.setContPerson(bipAddressVO.getContPerson());
            if (null != bipAddressVO.getDefaultFlag()) {
                bipOrderDo.setDefaultFlag(bipAddressVO.getDefaultFlag());
            }
            bipOrderDo.setDetailAddr(bipAddressVO.getDetailAddr());
            bipOrderDo.setMobile(bipAddressVO.getMobile());
            bipOrderDo.setProvince(bipAddressVO.getProvince());
            bipOrderDo.setProvinceName(bipAddressVO.getProvinceName());
        }
        if (bipOrderDo.getPayMethodName().equals("offline")) {
            bipOrderDo.setPayDoneAmt(BigDecimal.ZERO);
            bipOrderDo.setPayTime(null);
        }
        this.bipOrderRepo.save(bipOrderDo);
        hashMap.put("id", bipOrderDo.getId());
        log.info("\u8ba2\u5355\u751f\u6210\u4e3b\u5355\u4fe1\u606f---" + JSON.toJSONString((Object)bipOrderDo));
        CPCN5011Resp resp = null;
        if ("online".equals(bipAppOrderSaveVO.getPayWay())) {
            nowDateTime = nowDateTime.plusMinutes(10L);
            if (bipAppOrderSaveVO.getCode() == null) {
                throw new BusinessException("\u7ebf\u4e0a\u652f\u4ed8code\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (bipOrderDo.getPayAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0!");
            }
        } else {
            nowDateTime = nowDateTime.plusHours(48L);
        }
        if ("offline".equals(bipAppOrderSaveVO.getPayWay())) {
            if (bipOrderDo.getCustId() == null) {
                throw new BusinessException("\u8ba2\u5355\u5ba2\u6237id\u4e3a\u7a7a!");
            }
            CrmCustDO crmCustDO = this.getByCustId(bipOrderDo.getCustId());
            if (null == crmCustDO) {
                throw new BusinessException("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
            }
            this.bipOrderToOmsServiceimpl.sendToOms(bipOrderDo.getId());
        }
        log.info("\u53d1\u8d77\u8ba2\u5355\u53d6\u6d88\u5ef6\u65f6\u961f\u5217");
        this.delayTaskSender.send("bip_order_cancle", String.valueOf(bipOrderDo.getId()), (Serializable)bipOrderDo.getId(), nowDateTime);
        if ("online".equals(bipAppOrderSaveVO.getPayWay())) {
            String payStatus = "ps";
            String status = "shipping";
            String txsn = "txsn";
            BigDecimal amont = bipOrderDo.getPayAmt();
            amont = amont.divide(BigDecimal.valueOf(100L));
            log.info("\u56de\u8c03\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u53c2\u6570\uff1a{},{},{},{}", new Object[]{payStatus, status, txsn, amont});
            this.updateOrderPayStatus(payStatus, docNo, status, txsn, LocalDateTime.now(), amont);
            this.updateOrderDPayDoneAmt(docNo);
            log.info("\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u6210\u529f");
            log.info("\u66f4\u65b0\u9500\u91cf");
            this.bipItemAppService.updateItemSalNumAll(docNo);
            log.info("\u66f4\u65b0\u9500\u91cf\u5b8c\u6210");
            BipOrderDO bipOrderDO = this.bipOrderRepoProc.findOrderByDocNo(docNo);
            log.info("\u540c\u6b65\u8ba2\u5355\u4fe1\u606f\u5f00\u59cb---------------" + bipOrderDO.getDocNo());
            this.bipOrderToOmsServiceimpl.sendToOms(bipOrderDO.getId());
        }
        return resp;
    }

    public BigDecimal getUnpaidOrderByCustId(Long custId) {
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.custId.eq((Object)custId).and((Predicate)qBipOrderDO.status.eq((Object)"unpaid")).and((Predicate)qBipOrderDO.payMethodName.eq((Object)"offline")).and((Predicate)qBipOrderDO.deleteFlag.eq((Object)0));
        Iterable iterables = this.bipOrderRepo.findAll((Predicate)expression);
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            return list.stream().map(BipOrderDO::getPayAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return new BigDecimal("0.00");
    }

    public CrmCustDO getByCustId(Long custId) {
        QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
        BooleanExpression expression = qCrmCustDO.id.eq((Object)custId).and((Predicate)qCrmCustDO.deleteFlag.eq((Object)0));
        Optional optional = this.crmCustRepo.findOne((Predicate)expression);
        if (optional.isPresent()) {
            return (CrmCustDO)optional.get();
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map saveOrder(BipAppOrderSaveVO bipAppOrderSaveVO) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        CPCN5011Resp cpcn5011Resp = this.createOrder(bipAppOrderSaveVO, hashMap);
        if (cpcn5011Resp != null) {
            hashMap.put("code", cpcn5011Resp.getQRAuthCode());
        }
        return hashMap;
    }

    private void fillOrderCustInfo(BipCustUserBindDO bipCustUserBindDO, BipOrderDO order) {
        Long custId = bipCustUserBindDO.getCustId();
        order.setOuId(bipCustUserBindDO.getOuId());
        Long ouId = bipCustUserBindDO.getOuId();
        ArrayList<Long> ouList = new ArrayList<Long>();
        ouList.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouList);
        log.info("\u8c03\u7528\u516c\u53f8\u63a5\u53e3\u53c2\u6570---" + JSON.toJSONString((Object)orgOuRpcDtoParam));
        List<OrgOuRpcDTO> orgOuRpcDTOS = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        if (orgOuRpcDTOS != null && !orgOuRpcDTOS.isEmpty()) {
            OrgOuRpcDTO orgOuRpcDTO = orgOuRpcDTOS.get(0);
            order.setOuName(orgOuRpcDTO.getOuName());
            order.setOuCode(orgOuRpcDTO.getOuCode());
        }
        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
        param.setEmpIds(Arrays.asList(bipCustUserBindDO.getAgentEmpId()));
        List<OrgEmpRpcDTO> emp = this.rmiOrgEmpService.findEmpListByParam(param);
        log.info("\u8c03\u7528\u5458\u5de5\u4fe1\u606f:" + JSON.toJSONString(emp));
        emp.stream().filter(emp1 -> emp1.getId().equals(bipCustUserBindDO.getAgentEmpId())).findFirst().ifPresent(oo -> {
            order.setAgentCode(oo.getBuCode());
            order.setAgentName(oo.getEmpName());
        });
        order.setCustId(custId);
        List bipCompanyManageRespVOS = this.bipCompanyManageService.findCompanyManageByOuIds(ouList);
        if (bipCompanyManageRespVOS != null && !bipCompanyManageRespVOS.isEmpty()) {
            BipCompanyManageRespVO bipCompanyManageRespVO = (BipCompanyManageRespVO)bipCompanyManageRespVOS.get(0);
            order.setBuId(bipCompanyManageRespVO.getBuId());
            order.setBuCode(bipCompanyManageRespVO.getBuCode());
            order.setBuName(bipCompanyManageRespVO.getBuName());
        }
        order.setCustCode(bipCustUserBindDO.getCustCode());
        order.setCustAccountId(bipCustUserBindDO.getUserId());
        order.setCustName(bipCustUserBindDO.getCustName());
        order.setAgentEmpId(bipCustUserBindDO.getAgentEmpId());
    }

    public void buildCouponInfo(BipOrderDO order, List<BipOrderDDO> bipOrderDDOS) {
        if (order.getCouponId() != null) {
            List<BipOrderDDO> matchList = this.match(order, bipOrderDDOS);
            log.info("\u5339\u914d\u5230\u7684\u8ba2\u5355\u4fe1\u606f:" + JSON.toJSONString(matchList));
            Map<Long, List<BipOrderDDO>> map = matchList.stream().collect(Collectors.groupingBy(bipOrderDDO -> bipOrderDDO.getId()));
            if (map == null) {
                log.info("\u4f18\u60e0\u5238\u672a\u5339\u914d\u5230\u8ba2\u5355\u4fe1\u606f");
                return;
            }
            for (int i = 0; i < bipOrderDDOS.size(); ++i) {
                BipOrderDDO bipOrderDDO2 = bipOrderDDOS.get(i);
                if (map.get(bipOrderDDO2.getId()) == null) continue;
                BipOrderDDO bipOrderDDOld = map.get(bipOrderDDO2.getId()).get(0);
                bipOrderDDO2.setCouponAmt(bipOrderDDOld.getCouponAmt());
                bipOrderDDO2.setPayAmt(bipOrderDDOld.getPayAmt());
            }
            this.bipCouponCustService.modifyOrderCouponCustUseStatus(order.getCouponId(), UdcEnum.SAL_COUPON_USE_STATUS_USED.getValueCode());
        }
        log.info("\u672a\u9009\u62e9\u4f18\u60e0\u5238");
        for (int i = 0; i < bipOrderDDOS.size(); ++i) {
            BipOrderDDO bipOrderDDO3 = bipOrderDDOS.get(i);
            BigDecimal couponAmt = bipOrderDDO3.getCouponAmt();
            if (couponAmt == null) {
                couponAmt = BigDecimal.ZERO;
            }
            BigDecimal itmeAmt = bipOrderDDO3.getItemAmt() == null ? BigDecimal.ZERO : bipOrderDDO3.getItemAmt();
            BigDecimal fareAmt = bipOrderDDO3.getFareAmt() == null ? BigDecimal.ZERO : bipOrderDDO3.getFareAmt();
            BigDecimal discountAmt = bipOrderDDO3.getDiscountAmt() == null ? BigDecimal.ZERO : bipOrderDDO3.getDiscountAmt();
            BigDecimal payAmt = itmeAmt.add(fareAmt).subtract(discountAmt).subtract(couponAmt);
            BigDecimal num = new BigDecimal(bipOrderDDO3.getBuyQty());
            BigDecimal buyAmt = payAmt.subtract(fareAmt).divide(num, 2, RoundingMode.HALF_UP);
            bipOrderDDO3.setPayAmt(payAmt);
            bipOrderDDO3.setBuyAmt(buyAmt);
            if (payAmt.compareTo(BigDecimal.ZERO) < 0) {
                bipOrderDDO3.setPayAmt(BigDecimal.ZERO);
            }
            if (!order.getPayMethodName().equals("offline")) continue;
            bipOrderDDO3.setPayDoneAmt(BigDecimal.ZERO);
        }
    }

    public List<BipOrderDDO> match(BipOrderDO order, List<BipOrderDDO> bipOrderDDOS) {
        Long couponId = order.getCouponId();
        BipCouponDO bipCouponDO = (BipCouponDO)this.bipCouponRepo.findById(couponId).get();
        ArrayList<BipOrderDDO> matchBipOrderDDOS = new ArrayList<BipOrderDDO>();
        List<BipCouponItemDO> bipCouponItemDOS = this.bipCouponItemRepo.findByCouponId(couponId);
        log.info("\u4f18\u60e0\u5238\u7684\u4fe1\u606f:" + JSON.toJSONString(bipCouponItemDOS));
        Set itemIdSet = bipCouponItemDOS.stream().map(bipCouponItemDO -> bipCouponItemDO.getBipItemId()).collect(Collectors.toSet());
        log.info("\u4f18\u60e0\u5238\u53ef\u7528\u5546\u54c1\u4fe1\u606f\u7684\u4fe1\u606f:" + JSON.toJSONString(itemIdSet));
        List matchBiprderDDos = bipOrderDDOS.stream().filter(bipOrderDDO -> itemIdSet.contains(bipOrderDDO.getItemId())).collect(Collectors.toList());
        log.info("\u5339\u914d\u5230\u4f18\u60e0\u5238\u8ba2\u5355\u7684\u4fe1\u606f:" + JSON.toJSONString(matchBiprderDDos));
        List finalBiporderDDos = matchBiprderDDos.stream().filter(bipOrderDDO -> {
            BigDecimal itmeAmt = bipOrderDDO.getItemAmt();
            BigDecimal limitAmt = bipCouponDO.getLimitAmt();
            log.info("itemAmt--" + itmeAmt + "||| limitAmt----" + limitAmt);
            return itmeAmt.compareTo(limitAmt) >= 0;
        }).collect(Collectors.toList());
        int size = finalBiporderDDos.size();
        if (size > 0) {
            BigDecimal freeAmt = bipCouponDO.getFreeAmt();
            if (freeAmt == null || freeAmt.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("\u4f18\u60e0\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            BigDecimal payAmt = order.getPayAmt();
            if (payAmt == null || payAmt.compareTo(BigDecimal.ZERO) <= 0) {
                throw new BusinessException("\u5b9e\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            if (freeAmt.compareTo(payAmt) > 0) {
                throw new BusinessException("\u4f18\u60e0\u5238\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d");
            }
            order.setCouponAmt(freeAmt);
            order.setPayAmt(payAmt.subtract(freeAmt));
            freeAmt.setScale(2, 1);
            BigDecimal amt = freeAmt.divide(BigDecimal.valueOf(size));
            BigDecimal balanceAmt = BigDecimal.ZERO;
            for (int i = 0; i < size; ++i) {
                balanceAmt = balanceAmt.add(amt);
                BipOrderDDO bipOrderDDO2 = (BipOrderDDO)finalBiporderDDos.get(i);
                if (i == size) {
                    amt = freeAmt.subtract(balanceAmt);
                }
                bipOrderDDO2.setCouponAmt(amt);
                log.info("\u4f18\u60e0\u5238\u5e73\u644a----" + bipOrderDDO2.getCouponAmt());
                bipOrderDDO2.setPayAmt(bipOrderDDO2.getItemAmt().subtract(amt).subtract(bipOrderDDO2.getDiscountAmt() == null ? BigDecimal.ZERO : bipOrderDDO2.getDiscountAmt()).add(bipOrderDDO2.getFareAmt() == null ? BigDecimal.ZERO : bipOrderDDO2.getFareAmt()));
                matchBipOrderDDOS.add(bipOrderDDO2);
            }
        }
        log.info("\u53ef\u7528\u4f18\u60e0\u5238\u7684\u5546\u54c1\u6240\u5728\u8ba2\u5355\u7684\u4fe1\u606f:" + JSON.toJSONString(matchBipOrderDDOS));
        return matchBipOrderDDOS;
    }

    public void bulidOrderAmtInfo(BipOrderDO bipOrderDo, List<BipOrderDDO> bipOrderDDOList) {
        BigDecimal custAmt = bipOrderDDOList.stream().map(bipOrderDDo -> {
            if (bipOrderDDo.getItemAmt() == null) {
                return BigDecimal.ZERO;
            }
            return bipOrderDDo.getItemAmt();
        }).reduce(BigDecimal::add).get();
        BigDecimal couponAmt = bipOrderDDOList.stream().map(bipOrderDDo -> {
            if (bipOrderDDo.getCouponAmt() == null) {
                return BigDecimal.ZERO;
            }
            return bipOrderDDo.getCouponAmt();
        }).reduce(BigDecimal::add).get();
        BigDecimal discountAmt = bipOrderDDOList.stream().map(bipOrderDDo -> {
            if (bipOrderDDo.getDiscountAmt() == null) {
                return BigDecimal.ZERO;
            }
            return bipOrderDDo.getDiscountAmt();
        }).reduce(BigDecimal::add).get();
        BigDecimal fareAmt = bipOrderDDOList.stream().map(bipOrderDDo -> {
            if (bipOrderDDo.getFareAmt() == null) {
                return BigDecimal.ZERO;
            }
            if (bipOrderDDo.getFareAmt().compareTo(BigDecimal.ZERO) < 0) {
                return BigDecimal.ZERO;
            }
            return bipOrderDDo.getFareAmt();
        }).reduce(BigDecimal::add).get();
        bipOrderDo.setCouponAmt(couponAmt);
        bipOrderDo.setDiscountAmt(discountAmt);
        bipOrderDo.setFareAmt(fareAmt);
        BigDecimal payAmt = custAmt.subtract(couponAmt).subtract(discountAmt).add(fareAmt);
        bipOrderDo.setPayAmt(payAmt);
        bipOrderDo.setItemAmt(custAmt);
        BigDecimal totalAmt = custAmt.add(fareAmt);
        bipOrderDo.setFreeFare(fareAmt.compareTo(BigDecimal.ZERO) > 0);
        bipOrderDo.setTotalAmt(totalAmt);
    }

    public PagingVO<BipOrderRespVO> findPageOrder(BipOrderParmVO bipOrderParmVO) {
        Predicate predicate = this.where(bipOrderParmVO);
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qBipOrderDo.getMetadata()));
        Page page = this.bipOrderRepo.findAll(predicate, (Pageable)bipOrderParmVO.getPageRequest());
        List resList = page.getContent().stream().map(BipOrderConvert.INSTANCE::doToResp).collect(Collectors.toList());
        resList.stream().forEach(bipOrderRespVO -> {
            if (bipOrderRespVO.getFareAmt().compareTo(BigDecimal.ZERO) > 0) {
                bipOrderRespVO.setFareType("\u4e0d\u5305\u90ae");
            } else {
                bipOrderRespVO.setFareType("\u5305\u90ae");
            }
            bipOrderRespVO.setStatusName(statusMap.get(bipOrderRespVO.getStatus()));
        });
        return PagingVO.builder().total(page.getTotalElements()).records(resList).build();
    }

    public BipOrderRespVO findPolymerizeOrder(Long orderId) {
        Optional couponDO;
        BipOrderDO biporderDo = (BipOrderDO)this.bipOrderRepo.findById(orderId).get();
        BipOrderRespVO bipOrderRespVO = BipOrderConvert.INSTANCE.doToResp(biporderDo);
        if (bipOrderRespVO.getFareAmt().compareTo(BigDecimal.ZERO) > 0) {
            bipOrderRespVO.setFareType("\u4e0d\u5305\u90ae");
        } else {
            bipOrderRespVO.setFareType("\u5305\u90ae");
        }
        BipOrderDParmVO bipOrderDParmVO = new BipOrderDParmVO();
        bipOrderDParmVO.setOrderId(orderId);
        List<BipOrderDRespVO> list = this.bipOrderDService.findOrderD(bipOrderDParmVO);
        for (BipOrderDRespVO orderDVO : list) {
            if (orderDVO.getSkuId() != null) {
                Long skuId = orderDVO.getSkuId();
                BipItemSkuDO bipItemSkuDO = (BipItemSkuDO)this.bipItemSkuRepo.findById(skuId).get();
                BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);
                orderDVO.setItemSkuRespVO(bipItemSkuRespVO);
            }
            ArrayList briefGiftVOS = new ArrayList();
            if (null == orderDVO.getGiftCodes() || orderDVO.getGiftCodes().length() <= 0) continue;
            List<Long> giftCodes = Arrays.asList(orderDVO.getGiftCodes().split(",")).stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
            List<MktGiftDO> giftList = this.mktGiftRepo.findByIdIn(giftCodes);
            giftList.forEach(gift -> {
                BipOrderDRespVO.BriefGiftVO respVO = new BipOrderDRespVO.BriefGiftVO();
                respVO.setItemCode(gift.getItemCode());
                respVO.setItemName(gift.getItemName());
                briefGiftVOS.add(respVO);
            });
            orderDVO.setBriefGiftVOS(briefGiftVOS);
        }
        bipOrderRespVO.setOrderDList(list);
        if (StringUtils.isNotBlank((CharSequence)biporderDo.getStatus())) {
            String statusName = statusMap.get(biporderDo.getStatus());
            bipOrderRespVO.setStatusName(statusName);
        }
        if (bipOrderRespVO.getCouponId() != null && (couponDO = this.bipCouponRepo.findById(bipOrderRespVO.getCouponId())).isPresent()) {
            bipOrderRespVO.setCouponCode(((BipCouponDO)couponDO.get()).getCouponCode());
        }
        return bipOrderRespVO;
    }

    public BipOrderRespVO findOrderById(Long id) {
        BipOrderDO biporderDo = (BipOrderDO)this.bipOrderRepo.findById(id).get();
        BipOrderRespVO bipOrderRespVO = BipOrderConvert.INSTANCE.doToResp(biporderDo);
        List<BipOrderDDO> bipOrderDDOList = this.bipOrderDRepo.findByOrderId(id);
        List<BipOrderDRespVO> bipOrderDRespVOS = BipOrderDConvert.INSTANCE.dosToResps(bipOrderDDOList);
        bipOrderRespVO.setOrderDList(bipOrderDRespVOS);
        return bipOrderRespVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrder(BipOrderSaveVO bipOrderSaveVO) {
        if (bipOrderSaveVO.getId() == null) {
            throw new BusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BipOrderDO bipOrderDO = (BipOrderDO)this.bipOrderRepo.findById(bipOrderSaveVO.getId()).get();
        BipOrderConvert.INSTANCE.copySaveToDo(bipOrderSaveVO, bipOrderDO);
        this.bipOrderRepo.save(bipOrderDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void cancleOrder(BipOrderSaveVO bipOrderSaveVO) {
        if (bipOrderSaveVO.getId() == null) {
            throw new BusinessException("\u53d6\u6d88\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)bipOrderSaveVO.getStatus())) {
            throw new BusinessException("\u53d6\u6d88\u8ba2\u5355\u6570\u636e\u5f02\u5e38!");
        }
        BipOrderDO bipOrderDo = (BipOrderDO)this.bipOrderRepo.findById(bipOrderSaveVO.getId()).get();
        List<BipOrderDDO> bipOrderDDOList = this.bipOrderDRepo.findByOrderId(bipOrderSaveVO.getId());
        bipOrderDDOList.stream().forEach(bipOrderDDO -> {
            Long skuId = bipOrderDDO.getSkuId();
            Long qty = bipOrderDDO.getBuyQty();
            this.bipItemService.incrementStock(skuId, Integer.valueOf(qty.intValue()));
            if (null != bipOrderDDO.getGiftCodes() && !bipOrderDDO.getGiftCodes().isEmpty()) {
                List<Long> giftCodes = Arrays.asList(bipOrderDDO.getGiftCodes().split(",")).stream().map(a -> Long.parseLong(a)).collect(Collectors.toList());
                List<MktGiftDO> giftList = this.mktGiftRepo.findByIdIn(giftCodes);
                List<Long> giftIds = giftList.stream().filter(a -> a.getId() != null).map(BaseModel::getId).collect(Collectors.toList());
                this.mktGiftRepo.addMktGiftById(giftIds);
            }
        });
        this.bipOrderRepoProc.updatStatus(bipOrderSaveVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOrderByIds(List<Long> ids) {
        this.bipOrderRepo.deleteOrderByIds(ids);
        this.bipOrderDRepo.deleteOrderDByOrderIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOrderById(Long id) {
        List<BipOrderBackDDO> bipOrderBackDDOList = this.bipOrderBackDRepo.findByOrderIdAndStatusIsNot(id, "DONE");
        if (bipOrderBackDDOList != null && bipOrderBackDDOList.size() > 0) {
            throw new BusinessException("\u8ba2\u5355\u5173\u8054\u9000\u8d27\u5355,\u4e0d\u80fd\u5220\u9664!");
        }
        this.bipOrderRepo.deleteOrderById(id);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        this.bipOrderDRepo.deleteOrderDByOrderIds(ids);
    }

    @Transactional
    public void deleteOrder(List<BipOrderSaveVO> bipOrderSaveVOS) {
        List list = bipOrderSaveVOS.stream().map(BipOrderConvert.INSTANCE::saveToDo).collect(Collectors.toList());
        list.stream().forEach(bipOrderDo -> bipOrderDo.setDeleteFlag(1));
        this.bipOrderRepo.saveAll(list);
    }

    public Predicate where(BipOrderParmVO bipOrderParmVO) {
        return null;
    }

    public Boolean isFirstOrder(Long userId, String payStatus) {
        List<BipOrderDO> bipOrderDOS = this.bipOrderRepo.findByCustAccountIdAndPayStatus(userId, payStatus);
        return bipOrderDOS != null && bipOrderDOS.size() > 0;
    }

    @Transactional
    public Long queryItemByOrderId(Long orderId) {
        List fetch = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBipOrderDo.ouId).from((EntityPath)this.qBipOrderDo)).where((Predicate)this.qBipOrderDo.id.eq((Object)orderId))).fetch();
        return (Long)fetch.get(0);
    }

    @Transactional
    public void updateItemOrderD(Long orderIds, boolean invoice, Integer offFlag) {
        this.jpaQueryFactory.update((EntityPath)this.qBipOrderDo).set((Path)this.qBipOrderDo.invoice, (Object)true).set(this.qBipOrderDo.offFlag, (Object)offFlag).where(new Predicate[]{this.qBipOrderDo.id.in((Object[])new Long[]{orderIds})}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult updateOrderSignStatus(Long bipOrderId) {
        BipOrderDO biporderDo = (BipOrderDO)this.bipOrderRepo.findById(bipOrderId).get();
        if (biporderDo == null) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        this.bipOrderRepoProc.updateSignStatus(bipOrderId, "signed");
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (currentUserDTO == null) {
            throw new BusinessException("\u83b7\u53d6\u767b\u5f55\u4eba\u4fe1\u606f\u5f02\u5e38!");
        }
        UserDTO userDTO = currentUserDTO.getDetail();
        if (userDTO == null) {
            throw new BusinessException("\u83b7\u53d6\u767b\u5f55\u4eba\u4fe1\u606f\u5f02\u5e38!");
        }
        SalDoSignUserInfoDto salDoSignUserInfoDto = new SalDoSignUserInfoDto();
        salDoSignUserInfoDto.setConfirmUserId(currentUserDTO.getUserId());
        salDoSignUserInfoDto.setConfirmUserName(userDTO.getUsername());
        SalSoSignReqDto salSoSignReqDto = new SalSoSignReqDto();
        salSoSignReqDto.setDocNo(biporderDo.getDocNo());
        salSoSignReqDto.setSalDoSignUserInfoDto(salDoSignUserInfoDto);
        log.info("\u8ba2\u5355\u7b7e\u6536\u7528\u6237\u4fe1\u606f:" + JSON.toJSONString((Object)userDTO));
        log.info("\u8ba2\u5355\u7b7e\u6536\u63a5\u53e3\u53c2\u6570:" + JSON.toJSONString((Object)salSoSignReqDto));
        return ApiResult.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderAllowStatus(Long bipOrderId) {
        this.bipOrderRepoProc.updateOrderAllowStatus(bipOrderId, UdcEnum.SAL_ORDER_STATUS_SHIP.getCode());
        this.bipOrderDRepoProc.updateOrderDAllowStatus(bipOrderId, UdcEnum.SAL_ORDER_STATUS_SHIP.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void updatePayStatus(BipOrderSaveVO bipOrderSaveVO) {
        bipOrderSaveVO.setPayTime(LocalDateTime.now());
        this.updateOrder(bipOrderSaveVO);
        List<BipOrderDDO> list = this.bipOrderDRepo.findByOrderId(bipOrderSaveVO.getId());
        list.stream().forEach(bipOrderDDO -> {
            bipOrderDDO.setPayDoneAmt(bipOrderDDO.getPayAmt());
            bipOrderDDO.setPayTime(LocalDateTime.now());
        });
        this.bipOrderDRepo.saveAll(list);
    }

    public PagingVO<BipOrderRespVO> findUserOrderByStatus(BipOrderUserParmVO bipOrderUserParmVO) {
        CurrentUserDTO currentUser = UserService.currentUser();
        Long userId = currentUser.getUserId();
        if (currentUser == null || userId == null) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        BooleanExpression predicate = this.qBipOrderDo.isNotNull();
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDo.custAccountId.eq((Object)userId));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDo.status.eq((Object)bipOrderUserParmVO.getStatus()));
        Page page = this.bipOrderRepo.findAll((Predicate)predicate, (Pageable)bipOrderUserParmVO.getPageRequest());
        List bipOrderRespVOList = page.getContent().stream().map(BipOrderConvert.INSTANCE::doToResp).collect(Collectors.toList());
        bipOrderRespVOList.stream().forEach(bipOrderRespVO -> {
            Long orderId = bipOrderRespVO.getId();
            List<BipOrderDRespVO> bipOrderDRespVOList = this.bipOrderDService.fingOrderDByorderId(orderId);
            log.info("\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u2014\u2014" + JSON.toJSONString(bipOrderDRespVOList));
            List skuIds = bipOrderDRespVOList.stream().filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null).map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()).distinct().collect(Collectors.toList());
            List bipItemSkuDOS = this.bipItemSkuRepo.findAllById(skuIds);
            log.info("\u8ba2\u5355\u660e\u7ec6sku\u96c6\u5408\u2014\u2014" + JSON.toJSONString((Object)bipItemSkuDOS));
            Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BaseModel::getId));
            bipOrderDRespVOList.stream().forEach(bipOrderDRespVO -> {
                List skus;
                if (bipOrderDRespVO.getSkuId() != null && (skus = (List)skuMap.get(bipOrderDRespVO.getSkuId())) != null & skus.size() > 0) {
                    BipItemSkuDO skuDO = (BipItemSkuDO)skus.get(0);
                    BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(skuDO);
                    bipOrderDRespVO.setItemSkuRespVO(bipItemSkuRespVO);
                }
            });
            bipOrderRespVO.setOrderDList(bipOrderDRespVOList);
        });
        return PagingVO.builder().total(page.getTotalElements()).records(bipOrderRespVOList).build();
    }

    public PagingVO<BipOrderRespVO> findUserOrder(BipOrderUserParmVO bipOrderUserParmVO) {
        log.info("\u6211\u7684\u8ba2\u5355\u53c2\u6570\u4fe1\u606f--" + JSON.toJSONString((Object)bipOrderUserParmVO));
        CurrentUserDTO currentUser = UserService.currentUser();
        Long userId = currentUser.getUserId();
        BipOrderParmVO bipOrderParmVO = new BipOrderParmVO();
        bipOrderParmVO.setCustAccountId(userId);
        BooleanExpression predicate = this.qBipOrderDO.isNotNull();
        if (StringUtils.isNotBlank((CharSequence)bipOrderUserParmVO.getStatus())) {
            bipOrderParmVO.setStatus(bipOrderUserParmVO.getStatus());
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.status.eq((Object)bipOrderUserParmVO.getStatus()));
        }
        if (bipOrderUserParmVO.getOrderId() != null) {
            bipOrderParmVO.setId(bipOrderUserParmVO.getOrderId());
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.id.eq((Object)bipOrderUserParmVO.getOrderId()));
        }
        if ("0".equals(bipOrderUserParmVO.getIsEval())) {
            bipOrderParmVO.setIsEval(Boolean.valueOf(true));
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.isEval.eq(Boolean.valueOf(true)));
        }
        if ("1".equals(bipOrderUserParmVO.getIsEval())) {
            bipOrderParmVO.setIsEval(Boolean.valueOf(false));
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.isEval.eq(Boolean.valueOf(false)));
        }
        if (Objects.nonNull(bipOrderUserParmVO.getInvoice())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.invoice.eq(Boolean.valueOf(bipOrderUserParmVO.getInvoice() == false)));
        }
        if (StringUtils.isNotBlank((CharSequence)bipOrderUserParmVO.getKeyword())) {
            QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
            List orderIds = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(qBipOrderDDO.orderId).from((EntityPath)qBipOrderDDO)).where((Predicate)qBipOrderDDO.itemTitle.like("%" + bipOrderUserParmVO.getKeyword() + "%").and((Predicate)qBipOrderDDO.createUserId.eq((Object)userId)))).fetch();
            predicate = orderIds == null || orderIds.size() == 0 ? ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.docNo.like("%" + bipOrderUserParmVO.getKeyword() + "%")) : ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.id.in((Collection)orderIds));
        }
        if (Objects.nonNull(bipOrderUserParmVO.getTimeTag())) {
            if (1 == bipOrderUserParmVO.getTimeTag()) {
                lastMonth = LocalDateTime.now().minusMonths(1L);
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.createTime.between((Comparable)lastMonth, (Comparable)LocalDateTime.now()));
            } else if (2 == bipOrderUserParmVO.getTimeTag()) {
                lastMonth = LocalDateTime.now().minusMonths(2L);
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.createTime.between((Comparable)lastMonth, (Comparable)LocalDateTime.now()));
            } else if (6 == bipOrderUserParmVO.getTimeTag()) {
                lastMonth = LocalDateTime.now().minusMonths(6L);
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.createTime.between((Comparable)lastMonth, (Comparable)LocalDateTime.now()));
            } else if (12 == bipOrderUserParmVO.getTimeTag()) {
                lastMonth = LocalDateTime.now().minusMonths(12L);
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.createTime.between((Comparable)lastMonth, (Comparable)LocalDateTime.now()));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipOrderDO.custAccountId.eq((Object)userId));
        Page page = this.bipOrderRepo.findAll((Predicate)predicate, (Pageable)bipOrderUserParmVO.getPageRequest());
        List bipOrderRespVOList = page.getContent().stream().map(BipOrderConvert.INSTANCE::doToResp).collect(Collectors.toList());
        bipOrderRespVOList.stream().forEach(bipOrderRespVO -> {
            BipOrderDO bo;
            Long orderId = bipOrderRespVO.getId();
            List<BipOrderDRespVO> bipOrderDRespVOList = this.bipOrderDService.fingOrderDByorderId(orderId);
            bipOrderRespVO.setStatusName(statusMap.get(bipOrderRespVO.getStatus()));
            bipOrderRespVO.setTotalItemNum(Long.valueOf(0L));
            log.info("\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u2014\u2014" + JSON.toJSONString(bipOrderDRespVOList));
            List skuIds = bipOrderDRespVOList.stream().filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null).map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()).distinct().collect(Collectors.toList());
            List bipItemSkuDOS = this.bipItemSkuRepo.findAllById(skuIds);
            log.info("\u8ba2\u5355\u660e\u7ec6sku\u96c6\u5408\u2014\u2014" + JSON.toJSONString((Object)bipItemSkuDOS));
            Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BaseModel::getId));
            List<String> giftCodes = bipOrderDRespVOList.stream().filter(a -> a.getGiftCodes() != null).map(BipOrderDRespVO::getGiftCodes).collect(Collectors.toList());
            ArrayList<Long> codes = new ArrayList<Long>();
            giftCodes.forEach(giftCode -> codes.addAll(Arrays.asList(giftCode.split(",")).stream().map(a -> Long.parseLong(a)).collect(Collectors.toList())));
            List giftList = this.mktDiscountGiftRepoProc.getGiftListByCode(codes, null).fetch();
            bipOrderDRespVOList.stream().forEach(bipOrderDRespVO -> {
                BigDecimal backPrice = bipOrderDRespVO.getPayAmt().subtract(bipOrderDRespVO.getFareAmt()).divide(new BigDecimal(bipOrderDRespVO.getBuyQty()), 2, RoundingMode.UP);
                bipOrderDRespVO.setBackPrice(backPrice);
                bipOrderDRespVO.setBuyAmt(backPrice);
                if (bipOrderDRespVO.getSkuId() != null) {
                    List skus = (List)skuMap.get(bipOrderDRespVO.getSkuId());
                    if (skus != null & skus.size() > 0) {
                        BipItemSkuDO skuDO = (BipItemSkuDO)skus.get(0);
                        BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(skuDO);
                        bipOrderDRespVO.setItemSkuRespVO(bipItemSkuRespVO);
                        List<BipItemSkuAttrRespVO> attrList = this.convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);
                        ArrayList<CallSite> list = new ArrayList<CallSite>();
                        for (int i = 0; i < attrList.size(); ++i) {
                            BipItemSkuAttrRespVO bipItemSkuAttrRespVO = (BipItemSkuAttrRespVO)JSON.parseObject((String)JSON.toJSONString((Object)attrList.get(0)), BipItemSkuAttrRespVO.class);
                            if (bipItemSkuAttrRespVO == null) continue;
                            list.add((CallSite)((Object)(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue())));
                        }
                        String attstr = String.join((CharSequence)";", list);
                        bipOrderDRespVO.setAttr(attstr);
                    }
                    if (giftList != null && giftList.size() > 0) {
                        ArrayList giftVOS = new ArrayList();
                        giftList.forEach(gift -> {
                            if (gift.getSkuId().equals(bipOrderDRespVO.getSkuId())) {
                                giftVOS.add(gift);
                            }
                        });
                        if (giftVOS.size() > 0) {
                            bipOrderDRespVO.setGiftList(giftVOS);
                        }
                    }
                }
                Long num = bipOrderRespVO.getTotalItemNum() + bipOrderDRespVO.getBuyQty();
                bipOrderRespVO.setTotalItemNum(num);
            });
            bipOrderRespVO.setOrderDList(bipOrderDRespVOList);
            String code = bipOrderRespVO.getPayMethodName();
            if ("online".equals(code)) {
                bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_ONLINE.getValueCodeName());
            } else if ("offline".equals(code)) {
                bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_OFFLINE.getValueCodeName());
            }
            if (bipOrderRespVO.getAdressId() != null && null != (bo = (BipOrderDO)this.bipOrderRepo.findById(bipOrderRespVO.getId()).get())) {
                BipAddressVO bipAddressVO = new BipAddressVO();
                bipAddressVO.setMobile(bo.getMobile());
                bipAddressVO.setDetailAddr(bo.getDetailAddr());
                bipAddressVO.setDefaultFlag(bo.getDefaultFlag());
                bipAddressVO.setCountyName(bo.getCountyName());
                bipAddressVO.setCounty(bo.getCounty());
                bipAddressVO.setProvinceName(bo.getProvinceName());
                bipAddressVO.setProvince(bo.getProvince());
                bipAddressVO.setCity(bo.getCity());
                bipAddressVO.setCityName(bo.getCityName());
                bipOrderRespVO.setBipAddressVO(bipAddressVO);
            }
            for (BipOrderDRespVO dRespVO : bipOrderRespVO.getOrderDList()) {
                if (dRespVO.getCustPrice() != null && dRespVO.getCustPrice().compareTo(BigDecimal.ZERO) > 0) continue;
                dRespVO.setCustPrice(dRespVO.getBasePrice());
            }
        });
        return PagingVO.builder().total(page.getTotalElements()).records(bipOrderRespVOList).build();
    }

    public BipOrderRespVO findUserOrderDetail(Long id) {
        if (id == null) {
            throw new BusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BipOrderDO bipOrderDO = (BipOrderDO)this.bipOrderRepo.findById(id).get();
        BipOrderRespVO bipOrderRespVO = BipOrderConvert.INSTANCE.doToResp(bipOrderDO);
        Long orderId = bipOrderRespVO.getId();
        List<BipOrderDRespVO> bipOrderDRespVOList = this.bipOrderDService.fingOrderDByorderId(orderId);
        bipOrderRespVO.setStatusName(statusMap.get(bipOrderRespVO.getStatus()));
        bipOrderRespVO.setTotalItemNum(Long.valueOf(0L));
        log.info("\u8ba2\u5355\u660e\u7ec6\u96c6\u5408\u2014\u2014" + JSON.toJSONString(bipOrderDRespVOList));
        List skuIds = bipOrderDRespVOList.stream().filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null).map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()).distinct().collect(Collectors.toList());
        List bipItemSkuDOS = this.bipItemSkuRepo.findAllById(skuIds);
        log.info("\u8ba2\u5355\u660e\u7ec6sku\u96c6\u5408\u2014\u2014" + JSON.toJSONString((Object)bipItemSkuDOS));
        Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BaseModel::getId));
        List<String> giftCodes = bipOrderDRespVOList.stream().filter(a -> a.getGiftCodes() != null).map(BipOrderDRespVO::getGiftCodes).collect(Collectors.toList());
        ArrayList<Long> codes = new ArrayList<Long>();
        giftCodes.forEach(giftCode -> codes.addAll(Arrays.asList(giftCode.split(",")).stream().map(a -> Long.parseLong(a)).collect(Collectors.toList())));
        List giftList = new ArrayList();
        if (null != codes && !codes.isEmpty()) {
            giftList = this.mktDiscountGiftRepoProc.getGiftListByCode(codes, null).fetch();
        }
        log.info("\u8ba2\u5355\u660e\u7ec6");
        ArrayList finalGiftList = giftList;
        bipOrderDRespVOList.stream().forEach(bipOrderDRespVO -> {
            if (bipOrderDRespVO.getSkuId() != null) {
                List skus = (List)skuMap.get(bipOrderDRespVO.getSkuId());
                if (skus != null & skus.size() > 0) {
                    BipItemSkuDO skuDO = (BipItemSkuDO)skus.get(0);
                    BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(skuDO);
                    bipOrderDRespVO.setItemSkuRespVO(bipItemSkuRespVO);
                    List<BipItemSkuAttrRespVO> attrList = this.convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);
                    ArrayList<CallSite> list = new ArrayList<CallSite>();
                    for (int i = 0; i < attrList.size(); ++i) {
                        BipItemSkuAttrRespVO bipItemSkuAttrRespVO = (BipItemSkuAttrRespVO)JSON.parseObject((String)JSON.toJSONString((Object)attrList.get(i)), BipItemSkuAttrRespVO.class);
                        if (bipItemSkuAttrRespVO == null) continue;
                        list.add((CallSite)((Object)(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue())));
                    }
                    String attstr = String.join((CharSequence)";", list);
                    bipOrderDRespVO.setAttr(attstr);
                }
                if (finalGiftList != null && finalGiftList.size() > 0) {
                    ArrayList giftVOS = new ArrayList();
                    finalGiftList.forEach(gift -> {
                        if (gift.getSkuId().equals(bipOrderDRespVO.getSkuId())) {
                            giftVOS.add(gift);
                        }
                    });
                    if (giftVOS.size() > 0) {
                        bipOrderDRespVO.setGiftList(giftVOS);
                    }
                }
            }
            Long num = bipOrderRespVO.getTotalItemNum() + bipOrderDRespVO.getBuyQty();
            bipOrderRespVO.setTotalItemNum(num);
        });
        log.info("\u652f\u4ed8\u65b9\u5f0f\u540d\u79f0");
        bipOrderRespVO.setOrderDList(bipOrderDRespVOList);
        String code = bipOrderRespVO.getPayMethodName();
        if ("online".equals(code)) {
            bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_ONLINE.getValueCodeName());
        } else if ("offline".equals(code)) {
            bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_OFFLINE.getValueCodeName());
        }
        log.info("\u5730\u5740");
        if (bipOrderDO.getAdressId() != null) {
            BipAddressVO bipAddressVO = new BipAddressVO();
            bipAddressVO.setCity(bipOrderDO.getCity());
            bipAddressVO.setCityName(bipOrderDO.getCityName());
            bipAddressVO.setProvince(bipOrderDO.getProvince());
            bipAddressVO.setProvinceName(bipOrderDO.getProvinceName());
            bipAddressVO.setCounty(bipOrderDO.getCounty());
            bipAddressVO.setCountyName(bipOrderDO.getCountyName());
            bipAddressVO.setContPerson(bipOrderDO.getContPerson());
            bipAddressVO.setDefaultFlag(bipOrderDO.getDefaultFlag());
            bipAddressVO.setDetailAddr(bipOrderDO.getDetailAddr());
            bipAddressVO.setMobile(bipOrderDO.getMobile());
            bipOrderRespVO.setBipAddressVO(bipAddressVO);
        }
        log.info("\u53d1\u8d27\u72b6\u6001");
        for (BipOrderDRespVO dRespVO : bipOrderRespVO.getOrderDList()) {
            if (dRespVO.getCustPrice() != null && dRespVO.getCustPrice().compareTo(BigDecimal.ZERO) > 0) continue;
            dRespVO.setCustPrice(dRespVO.getBasePrice());
        }
        return bipOrderRespVO;
    }

    public BipCartItemRespVO buildCartItemRespVO(BipOrderDSaveVO bipOrderDSaveVOS, Long userId, String userName) {
        BipCartItemRespVO bipCartItemRespVO = new BipCartItemRespVO();
        bipCartItemRespVO.setItemNum(bipOrderDSaveVOS.getBuyQty());
        bipCartItemRespVO.setItemId(bipOrderDSaveVOS.getItemId());
        bipCartItemRespVO.setItemCode(bipOrderDSaveVOS.getItemCode());
        bipCartItemRespVO.setSkuId(bipOrderDSaveVOS.getSkuId());
        bipCartItemRespVO.setSkuCode(bipOrderDSaveVOS.getSkuCode());
        bipCartItemRespVO.setRelateItemId(bipOrderDSaveVOS.getRelateItemId());
        bipCartItemRespVO.setUserId(userId);
        bipCartItemRespVO.setUserName(userName);
        bipCartItemRespVO.setMktDiscountGiftDId(bipOrderDSaveVOS.getDiscountOffsetGiftDId());
        bipCartItemRespVO.setMktDiscountGiftId(bipOrderDSaveVOS.getDiscountOffsetGiftId());
        bipCartItemRespVO.setMktGiftId(bipCartItemRespVO.getMktDiscountGiftId());
        bipCartItemRespVO.setMktDiscountOffsetId(bipOrderDSaveVOS.getDiscountOffsetId());
        bipCartItemRespVO.setMktDiscountGiftDId(bipOrderDSaveVOS.getDiscountOffsetGiftDId());
        bipCartItemRespVO.setMktDiscountOffsetCode(bipOrderDSaveVOS.getDiscountOffsetCode());
        return bipCartItemRespVO;
    }

    public void payOrder(String orderDocNo, String openId, BigDecimal payAmt) {
    }

    @Transactional
    public void BuildPayOrderSucessInfo(BipOrderDO biporderDo) {
        biporderDo.setPayDoneAmt(biporderDo.getPayAmt());
        biporderDo.setPayTime(LocalDateTime.now());
        biporderDo.setStatus("shipping");
        this.bipOrderRepo.save(biporderDo);
        List<BipOrderDDO> list = this.bipOrderDRepo.findByOrderId(biporderDo.getId());
        for (BipOrderDDO bipOrderDDO : list) {
            bipOrderDDO.setPayDoneAmt(biporderDo.getPayAmt());
            bipOrderDDO.setPayTime(LocalDateTime.now());
        }
        this.bipOrderDRepo.saveAll(list);
        this.bipOrderToOmsServiceimpl.sendToOms(biporderDo.getId());
    }

    public BigDecimal getCustPrice(Long itemId, String custLevel) {
        List priceList = (List)this.salePriceService.queryCustPrice(itemId).getData();
        if (CollUtil.isEmpty((Collection)priceList)) {
            return null;
        }
        BigDecimal min = null;
        BigDecimal priceTemp = null;
        for (BipCustPriceDTO custPrice : priceList) {
            priceTemp = custPrice.getPrice();
            if (priceTemp == null || !UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(custPrice.getPriceType()) || !ObjectUtil.equal((Object)custLevel, (Object)custPrice.getCustGroup())) continue;
            min = min == null ? priceTemp : NumberUtil.min((BigDecimal[])new BigDecimal[]{min, priceTemp});
        }
        return min;
    }

    @Transactional
    public void updateOrderPayStatus(String payStatus, String docNo, String status, String txsn, LocalDateTime payTime, BigDecimal payDoneAmt) {
        this.bipOrderRepoProc.updateOrderPayStatus(payStatus, docNo, status, txsn, payTime, payDoneAmt);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderDPayDoneAmt(String docNo) {
        List<BipOrderDDO> bipOrderDDOS = this.bipOrderDRepo.findByOrderDocNo(docNo);
        for (BipOrderDDO bipOrderDDO : bipOrderDDOS) {
            BigDecimal payAmt = bipOrderDDO.getPayAmt();
            bipOrderDDO.setPayDoneAmt(payAmt);
        }
        this.bipOrderDRepo.saveAll(bipOrderDDOS);
    }

    public JSONObject findUserOrderCount(Long userId) {
        JSONObject jsonObject = new JSONObject();
        if (null == userId) {
            jsonObject.put("unpaid", (Object)0);
            jsonObject.put("shipping", (Object)0);
            jsonObject.put("signed", (Object)0);
            jsonObject.put("cancelled", (Object)0);
            jsonObject.put("back", (Object)0);
            return jsonObject;
        }
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression unpaidExpre = qBipOrderDO.deleteFlag.eq((Object)0).and((Predicate)qBipOrderDO.custAccountId.eq((Object)userId)).and((Predicate)qBipOrderDO.status.eq((Object)"unpaid"));
        Long unpaidCount = this.bipOrderRepo.count((Predicate)unpaidExpre);
        jsonObject.put("unpaid", (Object)unpaidCount);
        BooleanExpression shippingExpre = qBipOrderDO.deleteFlag.eq((Object)0).and((Predicate)qBipOrderDO.custAccountId.eq((Object)userId)).and((Predicate)qBipOrderDO.status.eq((Object)"shipping"));
        Long shippingCount = this.bipOrderRepo.count((Predicate)shippingExpre);
        jsonObject.put("shipping", (Object)shippingCount);
        BooleanExpression signedExpre = qBipOrderDO.deleteFlag.eq((Object)0).and((Predicate)qBipOrderDO.custAccountId.eq((Object)userId)).and((Predicate)qBipOrderDO.status.eq((Object)"signed"));
        Long signedCount = this.bipOrderRepo.count((Predicate)signedExpre);
        jsonObject.put("signed", (Object)signedCount);
        BooleanExpression cancelledExpre = qBipOrderDO.deleteFlag.eq((Object)0).and((Predicate)qBipOrderDO.custAccountId.eq((Object)userId)).and((Predicate)qBipOrderDO.status.eq((Object)"cancelled"));
        Long cancelledCount = this.bipOrderRepo.count((Predicate)cancelledExpre);
        jsonObject.put("cancelled", (Object)cancelledCount);
        QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;
        BooleanExpression backExpre = qBipOrderBackDO.deleteFlag.eq((Object)0).and((Predicate)qBipOrderBackDO.custAccountId.eq((Object)userId)).and((Predicate)qBipOrderBackDO.status.notEqualsIgnoreCase("DONE")).and((Predicate)qBipOrderBackDO.status.notEqualsIgnoreCase("CL"));
        Long backCount = this.bipOrderBackRepo.count((Predicate)backExpre);
        jsonObject.put("back", (Object)backCount);
        return jsonObject;
    }

    public CPCN5011Resp cpcn5011(BipOrderDO bipOrderDO, String code) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RmiOrgBankAccRpcVO getVirtualInfo(Long ouId) {
        ArrayList resList = new ArrayList();
        log.info("\u8ba2\u5355\u516c\u53f8ID:---" + ouId);
        ArrayList<Long> ouIds = new ArrayList<Long>();
        ouIds.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        List<OrgOuRpcDTO> orgOuRpcDTOS = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        log.info("\u6839\u636e\u516c\u53f8\u7684\u4fe1\u606f\u83b7\u53d6\u5230\u516c\u53f8\u5bf9\u5e94\u7684\u5730\u5740\u53f7\u4fe1\u606f:-----" + JSON.toJSONString(orgOuRpcDTOS));
        if (null != orgOuRpcDTOS && !orgOuRpcDTOS.isEmpty()) {
            OrgOuRpcDTO orgOuRpcDTO = orgOuRpcDTOS.get(0);
            OrgBankAccRpcDtoParam orgBankAccRpcDtoParam = new OrgBankAccRpcDtoParam();
            if (null == orgOuRpcDTO.getAddrNo()) throw new BusinessException("\u652f\u4ed8\u65f6\u83b7\u53d6\u7684\u53c2\u6570:--------" + JSON.toJSONString((Object)orgBankAccRpcDtoParam));
            ArrayList<Long> addNos = new ArrayList<Long>();
            addNos.add(orgOuRpcDTO.getAddrNo());
            orgBankAccRpcDtoParam.setAddrNos(addNos);
            log.info("\u6839\u636e\u5730\u5740\u4fe1\u606f\u83b7\u53d6\u94f6\u884c\u4fe1\u606f\u53c2\u6570:-----" + JSON.toJSONString((Object)orgBankAccRpcDtoParam));
            List<RmiOrgBankAccRpcVO> list = this.rmiOrgAddrService.findBankAccRpcDtoByParam(orgBankAccRpcDtoParam);
            log.info("\u6839\u636e\u5730\u5740\u4fe1\u606f\u83b7\u53d6\u94f6\u884c\u4fe1\u606f:-----" + JSON.toJSONString(list));
            if (null == list || list.isEmpty()) throw new BusinessException("\u94f6\u884c\u8d26\u6237\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff0c\u53c2\u6570:------" + JSON.toJSONString((Object)orgBankAccRpcDtoParam));
            list.stream().forEach(l -> {
                if (StringUtils.isNotBlank((CharSequence)l.getAccType()) && "IN".equals(l.getAccType()) && StringUtils.isNotBlank((CharSequence)l.getThirdpartyVirtualUserId()) && StringUtils.isNotBlank((CharSequence)l.getThirdpartyVirtualAcc())) {
                    resList.add(l);
                }
            });
        }
        if (null != resList && !resList.isEmpty()) return (RmiOrgBankAccRpcVO)resList.get(0);
        return null;
    }

    public static String postJsonData(String code, String appid, String appsecret) {
        log.info("\u83b7\u53d6openID\u53c2\u6570--code:" + code + ",--appid:" + appid + "--appsecret:" + appsecret);
        String requestUrl = "https://api.weixin.qq.com/sns/jscode2session";
        HttpPost httppost = new HttpPost(requestUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
        formparams.add(new BasicNameValuePair("appid", appid));
        formparams.add(new BasicNameValuePair("secret", appsecret));
        formparams.add(new BasicNameValuePair("js_code", code));
        formparams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        log.info("\u83b7\u53d6openID\u53c2\u6570:" + JSON.toJSONString(formparams));
        CloseableHttpResponse response = null;
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(formparams));
            response = httpclient.execute((HttpUriRequest)httppost);
        }
        catch (UnsupportedEncodingException e1) {
            log.info(e1.getMessage());
        }
        catch (ClientProtocolException e) {
            log.info(e.getMessage());
        }
        catch (IOException e) {
            log.info(e.getMessage());
        }
        JSONObject jsonObject = null;
        if (response.getStatusLine().getStatusCode() == 200) {
            HttpEntity httpEntity = response.getEntity();
            String result = null;
            try {
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("\u5fae\u4fe1\u8bf7\u6c42oppenID\u8fd4\u56de\u4fe1\u606f:" + JSON.toJSONString((Object)result));
            }
            catch (ParseException e) {
                log.info(e.getMessage());
            }
            catch (IOException e) {
                log.info(e.getMessage());
            }
            jsonObject = JSONObject.parseObject((String)result);
        }
        String access_token = jsonObject.getString("access_token");
        String opendId = jsonObject.getString("openid");
        return opendId;
    }

    public Map orderPay(BipAppOrderPayVO bipAppOrderPayVO) {
        if (bipAppOrderPayVO.getCode() == null) {
            throw new BusinessException("Code\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (bipAppOrderPayVO.getOrderId() == null) {
            throw new BusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BipOrderDO bipOrderDO = (BipOrderDO)this.bipOrderRepo.findById(bipAppOrderPayVO.getOrderId()).get();
        CPCN5011Resp cpcn5011Resp = this.cpcn5011(bipOrderDO, bipAppOrderPayVO.getCode());
        if (cpcn5011Resp == null) {
            throw new BusinessException("\u652f\u4ed8\u5f02\u5e38!");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("code", cpcn5011Resp.getQRAuthCode());
        return hashMap;
    }

    public static void main(String[] args) {
        BigDecimal farmt = new BigDecimal(2.01);
        System.out.println(farmt.compareTo(BigDecimal.ZERO));
    }

    public BipOrderServiceimpl(MktDiscountGiftRepoProc mktDiscountGiftRepoProc, RmiSysNextNumberService rmiSysNextNumberService, PriSalePriceService salePriceService, RmiOrgAddrService rmiOrgAddrService, BipItemAppService bipItemAppService, DelayTaskSender delayTaskSender, MktGiftRepoProc mktGiftRepoProc) {
        this.mktDiscountGiftRepoProc = mktDiscountGiftRepoProc;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.salePriceService = salePriceService;
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.bipItemAppService = bipItemAppService;
        this.delayTaskSender = delayTaskSender;
        this.mktGiftRepoProc = mktGiftRepoProc;
    }

    static {
        statusMap.put("unpaid", "\u5f85\u4ed8\u6b3e");
        statusMap.put("shipping", "\u5f85\u6536\u8d27");
        statusMap.put("signed", "\u5df2\u7b7e\u6536");
        statusMap.put("cancelled", "\u5df2\u53d6\u6d88");
        payStatusMap.put("ps", "\u652f\u4ed8\u6210\u529f");
        payStatusMap.put("pf", "\u652f\u4ed8\u5931\u8d25");
        payStatusMap.put("pc", "\u652f\u4ed8\u53d6\u6d88");
    }
}

