/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.MktDiscountOffsetService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetDSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.MktDiscountOffsetConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceSimpleDTO;
import com.elitesland.yst.production.sale.dto.query.PriSaleItemReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.MktDiscountOffsetDDO;
import com.elitesland.yst.production.sale.entity.MktDiscountOffsetDO;
import com.elitesland.yst.production.sale.entity.QBipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.QBipItemSkuDO;
import com.elitesland.yst.production.sale.entity.QMktDiscountOffsetDDO;
import com.elitesland.yst.production.sale.entity.QMktDiscountOffsetDO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountGiftRepoProc;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetDRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetRepo;
import com.elitesland.yst.production.sale.repo.shop.MktDiscountOffsetRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.service.PriSalePriceRpcService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MktDiscountOffsetServiceImpl
extends BaseServiceImpl
implements MktDiscountOffsetService {
    private static final Logger log = LoggerFactory.getLogger(MktDiscountOffsetServiceImpl.class);
    private final OrgEmpRpcService orgEmpRpcService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipCompanyManageService bipCompanyManageService;
    private final PriSalePriceRpcService priSalePriceRpcService;
    private final MktDiscountOffsetRepo mktDiscountOffsetRepo;
    private final MktDiscountOffsetDRepo mktDiscountOffsetDRepo;
    private final BipItemSkuRepo bipItemSkuRepo;
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final BipCustUserBindRepo bipCustUserBindRepo;
    private final RmiItemService rmiItemService;
    @Autowired
    private UdcProvider udcProvider;

    public PagingVO<MktDiscountOffsetRespVO> search(MktDiscountOffsetQueryVO queryParam) {
        List<Long> ids = this.mktDiscountOffsetRepoProc.findMasIdByItemCode(queryParam.getItemCode());
        queryParam.setIds(ids != null && ids.size() > 0 ? ids : new ArrayList());
        QMktDiscountOffsetDO qmktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        JPAQuery<MktDiscountOffsetRespVO> jpaQuery = this.mktDiscountOffsetRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(queryParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qmktDiscountOffsetDO);
        List pageResult = jpaQuery.fetch();
        this.transUdc(pageResult);
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    public Optional<MktDiscountOffsetRespVO> findCodeOne(String code) {
        QMktDiscountOffsetDO qmktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        MktDiscountOffsetRespVO mktDiscountOffsetRespVO = (MktDiscountOffsetRespVO)((JPAQuery)this.mktDiscountOffsetRepoProc.select(null).where((Predicate)qmktDiscountOffsetDO.code.eq((Object)code))).fetchOne();
        if (mktDiscountOffsetRespVO == null) {
            return Optional.empty();
        }
        this.setDetails(mktDiscountOffsetRespVO);
        this.transUdc(Collections.singletonList(mktDiscountOffsetRespVO));
        return Optional.of(mktDiscountOffsetRespVO);
    }

    public Optional<MktDiscountOffsetRespVO> findIdOne(Long id) {
        QMktDiscountOffsetDO qmktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        MktDiscountOffsetRespVO mktDiscountOffsetRespVO = (MktDiscountOffsetRespVO)((JPAQuery)this.mktDiscountOffsetRepoProc.select(null).where((Predicate)qmktDiscountOffsetDO.id.eq((Object)id))).fetchOne();
        if (mktDiscountOffsetRespVO == null) {
            return Optional.empty();
        }
        this.setDetails(mktDiscountOffsetRespVO);
        this.transUdc(Collections.singletonList(mktDiscountOffsetRespVO));
        return Optional.of(mktDiscountOffsetRespVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Long> createBatch(List<MktDiscountOffsetSaveVO> list) {
        if (!CollectionUtil.isEmpty(list)) {
            OrgUserEmpInfoRpcDTO userEmpInfo = this.getCurrentEmpInfo();
            List manageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
            if (CollectionUtils.isEmpty((Collection)manageByOuIds)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
            }
            this.paramCheck(list, true);
            List<Long> result = list.stream().map(i -> {
                MktDiscountOffsetConvert mktDiscountOffsetConvert = MktDiscountOffsetConvert.INSTANCE;
                MktDiscountOffsetDO mktDiscountOffsetDO = mktDiscountOffsetConvert.saveVoToDo((MktDiscountOffsetSaveVO)i);
                mktDiscountOffsetDO.setSecOuId(userEmpInfo.getOuId());
                mktDiscountOffsetDO.setSecUserId(userEmpInfo.getUserId());
                mktDiscountOffsetDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                mktDiscountOffsetDO.setId(null);
                String code = this.rmiSysNextNumberService.generateCode("yst-sale", "CX", null);
                mktDiscountOffsetDO.setCode(code);
                mktDiscountOffsetDO.setOuId(userEmpInfo.getOuId());
                mktDiscountOffsetDO.setOuCode(userEmpInfo.getOuCode());
                mktDiscountOffsetDO.setOuName(userEmpInfo.getOuName());
                mktDiscountOffsetDO.setBuId(userEmpInfo.getBuId());
                mktDiscountOffsetDO.setBuCode(userEmpInfo.getBuCode());
                mktDiscountOffsetDO.setBuName(userEmpInfo.getBuName());
                mktDiscountOffsetDO.setDeleteFlag(0);
                Long masId = ((MktDiscountOffsetDO)this.mktDiscountOffsetRepo.save(mktDiscountOffsetDO)).getId();
                List details = i.getDetails().stream().map(d -> {
                    if ("0".equals(i.getType())) {
                        BigDecimal targetAmt = d.getBasePrice().multiply(BigDecimal.valueOf(d.getLimitNum()));
                        Assert.isTrue((targetAmt.compareTo(d.getFreeAmt()) > 0 ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + d.getItemName() + "\u3011\u7684\u57fa\u7840\u4ef7\u683c\u4e58\u4ee5\u4fc3\u9500\u6761\u4ef6\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u51cf\u514d\u91d1\u989d\uff01"), (Object[])new Object[0]);
                    } else {
                        Assert.isTrue((d.getLimitAmt().compareTo(d.getFreeAmt()) > 0 ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + d.getItemName() + "\u3011\u7684\u4fc3\u9500\u6761\u4ef6\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u51cf\u514d\u91d1\u989d\uff01"), (Object[])new Object[0]);
                    }
                    MktDiscountOffsetDDO mktDiscountOffsetDDO = mktDiscountOffsetConvert.dsaveVoToDo((MktDiscountOffsetDSaveVO)d);
                    String skuCode = mktDiscountOffsetDDO.getItemCode();
                    if (StringUtils.isNotBlank((CharSequence)skuCode)) {
                        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
                        BooleanExpression exp = qBipItemSkuDO.skuCode.eq((Object)skuCode).and((Predicate)qBipItemSkuDO.deleteFlag.eq((Object)0));
                        Iterable iterables = this.bipItemSkuRepo.findAll((Predicate)exp);
                        if (!IterUtil.isEmpty((Iterable)iterables)) {
                            ArrayList listSkus = Lists.newArrayList((Iterable)iterables);
                            mktDiscountOffsetDDO.setItemId(((BipItemSkuDO)listSkus.get(0)).getId());
                        }
                    }
                    mktDiscountOffsetDDO.setSecOuId(userEmpInfo.getOuId());
                    mktDiscountOffsetDDO.setSecUserId(userEmpInfo.getUserId());
                    mktDiscountOffsetDDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                    mktDiscountOffsetDDO.setId(null);
                    mktDiscountOffsetDDO.setMktDiscountOffsetId(masId);
                    mktDiscountOffsetDDO.setDeleteFlag(0);
                    ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
                    ArrayList<String> skuCodes = new ArrayList<String>();
                    skuCodes.add(mktDiscountOffsetDDO.getItemCode());
                    codeparam.setItemCodes(skuCodes);
                    ArrayList<ItmItemRpcDTO> dtos = new ArrayList<ItmItemRpcDTO>(this.rmiItemService.findItemListByParam(codeparam));
                    if (null != dtos && !dtos.isEmpty()) {
                        mktDiscountOffsetDDO.setUom(((ItmItemRpcDTO)dtos.get(0)).getUom());
                    }
                    MktDiscountOffsetVO mktDiscountOffsetVO = new MktDiscountOffsetVO();
                    mktDiscountOffsetVO.setFreeAmt(mktDiscountOffsetDDO.getFreeAmt());
                    mktDiscountOffsetVO.setBasePrice(mktDiscountOffsetDDO.getBasePrice());
                    mktDiscountOffsetVO.setType(mktDiscountOffsetDO.getType());
                    mktDiscountOffsetVO.setLimitAmt(mktDiscountOffsetDDO.getLimitAmt());
                    mktDiscountOffsetVO.setLimitNum(mktDiscountOffsetDDO.getLimitNum());
                    mktDiscountOffsetVO.setOuId(mktDiscountOffsetDO.getOuId());
                    mktDiscountOffsetVO.setUom(mktDiscountOffsetDDO.getUom());
                    if (null != dtos && !dtos.isEmpty() && null != ((ItmItemRpcDTO)dtos.get(0)).getId()) {
                        mktDiscountOffsetVO.setItemId(((ItmItemRpcDTO)dtos.get(0)).getId());
                    } else {
                        mktDiscountOffsetVO.setItemId(mktDiscountOffsetDDO.getItemId());
                    }
                    if (!this.disRule(mktDiscountOffsetVO).booleanValue()) {
                        throw new BusinessException("\u8bf7\u68c0\u67e5\u6570\u636e\uff01");
                    }
                    return mktDiscountOffsetDDO;
                }).collect(Collectors.toList());
                this.mktDiscountOffsetDRepo.saveAll(details);
                return mktDiscountOffsetDO.getId();
            }).collect(Collectors.toList());
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(MktDiscountOffsetSaveVO updateParam) {
    }

    public Boolean disRule(MktDiscountOffsetVO mktDiscountOffsetVO) {
        BigDecimal floorScale;
        BigDecimal floorPrice;
        BigDecimal disScale;
        BigDecimal freeAmt = mktDiscountOffsetVO.getFreeAmt();
        BigDecimal basePrice = mktDiscountOffsetVO.getBasePrice();
        if (mktDiscountOffsetVO.getType().equals("1")) {
            BigDecimal limitAmt = mktDiscountOffsetVO.getLimitAmt();
            disScale = freeAmt.divide(limitAmt, 4, RoundingMode.HALF_UP);
            floorPrice = this.getMinPrice(mktDiscountOffsetVO);
            if (null == floorPrice) {
                floorPrice = BigDecimal.ZERO;
            }
            if (floorPrice.compareTo(BigDecimal.ZERO) == 0) {
                return true;
            }
            if (floorPrice.compareTo(BigDecimal.ZERO) > 0 && disScale.compareTo(floorScale = basePrice.subtract(floorPrice).divide(basePrice, 4, RoundingMode.HALF_UP)) < 0) {
                return true;
            }
        }
        if (mktDiscountOffsetVO.getType().equals("0")) {
            BigDecimal amt = new BigDecimal(mktDiscountOffsetVO.getLimitNum()).multiply(basePrice);
            disScale = freeAmt.divide(amt, 4, RoundingMode.HALF_UP);
            floorPrice = this.getMinPrice(mktDiscountOffsetVO);
            if (null == floorPrice) {
                floorPrice = BigDecimal.ZERO;
            }
            if (floorPrice.compareTo(BigDecimal.ZERO) == 0) {
                return true;
            }
            floorScale = basePrice.subtract(floorPrice).divide(basePrice, 4, RoundingMode.HALF_UP);
            if (disScale.compareTo(floorScale) < 0) {
                return true;
            }
        }
        return false;
    }

    public BigDecimal getMinPrice(MktDiscountOffsetVO mktDiscountOffsetVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression expression = qBipCustUserBindDO.agentEmpId.eq((Object)currentUserDTO.getUserId()).and((Predicate)qBipCustUserBindDO.deleteFlag.eq((Object)0)).and((Predicate)qBipCustUserBindDO.ouId.eq((Object)mktDiscountOffsetVO.getOuId()));
        Iterable iterables = this.bipCustUserBindRepo.findAll((Predicate)expression);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if (!IterUtil.isEmpty((Iterable)iterables)) {
            bipCustUserBindDO = (BipCustUserBindDO)Lists.newArrayList((Iterable)iterables).get(0);
        }
        if (null == bipCustUserBindDO || null == bipCustUserBindDO.getCustId()) {
            return BigDecimal.ZERO;
        }
        PriSalePriceReqDTO priSalePriceReqDTO = new PriSalePriceReqDTO();
        priSalePriceReqDTO.setOuId(mktDiscountOffsetVO.getOuId());
        priSalePriceReqDTO.setCustId(bipCustUserBindDO.getCustId());
        priSalePriceReqDTO.setCustCode(bipCustUserBindDO.getCustCode());
        ArrayList<PriSaleItemReqDTO> list = new ArrayList<PriSaleItemReqDTO>();
        PriSaleItemReqDTO priSaleItemReqDTO = new PriSaleItemReqDTO();
        priSaleItemReqDTO.setItemId(mktDiscountOffsetVO.getItemId());
        priSaleItemReqDTO.setUom(mktDiscountOffsetVO.getUom());
        list.add(priSaleItemReqDTO);
        priSalePriceReqDTO.setItems(list);
        ApiResult res = this.priSalePriceRpcService.findSalePriceDto(priSalePriceReqDTO);
        if (res.getCode() == 200 && null != res.getData() && null != ((PriSalePriceDTO)res.getData()).getPriceList() && !((PriSalePriceDTO)res.getData()).getPriceList().isEmpty()) {
            PriSalePriceSimpleDTO priSalePriceSimpleDTO = (PriSalePriceSimpleDTO)((PriSalePriceDTO)res.getData()).getPriceList().get(0);
            return priSalePriceSimpleDTO.getFloorPrice();
        }
        return BigDecimal.ZERO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        this.mktDiscountOffsetRepoProc.deleteIdBatch(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        this.updateDeleteFlagBatch(Collections.singletonList(id));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u6ee1\u51cf\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        this.mktDiscountOffsetRepoProc.updateDeleteFlagBatch(ids, 1);
    }

    @Transactional(rollbackFor={Exception.class})
    public void appr(List<Long> ids, String status) {
        Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u6ee1\u51cf\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)this.checkUdcValueExit(statusUdcMap, status), (String)"\u4fc3\u9500\u72b6\u6001\u5f02\u5e38", (Object[])new Object[0]);
        if (status.equals("ENABLE")) {
            boolean flag = this.getGiftSkuIds(ids);
            if (!flag) {
                throw new BusinessException("\u4e00\u4e2a\u5546\u54c1\u53ea\u80fd\u662f\u6ee1\u51cf\u6216\u4e70\u8d60");
            }
            if (!this.isExistsType(ids).booleanValue()) {
                throw new BusinessException("\u6ee1\u51cf\u540c\u4e00\u5546\u54c1\u7c7b\u578b\u53ea\u80fd\u6309\u5546\u54c1\u6216\u6570\u91cf");
            }
            for (Long id : ids) {
                Optional<MktDiscountOffsetRespVO> offsetOPT = this.findIdOne(id);
                if (!offsetOPT.isPresent()) continue;
                MktDiscountOffsetRespVO offset = offsetOPT.get();
                List details = offset.getDetails();
                if ("0".equals(offset.getType())) {
                    for (MktDiscountOffsetRespDVO detail : details) {
                        BigDecimal targetAmt = detail.getBasePrice().multiply(BigDecimal.valueOf(detail.getLimitNum()));
                        Assert.isTrue((targetAmt.compareTo(detail.getFreeAmt()) > 0 ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + detail.getItemName() + "\u3011\u7684\u57fa\u7840\u4ef7\u683c\u4e58\u4ee5\u4fc3\u9500\u6761\u4ef6\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u51cf\u514d\u91d1\u989d\uff01"), (Object[])new Object[0]);
                    }
                    continue;
                }
                for (MktDiscountOffsetRespDVO detail : details) {
                    Assert.isTrue((detail.getLimitAmt().compareTo(detail.getFreeAmt()) > 0 ? 1 : 0) != 0, (String)("\u5546\u54c1\u3010" + detail.getItemName() + "\u3011\u7684\u4fc3\u9500\u6761\u4ef6\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u51cf\u514d\u91d1\u989d\uff01"), (Object[])new Object[0]);
                }
            }
        }
        this.mktDiscountOffsetRepoProc.updateStatusBatch(ids, status);
    }

    public Boolean isExistsType(List<Long> ids) {
        log.info("ids:-------------" + JSON.toJSONString(ids));
        QMktDiscountOffsetDO qMktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        QMktDiscountOffsetDDO qMktDiscountOffsetDDO = QMktDiscountOffsetDDO.mktDiscountOffsetDDO;
        for (Long id : ids) {
            MktDiscountOffsetDO mktDiscountOffsetDO = (MktDiscountOffsetDO)this.mktDiscountOffsetRepo.findById(id).get();
            String type = mktDiscountOffsetDO.getType();
            log.info("type:-------------" + type);
            BooleanExpression expression = qMktDiscountOffsetDDO.mktDiscountOffsetId.eq((Object)mktDiscountOffsetDO.getId()).and((Predicate)qMktDiscountOffsetDDO.deleteFlag.eq((Object)0));
            Iterable iterables = this.mktDiscountOffsetDRepo.findAll((Predicate)expression);
            if (IterUtil.isEmpty((Iterable)iterables)) continue;
            ArrayList list = Lists.newArrayList((Iterable)iterables);
            List items = list.stream().map(MktDiscountOffsetDDO::getItemCode).distinct().collect(Collectors.toList());
            log.info("items:-------------" + JSON.toJSONString(items));
            String typeRec = "";
            typeRec = type.equals("0") ? "1" : "0";
            BooleanExpression e = qMktDiscountOffsetDO.deleteFlag.eq((Object)0).and((Predicate)qMktDiscountOffsetDO.status.eq((Object)"ENABLE")).and((Predicate)qMktDiscountOffsetDO.ouId.eq((Object)mktDiscountOffsetDO.getOuId())).and((Predicate)qMktDiscountOffsetDO.type.eq((Object)typeRec)).and((Predicate)qMktDiscountOffsetDO.code.notEqualsIgnoreCase(mktDiscountOffsetDO.getCode()));
            Iterable iterableDos = this.mktDiscountOffsetRepo.findAll((Predicate)e);
            if (IterUtil.isEmpty((Iterable)iterableDos)) continue;
            ArrayList dos = Lists.newArrayList((Iterable)iterableDos);
            List doIds = dos.stream().map(BaseModel::getId).distinct().collect(Collectors.toList());
            log.info("doIds:-------------" + JSON.toJSONString(doIds));
            BooleanExpression ddoExpr = qMktDiscountOffsetDDO.mktDiscountOffsetId.in(doIds).and((Predicate)qMktDiscountOffsetDDO.deleteFlag.eq((Object)0));
            Iterable ddosIterables = this.mktDiscountOffsetDRepo.findAll((Predicate)ddoExpr);
            if (IterUtil.isEmpty((Iterable)ddosIterables)) continue;
            ArrayList ddosList = Lists.newArrayList((Iterable)ddosIterables);
            List ddoItemIds = ddosList.stream().map(MktDiscountOffsetDDO::getItemCode).distinct().collect(Collectors.toList());
            log.info("ddoItemIds:-------------" + JSON.toJSONString(ddoItemIds));
            List intersection = items.stream().filter(item -> ddoItemIds.contains(item)).collect(Collectors.toList());
            log.info("intersection:-------------" + JSON.toJSONString(intersection));
            if (null == intersection || intersection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean getGiftSkuIds(List<Long> ids) {
        for (Long id : ids) {
            List<String> giftSkuCodes;
            List<String> offsetItemCodes = this.mktDiscountOffsetRepoProc.getOffsetSkuCode(id);
            Long ouId = this.mktDiscountOffsetRepoProc.getOuIdById(id).get(0);
            List<Long> giftIds = this.mktDiscountGiftRepoProc.getGiftId(ouId);
            if (null == giftIds || giftIds.isEmpty() || (giftSkuCodes = this.mktDiscountGiftRepoProc.getGiftDetailCode(giftIds)).isEmpty() || offsetItemCodes.isEmpty()) continue;
            giftSkuCodes.retainAll(offsetItemCodes);
            if (giftSkuCodes.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<MktDiscountOffsetVO> findMktDiscountOffsetByParam(Long ouId, String customLevel, List<Long> itemIds) {
        Assert.isFalse((boolean)CollectionUtil.isEmpty(itemIds), (String)"\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)Validator.isNull((Object)ouId), (String)"\u516c\u53f8\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List mktDiscountOffsetVOS = this.mktDiscountOffsetRepoProc.findMktDisCountOffset(ouId, customLevel, LocalDateTime.now(), itemIds).fetch();
        if (CollectionUtil.isNotEmpty((Collection)mktDiscountOffsetVOS)) {
            Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
            Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
            Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
            Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
            mktDiscountOffsetVOS.forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)i.getCustomLevel()) && !MapUtils.isEmpty((Map)custGroupUdcMap)) {
                    i.setCustomLevelName((String)custGroupUdcMap.get(i.getCustomLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getType()) && !MapUtils.isEmpty((Map)typeUdcMap)) {
                    i.setTypeName((String)typeUdcMap.get(i.getType()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getStatus()) && !MapUtils.isEmpty((Map)statusUdcMap)) {
                    i.setStatusName((String)statusUdcMap.get(i.getStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getUom()) && !MapUtils.isEmpty((Map)uomUdcMap)) {
                    i.setUomName((String)uomUdcMap.get(i.getUom()));
                }
            });
        }
        return mktDiscountOffsetVOS;
    }

    public List<MktDiscountOffsetVO> findMktDiscountOffsetByParamCode(Long ouId, String customLevel, List<String> itemCodes) {
        Assert.isFalse((boolean)CollectionUtil.isEmpty(itemCodes), (String)"\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)Validator.isNull((Object)ouId), (String)"\u516c\u53f8\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List mktDiscountOffsetVOS = this.mktDiscountOffsetRepoProc.findMktDisCountOffsetCode(ouId, customLevel, LocalDateTime.now(), itemCodes).fetch();
        if (CollectionUtil.isNotEmpty((Collection)mktDiscountOffsetVOS)) {
            Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
            Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
            Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
            Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
            mktDiscountOffsetVOS.forEach(i -> {
                if (StringUtils.isNotBlank((CharSequence)i.getCustomLevel()) && !MapUtils.isEmpty((Map)custGroupUdcMap)) {
                    i.setCustomLevelName((String)custGroupUdcMap.get(i.getCustomLevel()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getType()) && !MapUtils.isEmpty((Map)typeUdcMap)) {
                    i.setTypeName((String)typeUdcMap.get(i.getType()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getStatus()) && !MapUtils.isEmpty((Map)statusUdcMap)) {
                    i.setStatusName((String)statusUdcMap.get(i.getStatus()));
                }
                if (StringUtils.isNotBlank((CharSequence)i.getUom()) && !MapUtils.isEmpty((Map)uomUdcMap)) {
                    i.setUomName((String)uomUdcMap.get(i.getUom()));
                }
            });
        }
        return mktDiscountOffsetVOS;
    }

    private void setDetails(MktDiscountOffsetRespVO mktDiscountOffsetRespVO) {
        if (mktDiscountOffsetRespVO == null) {
            return;
        }
        List details = this.mktDiscountOffsetRepoProc.selectDetailsByMasId(mktDiscountOffsetRespVO.getId()).fetch();
        mktDiscountOffsetRespVO.setDetails(details);
    }

    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        return userEmpInfo;
    }

    private void paramCheck(List<MktDiscountOffsetSaveVO> source, boolean isNew) {
        Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        source.forEach(i -> {
            Assert.isFalse((boolean)Validator.isNull((Object)i), (String)"[\u6ee1\u51cf\u4fc3\u9500]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!isNew) {
                Assert.isFalse((boolean)Validator.isNull((Object)i.getId()), (String)"\u66f4\u65b0\u4e3b\u952e\u7f3a\u5931", (Object[])new Object[0]);
                Assert.isFalse((boolean)Validator.isEmpty((Object)i.getCode()), (String)"\u4fc3\u9500\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            Assert.isFalse((boolean)Validator.isEmpty((Object)i.getName()), (String)"\u4fc3\u9500\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isEmpty((Object)i.getCurrCode()), (String)"\u5e01\u79cd\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isNull((Object)i.getValidStime()), (String)"\u4fc3\u9500\u751f\u6548\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isNull((Object)i.getValidEtime()), (String)"\u4fc3\u9500\u5931\u6548\u65f6\u95f4\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)Validator.isEmpty((Object)i.getType()), (String)"\u4fc3\u9500\u6761\u4ef6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)CollectionUtil.isEmpty((Collection)i.getDetails()), (String)"\u4fc3\u9500\u660e\u7ec6\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isTrue((boolean)this.checkUdcValueExit(typeUdcMap, i.getType()), (String)"\u4fc3\u9500\u7c7b\u578b\u5f02\u5e38", (Object[])new Object[0]);
            Assert.isTrue((boolean)this.checkUdcValueExit(statusUdcMap, i.getStatus()), (String)"\u4fc3\u9500\u72b6\u6001\u5f02\u5e38", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((CharSequence)i.getCustomLevel())) {
                Assert.isTrue((boolean)this.checkUdcValueExit(custGroupUdcMap, i.getCustomLevel()), (String)"\u5ba2\u6237\u7b49\u7ea7\u6570\u636e\u5f02\u5e38", (Object[])new Object[0]);
            }
            List itemIds = i.getDetails().stream().map(MktDiscountOffsetDSaveVO::getItemCode).distinct().collect(Collectors.toList());
            i.getDetails().forEach(d -> {
                Assert.isTrue((boolean)this.checkUdcValueExit(uomUdcMap, d.getUom()), (String)"\u660e\u7ec6\u5546\u54c1\u5355\u4f4d\u5f02\u5e38", (Object[])new Object[0]);
                if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_0.getValueCode().equals(i.getType())) {
                    Assert.isFalse((boolean)Validator.isNull((Object)d.getLimitNum()), (String)"\u3010\u4fc3\u9500\u6761\u4ef6\u3011\u4e3a\u3010\u6309\u6570\u91cf\u3011\uff0c\u4fc3\u9500\u6761\u4ef6\u6570\u91cf\u4e3a\u7a7a", (Object[])new Object[0]);
                    d.setLimitAmt(null);
                } else if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_1.getValueCode().equals(i.getType())) {
                    Assert.isFalse((boolean)Validator.isNull((Object)d.getLimitAmt()), (String)"\u3010\u4fc3\u9500\u6761\u4ef6\u3011\u4e3a\u3010\u6309\u91d1\u989d\u3011\uff0c\u4fc3\u9500\u6761\u4ef6\u91d1\u989d\u4e3a\u7a7a", (Object[])new Object[0]);
                    d.setLimitNum(null);
                }
            });
        });
    }

    private void paramDbCheck(List<MktDiscountOffsetSaveVO> source, boolean isNew, Long ouId) {
        source.forEach(i -> {
            if (i.getValidEtime().isAfter(LocalDateTime.now())) {
                List<Long> itemIds = i.getDetails().stream().map(MktDiscountOffsetDSaveVO::getItemId).distinct().collect(Collectors.toList());
                List<Tuple> itemCodes = this.mktDiscountOffsetRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse((itemCodes.size() > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7b26\u5408\u751f\u6548\u89c4\u5219\u7684[\u6ee1\u51cf\u6d3b\u52a8]\u5546\u54c1\u660e\u7ec6\uff1a{}", (Object[])new Object[]{String.join((CharSequence)",", itemCodes.stream().map(t -> StrUtil.format((CharSequence)"[\u4fc3\u9500\u7f16\u7801\u4e3a\uff1a{}\uff0c\u5546\u54c1\u7f16\u53f7\u4e3a:{}]", (Object[])new Object[]{t.get(0, String.class), t.get(1, String.class)})).collect(Collectors.toList()))});
                itemCodes = this.mktDiscountGiftRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse((itemCodes.size() > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\u7b26\u5408\u751f\u6548\u89c4\u5219\u7684[\u4e70\u8d60\u6d3b\u52a8]\u5546\u54c1\u660e\u7ec6\uff1a{}", (Object[])new Object[]{String.join((CharSequence)",", itemCodes.stream().map(t -> StrUtil.format((CharSequence)"[\u4fc3\u9500\u7f16\u7801\u4e3a\uff1a{}\uff0c\u5546\u54c1\u7f16\u53f7\u4e3a:{}]", (Object[])new Object[]{t.get(0, String.class), t.get(1, String.class)})).collect(Collectors.toList()))});
            }
        });
    }

    private void transUdc(List<MktDiscountOffsetRespVO> source) {
        Map custGroupUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map statusUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map typeUdcMap = this.udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map uomUdcMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        source.forEach(i -> {
            if (StringUtils.isNotBlank((CharSequence)i.getCustomLevel()) && !MapUtils.isEmpty((Map)custGroupUdcMap)) {
                i.setCustomLevelName((String)custGroupUdcMap.get(i.getCustomLevel()));
            }
            if (StringUtils.isNotBlank((CharSequence)i.getType()) && !MapUtils.isEmpty((Map)typeUdcMap)) {
                i.setTypeName((String)typeUdcMap.get(i.getType()));
            }
            if (StringUtils.isNotBlank((CharSequence)i.getStatus()) && !MapUtils.isEmpty((Map)statusUdcMap)) {
                i.setStatusName((String)statusUdcMap.get(i.getStatus()));
            }
            if (!CollectionUtil.isEmpty((Collection)i.getDetails())) {
                i.getDetails().forEach(d -> {
                    if (StringUtils.isNotBlank((CharSequence)d.getUom()) && !MapUtils.isEmpty((Map)uomUdcMap)) {
                        d.setUomName((String)uomUdcMap.get(d.getUom()));
                    }
                });
            }
        });
    }

    public MktDiscountOffsetServiceImpl(OrgEmpRpcService orgEmpRpcService, RmiSysNextNumberService rmiSysNextNumberService, BipCompanyManageService bipCompanyManageService, PriSalePriceRpcService priSalePriceRpcService, MktDiscountOffsetRepo mktDiscountOffsetRepo, MktDiscountOffsetDRepo mktDiscountOffsetDRepo, BipItemSkuRepo bipItemSkuRepo, MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc, MktDiscountGiftRepoProc mktDiscountGiftRepoProc, BipCustUserBindRepoProc bipCustUserBindRepoProc, BipCustUserBindRepo bipCustUserBindRepo, RmiItemService rmiItemService) {
        this.orgEmpRpcService = orgEmpRpcService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.bipCompanyManageService = bipCompanyManageService;
        this.priSalePriceRpcService = priSalePriceRpcService;
        this.mktDiscountOffsetRepo = mktDiscountOffsetRepo;
        this.mktDiscountOffsetDRepo = mktDiscountOffsetDRepo;
        this.bipItemSkuRepo = bipItemSkuRepo;
        this.mktDiscountOffsetRepoProc = mktDiscountOffsetRepoProc;
        this.mktDiscountGiftRepoProc = mktDiscountGiftRepoProc;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.bipCustUserBindRepo = bipCustUserBindRepo;
        this.rmiItemService = rmiItemService;
    }
}

