package com.elitesland.yst.production.sale.common.constant;

/**
 * @author Danny.Wang
 * @title Constant
 * @Date2023/2/20 11:31
 */

import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**support域常用常量及方法
 * @author Danny.Wang
 * @title Constant
 * @Date2023/1/17 17:13
 */
@Component
public class Constant {

    private Constant() {
    }
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final LocalTime MAX = LocalTime.of(23,59,59);
    //产品结构配置编码
    public static final String PROUDCT_RELATE_CODE = "PROUDCT_RELATE_CODE";
    //业务员角色
    public static final String SALESMAN = "salesman";
    public static final String SALESMAN_ADMIN = "salesman_admin";
    /**
     * String转LocalDateTime当天最小时间
     * @param date
     * @return
     */
    public LocalDateTime swapTimeMin(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(Constant.DATE_FORMAT);
        LocalDate localDate = LocalDate.parse(date, dtf);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
        return localDateTime;
    }

    /**
     * String转LocalDateTime当天最大时间
     * @param date
     * @return
     */
    public LocalDateTime swapTimeMax(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(Constant.DATE_FORMAT);
        LocalDate localDate = LocalDate.parse(date, dtf);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, MAX);
        return localDateTime;
    }

    public LocalDate stringToLocalDate(String date){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate dateParam = LocalDate.parse(date, df);
        return dateParam;
    }

}
