package com.elitesland.yst.production.sale.controller.sal;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.yst.production.sale.api.service.SalAcceptanceService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptancePagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalAcceptanceSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptanceDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalAcceptancePageRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import netscape.javascript.JSObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 合同验收
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-16 14:43:45
 */
@RestController
@RequestMapping(value = "/acceptance", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售合同验收")
public class SalAcceptanceController {

    @Autowired
    private SalAcceptanceService salAcceptanceService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "验收单分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalAcceptancePageRespVO>> query(@RequestBody SalAcceptancePagingParam pagingParam) {
        return ApiResult.ok(salAcceptanceService.query(pagingParam));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存验收单")
    @ApiOperationSupport(order = 2)
    public ApiResult<JSONObject> save(@RequestBody SalAcceptanceSaveParam param) {
        JSONObject result = salAcceptanceService.saveOrSubmit(param, ConstantsSale.SAVE_OPERATION);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/submit")
    @ApiOperation(value = "提交验收单")
    @ApiOperationSupport(order = 3)
    public ApiResult<JSONObject> submit(@RequestBody SalAcceptanceSaveParam param) {
        JSONObject result = salAcceptanceService.saveOrSubmit(param, ConstantsSale.SUBMIT_OPERATION);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/submitOne/{id}")
    @ApiOperation(value = "直接在列表提交验收单")
    @ApiOperationSupport(order = 4)
    public ApiResult<JSONObject> submitOne(@PathVariable("id") Long id) {
        salAcceptanceService.submitOne(id);
        return ApiResult.ok();
    }

    @GetMapping(value = "/detail/{id}")
    @ApiOperation(value = "获取验收单详情")
    @ApiOperationSupport(order = 5)
    public ApiResult<SalAcceptanceDetailRespVO> queryOneDetail(@PathVariable("id") Long id) {
        return ApiResult.ok(salAcceptanceService.findOneDetail(id));
    }

    @PostMapping(value = "/delete/{id}")
    @ApiOperation(value = "删除一个验收单")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> delete(@PathVariable("id") Long id) {
        salAcceptanceService.deleteAc(id);
        return ApiResult.ok();
    }

    @PostMapping(value = "/appr/{id}/{apprStatus}")
    @ApiOperation(value = "审批销售合同 通过：APPROVED、拒绝：REJECTED")
    @ApiOperationSupport(order = 7)
    public ApiResult<JSObject> apprContract(@PathVariable("id") Long id, @PathVariable("apprStatus") String apprStatus) {
        salAcceptanceService.apprAcc(id, apprStatus);
        return ApiResult.ok();
    }

}
