package com.elitesland.yst.production.sale.controller.search;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.search.service.StatisticsDealerSearchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/07/05
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/statistics/dealer/search")
@RequiredArgsConstructor
@Api(value = "销售业绩统计-经销商-beanSearch", tags = {"销售业绩统计-经销商-beanSearch"})
public class StatisticsDealerSearchController {
    private final StatisticsDealerSearchService statisticsDealerSearchService;

    @PostMapping("/page")
    @ApiOperation("经销商销售业绩分页查询")
    public ApiResult<PagingVO<SaleStatisticsDealerRespVO>> page(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> page = statisticsDealerSearchService.page(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/pageSum")
    @ApiOperation("经销商销售业绩统计汇总")
    ApiResult<StatisticsDealerSumRespVO> pageSum(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        return ApiResult.ok(statisticsDealerSearchService.pageSum(pageParam));
    }

}
