package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipItemEvalService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemEvalParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemEvalRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalDetailSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSimpleSaveVO;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/19/16:51
 * @Description:
 */
@RestController
@RequestMapping("/bip/eval")
@Api(value = "评价", tags = {"评价"})
@RequiredArgsConstructor
public class BipItemEvalController {

    @Autowired
    private BipItemEvalService bipItemEvalService;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;

    @PostMapping ("/page/search")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipItemEvalRespVO>> findItemEvalPage(@RequestBody BipItemEvalParmVO bipItemEvalParmVO){
        return ApiResult.ok(bipItemEvalService.findItemEvalPage(bipItemEvalParmVO)) ;
    }

    @PostMapping("/search")
    @ApiOperation("查询")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<BipItemEvalRespVO>> findItemEval(@RequestBody BipItemEvalParmVO bipItemEvalParmVO){
        return ApiResult.ok(bipItemEvalService.findItemEval(bipItemEvalParmVO));
    }

    @PostMapping("/save")
    @ApiOperation("保存评价")
    @ApiOperationSupport(order = 3)
    public ApiResult<String> saveItemEval(@RequestBody BipItemEvalSaveVO bipItemEvalSaveVO){
        bipItemEvalService.saveItemEval(bipItemEvalSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/replay")
    @ApiOperation("回复评价")
    @ApiOperationSupport(order = 4)
    public ApiResult<String> replayItemEval(@RequestBody BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO){
        bipItemEvalService.replayItemEval(bipItemEvalDetailSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/update")
    @ApiOperation("更新评价")
    @ApiOperationSupport(order = 5)
    public ApiResult<Boolean> updateItemEval(@RequestBody List<BipItemEvalDetailSaveVO> bipItemEvalDetailSaveVOList){
        bipItemEvalService.updateItemEval(bipItemEvalDetailSaveVOList);
        return ApiResult.ok();
    }

    @GetMapping("/find/{id}")
    @ApiOperation("根据id查询评价")
    @ApiOperationSupport(order = 6)
    public ApiResult<BipItemEvalRespVO> replayItemEval(@PathVariable Long id){
        BipItemEvalRespVO bipItemEvalRespVO=bipItemEvalService.findItemEval(id);
        return ApiResult.ok(bipItemEvalRespVO);
    }

    @PostMapping("/update/isShow")
    @ApiOperation("更新评价隐藏")
    @ApiOperationSupport(order = 7)
    public ApiResult<String> updateItemEvalIsShow(@RequestBody BipItemEvalSimpleSaveVO bipItemEvalSimpleSaveVO){

        bipItemEvalService.updateItemEvalIsShow(bipItemEvalSimpleSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/delete")
    @ApiOperation("删除评价")
    @ApiOperationSupport(order = 8)
    public ApiResult<BipItemEvalRespVO> deleteItemEval(@RequestBody List<Long> ids){
        bipItemEvalService.deleteItemEvalByIds(ids);
        return ApiResult.ok();
    }

    @GetMapping("/app/find/{id}")
    @ApiOperation("查询订单评价")
    @ApiOperationSupport(order = 9)
    public ApiResult<BipItemEvalAppRespVO> findOrderEval(@PathVariable Long id){
        BipItemEvalAppRespVO bipItemEvalAppRespVO=bipItemEvalService.findItemEvalByOrderId(id);
        return ApiResult.ok(bipItemEvalAppRespVO);
    }

    @PostMapping ("/app/page/search")
    @ApiOperation("APP分页查询")
    @ApiOperationSupport(order = 10)
    public ApiResult<PagingVO<BipItemEvalDetailAppRespVO>> findItemEvalAppPage(@RequestBody BipItemEvalParmVO bipItemEvalParmVO){
        if(bipItemEvalParmVO.getIsShow()==null){
            bipItemEvalParmVO.setIsShow(false);
        }
        return ApiResult.ok(bipItemEvalService.findItemEvalAppPage(bipItemEvalParmVO)) ;
    }
}
