package com.elitesland.yst.production.sale.core.cache.key;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitesland.yst.production.sale.common.constant.ConstantsCache;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/01
 */
@Component(ConstantsCache.KEY_GENERATOR_CURRENT_USER)
public class CurrentUserKeyGenerator implements KeyGenerator {

    @Override
    public Object generate(@NonNull Object target, @NonNull Method method, @NonNull Object... params) {
        var user = SecurityContextUtil.currentUser();
        if (user == null) {
            return -1;
        }
        return user.getUser().getId();
    }
}
