package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/19
 */
@Entity
@Table(name = "bip_item_ext", indexes = {
        @Index(name = "idx_bip_item_ext_item_id", columnList = "bip_item_id")
})
@org.hibernate.annotations.Table(appliesTo = "bip_item_ext", comment = "商品扩展信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class BipItemExtDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 7505173069106522896L;

    @Column(name = "bip_item_id", columnDefinition = "bigint(20) not null comment '商品Id'")
    private Long bipItemId;

    @Column(name = "content", columnDefinition = "longtext comment '商品图文描述'")
    private String content;

    @Column(name = "spec", columnDefinition = "longtext comment '规格参数'")
    private String spec;

    @Column(name = "unit", columnDefinition = "varchar(64) comment '商品单位'")
    private String unit;

    @Column(name = "time_on_shelf_plan", columnDefinition = "datetime comment '预计上架时间'")
    private LocalDateTime timeOnShelfPlan;

    @Column(name = "time_off_shelf_plan", columnDefinition = "datetime comment '预计下架时间'")
    private LocalDateTime timeOffShelfPlan;

    @Column(name = "time_approve_create", columnDefinition = "datetime comment '发起审批时间'")
    private LocalDateTime timeApproveCreate;

    @Column(name = "time_approved", columnDefinition = "datetime comment '审批完成时间'")
    private LocalDateTime timeApproved;

    @Column(name = "approver_id", columnDefinition = "bigint(20) comment '审批人Id'")
    private Long approverId;

    @Column(name = "approver_name", columnDefinition = "varchar(64) comment '审批人名称'")
    private String approverName;

    @Column(name = "approve_opinion", columnDefinition = "longtext comment '审批意见'")
    private String approveOpinion;

    @Column(name = "approved", columnDefinition = "tinyint(1) comment '是否审批通过'")
    private Boolean approved;
}
