package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/16:52
 * @Description:
 */

@Entity
@Table(name = "bip_order_back_d")
@org.hibernate.annotations.Table(appliesTo = "bip_order_back_d", comment = "订单表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipOrderBackDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -8903727818938029276L;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(64) comment '公司编码'")
    private String ouCode;


    @Column(name = "ou_name", columnDefinition = "varchar(64) comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigInt(20) comment '组织id'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(64) comment '组织编码'")
    private String buCode;
    @Column(name = "p_id", columnDefinition = "bigInt(20) comment '明细单的父id--赠品订单此字段不能为空'")
    private Long pid;

    @Column(name = "line_no", columnDefinition = "int(10) default null  comment '行号'")
    private Integer lineNo;

    @Column(name = "item_type", columnDefinition = "varchar(32) comment '商品类型 [UDC]ITM：ITEM_TYPE'")
    private String itemType;

    @Column(name = "bu_name", columnDefinition = "varchar(64) comment '组织名称'")
    private String buName;

    @Column(name = "order_id", columnDefinition = "bigInt(20) comment '订单主表id'")
    private Long orderId;

    @Column(name = "order_d_id", columnDefinition = "bigInt(20) comment '订单子表id'")
    private Long orderDId;

    @Column(name = "order_doc_no", columnDefinition = "varchar(64) comment '订单主表单号'")
    private String orderDocNo;

    @Column(name = "order_back_id", columnDefinition = "bigInt(20) comment '退货单单主表id'")
    private Long orderBackId;

    @Column(name = "order_back_doc_no", columnDefinition = "varchar(64) comment '退货单单号'")
    private String orderBackDocNo;


    @Column(name = "cust_account_id", columnDefinition = "bigInt(20) comment '登录人id'")
    private Long custAccountId;

    @Column(name = "cust_account_name", columnDefinition = "varchar(128) comment '登录人姓名'")
    private String custAccountName;





    @Column(name = "item_id", columnDefinition = "bigInt(20) comment '商品id'")
    private Long itemId;
    @Column(name = "sku_id", columnDefinition = "bigInt(20) comment '商品sku id'")
    private Long skuId;

    @Column(name = "relate_item_id", columnDefinition = "bigInt(20) comment '关联商品中心的商品ID'")
    private Long relateItemId;

//    @Column(name = "item_pic_id", columnDefinition = "bigInt(20) comment '商品图片id'")
//    private Long itemPicId;
    @Column(name = "item_pic_file_code", columnDefinition = "varchar(64) comment '商品图片id'")
    private String itemPicFileCode;

    @Column(name = "item_code", columnDefinition = "varchar(64) comment '商品编码'")
    private String itemCode;


    @Column(name = "item_name", columnDefinition = "varchar(255) comment '商品名称'")
    private String itemName;

    @Column(name = "item_title", columnDefinition = "varchar(1024) comment '商品标题'")
    private String itemTitle;

    @Column(name = "item_brand_id", columnDefinition = "bigInt(64) comment '商品品牌id'")
    private Long itmeBrandID;

    @Column(name = "item_brand_code", columnDefinition = "bigInt(20) comment '商品品牌编码'")
    private String itmeBrandCode;

    @Column(name = "item_brand", columnDefinition = "varchar(255) comment '商品品牌名称'")
    private String itemBrand;

    @Column(name = "item_spec", columnDefinition = "varchar(255) default null  comment '商品规格'")
    private String itemSpec;


    @Column(name = "uom", columnDefinition = "varchar(20) comment '商品计量单位'")
    private String uom;

    @Column(name = "back_num", columnDefinition = "bigInt(20) comment '退货数量'")
    private Long backNum;

    @Column(name = "status", columnDefinition = "varchar(20) comment '订单状态'")
    private String status;


    @Column(name = "pay_amt", columnDefinition = "decimal(20,2) comment '购买时价格'")
    private BigDecimal payAmt;

//    @Column(name = "back_logis_id", columnDefinition = "bigInt(20) comment '退货物流ID'")
//    private Long backLogisId;
//
//    @Column(name = "back_logis_no", columnDefinition = "varchar(64) comment '退货物流单号'")
//    private String backLogisNo;
//
//
//    @Column(name = "approve_time", columnDefinition = "datetime comment '审核时间'")
//    private LocalDateTime approveTime;
//
//    @Column(name = "sign_time", columnDefinition = "datetime comment '签收时间'")
//    private LocalDateTime signTime;
//
//    @Column(name = "refuse_reason", columnDefinition = "varchar(256) comment '审核拒绝原因'")
//    private String refuseReason;


    @Column(name = "apply_back_amt", columnDefinition = "decimal(20,2) comment '申请退款金额'")
    private BigDecimal applyBackAmt;

    @Column(name = "approve_back_amt", columnDefinition = "decimal(20,2) comment '批准退款金额'")
    private BigDecimal approveBackAmt;

    @Column(name = "approve_user_id", columnDefinition = "bigInt(20) comment '审批人id'")
    private Long approveUserId;

    @Column(name = "approve_user_name", columnDefinition = "varchar(64) comment '审批人姓名'")
    private String approveUserName;


//    @Column(name = "back_type", columnDefinition = "varchar(64) comment '退货类型'")
//    private String backType;
//
//    @Column(name = "back_reason", columnDefinition = "varchar(64) comment '退款原因'")
//    private String backReason;
//
//
//    @Column(name = "back_pay_time", columnDefinition = "datetime comment '退款时间'")
//    private LocalDateTime backPayTime;
//
//    @Column(name = "back_time", columnDefinition = "datetime comment '退货时间'")
//    private LocalDateTime backTime;

    @Column(name = "is_word_order", columnDefinition = "tinyint(1) default 0 comment '是否需要生成工单 0 是 1 否'")
    private Boolean isWorkOrder;

//    @Column(name = "shipper_name", columnDefinition = "varchar(64) comment '寄货人姓名'")
//    private String shipperName;
//
//    @Column(name = "shipper_tel", columnDefinition = "varchar(64) comment '寄货人电话'")
//    private String shipperTel;
//
//    @Column(name = "receiver_name", columnDefinition = "varchar(64) comment '收货人姓名'")
//    private String receiverName;
//
//    @Column(name = "receiver_tel", columnDefinition = "varchar(64) comment '收货人电话'")
//    private String receiverTel;




}
