package com.elitesland.yst.production.sale.entity;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录明细表
 */
@Entity
@Table(name="execut_record_dtl")
@org.hibernate.annotations.Table(appliesTo = "execut_record_dtl", comment = "执行记录明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ExecutRecordDtlDO extends BaseModel {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    @Column(name = "entry_time", columnDefinition = "datetime(6) comment '进店时间'")
    private LocalDateTime entryTime;

    @Column(name = "leave_time", columnDefinition = "datetime(6) comment '离店时间'")
    private LocalDateTime leaveTime;

    @Column(name = "sign_in_position", columnDefinition = "varchar(255) comment '签到地点'")
    private String signInPosition;

    @Column(name = "sign_in_position_code", columnDefinition = "varchar(255) comment '签到地点编码'")
    private String signInPositionCode;

    @Column(name = "sign_out_position", columnDefinition = "varchar(255) comment '签退地点'")
    private String signOutPosition;

    @Column(name = "sign_out_position_code", columnDefinition = "varchar(255) comment '签退地点编码'")
    private String signOutPositionCode;

    @Column(name = "sign_desc", columnDefinition = "varchar(255) comment '签到备注'")
    private String signDesc;


}