package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 文件信息
 */
@Entity
@Table(name="file_info")
@org.hibernate.annotations.Table(appliesTo = "file_info", comment = "文件信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class FileInfoDO extends BaseModel {

    @Column(name = "url", columnDefinition = "varchar(255) comment '链接'")
    private String url;

    @Column(name = "code", columnDefinition = "varchar(255) comment '编码'")
    private String code;

    @Column(name = "source_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long sourceId;

    @Column(name = "source_type", columnDefinition = "varchar(255) comment '来源类型'")
    private String sourceType;

    @Column(name = "file_name", columnDefinition = "varchar(255) comment '文件名称'")
    private String fileName;

    @Column(name = "file_type", columnDefinition = "varchar(255) comment '文件类型'")
    private String fileType;

    @Column(name = "file_path", columnDefinition = "varchar(255) comment '文件路径'")
    private String filePath;

    @Column(name = "old_file_name", columnDefinition = "varchar(255) comment '原始文件名称'")
    private String oldFileName;

    @Column(name = "file_size", columnDefinition = "varchar(255) comment '文件大小'")
    private String fileSize;

    @Column(name = "file_info", columnDefinition = "varchar(255) comment '文件内容'")
    private String fileInfo;


}