package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 10:41
 */
@Entity
@Table(name = "sal_quotation_d")
@org.hibernate.annotations.Table(appliesTo = "sal_quotation_d", comment = "销售报价单详情表")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalQuotationDDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 3070948371889145357L;

    @ApiModelProperty("报价单号")
    @Column(name = "doc_no", columnDefinition = "varchar(40) default null comment '报价单号'")
    private String docNo;

    @ApiModelProperty("行号")
    @Column(name = "line_no", columnDefinition = "NUMERIC(20,2) default null comment '行号'")
    private BigDecimal lineNo;

    @ApiModelProperty("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(18) default null comment '主表ID'")
    private Long masId;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(18) default null comment '客户ID'")
    private Long custId;

    @ApiModelProperty("行状态")
    @Column(name = "line_status", columnDefinition = "longtext default null comment '行状态'")
    private String lineStatus;

    @ApiModelProperty("商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(18) default null comment '商品ID'")
    private Long itemId;

    @ApiModelProperty("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(40) default null comment '商品编码'")
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) default null comment '商品名称'")
    private String itemName;

    @ApiModelProperty("商品名称2")
    @Column(name = "item_name2", columnDefinition = "varchar(100) default null comment '商品名称2'")
    private String itemName2;

    @ApiModelProperty("商品规格")
    @Column(name = "item_spec", columnDefinition = "longtext default null comment '商品规格'")
    private String itemSpec;

    @ApiModelProperty("品牌")
    @Column(name = "item_brand", columnDefinition = "longtext default null comment '品牌'")
    private String itemBrand;

    @ApiModelProperty("批次")
    @Column(name = "lot_no", columnDefinition = "longtext default null comment '批次'")
    private String lotNo;


    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "varchar(40) default null comment '公司ID'")
    private Long ouId;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "longtext default null comment '公司编码'")
    private String ouCode;

    @ApiModelProperty("销售组织ID")
    @Column(name = "bu_id", columnDefinition = "varchar(40) default null comment '销售组织ID'")
    private Long buId;

    @ApiModelProperty("销售组织编码")
    @Column(name = "bu_code", columnDefinition = "longtext default null comment '销售组织编码'")
    private String buCode;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "varchar(40) default null comment '仓库ID'")
    private Long whId;

    @ApiModelProperty("库位")
    @Column(name = "wh_loc", columnDefinition = "longtext default null comment '库位'")
    private String whLoc;

    @ApiModelProperty("报价人ID")
    @Column(name = "agent_emp_id", columnDefinition = "varchar(40) default null comment '报价人ID'")
    private Long agentEmpId;

    @ApiModelProperty("报价人编码")
    @Column(name = "agent_emp_code", columnDefinition = "longtext default null comment '报价人编码'")
    private String agentEmpCode;

    @ApiModelProperty("本位币币种")
    @Column(name = "home_curr", columnDefinition = "longtext default null comment '本位币币种'")
    private String homeCurr;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "longtext default null comment '币种'")
    private String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "curr_rate", columnDefinition = "decimal(20,8) default null comment '汇率'")
    private BigDecimal currRate;

    @ApiModelProperty("报价日期")
    @Column(name = "quotation_date", columnDefinition = "datetime default null comment '报价日期'")
    private LocalDateTime quotationDate;

    @ApiModelProperty("销售区域")
    @Column(name = "sale_region", columnDefinition = "varchar(40) default null comment '销售区域'")
    private String saleRegion;

    @ApiModelProperty("报价单状态")
    @Column(name = "quotation_status", columnDefinition = "varchar(40) default null comment '报价单状态'")
    private String quotationStatus;

    @ApiModelProperty("审批日期")
    @Column(name = "appr_time", columnDefinition = "datetime default null comment '审批日期'")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人")
    @Column(name = "appr_user_id", columnDefinition = "bigint(18) default null comment '审批人'")
    private Long apprUserId;

    @ApiModelProperty("付款方式")
    @Column(name = "pay_method", columnDefinition = "varchar(40) default null comment '付款方式'")
    private String payMethod;

    @ApiModelProperty("审批意见")
    @Column(name = "appr_comment", columnDefinition = "longtext default null comment '审批意见'")
    private String apprComment;

    @ApiModelProperty("客户商品编号")
    @Column(name = "item_cs_code", columnDefinition = "longtext default null comment '客户商品编号'")
    private String itemCsCode;

    @ApiModelProperty("客户联系人")
    @Column(name = "cust_contact_name", columnDefinition = "varchar(40) default null comment '客户联系人'")
    private String custContactName;

    @ApiModelProperty("客户联系人电话")
    @Column(name = "cust_contact_tel", columnDefinition = "varchar(40) default null comment '客户联系人电话'")
    private String custContactTel;

    @ApiModelProperty("收货地址ID")
    @Column(name = "recv_addr_no", columnDefinition = "bigint(18) default null comment '收货地址ID'")
    private Long recvAddrNo;

    @ApiModelProperty("收货详细地址")
    @Column(name = "recv_detailaddr", columnDefinition = "varchar(100) default null comment '收货详细地址'")
    private String recvDetailaddr;

    @ApiModelProperty("配送方式")
    @Column(name = "deliver_method", columnDefinition = "varchar(40) default null comment '配送方式'")
    private String deliverMethod;

    @ApiModelProperty("要求日期")
    @Column(name = "demand_timespan", columnDefinition = "datetime default null comment '要求日期'")
    private LocalDateTime demandTimespan;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "longtext default null comment '客户名称'")
    private String custName;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "longtext default null comment '客户编码'")
    private String custCode;

    @ApiModelProperty("数量")
    @Column(name = "qty", columnDefinition = "bigint(18) default null comment '数量'")
    private Long qty;

    @ApiModelProperty("计量单位")
    @Column(name = "uom", columnDefinition = "varchar(10) default null comment '计量单位'")
    private String uom;

    @ApiModelProperty("价格类型")
    @Column(name = "price_type", columnDefinition = "varchar(40) default null comment '价格类型'")
    private String priceType;

    @ApiModelProperty("未税单价")
    @Column(name = "net_price", columnDefinition = "decimal(20,8) default null comment '未税单价'")
    private BigDecimal netPrice;

    @ApiModelProperty("未税金额")
    @Column(name = "net_amt", columnDefinition = "decimal(20,2) default null comment '未税金额'")
    private BigDecimal netAmt;

    @ApiModelProperty("含税单价")
    @Column(name = "price", columnDefinition = "decimal(20,8) default null comment '含税单价'")
    private BigDecimal price;

    @ApiModelProperty("含税金额")
    @Column(name = "amt", columnDefinition = "decimal(20,2) default null comment '含税金额'")
    private BigDecimal amt;

    @ApiModelProperty("税额")
    @Column(name = "tax_amt", columnDefinition = "decimal(20,2) default null comment '税额'")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20,8) default null comment '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("税率编号")
    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) default null comment '税率编号'")
    private String taxRateNo;

    @ApiModelProperty("税率描述")
    @Column(name = "tax_rate_desc", columnDefinition = "varchar(40) default null comment '税率描述'")
    private String taxRateDesc;

    @ApiModelProperty("折扣率")
    @Column(name = "disc_ratio", columnDefinition = "decimal(20,8) default null comment '折扣率'")
    private BigDecimal discRatio;

    @ApiModelProperty("原始金额")
    @Column(name = "price_orig", columnDefinition = "decimal(20,2) default null comment '原始金额'")
    private BigDecimal priceOrig;

    @ApiModelProperty("折扣金额")
    @Column(name = "disc_amt", columnDefinition = "decimal(20,2) default null comment '折扣金额'")
    private BigDecimal discAmt;

    @ApiModelProperty("未税折扣金额")
    @Column(name = "disc_net_amt", columnDefinition = "decimal(20,2) default null comment '未税折扣金额'")
    private BigDecimal discNetAmt;

    @ApiModelProperty("行类型")
    @Column(name = "line_type", columnDefinition = "varchar(40) default null comment '行类型'")
    private String lineType;

    @ApiModelProperty("运输方式")
    @Column(name = "trans_type", columnDefinition = "longtext default null comment '运输方式'")
    private String transType;

    @ApiModelProperty("运输温层")
    @Column(name = "transport_temp", columnDefinition = "longtext default null comment '运输温层'")
    private String transportTemp;

    @ApiModelProperty("ED1")
    @Column(name = "ed1", columnDefinition = "datetime default null comment 'ED1'")
    private LocalDateTime ed1;

    @ApiModelProperty("ED2")
    @Column(name = "ed2", columnDefinition = "datetime default null comment 'ED2'")
    private LocalDateTime ed2;

    @ApiModelProperty("ED3")
    @Column(name = "ed3", columnDefinition = "datetime default null comment 'ED3'")
    private LocalDateTime ed3;

    @ApiModelProperty("EN1")
    @Column(name = "en1", columnDefinition = "decimal(20,8) default null comment 'EN1'")
    private BigDecimal en1;

    @ApiModelProperty("EN2")
    @Column(name = "en2", columnDefinition = "decimal(20,8) default null comment 'EN2'")
    private BigDecimal en2;

    @ApiModelProperty("EN3")
    @Column(name = "en3", columnDefinition = "decimal(20,8) default null comment 'EN3'")
    private BigDecimal en3;

    @ApiModelProperty("EN4")
    @Column(name = "en4", columnDefinition = "decimal(20,8) default null comment 'EN4'")
    private BigDecimal en4;

    @ApiModelProperty("EN5")
    @Column(name = "en5", columnDefinition = "decimal(20,8) default null comment 'EN5'")
    private BigDecimal en5;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "longtext default null comment 'ES1'")
    private String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "longtext default null comment 'ES2'")
    private String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "longtext default null comment 'ES3'")
    private String es3;

    @ApiModelProperty("ES4")
    @Column(name = "es4", columnDefinition = "longtext default null comment 'ES4'")
    private String es4;

    @ApiModelProperty("ES5")
    @Column(name = "es5", columnDefinition = "longtext default null comment 'ES5'")
    private String es5;

    @ApiModelProperty("ES6")
    @Column(name = "es6", columnDefinition = "longtext default null comment 'ES6'")
    private String es6;

    @ApiModelProperty("ES7")
    @Column(name = "es7", columnDefinition = "longtext default null comment 'ES7'")
    private String es7;

    @ApiModelProperty("ES8")
    @Column(name = "es8", columnDefinition = "longtext default null comment 'ES8'")
    private String es8;

    @ApiModelProperty("ES9")
    @Column(name = "es9", columnDefinition = "longtext default null comment 'ES9'")
    private String es9;

    @ApiModelProperty("ES10")
    @Column(name = "es10", columnDefinition = "longtext default null comment 'ES1'")
    private String es10;
}
