package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author Danny.Wang
 * @title SalesmanInfoDO
 * @Date2023/2/20 10:55
 */
@Entity
@Table(name = "salesman_info")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "salesman_info", comment = "业务员信息表")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@Accessors(chain = true)
@ApiModel(value = "salesman_info", description = "业务员信息表")
public class SalesmanInfoDO extends BaseModel {

    private static final long serialVersionUID = -7649324985994842998L;
    @ApiModelProperty("业务员编号")
    @Column(name = "salesman_no", columnDefinition = "varchar(30) default 0 comment '业务员编号'")
    private String salesmanNo;

    @ApiModelProperty("业务员类型")
    @Column(name = "salesman_type ", columnDefinition = "varchar(20) default 0 comment '业务员类型'")
    private String salesmanType;

    @ApiModelProperty("管辖区域")
    @Column(name = "jurisdiction", columnDefinition = "varchar(50) default 0 comment '管辖区域'")
    private String jurisdiction;

    @ApiModelProperty("登录账号")
    @Column(name = "login_account", columnDefinition = "varchar(30) comment '关联用户id'")
    private String loginAccount;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(50) comment '公司名称'")
    private String ouName;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(30) comment '公司编码'")
    private String ouCode;

    @ApiModelProperty("公司id")
    @Column(name = "ou_id", columnDefinition = "bigint(30) comment '公司id'")
    private Long ouId;

    @ApiModelProperty("公司所属组织id")
    @Column(name = "org_id_belong", columnDefinition = "bigint(30) comment '公司所属组织id'")
    private Long orgIdBelong;

    @ApiModelProperty("头像文件编码")
    @Column(name = "file_code", columnDefinition = "varchar(50) comment '头像文件编码'")
    private String fileCode;

    @ApiModelProperty("启用状态")
    @Column(name = "enable_status", columnDefinition = "tinyint(3)")
    private Integer enableStatus;


    @ApiModelProperty("名称")
    @Column(name = "name", columnDefinition = "varchar(100) comment '名称'")
    private String name;

}
