package com.elitesland.yst.production.sale.ext.cpcn.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.ext.cpcn.param.*;
import com.elitesland.yst.production.sale.ext.cpcn.resp.*;
import cpcn.institution.tools.net.RequestDgtEnvlp;
import cpcn.institution.tools.util.Base64;
import cpcn.institution.tools.util.DigitalEnvelopeUtil;
import cpcn.institution.tools.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import payment.api.notice.*;
import payment.api.system.PaymentEnvironment;
import payment.api.system.TxMessenger;
import payment.api.tx.TxBaseRequest;
import payment.api.tx.TxBaseResponse;
import payment.api.tx.aggregate.Tx5011Request;
import payment.api.tx.aggregate.Tx5011Response;
import payment.api.tx.aggregate.Tx5021Request;
import payment.api.tx.aggregate.Tx5021Response;
import payment.api.tx.foundationaccount.Tx4643Request;
import payment.api.tx.foundationaccount.Tx4643Response;
import payment.api.tx.foundationaccount.Tx4692Request;
import payment.api.tx.foundationaccount.Tx4692Response;
import payment.api.util.GUIDGenerator;
import payment.api.vo.Item;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
@Slf4j
public class CPCNUtils {
//    private static Logger logger = LoggerFactory.getLogger(CPCNUtils.class);
//    private static DecimalFormat decimalFormat = new DecimalFormat("###################");
//    private static String clientIP ="127.0.0.1";
//    /**
//     * 交易响应码
//     */
//    private static String SUCCESS_CODE ="2000"; //ok
//    //读取配置,获取配置文件地址
//    //本地调试路径改为 "/yst-fin-endpoint/docker/payment"
////    private static String CHINAGAS_PAYMENT_FILE = "/yst-sale-endpoint/docker/payment";
//
//    //提交代码时路径改为 "/payment"
//    private static String CHINAGAS_PAYMENT_FILE = "/payment";
//
//    //初始化支付环境
//    static {
//        try {
//            clientIP = InetAddress.getLocalHost().getHostAddress();
//            String path = System.getProperty("user.dir");
//            System.out.println("*****中金文件路径"+path+"********");
//            log.info("中金环境初始化---"+CHINAGAS_PAYMENT_FILE);
//            //本地调试路径改为 "path+CHINAGAS_PAYMENT_FILE"
//            //提交代码时路径改为 "CHINAGAS_PAYMENT_FILE"
//            PaymentEnvironment.initialize(CHINAGAS_PAYMENT_FILE);
//            if(StringUtil.isEmpty(PaymentEnvironment.institutionID)){
//                PaymentEnvironment.institutionID = "007087";
//                System.out.println("##################初始化支付环境##################");
//            }
//            PaymentEnvironment.isDgEnv="YES";
//            clientIP = InetAddress.getLocalHost().getHostName();
//        }catch(Throwable t){
//            logger.error("初始化失败！"+t.getMessage(),t);
//            log.info("中金环境初始化!");
//        }
//    }
//
//    /**
//     * 报文发送方法
//     * @param baseRequest:该类是基类，根据交易报文对象传值
//     * @return
//     */
//    public static TxBaseResponse send(TxBaseRequest baseRequest){
//        //定义返回值
//        TxBaseResponse txBaseResponse = null;
//        try {
//            baseRequest.process();
//            String message = baseRequest.getRequestMessage();
//            String signature = baseRequest.getRequestSignature();
//            RequestDgtEnvlp requestDgtEnvlp = new RequestDgtEnvlp();
//            requestDgtEnvlp.setDgtlEnvlp(baseRequest.getDgtlEnvlp());
//            requestDgtEnvlp.setSignAlgorithm(baseRequest.getSignAlgorithm());
//            requestDgtEnvlp.setSignSN(baseRequest.getSignSN());
//            requestDgtEnvlp.setEncryptSN(baseRequest.getEncryptSN());
//            requestDgtEnvlp.setInstitutionID(PaymentEnvironment.institutionID);
//            requestDgtEnvlp.setIsDgEnv(PaymentEnvironment.isDgEnv);
//            TxMessenger txMessenger = new TxMessenger();
//            String[] respMsg = null;
//            respMsg = txMessenger.send(message, signature, requestDgtEnvlp); // 0:message;
//            String plainText;
//            if ("YES".equals(respMsg[2])) {
//                //如果响应是数字信封，对消息进行对称解密
//                try {
//                    logger.info("开始对响应消息做对称解密。。。。。。");
//                    respMsg[0] = DigitalEnvelopeUtil.decryptResponse(respMsg[0], respMsg[3], respMsg[5], respMsg[6]);
//                    respMsg[0] = Base64.encode(respMsg[0], "UTF-8");
//                    respMsg[0] = respMsg[0] + "," + respMsg[5] + "," + respMsg[4] + "," + respMsg[2];
//                    logger.info("响应消息做对称解密完成。。。。。。");
//                } catch (Exception e) {
//                    throw new Exception(e + "对称解密异常！");
//                }
//            } else {
//                if (StringUtil.isNotEmpty(respMsg[5])) {
//                    respMsg[0] = respMsg[0] + "," + respMsg[5] + "," + respMsg[4] + "," + respMsg[2];
//                }
//            }
//            int txCode =Integer.parseInt(baseRequest.getTxCode()) ;
//            switch (txCode){
//                case 5011 :  //聚合支付
//                    txBaseResponse = new Tx5011Response(respMsg[0], respMsg[1]);
//                    break;
//                case 5018 :  //聚合支付回调通知(回调不发报文)
//                    txBaseResponse = new Tx5011Response(respMsg[0], respMsg[1]);
//                    break;
//                case 4643 :  //提现
//                    txBaseResponse = new Tx4643Response(respMsg[0], respMsg[1]);
//                    break;
//                case 4692:  //用户查询
//                    txBaseResponse = new Tx4692Response(respMsg[0], respMsg[1]);
//                    break;
//                case 4658 :  //提现回调通知（回调不发送报文）
//                    txBaseResponse = new Tx4643Response(respMsg[0], respMsg[1]);
//                    break;
//                case 5021 :  //提现回调通知（回调不发送报文）
//                    txBaseResponse = new Tx5021Response(respMsg[0], respMsg[1]);
//                    break;
//                default:
//                    logger.error("反回response 没有配置"+ respMsg[0] +  respMsg[1]);
//                    logger.info("中金支付接口交互，返回 response 没有配置"+ respMsg[0] +  respMsg[1]);
//            }
//        }catch(Throwable t){
//            log.info(t.getMessage());
//        }
//        return txBaseResponse;
//    }
//
//    /**
//     * 生成流水号
//     * @return
//     */
//    public static String getTxSN(){
//        String txSN = null;
//        try {
//            txSN = GUIDGenerator.genGUID();
//        } catch (Exception e) {
//            log.info("交易流水号生成失败,发生异常:{}",e,e.getMessage());
//            //logger.error("交易流水号生成失败,发生异常:{}",e,e.getMessage());
//        }
//        return txSN;
//    }
//
//    /**
//     * 5011-综合支付-余额支付功能
//     */
//    public static CPCN5011Resp cpcn5011Request(CPCN5011Param cpcn5011Param){
//        //转换的 5011 响应信息
//        CPCN5011Resp cpcn5011Resp = new CPCN5011Resp();
//        //中金的定义的5011接口请求的实体类
//        Tx5011Request req = new Tx5011Request();
//        //余额支付需要的参数信息
//        req.setInstitutionID(PaymentEnvironment.institutionID);//007087
////        cpcn5011Param.setPayeeUserID(PaymentEnvironment.institutionID);
//        req.setTxSN(cpcn5011Param.getTxSN());
//        req.setOrderNo(cpcn5011Param.getOrderNo());
////        req.setPayerUserID(cpcn5011Param.getPayerUserID());
////        req.setPayeeUserID(cpcn5011Param.getPayeeUserID());
//        req.setPaymentWay(cpcn5011Param.getPaymentWay());
//        req.setAmount(decimalFormat.format(cpcn5011Param.getAmount().multiply(new BigDecimal(100))));
//        req.setRemark(cpcn5011Param.getRemark());
//
//        req.setPayWay(cpcn5011Param.getPayWay());
//        req.setPayType(cpcn5011Param.getPayType());
//        req.setSubOpenID(cpcn5011Param.getSubOpenID());
//        req.setSubAppID(cpcn5011Param.getSubAppID());
//        req.setPlatformName(cpcn5011Param.getPlatformName());
//        req.setNoticeURL(cpcn5011Param.getNoticeUrl());
//        //商品名称
//        req.setGoodsName(cpcn5011Param.getGoodsName());
//        // 收款用户 007087  0001
//        req.setPayerUserID(cpcn5011Param.getPayerUserID());
//        req.setPayeeUserID(cpcn5011Param.getPayeeUserID());
//        //当PayeeUserID为电子账户ID时，PayeeAccountNumber字段可以传空值
//    //    req.setPayeeAccountNumber(cpcn5011Param.getPayeeAccountNumber());
//
//        req.setClientIP(clientIP);
//
//        req.setRedirectSource("40");
//
//        logger.info("中金请求信息--"+ JSON.toJSONString(req));
//        //向中金发送报文获取响应结果
//        Tx5011Response response = (Tx5011Response) send(req);
//
//        logger.info("中金返回信息--"+ JSON.toJSONString(response));
//
//        //判断响应码是否成功
//        if (!SUCCESS_CODE.equals(response.getCode())) {
//            logger.info("响应失败，响应码:{}", response.getCode());
//            return null;
//        }
//        logger.info("中金支付响应的报文: \n" + response.getResponsePlainText()+"\n");
//        //将响应结果进行转换成自定义的实体信息
//        BeanUtil.copyProperties(response,cpcn5011Resp);
//        //中金响应的报文
//        cpcn5011Resp.setResponsePlainText(response.getResponsePlainText());
//        return cpcn5011Resp;
//    }
//
//    /**
//     * 4643-余额提现功能
//     * @param cpcn4643Param
//     * @return
//     */
//    public static CPCN4643Resp cpcn4643Request(CPCN4643Param cpcn4643Param){
//        CPCN4643Resp cpcn4643Resp = new CPCN4643Resp();
//        Tx4643Request req = new Tx4643Request();
//        req.setInstitutionID(PaymentEnvironment.institutionID);
//        req.setTxSN(cpcn4643Param.getTxSN()); //交易流水号
//        req.setNoticeURL("http://nrp-test.zrhsh.com/yst-fin/fin/cpcn/payResultNotice");
//        req.setUserID(cpcn4643Param.getUserId()); //用户ID
//        req.setBindingTxSN(cpcn4643Param.getBindingTxSN()); //绑定银行卡的流水号
//        req.setAmount(decimalFormat.format(cpcn4643Param.getPayAmount().multiply(new BigDecimal(100)))); //提现金额
//        if(StringUtil.isEmpty(cpcn4643Param.getAcceptanceConfirmType())){
//            req.setAcceptanceConfirmType("111111111");
//        }else {
//            req.setAcceptanceConfirmType(cpcn4643Param.getAcceptanceConfirmType());
//        }
//        req.setArrivalType(cpcn4643Param.getArrivalType()); //提现类型 10：T +1  20： D0
//        if(StringUtil.isNotEmpty(cpcn4643Param.getNoticeURL())) {
//            req.setNoticeURL(cpcn4643Param.getNoticeURL());//回调地址
//        }
//        if(StringUtil.isNotEmpty(cpcn4643Param.getRemark())) {
//            req.setRemark(cpcn4643Param.getRemark());//备注信息
//        }
//
//        Tx4643Response response = (Tx4643Response) send(req);
//        if (!SUCCESS_CODE.equals(response.getCode())) {
//            logger.info("响应失败，响应码:{}", response.getCode());
//        }
//        logger.info("中金支付响应的报文: \n" + response.getResponsePlainText()+"\n");
//
//        BeanUtil.copyProperties(response,cpcn4643Resp);
//        //中金响应的报文
//        cpcn4643Resp.setResponsePlainText(response.getResponsePlainText());
//        return cpcn4643Resp;
//    }
//
//    /**
//     *  4692-用户账户明细查询,分页号和分页大小为可选参数
//     * @param cpcn4692Param
//     * @return
//     */
//    public static CPCN4692Resp cpcn4692Request(CPCN4692Param cpcn4692Param){
//        CPCN4692Resp cpcn4692Resp = new CPCN4692Resp();
//        Tx4692Request req = new Tx4692Request();
//        req.setInstitutionID(PaymentEnvironment.institutionID);
//        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
//        req.setUserID(cpcn4692Param.getUserId());
//        req.setStartDate(cpcn4692Param.getStartDate().format(formatter));
//        req.setEndDate(cpcn4692Param.getEndDate().format(formatter));
//        //分页查询
//        if(StringUtil.isNotEmpty(cpcn4692Param.getPageIndex())){
//            req.setPageIndex(cpcn4692Param.getPageIndex());
//        }
//        if(StringUtil.isNotEmpty(cpcn4692Param.getPageSize())){
//            req.setPageSize(cpcn4692Param.getPageSize());
//        }
//
//        Tx4692Response response = (Tx4692Response) send(req);
//        if (!SUCCESS_CODE.equals(response.getCode())) {
//            logger.info("中金响应失败，响应码:{}", response.getCode());
//        }
//
//        BeanUtil.copyProperties(response,cpcn4692Resp,"itemList");
//        List<Item> items=new ArrayList<>();
//        if(!StringUtils.isEmpty(response.getTotalPage())){
//            Integer totalPage = Integer.valueOf(response.getTotalPage());
//            if(totalPage>=1) {
//                items.addAll(response.getItemList());
//                for (int i = 1; i < totalPage; i++) {
//                    req.setPageIndex(String.valueOf(i+1));
//                    response = (Tx4692Response) send(req);
//                    if (!SUCCESS_CODE.equals(response.getCode())) {
//                        logger.info("响应失败，响应码:{}", response.getCode());
//                    }
//                    items.addAll(response.getItemList());
//                }
//                if (CollUtil.isNotEmpty(items)) {
//                    List<CPCN4692Item> itemList = items.stream().map(t -> {
//                        CPCN4692Item item = new CPCN4692Item();
//                        BeanUtil.copyProperties(t, item, "txSn");
//                        item.setTxSn(t.getTxSn());
//                        return item;
//                    }).collect(Collectors.toList());
//                    cpcn4692Resp.setItemList(itemList);
//                }
//            }
//        }
//        return cpcn4692Resp;
//    }
//
//    /**
//     * 当5011在支付时，返回的status的状态是20时，会回调5018通知支付结果
//     * 5018-综合支付回调函数
//     * @param cpcn5018Param
//     * @return
//     * @throws Exception
//     */
//    public static CPCN5018Req cpcn5018Request(CPCN5018Param cpcn5018Param) throws Exception {
//        CPCN5018Req cpcn5018Req = new CPCN5018Req();
//        Notice5018Request notice5018Request = null;
//        NoticeRequest noticeRequest = null;
//        if ("YES".equals(cpcn5018Param.getIsDgEnv())) {
//            //数字信封解密验签
//            noticeRequest = new NoticeRequest(cpcn5018Param.getMessage(),
//                    cpcn5018Param.getSignature(), cpcn5018Param.getDigitalEnvelope(),
//                    cpcn5018Param.getSignSN(), cpcn5018Param.getEncryptSN(),
//                    cpcn5018Param.getSignAlgorithm());
//        } else {
//            //非数字信封解密验签
//            if (StringUtil.isNotEmpty(cpcn5018Param.getSignSN())) {
//                cpcn5018Param.setMessage(cpcn5018Param.getMessage() + "," + cpcn5018Param.getSignSN() + "," + cpcn5018Param.getSignAlgorithm());
//            }
//            noticeRequest = new NoticeRequest(cpcn5018Param.getMessage(), cpcn5018Param.getSignature());
//        }
//        logger.error("****中金回调参数CPCNUtils.noticeRequest["+noticeRequest.getDocument()+"]******");
//        logger.error("****中金回调参数CPCNUtils.TxCode["+noticeRequest.getTxCode()+"]******");
//        if (noticeRequest.getTxCode().equals("5018")){//返回的接口编号
//            notice5018Request = new Notice5018Request(noticeRequest.getDocument());
//            logger.error("****中金回调参数CPCNUtils.notice5018Request["+notice5018Request.toString()+"]******");
//            BeanUtil.copyProperties(notice5018Request,cpcn5018Req);
//        }else{
//            logger.error("中金回调参数CPCNUtils.noticeRequest.txCode ["+noticeRequest.getTxCode()+"]******");
//        }
//        logger.error("****中金回调参数CPCNUtils.cpcn5018Resp["+cpcn5018Req.toString()+"]******");
//        return cpcn5018Req;
//    }
//    /**
//     * 当5011在支付时，返回的status的状态是20时，会回调5018通知支付结果
//     * 5018-生成响应信息响应给中金
//     * @param cpcn5018Resp
//     * @return
//     * @throws Exception
//     */
//    public static String cpcn5018Response(CPCN5018Resp cpcn5018Resp) throws Exception {
//        String xmlString = "处理结果异常";
//        if (cpcn5018Resp.getCode().equals("2000") && cpcn5018Resp.getMessage().equals("OK")) {
//            xmlString = new NoticeResponse().getMessage();
//        }
//        String base64String = new String(Base64.encode(xmlString.getBytes("UTF-8")));
//        return base64String;
//    }
//    /**
//     * 4658-提现回调函数
//     * @param cpcn4658Param
//     * @return
//     * @throws Exception
//     */
//    public static CPCN4658Req cpcn4658Request(CPCN4658Param cpcn4658Param) throws Exception {
//        CPCN4658Req cpcn4658Resp = new CPCN4658Req();
//        Notice4658Request notice4658Request = null;
//        NoticeRequest noticeRequest = null;
//        if ("YES".equals(cpcn4658Param.getIsDgEnv())) {
//            //数字信封解密验签
//            noticeRequest = new NoticeRequest(cpcn4658Param.getMessage(),
//                    cpcn4658Param.getSignature(), cpcn4658Param.getDigitalEnvelope(),
//                    cpcn4658Param.getSignSN(), cpcn4658Param.getEncryptSN(),
//                    cpcn4658Param.getSignAlgorithm());
//        } else {
//            //非数字信封解密验签
//            if (StringUtil.isNotEmpty(cpcn4658Param.getSignSN())) {
//                cpcn4658Param.setMessage(cpcn4658Param.getMessage() + "," + cpcn4658Param.getSignSN() + "," + cpcn4658Param.getSignAlgorithm());
//            }
//            noticeRequest = new NoticeRequest(cpcn4658Param.getMessage(), cpcn4658Param.getSignature());
//        }
//       logger.error("****中金回调参数CPCNUtils.noticeRequest["+noticeRequest.getDocument()+"]******");
//       logger.error("****中金回调参数CPCNUtils.TxCode["+noticeRequest.getTxCode()+"]******");
//        if (noticeRequest.getTxCode().equals("4658")){//返回的接口编号
//            notice4658Request = new Notice4658Request(noticeRequest.getDocument());
//            logger.error("****中金回调参数CPCNUtils.notice4658Request["+notice4658Request.toString()+"]******");
//            BeanUtil.copyProperties(notice4658Request,cpcn4658Resp);
//        }else{
//            logger.error("中金回调参数CPCNUtils.noticeRequest.txCode ["+noticeRequest.getTxCode()+"]******");
//        }
//        logger.error("****中金回调参数CPCNUtils.cpcn4658Resp["+cpcn4658Resp.toString()+"]******");
//        return cpcn4658Resp;
//    }
//
//    /**
//     * 4658-生成响应信息响应给中金
//     * @param cpcn4658Resp
//     * @return
//     * @throws Exception
//     */
//    public static String cpcn4658Response(CPCN4658Resp cpcn4658Resp) throws Exception {
//        String xmlString = "处理结果异常";
//        if (cpcn4658Resp.getCode().equals("2000") && cpcn4658Resp.getMessage().equals("OK")) {
//            xmlString = new NoticeResponse().getMessage();
//        }
//        String base64String = new String(Base64.encode(xmlString.getBytes("UTF-8")));
//        return base64String;
//    }
//
//    /**
//     * 5021-发送退款请求
//     */
//    public static CPCN5021Resp cpcn5021Request(CPCN5021Req cpcn5021Req){
//        //转换的 5011 响应信息
//        CPCN5021Resp cpcn5021Resp = new CPCN5021Resp();
//        //中金的定义的5011接口请求的实体类
//        Tx5021Request req = new Tx5021Request();
//        //余额支付需要的参数信息
//        req.setInstitutionID(PaymentEnvironment.institutionID);//007087
//        //退款流水号
//        req.setTxSN(cpcn5021Req.getTxSN());
//        //原交易流水号
//        req.setPaymentTxSN(cpcn5021Req.getPaymentTxSN());
//
//        req.setNoticeURL(cpcn5021Req.getNoticeURL());
//
//        req.setAmount(cpcn5021Req.getAmount());
//        req.setCancelAmount(cpcn5021Req.getCancelAmount());
//        req.setRemark(cpcn5021Req.getRemark());
//        req.setSourceTxTime(cpcn5021Req.getSourceTxTime());
//
//        req.setRefundWay("20");
////        req.setNoticeURL("http://nrp-test.zrhsh.com/yst-sale/sale/cpcn/returnNotice");
//
//        logger.info("中金请求信息--"+ JSON.toJSONString(req));
//        //向中金发送报文获取响应结果
//        Tx5021Response response = (Tx5021Response) send(req);
//        logger.info("中金返回信息--"+ JSON.toJSONString(response));
//
//        //判断响应码是否成功
//        if (!SUCCESS_CODE.equals(response.getCode())) {
//            logger.info("响应失败，响应码:{}", response.getCode());
//            return null;
//        }
//        logger.info("中金支付响应的报文: \n" + response.getResponsePlainText()+"\n");
//        BeanUtil.copyProperties(response,cpcn5021Resp);
//        return cpcn5021Resp;
//    }
//
//    /**
//     * 退款通知请求信息解析
//     * @param cpcn5028Param
//     * @return
//     * @throws Exception
//     */
//    public static CPCN5028Req cpcn5028Request(CPCN5028Param cpcn5028Param) throws Exception {
//        CPCN5028Req cpcn5028Req = new CPCN5028Req();
//        Notice5028Request notice5028Request = null;
//
//        NoticeRequest noticeRequest = null;
//        if ("YES".equals(cpcn5028Param.getIsDgEnv())) {
//            //数字信封解密验签
//            noticeRequest = new NoticeRequest(cpcn5028Param.getMessage(),
//                    cpcn5028Param.getSignature(), cpcn5028Param.getDigitalEnvelope(),
//                    cpcn5028Param.getSignSN(), cpcn5028Param.getEncryptSN(),
//                    cpcn5028Param.getSignAlgorithm());
//        } else {
//            //非数字信封解密验签
//            if (StringUtil.isNotEmpty(cpcn5028Param.getSignSN())) {
//                cpcn5028Param.setMessage(cpcn5028Param.getMessage() + "," + cpcn5028Param.getSignSN() + "," + cpcn5028Param.getSignAlgorithm());
//            }
//            noticeRequest = new NoticeRequest(cpcn5028Param.getMessage(), cpcn5028Param.getSignature());
//        }
//
//        logger.error("退款通知解析结果--"+JSON.toJSONString(noticeRequest));
//        if (noticeRequest.getTxCode().equals("5028")){//返回的接口编号
//            notice5028Request = new Notice5028Request(noticeRequest.getDocument());
//            logger.error("退款通知解析结果--"+JSON.toJSONString(notice5028Request));
//            BeanUtil.copyProperties(notice5028Request,cpcn5028Req);
//        }else{
//            logger.error("退款通知解析结果不匹配--"+noticeRequest.getTxCode());
//        }
//        return cpcn5028Req;
//    }
//
//    public static void main(String[] args) {
//            //转换的 5011 响应信息
//            CPCN5021Resp cpcn5021Resp = new CPCN5021Resp();
//            //中金的定义的5011接口请求的实体类
//            Tx5021Request req = new Tx5021Request();
//            //余额支付需要的参数信息
//            req.setInstitutionID(PaymentEnvironment.institutionID);//007087
//            req.setTxSN(CPCNUtils.getTxSN());
//            req.setPaymentTxSN("202110171443007498477937373");
//            req.setAmount("1");
////        req.setCancelAmount("1");
//            req.setRefundWay("20");
//            req.setSourceTxTime("20211017");
//            req.setNoticeURL("http://nrp-test.zrhsh.com/yst-sale/sale/cpcn/returnNotice");
//            req.setRemark("商场退款");
//
//
//            log.info("中金请求信息--"+ JSON.toJSONString(req));
//            //向中金发送报文获取响应结果
//            Tx5021Response response = (Tx5021Response) CPCNUtils.send(req);
//
//            log.info("中金返回信息--"+ JSON.toJSONString(response));
//
//            //判断响应码是否成功
//            if (!"2000".equals(response.getCode())) {
//                log.info("响应失败，响应码:{}", response.getCode());
//            }
//            log.info("中金支付响应的报文: \n" + response.getResponsePlainText()+"\n");
//            //将响应结果进行转换成自定义的实体信息
//            BeanUtil.copyProperties(response,cpcn5021Resp);
//    }

}
