package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipCompanyManageDO;
import com.elitesland.yst.production.sale.entity.QBipCompanyManageDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/10/26 10:04
 */
@Component
@RequiredArgsConstructor
public class BipCompanyManageRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QBipCompanyManageDO qBipCompanyManageDO = QBipCompanyManageDO.bipCompanyManageDO;

    /**
     * 判断B端商城公司名称是否已存在
     *
     * @param id ID
     * @return 是否存在
     */
    public Boolean exists(Long ouId, Long id) {
        Predicate predicate = qBipCompanyManageDO.deleteFlag.eq(0).or(qBipCompanyManageDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(ouId) ? predicate : ExpressionUtils.and(predicate, qBipCompanyManageDO.ouId.eq(ouId));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qBipCompanyManageDO.id.ne(id));
        return jpaQueryFactory.select(qBipCompanyManageDO)
                .from(qBipCompanyManageDO)
                .where(predicate)
                .fetchCount() > 0;
    }


    /**
     * 判断B端商城公司显示名称是否已存在
     *
     * @param id ID
     * @return 是否存在
     */
    public Boolean exists(String ouViewName, Long id) {
        Predicate predicate = qBipCompanyManageDO.deleteFlag.eq(0).or(qBipCompanyManageDO.deleteFlag.isNull());
        predicate = ObjectUtils.isEmpty(ouViewName) ? predicate : ExpressionUtils.and(predicate, qBipCompanyManageDO.viewOuName.eq(ouViewName));
        predicate = ObjectUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qBipCompanyManageDO.id.ne(id));
        return jpaQueryFactory.select(qBipCompanyManageDO)
                .from(qBipCompanyManageDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    public BipCompanyManageDO findByOuId(Long ouId){
        return jpaQueryFactory.select(qBipCompanyManageDO).from(qBipCompanyManageDO).where(qBipCompanyManageDO.ouId.eq(ouId)).limit(1).fetchOne();
    }

    public BipCompanyManageDO findByOuCode(String ouCode){
        return jpaQueryFactory.select(qBipCompanyManageDO).from(qBipCompanyManageDO).where(qBipCompanyManageDO.ouCode.eq(ouCode)).limit(1).fetchOne();
    }

}















