package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.BipOrderBackDO;
import com.elitesland.yst.production.sale.entity.QBipOrderBackDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/10/07/11:58
 * @Description:
 */
@Repository
public class BipOrderBackRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;

    public BipOrderBackRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }


    public void updateStatus(Long id, String status) {
        jpaQueryFactory.update(qBipOrderBackDO)
                .set(qBipOrderBackDO.status, status)
                .where(qBipOrderBackDO.id.eq(id)).execute();
    }


    public BipOrderBackDO findOrderBackByDocNo(String docNo) {
        return jpaQueryFactory.select(qBipOrderBackDO).from(qBipOrderBackDO).where(qBipOrderBackDO.orderBackDocNo.eq(docNo)).fetchOne();
    }


    public boolean updateOrderBackStatus(String docNo, String status, String txsn, LocalDateTime payTime) {
        return jpaQueryFactory.update(qBipOrderBackDO)
                .set(qBipOrderBackDO.status, "DONE")
                .set(qBipOrderBackDO.txsn, txsn)
                .set(qBipOrderBackDO.backPayTime, payTime)
                .where(qBipOrderBackDO.orderDocNo.eq(docNo))
                .execute() == 1;
    }


    /**
     * 退款异常插入异常信息
     *
     * @param docNo
     * @param msg
     * @return
     */
    public boolean updateOrderBackReturnMsg(String docNo, String msg) {
        return jpaQueryFactory.update(qBipOrderBackDO)
                .set(qBipOrderBackDO.returnMsg, msg)
                .where(qBipOrderBackDO.orderDocNo.eq(docNo))
                .execute() == 1;
    }


    public Long getOuIdById(Long id) {
        return jpaQueryFactory.select(qBipOrderBackDO.ouId)
                .from(qBipOrderBackDO)
                .where(qBipOrderBackDO.id.eq(id).and(qBipOrderBackDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetchOne();
    }
}
