package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.PriSalePrice2Service;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePricePagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePriceExportVO;
import com.elitesland.yst.production.sale.api.vo.resp.pri.PriSalePricePageRespVO;
import com.elitesland.yst.production.sale.convert.PriSalePriceConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/8/22 16:08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PriSalePrice2ServiceImpl extends BaseServiceImpl implements PriSalePrice2Service {

    private final PriSalePriceService priSalePriceService;

    @Override
    public ApiResult<PagingVO<PriSalePriceExportVO>> searchForExport(PriSalePricePagingParam paramVO) {
        // 联表查询主表和明细
        PagingVO<PriSalePricePageRespVO> pageRespVOPagingVO = priSalePriceService.query(paramVO);
        List<PriSalePriceExportVO> salePriceExportVoS = pageRespVOPagingVO.getRecords().stream().map(PriSalePriceConvert.INSTANCE::respVoToExport).collect(Collectors.toList());
        long total = pageRespVOPagingVO.getTotal();
        this.transactionExport(salePriceExportVoS);
        return ApiResult.ok(PagingVO.<PriSalePriceExportVO>builder()
                .total(total)
                .records(salePriceExportVoS)
                .build());
    }

    private void transactionExport(List<PriSalePriceExportVO> salePriceExportVoS){
        salePriceExportVoS.forEach(sale ->{
           sale.setMarketPrice(sale.getMarketPrice() == null ? null:sale.getMarketPrice().setScale(4,BigDecimal.ROUND_DOWN));
           sale.setPrice(sale.getPrice() == null ? null:sale.getPrice().setScale(4,BigDecimal.ROUND_DOWN));
           sale.setGuidePrice(sale.getGuidePrice() == null ? null:sale.getGuidePrice().setScale(4,BigDecimal.ROUND_DOWN));
           sale.setPromotionPrice(sale.getPromotionPrice() == null ? null:sale.getPromotionPrice().setScale(4,BigDecimal.ROUND_DOWN));
           sale.setPromotionNetPrice(sale.getPromotionNetPrice() == null ? null:sale.getPromotionNetPrice().setScale(4,BigDecimal.ROUND_DOWN));
           sale.setTaxRate(sale.getTaxRate() == null ? null:sale.getTaxRate().setScale(2,BigDecimal.ROUND_DOWN));
           sale.setValidToLD(sale.getValidTo() == null ? null:sale.getValidTo().toString());
           sale.setValidFromLD(sale.getValidFrom() == null ? null:sale.getValidFrom().toString());
           sale.setModifyTimeLD(sale.getModifyTime() == null ? null:sale.getModifyTime().toString());
           sale.setCreateTimeLD(sale.getCreateTime() == null ? null:sale.getCreateTime().toString());
           sale.setPromDateFLD(sale.getPromDateF() == null ? null:sale.getPromDateF().toString());
           sale.setPromDateTLD(sale.getPromDateT() == null ? null:sale.getPromDateT().toString());
        });
    }

}
