package com.elitesland.yst.production.sale.service;

import com.elitescloud.boot.excel.common.DataExport;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.search.service.StatisticsDealerSearchService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/12
 * @Version 1.0
 * @Content:
 */
@Component
@RequiredArgsConstructor
public class StatisticsDealerExportServiceImpl implements DataExport<SaleStatisticsDealerRespVO, SaleStatisticsDealerQueryVO> {

    //private final StatisticsDealerService statisticsDealerService;
    private final StatisticsDealerSearchService statisticsDealerSearchService;

    /**
     * 获取模板编号
     *
     * @return 模板编号
     */
    @Override
    public String getTmplCode() {
        return ConstantsSale.STATISTICS_DEALER_EXPORT;
    }

    /**
     * 导出数据
     *
     * @param queryParam 查询参数
     * @return 数据
     */
    @Override
    public PagingVO<SaleStatisticsDealerRespVO> executeExport(SaleStatisticsDealerQueryVO queryParam) {
        PagingVO<SaleStatisticsDealerRespVO> pagingVO = statisticsDealerSearchService.page(queryParam);

        return PagingVO.<SaleStatisticsDealerRespVO>builder()
                .total(pagingVO.getTotal())
                .records(pagingVO.getRecords())
                .build();
    }

}
