package com.elitesland.yst.production.sale.service.common;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.common.DeAccountRoleService;
import com.elitesland.yst.production.sale.api.vo.param.com.DeAccountRoleParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.DeAccountRoleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.convert.CustAccountConvert;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.common.DeAccountRoleRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/22 19:50
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class DeAcountRoleServiceImpl implements DeAccountRoleService {

    private final DeAccountRoleRepoProc deAccountRoleRepoProc;

    private final CustAccountRepoProc custAccountRepoProc;

    @Override
    public List<DeAccountRoleVO> getRole(DeAccountRoleParam param) {
        // 角色信息处理
        CustAccountVO custAccountInfo = this.getCustAccountInfo();
        param.setDealerType(custAccountInfo.getDealerType());
        param.setBusinessType(custAccountInfo.getBusinessType());
        List<DeAccountRoleVO> role = deAccountRoleRepoProc.getRole(param);
        return role;
    }

    private CustAccountVO getCustAccountInfo(){
        CustAccountConvert custAccountConvert = CustAccountConvert.INSTANCE;
        //获取当前用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if(Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())){
            throw new BusinessException("获取当前用户信息失败");
        }
        SysUserDTO sysUser = userDetails.getUser();
            //SysUserDTO sysUser = rmiSysUserService.currentUser();
        if(ObjectUtils.isEmpty(sysUser)){
            throw new BusinessException("用户信息获取失败");
        }
        CustAccountDO byUserName = custAccountRepoProc.getByUserName(sysUser.getUsername());
        return custAccountConvert.doToVO(byUserName);
    }
}
