package com.elitesland.yst.production.sale.workflow;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepoProc;
import com.elitesland.yst.production.sale.workflow.service.BipOrderBackProcessService;
import com.elitesland.yst.production.sale.workflow.service.PriSalePriceAlterProcessService;
import com.elitesland.yst.production.sale.workflow.service.SalAcceptanceProcessService;
import com.elitesland.yst.production.sale.workflow.service.SalQuotationProcessService;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * @author yangzhibin
 * @date 2021/8/5
 */
//@Service
@Slf4j
@RequiredArgsConstructor
public class B2BWorkflowCallBack implements WorkflowCallBack {

    private final PriSalePriceAlterProcessService priSalePriceAlterProcessService;

    private final PriSalePriceAlterRepoProc priSalePriceAlterRepoProc;

    private final SalQuotationProcessService salQuotationProcessService;

    private final SalAcceptanceProcessService salAcceptanceProcessService;

    private final BipOrderBackProcessService bipOrderBackProcessService;

//    /**
//     * 动态指定任务负责人
//     *
//     * @param procDefKey  流程定义KEY
//     * @param taskKey     任务KEY
//     * @param businessKey 业务标识（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
//     * @return 任务处理人USER_ID集合
//     */
//    @Override
//    public ArrayList<String> taskAssignee(String tenantId, String procDefKey, String taskKey, String businessKey, String customParams) {
//        log.info("动态指定任务负责人: 流程定义KEY:{},任务key:{},业务key:{},自定义参数:{}", procDefKey, taskKey, businessKey, customParams);
//
//        // 1.判断流程节点是否有审批角色
//        if (procDefKey.equals(ProcDefKey.B2B_IN_SETTLE_PRICE.name()) || procDefKey.equals(ProcDefKey.B2B_OUT_SALE_PRICE.name())) {
//            // 内部结算价或是对外销售价
//            List<String> userIds = priSalePriceAlterProcessService.taskAssignee(getId(businessKey), customParams);
//            return CollUtil.newArrayList(userIds);
//        } else if (procDefKey.equals(ProcDefKey.SAL_QUOTATION.name())) {
//            List<String> userIds = salQuotationProcessService.taskAssignee(getId(businessKey), customParams);
//            return CollUtil.newArrayList(userIds);
//        } else if (procDefKey.equals(ProcDefKey.SAL_ACCEPTANCE.name())) {
//            List<String> userIds = salAcceptanceProcessService.taskAssignee(getId(businessKey), customParams);
//            return CollUtil.newArrayList(userIds);
//        } else if (procDefKey.equals(ProcDefKey.TOB_SALE_RETURN.name())) {
//            List<String> userIds = bipOrderBackProcessService.taskAssignee(getId(businessKey), customParams);
//            return CollUtil.newArrayList(userIds);
//        } else {
//            return null;
//        }
//    }
//    /**
//     * 任务创建后回调
//     *
//     * @param procDefKey    流程定义KEY
//     * @param taskKey       任务KEY
//     * @param businessKey   业务标识（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
//     * @param taskAssignees 任务处理人
//     */
//    @Override
//    public void taskCreated(String tenantId, String procDefKey, String taskKey, String businessKey, Set<String> taskAssignees) {
//        log.info("任务创建后回调: 流程定义KEY:{},任务key:{},业务key:{},处理人:{}", procDefKey, taskKey, businessKey, taskAssignees);
//    }
//    /**
//     * 任务完成后回调
//     *
//     * @param procDefKey  流程定义KEY
//     * @param taskKey     任务KEY
//     * @param businessKey 业务标识（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
//     * @param taskHandler 处理人userId
//     */
//    @Override
//    public void taskCompleted(String tenantId, String procDefKey, String taskKey, String businessKey, String taskHandler) {
//        log.info("任务完成后回调: 流程定义KEY:{},任务key:{},业务key:{}，任务处理人{}", procDefKey, taskKey, businessKey, taskHandler);
//    }
//    /**
//     * 流程状态变化回调
//     *
//     * @param procDefKey     流程定义KEY
//     * @param procInstStatus 状态
//     * @param businessKey    业务标识（一般是id，也可以是自定义的，只要能根据businessKey找到你的业务对象,如id+code）
//     * @param commentInfo    审批信息
//     */
//    @Override
//    public void processStatusChange(String tenantId, String procDefKey, ProcInstStatus procInstStatus, String businessKey, CommentInfo commentInfo) {
//        log.info("流程回调 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey);
//
//        if (procDefKey.equals(ProcDefKey.B2B_OUT_SALE_PRICE.name()) || procDefKey.equals(ProcDefKey.B2B_IN_SETTLE_PRICE.name())) {
//            //B端对外销售价格申请单 + B端内部结算价申请单
//            priSalePriceAlterProcessService.processStatusChange(getId(businessKey), procInstStatus);
//        } else if (procDefKey.equals(ProcDefKey.SAL_QUOTATION.name())) {
//            //B端
//            salQuotationProcessService.processStatusChange(getId(businessKey), procInstStatus);
//        } else if (procDefKey.equals(ProcDefKey.SAL_ACCEPTANCE.name())) {
//            //B端合同验收单
//            salAcceptanceProcessService.processStatusChange(getId(businessKey), procInstStatus);
//        } else if (procDefKey.equals(ProcDefKey.TOB_SALE_RETURN.name())) {
//            //B端商城退货
//            bipOrderBackProcessService.processStatusChange(getId(businessKey), procInstStatus);
//        }
//    }

    //从businessKey中提取id
    private Long getId(String businessKey) {
        return Long.valueOf(businessKey);
    }

    @Override
    public ArrayList<String> taskAssignee(TaskAssigneePayload payload) {
        String procDefKey = payload.getProcDefKey(); String taskKey = payload.getTaskKey(); String businessKey = payload.getBusinessKey(); String customParams = payload.getCustomParams();
        log.info("动态指定任务负责人: 流程定义KEY:{},任务key:{},业务key:{},自定义参数:{}", procDefKey, taskKey, businessKey, customParams);

        // 1.判断流程节点是否有审批角色
        if (procDefKey.equals(ProcDefKey.B2B_IN_SETTLE_PRICE.name()) || procDefKey.equals(ProcDefKey.B2B_OUT_SALE_PRICE.name())) {
            // 内部结算价或是对外销售价
            List<String> userIds = priSalePriceAlterProcessService.taskAssignee(getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        } else if (procDefKey.equals(ProcDefKey.SAL_QUOTATION.name())) {
            List<String> userIds = salQuotationProcessService.taskAssignee(getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        } else if (procDefKey.equals(ProcDefKey.SAL_ACCEPTANCE.name())) {
            List<String> userIds = salAcceptanceProcessService.taskAssignee(getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        } else if (procDefKey.equals(ProcDefKey.TOB_SALE_RETURN.name())) {
            List<String> userIds = bipOrderBackProcessService.taskAssignee(getId(businessKey), customParams);
            return CollUtil.newArrayList(userIds);
        } else {
            return null;
        }
    }

    @Override
    public void taskCreated(TaskCreatedPayload payload) {
        log.info("任务创建后回调: 流程定义KEY:{},任务key:{},业务key:{},处理人:{}"+ JSON.toJSONString(payload));
    }

    @Override
    public void taskCompleted(TaskCompletedPayload payload) {
        log.info("任务完成后回调: 流程定义KEY:{},任务key:{},业务key:{}，任务处理人{}"+JSON.toJSONString(payload));
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String procDefKey = payload.getProcDefKey();  ProcInstStatus procInstStatus = payload.getProcInstStatus(); String businessKey = payload.getBusinessKey();
        log.info("流程回调 procDefKey:" + procDefKey + " ,procInstStatus:" + procInstStatus + ",businessKey:" + businessKey);

        if (procDefKey.equals(ProcDefKey.B2B_OUT_SALE_PRICE.name()) || procDefKey.equals(ProcDefKey.B2B_IN_SETTLE_PRICE.name())) {
            //B端对外销售价格申请单 + B端内部结算价申请单
            priSalePriceAlterProcessService.processStatusChange(getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.SAL_QUOTATION.name())) {
            //B端
            salQuotationProcessService.processStatusChange(getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.SAL_ACCEPTANCE.name())) {
            //B端合同验收单
            salAcceptanceProcessService.processStatusChange(getId(businessKey), procInstStatus);
        } else if (procDefKey.equals(ProcDefKey.TOB_SALE_RETURN.name())) {
            //B端商城退货
            bipOrderBackProcessService.processStatusChange(getId(businessKey), procInstStatus);
        }
    }
}