/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.crm;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.CrmScustService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmScustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmScustSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/crm/scust"}, produces={"application/json"})
@Api(tags={"\u6f5c\u5728\u5ba2\u6237\u4fe1\u606f"})
@ApiSupport(author="zhao.zhi.hao", order=1)
public class CrmScustController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(CrmScustController.class);
    @Autowired
    private CrmScustService crmScustService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6f5c\u5728\u5ba2\u6237\u5217\u8868")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<CrmScustPageRespVO>> search(@RequestBody CrmScustQueryParamVO searchParam) {
        return ApiResult.ok((Object)this.crmScustService.search(searchParam));
    }

    @PostMapping(value={"/get/{id}"})
    @ApiOperation(value="\u67e5\u8be2\u6f5c\u5728\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f")
    @ApiOperationSupport(order=2)
    public ApiResult<CrmScustDetailRespVO> getScustDetail(@PathVariable Long id) {
        return ApiResult.ok((Object)this.crmScustService.findScustById(id));
    }

    @PostMapping(value={"/empAssign"})
    @ApiOperation(value="\u6279\u91cf\u5206\u914d\u4e1a\u52a1\u5458")
    @ApiOperationSupport(order=3)
    public ApiResult<Object> empAssign(@RequestBody CrmEmpAssignParamVO crmEmpAssignParamVO) {
        this.crmScustService.empAssign(crmEmpAssignParamVO);
        return ApiResult.ok();
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6f5c\u5728\u5ba2\u6237\u4fdd\u5b58")
    @ApiOperationSupport(order=4)
    public ApiResult<Long> save(@RequestBody CrmScustSaveVO saveVO) {
        CrmScustDetailRespVO scustDetailRespVO = (CrmScustDetailRespVO)this.crmScustService.save(saveVO).getData();
        return ApiResult.ok((Object)scustDetailRespVO.getId());
    }

    @GetMapping(value={"/updateStatus/{id}"})
    @ApiOperation(value="\u66f4\u6539\u6f5c\u5728\u5ba2\u6237\u72b6\u6001")
    @ApiOperationSupport(order=4)
    public ApiResult<Long> updateScustStatus(@PathVariable Long id) {
        return ApiResult.ok((Object)this.crmScustService.updateScustStatus(id));
    }

    @PostMapping(value={"/ImportScustData"})
    @ApiOperation(value="\u5bfc\u5165\u6f5c\u5728\u5ba2\u6237\u4fe1\u606f\u6570\u636e")
    @ApiOperationSupport(order=6)
    public ApiResult<Object> parseImportScustData(MultipartFile file) {
        List<?> parseData = null;
        try {
            parseData = this.importExcel(file, CrmScustImportSaveVO.class, 3, 3);
        }
        catch (Exception e) {
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u539f\u59cb\u6a21\u677f\u6570\u636e\u683c\u5f0f\u8fdb\u884c\u5bfc\u5165");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return this.crmScustService.conScustImportData(parseData);
        }
        return ApiResult.ok();
    }
}

