/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractPagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractExportVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSalContractDDO;
import com.elitesland.yst.production.sale.entity.QSalContractDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import org.springframework.stereotype.Repository;

@Repository
public class SalContractRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QSalContractDO qSalContractDO = QSalContractDO.salContractDO;
    private final QSalContractDDO qSalContractDDO = QSalContractDDO.salContractDDO;

    public BigDecimal getTotalAmt(String contractNo) {
        return (BigDecimal)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qSalContractDO.totalAmt).from((EntityPath)this.qSalContractDO)).where((Predicate)this.qSalContractDO.contractNo.eq((Object)contractNo))).limit(1L)).fetchOne();
    }

    private Predicate where(SalContractPagingParam pageParam) {
        BooleanExpression predicate = this.qSalContractDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (Objects.nonNull(pageParam.getIds()) && pageParam.getIds().size() > 0) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.id.in((Collection)pageParam.getIds()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractNo.like(pageParam.getContractNo().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractName.like("%" + pageParam.getContractName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractType.eq((Object)pageParam.getContractType()));
            }
            if (Objects.nonNull(pageParam.getSignDate())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.signDate.eq((Object)pageParam.getSignDate()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getProjName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.projName.like("%" + pageParam.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractStatus())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractStatus.eq((Object)pageParam.getContractStatus()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custId.eq((Object)pageParam.getCustId()));
            }
            if (CollUtil.isNotEmpty((Collection)pageParam.getCustIds())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custId.in((Collection)pageParam.getCustIds()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custCode.like(pageParam.getCustCode().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custName.like("%" + pageParam.getCustName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getSignOu())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.bSignOu.eq((Object)pageParam.getSignOu()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getSalesMan())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.bSalesman.eq((Object)pageParam.getSalesMan()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getRegion())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.bRegion.eq((Object)pageParam.getRegion()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getFindCloseOrderFlag()) && pageParam.getFindCloseOrderFlag().equals("false")) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractStatus.eq((Object)UdcEnum.SAL_CONTRACT_STATUS_APPROVED.getValueCode()));
            }
        }
        return predicate;
    }

    public JPAQuery<SalContractExportVO> selectForExport(SalContractPagingParam queryParam) {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalContractExportVO.class, (Expression[])new Expression[]{this.qSalContractDO.contractNo, this.qSalContractDO.contractType, this.qSalContractDO.contractStatus, this.qSalContractDO.contractName, this.qSalContractDO.contractVersion, this.qSalContractDO.projName, this.qSalContractDO.signDate, this.qSalContractDO.beginDate, this.qSalContractDO.endDate, this.qSalContractDO.totalAmt, this.qSalContractDO.currCode, this.qSalContractDO.custCode, this.qSalContractDO.custName, this.qSalContractDO.custPic, this.qSalContractDO.custPicTel, this.qSalContractDO.custAddress, this.qSalContractDO.endAmt, this.qSalContractDO.contractNo2, this.qSalContractDO.guaranteePeriod, this.qSalContractDO.contractCity, this.qSalContractDO.feeCarrier, this.qSalContractDO.deliverDate, this.qSalContractDO.installFlag, this.qSalContractDO.deliverAddress, this.qSalContractDO.projConfirmFlag, this.qSalContractDO.guaranteeAmt, this.qSalContractDO.deliverMethod, this.qSalContractDO.bSignOu.as("seSignOu"), this.qSalContractDO.bSignDept.as("seSignDept"), this.qSalContractDO.bSalesman.as("seSalesman"), this.qSalContractDO.bSalesmanTel.as("seSalesmanTel"), this.qSalContractDO.bRegion.as("seRegion"), this.qSalContractDO.bAddress.as("seAddress"), this.qSalContractDO.cCode.as("thCode"), this.qSalContractDO.cName.as("thName"), this.qSalContractDO.cContact.as("thContact"), this.qSalContractDO.cContactTel.as("thContactTel"), this.qSalContractDO.cAddress.as("thAddress"), this.qSalContractDDO.itemCode, this.qSalContractDDO.itemName, this.qSalContractDDO.itemSpec, this.qSalContractDDO.custItemCode, this.qSalContractDDO.itemBrand, this.qSalContractDDO.suppFlag, this.qSalContractDDO.qty, this.qSalContractDDO.uom, this.qSalContractDDO.netPrice, this.qSalContractDDO.netAmt, this.qSalContractDDO.price, this.qSalContractDDO.amt, this.qSalContractDDO.taxAmt, this.qSalContractDDO.taxRate, this.qSalContractDDO.discRatio, this.qSalContractDDO.discAmt, this.qSalContractDDO.basePrice, this.qSalContractDDO.remark})).from((EntityPath)this.qSalContractDO)).leftJoin((EntityPath)this.qSalContractDDO)).on((Predicate)this.qSalContractDDO.masId.eq(this.qSalContractDO.id))).where(this.where(queryParam));
    }

    public SalContractRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

