/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDtlDO;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDtlDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SaleStatisticsStoreDtlRepoProc
extends BaseRepoProc<SaleStatisticsStoreDtlDO> {
    private static final QSaleStatisticsStoreDtlDO QTY = QSaleStatisticsStoreDtlDO.saleStatisticsStoreDtlDO;
    private static final QSaleStatisticsStoreDO QDO = QSaleStatisticsStoreDO.saleStatisticsStoreDO;
    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String AGENT_EMP = "agentEmp";

    protected SaleStatisticsStoreDtlRepoProc() {
        super((EntityPathBase)QTY);
    }

    public PagingVO<SaleStatisticsStoreDtlRespVO> page(SaleStatisticsStoreDtlQueryVO saleStatisticsStoreDtlPageParam) {
        JPAQuery query = (JPAQuery)this.select(SaleStatisticsStoreDtlRespVO.class).where(this.bulidPredicate(saleStatisticsStoreDtlPageParam));
        saleStatisticsStoreDtlPageParam.setPaging(query);
        saleStatisticsStoreDtlPageParam.fillOrders(query, (EntityPathBase)QTY);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public Long del(List<Long> ids) {
        Long res = this.jpaQueryFactory.update((EntityPath)QTY).set(SaleStatisticsStoreDtlRepoProc.QTY.deleteFlag, (Object)1).where(new Predicate[]{SaleStatisticsStoreDtlRepoProc.QTY.id.in(ids)}).execute();
        return res;
    }

    public SaleStatisticsStoreDtlRespVO get(Long id) {
        SaleStatisticsStoreDtlRespVO saleStatisticsStoreDtlVO = (SaleStatisticsStoreDtlRespVO)((JPAQuery)this.select(SaleStatisticsStoreDtlRespVO.class).where((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.id.eq((Object)id))).fetchOne();
        return saleStatisticsStoreDtlVO;
    }

    public List<SaleStatisticsStoreDtlRespVO> getLevelList(SaleStatisticsStoreDtlQueryVO queryVO) {
        List res = ((JPAQuery)this.select(SaleStatisticsStoreDtlRespVO.class).where(this.bulidLevelList(queryVO))).fetch();
        return res;
    }

    public List<SaleStatisticsStoreDtlRespVO> getQueryDtl(SaleStatisticsStoreDtlQueryVO queryVO) {
        Predicate predicate = this.bulidLevelList(queryVO);
        List<Predicate> predicates = this.dtlWhere(queryVO);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleStatisticsStoreDtlRespVO.class, (Expression[])new Expression[]{SaleStatisticsStoreDtlRepoProc.QDO.id})).from((EntityPath)QTY)).leftJoin((EntityPath)QDO)).on((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.masId.eq(SaleStatisticsStoreDtlRepoProc.QDO.id))).where(ExpressionUtils.allOf(predicates))).where(ExpressionUtils.allOf((Predicate[])new Predicate[]{predicate}));
        jpaQuery.groupBy(SaleStatisticsStoreDtlRepoProc.QDO.id);
        return jpaQuery.fetch();
    }

    public List<SaleStatisticsTeamRespVO> getListByCodes(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<Predicate> predicates = this.dtlWhere(queryVO);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SaleStatisticsTeamRespVO.class, (Expression[])new Expression[]{SaleStatisticsStoreDtlRepoProc.QTY.code.as("agentEmp"), SaleStatisticsStoreDtlRepoProc.QDO.shipQty.sum().as("shipTotalQty")})).from((EntityPath)QTY)).leftJoin((EntityPath)QDO)).on((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.masId.eq(SaleStatisticsStoreDtlRepoProc.QDO.id))).where(ExpressionUtils.allOf(predicates));
        jpaQuery.groupBy((Expression)SaleStatisticsStoreDtlRepoProc.QTY.code);
        return jpaQuery.fetch();
    }

    private List<Predicate> dtlWhere(SaleStatisticsStoreDtlQueryVO queryVO) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!StringUtils.isEmpty((CharSequence)queryVO.getLevel())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.level.eq((Object)queryVO.getLevel()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getMasIds())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.masId.in((Collection)queryVO.getMasIds()));
        }
        if (queryVO.getMasId() != null) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.masId.eq((Object)queryVO.getMasId()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getLevels())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.level.in((Collection)queryVO.getLevels()));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getName())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.name.in((Object[])new String[]{queryVO.getName()}));
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getType())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.type.in((Object[])new String[]{queryVO.getName()}));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getTypes())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.type.in((Collection)queryVO.getTypes()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getCodes())) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.code.in((Collection)queryVO.getCodes()));
        }
        if (queryVO.getUserId() != null) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.userId.eq((Object)queryVO.getUserId()));
        }
        if (queryVO.getDocTimeStart() != null) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QDO.docTime.goe((Comparable)queryVO.getDocTimeStart()));
        }
        if (queryVO.getDocTimeEnd() != null) {
            predicates.add((Predicate)SaleStatisticsStoreDtlRepoProc.QDO.docTime.loe((Comparable)queryVO.getDocTimeEnd()));
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate((String)"DATE_FORMAT({0},'%Y-%m')", (Object[])new Object[]{SaleStatisticsStoreDtlRepoProc.QDO.docTime}).eq((Object)queryVO.getDocMonth());
            predicates.add((Predicate)booleanTemplate);
        }
        return predicates;
    }

    public List<SaleStatisticsStoreDtlRespVO> getMasIds(List<Long> masIds) {
        List res = ((JPAQuery)this.select(SaleStatisticsStoreDtlRespVO.class).where((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.masId.in(masIds))).fetch();
        return res;
    }

    public List<SaleStatisticsStoreDtlRespVO> selectByParam(SaleStatisticsStoreDtlQueryVO queryVO) {
        List<Predicate> predicates = this.dtlWhere(queryVO);
        List res = ((JPAQuery)this.select(SaleStatisticsStoreDtlRespVO.class).where(ExpressionUtils.allOf(predicates))).fetch();
        return res;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{SaleStatisticsStoreDtlRepoProc.QTY.masId, SaleStatisticsStoreDtlRepoProc.QTY.level, SaleStatisticsStoreDtlRepoProc.QTY.code, SaleStatisticsStoreDtlRepoProc.QTY.name, SaleStatisticsStoreDtlRepoProc.QTY.type, SaleStatisticsStoreDtlRepoProc.QTY.userId, SaleStatisticsStoreDtlRepoProc.QTY.id, SaleStatisticsStoreDtlRepoProc.QTY.createTime, SaleStatisticsStoreDtlRepoProc.QTY.remark})).from((EntityPath)QTY);
    }

    private Predicate bulidPredicate(SaleStatisticsStoreDtlQueryVO saleStatisticsStoreDtlPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(null != saleStatisticsStoreDtlPageParam.getMasId(), SaleStatisticsStoreDtlRepoProc.QTY.masId, (Object)saleStatisticsStoreDtlPageParam.getMasId()).andEq(StringUtils.isNotBlank((CharSequence)saleStatisticsStoreDtlPageParam.getLevel()), (SimpleExpression)SaleStatisticsStoreDtlRepoProc.QTY.level, (Object)saleStatisticsStoreDtlPageParam.getLevel()).andEq(StringUtils.isNotBlank((CharSequence)saleStatisticsStoreDtlPageParam.getCode()), (SimpleExpression)SaleStatisticsStoreDtlRepoProc.QTY.code, (Object)saleStatisticsStoreDtlPageParam.getCode()).andEq(StringUtils.isNotBlank((CharSequence)saleStatisticsStoreDtlPageParam.getName()), (SimpleExpression)SaleStatisticsStoreDtlRepoProc.QTY.name, (Object)saleStatisticsStoreDtlPageParam.getName()).andEq(StringUtils.isNotBlank((CharSequence)saleStatisticsStoreDtlPageParam.getType()), (SimpleExpression)SaleStatisticsStoreDtlRepoProc.QTY.type, (Object)saleStatisticsStoreDtlPageParam.getType()).build();
        return predicate;
    }

    private Predicate bulidLevelList(SaleStatisticsStoreDtlQueryVO queryVO) {
        BooleanExpression predicate = QTY.isNotNull().or((Predicate)QTY.isNull());
        if (StringUtils.isNotBlank((CharSequence)queryVO.getCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreDtlRepoProc.QTY.code.like("%" + queryVO.getCode() + "%").or((Predicate)SaleStatisticsStoreDtlRepoProc.QTY.name.like("%" + queryVO.getCode() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)queryVO.getLevel())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SaleStatisticsStoreDtlRepoProc.QTY.level.eq((Object)queryVO.getLevel()));
        }
        return predicate;
    }
}

