/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.service.shop.BipAddressService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipAddressCreateParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipAddressUpdateParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipAddressVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipAddressConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrBankAccRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrQualifyRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrBankAccRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQualifyRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class BipAddressServiceImpl
extends BaseServiceImpl
implements BipAddressService {
    private static final int DELETE_FLAG_1 = 1;
    private static final int DELETE_FLAG_0 = 0;
    private static final int IS_DEFAULT = 1;
    private static final int NOT_DEFAULT = 0;
    private final CrmCustRepoProc crmCustRepoPro;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final BipCustUserBindService bipCustUserBindService;

    @Transactional(rollbackFor={Exception.class})
    public Long createAddress(BipAddressCreateParam param) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        BipAddressUpdateParam bipAddressUpdateParam = convert.creatParamToUpdate(param);
        bipAddressUpdateParam.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode());
        Long id = this.updateAddress(bipAddressUpdateParam);
        ApiResult<OrgAddrDetailsRpcDTO> addrByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(id);
        OrgAddrAddressRpcDTO newAddr = null;
        List addressVos = ((OrgAddrDetailsRpcDTO)addrByAddrNo.getData()).getOrgAddrAddressVos();
        Optional<OrgAddrAddressRpcDTO> first = addressVos.stream().filter(addr -> param.getMobile().equals(addr.getMobile()) && param.getProvince().equals(addr.getProvince()) && param.getCity().equals(addr.getCity()) && param.getCounty().equals(addr.getCounty()) && param.getDetailAddr().equals(addr.getDetailAddr())).findFirst();
        if (!first.isPresent()) {
            throw new BusinessException("\u672a\u627e\u5230\u65b0\u589e\u5730\u5740");
        }
        newAddr = first.get();
        return newAddr.getId();
    }

    public List<OrgAddrAddressRpcSaveParam> convertAddrAddressVos(List<OrgAddrAddressRpcDTO> params) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        LinkedList<OrgAddrAddressRpcSaveParam> saveParams = new LinkedList<OrgAddrAddressRpcSaveParam>();
        for (OrgAddrAddressRpcDTO param : params) {
            OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = convert.orgAddrAddressRpcDTOToOrgAddrAddressRpcSaveParam(param);
            saveParams.add(orgAddrAddressRpcSaveParam);
        }
        return saveParams;
    }

    public List<OrgAddrBankAccRpcSaveParam> convertAddrBankAccVos(List<OrgAddrBankAccRpcDTO> params) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        LinkedList<OrgAddrBankAccRpcSaveParam> saveParams = new LinkedList<OrgAddrBankAccRpcSaveParam>();
        for (OrgAddrBankAccRpcDTO param : params) {
            OrgAddrBankAccRpcSaveParam orgAddrBankAccRpcSaveParam = convert.OrgAddrBankAccRpcDTOToOrgAddrAddressRpcSaveParam(param);
            saveParams.add(orgAddrBankAccRpcSaveParam);
        }
        return saveParams;
    }

    public List<OrgAddrQualifyRpcSaveParam> convertAddrQualifyVos(List<OrgAddrQualifyRpcDTO> params) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        LinkedList<OrgAddrQualifyRpcSaveParam> saveParams = new LinkedList<OrgAddrQualifyRpcSaveParam>();
        for (OrgAddrQualifyRpcDTO param : params) {
            OrgAddrQualifyRpcSaveParam orgAddrQualifyRpcSaveParam = convert.OrgAddrQualifyRpcDTOToOrgOrgAddrQualifyRpcSaveParam(param);
            saveParams.add(orgAddrQualifyRpcSaveParam);
        }
        return saveParams;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long deleteAddressById(Long id) {
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = this.findaddr();
        List orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        List collect = orgAddrAddressVos.stream().filter(org -> !id.equals(org.getId())).collect(Collectors.toList());
        orgAddrDetailsRpcDTO.setOrgAddrAddressVos(collect);
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = convert.rpcDTOToRpcParam(orgAddrDetailsRpcDTO);
        List orgAddrAddressNewVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        List<OrgAddrAddressRpcSaveParam> orgAddrAddressRpcSaveParams = this.convertAddrAddressVos(orgAddrAddressNewVos);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressRpcSaveParams);
        List orgAddrBankAccVos = orgAddrDetailsRpcDTO.getOrgAddrBankAccVos();
        List<OrgAddrBankAccRpcSaveParam> orgAddrBankAccRpcSaveParams = this.convertAddrBankAccVos(orgAddrBankAccVos);
        orgAddrRpcSaveParam.setOrgAddrBankAccSaveParams(orgAddrBankAccRpcSaveParams);
        List orgAddrQualifyVos = orgAddrDetailsRpcDTO.getOrgAddrQualifyVos();
        List<OrgAddrQualifyRpcSaveParam> orgAddrQualifyRpcSaveParams = this.convertAddrQualifyVos(orgAddrQualifyVos);
        orgAddrRpcSaveParam.setOrgAddrQualifySaveParams(orgAddrQualifyRpcSaveParams);
        this.rmiOrgAddrService.orgAddrSaveOrUpdate(orgAddrRpcSaveParam);
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateAddress(BipAddressUpdateParam param) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = this.findaddr();
        if (orgAddrDetailsRpcDTO == null) {
            throw new BusinessException("\u5730\u5740\u8584DTO\u4e3a\u7a7a\u8bf7\u68c0\u67e5!!");
        }
        List<OrgAddrAddressRpcDTO> orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        OrgAddrAddressRpcDTO orgAddrAddressRpcDTO = convert.updateParamToRpcDTO(param);
        ArrayList<OrgAddrAddressRpcDTO> orgAddrAddressRpcDTOS = new ArrayList<OrgAddrAddressRpcDTO>();
        if (orgAddrAddressRpcDTO.getDefaultFlag().booleanValue()) {
            for (OrgAddrAddressRpcDTO orgAddrAddressVo : orgAddrAddressVos) {
                if (orgAddrAddressVo.getDefaultFlag().booleanValue()) {
                    orgAddrAddressVo.setDefaultFlag(Boolean.valueOf(false));
                    orgAddrAddressRpcDTOS.add(orgAddrAddressVo);
                    continue;
                }
                orgAddrAddressRpcDTOS.add(orgAddrAddressVo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)orgAddrAddressVos)) {
            orgAddrAddressRpcDTO.setDefaultFlag(Boolean.valueOf(true));
        }
        if (param.getId() != null) {
            orgAddrAddressVos = orgAddrAddressVos.stream().filter(org -> !param.getId().equals(org.getId())).collect(Collectors.toList());
        }
        orgAddrAddressRpcDTO.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode());
        orgAddrAddressVos.add(orgAddrAddressRpcDTO);
        OrgAddrRpcSaveParam orgAddrRpcSaveParam = convert.rpcDTOToRpcParam(orgAddrDetailsRpcDTO);
        List<OrgAddrAddressRpcSaveParam> orgAddrAddressRpcSaveParams = this.convertAddrAddressVos(orgAddrAddressVos);
        orgAddrRpcSaveParam.setOrgAddrAddressSaveParams(orgAddrAddressRpcSaveParams);
        List orgAddrBankAccVos = orgAddrDetailsRpcDTO.getOrgAddrBankAccVos();
        List<OrgAddrBankAccRpcSaveParam> orgAddrBankAccRpcSaveParams = this.convertAddrBankAccVos(orgAddrBankAccVos);
        orgAddrRpcSaveParam.setOrgAddrBankAccSaveParams(orgAddrBankAccRpcSaveParams);
        List orgAddrQualifyVos = orgAddrDetailsRpcDTO.getOrgAddrQualifyVos();
        List<OrgAddrQualifyRpcSaveParam> orgAddrQualifyRpcSaveParams = this.convertAddrQualifyVos(orgAddrQualifyVos);
        orgAddrRpcSaveParam.setOrgAddrQualifySaveParams(orgAddrQualifyRpcSaveParams);
        ApiResult<Long> apiResult = this.rmiOrgAddrService.orgAddrSaveOrUpdate(orgAddrRpcSaveParam);
        if (apiResult == null) {
            throw new BusinessException("\u66f4\u65b0\u6216\u4fdd\u5b58\u540e\u672a\u8fd4\u56de!!");
        }
        return (Long)apiResult.getData();
    }

    public BipAddressVO findById(Long id) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        orgAddressRpcDtoParam.setIds(Arrays.asList(id));
        List<OrgAddressRpcDTO> addrAddressListByParam = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        if (CollectionUtils.isEmpty(addrAddressListByParam)) {
            return null;
        }
        return convert.addressRpcDTOToVO(addrAddressListByParam.get(0));
    }

    public List<BipAddressVO> findByAccountId() {
        List orgAddrAddressVos;
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = this.findaddr();
        if (orgAddrDetailsRpcDTO != null && !CollectionUtils.isEmpty((Collection)(orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos()))) {
            List collect = orgAddrAddressVos.stream().filter(org -> UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode().equals(org.getAddressType())).collect(Collectors.toList());
            ArrayList<BipAddressVO> bipAddressVOS = new ArrayList<BipAddressVO>();
            for (int i = 0; i < collect.size(); ++i) {
                if (!((OrgAddrAddressRpcDTO)collect.get(i)).getDefaultFlag().booleanValue()) continue;
                OrgAddrAddressRpcDTO defaultBipAddress = (OrgAddrAddressRpcDTO)collect.get(i);
                collect.remove(i);
                collect.add(0, defaultBipAddress);
            }
            for (OrgAddrAddressRpcDTO orgAddrAddressRpcDTO : collect) {
                BipAddressVO bipAddressVO = convert.rpcDTOToVO(orgAddrAddressRpcDTO);
                bipAddressVOS.add(bipAddressVO);
            }
            return bipAddressVOS;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateDefaultById(Long id) {
        BipAddressConvert convert = BipAddressConvert.INSTANCE;
        OrgAddrDetailsRpcDTO orgAddrDetailsRpcDTO = this.findaddr();
        List orgAddrAddressVos = orgAddrDetailsRpcDTO.getOrgAddrAddressVos();
        List collect = orgAddrAddressVos.stream().filter(org -> id.equals(org.getId())).collect(Collectors.toList());
        OrgAddrAddressRpcDTO orgAddrAddressRpcDTO = (OrgAddrAddressRpcDTO)collect.get(0);
        BipAddressUpdateParam bipAddressUpdateParam = convert.rpcDTOToUpdateParam(orgAddrAddressRpcDTO);
        bipAddressUpdateParam.setDefaultFlag(Boolean.valueOf(true));
        return this.updateAddress(bipAddressUpdateParam);
    }

    private static CurrentUserDTO checkUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        return currentUser;
    }

    @Transactional(rollbackFor={Exception.class})
    public OrgAddrDetailsRpcDTO findaddr() {
        ApiResult<OrgAddrDetailsRpcDTO> apiResult;
        CurrentUserDTO currentUser = BipAddressServiceImpl.checkUser();
        Long custAccountId = currentUser.getUserId();
        Long custId = (Long)this.bipCustUserBindService.getCustIdByUserId(custAccountId).getData();
        if (custId == null) {
            throw new BusinessException("\u6e38\u5ba2\u767b\u5f55 \u8bf7\u5148\u7ed1\u5b9a\u5ba2\u6237\u8eab\u4efd");
        }
        Long addrNo = this.crmCustRepoPro.getAddrNo(custId);
        if (addrNo == null) {
            OrgAddrRpcSaveParam orgAddrRpcSaveParam = new OrgAddrRpcSaveParam();
            orgAddrRpcSaveParam.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
            orgAddrRpcSaveParam.setAddrName(currentUser.getDetail().getUsername());
            ApiResult<Long> addrNoNew = this.rmiOrgAddrService.orgAddrSaveOrUpdate(orgAddrRpcSaveParam);
            Boolean aBoolean = this.crmCustRepoPro.existsCode(null, custAccountId);
            if (!aBoolean.booleanValue()) {
                this.crmCustRepoPro.updateAddrNo(custAccountId, (Long)addrNoNew.getData());
            }
        }
        if ((apiResult = this.rmiOrgAddrService.findAddrByAddrNo(addrNo)).getData() == null) {
            throw new BusinessException("\u5730\u5740\u8584DTO\u4e3a\u7a7a\u8bf7\u68c0\u67e5!!");
        }
        return (OrgAddrDetailsRpcDTO)apiResult.getData();
    }

    public BipAddressServiceImpl(CrmCustRepoProc crmCustRepoPro, RmiOrgAddrService rmiOrgAddrService, BipCustUserBindService bipCustUserBindService) {
        this.crmCustRepoPro = crmCustRepoPro;
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.bipCustUserBindService = bipCustUserBindService;
    }
}

