/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.workflow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.core.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceApproveParam;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QPriSalePriceAlterDO;
import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepo;
import com.elitesland.yst.production.sale.repo.PriSalePriceAlterRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserFlowRoleRpcService;
import com.elitesland.yst.production.sale.workflow.service.PriSalePriceAlterProcessService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PriSalePriceAlterProcessServiceImpl
implements PriSalePriceAlterProcessService {
    private static final Logger log = LoggerFactory.getLogger(PriSalePriceAlterProcessServiceImpl.class);
    private final JPAQueryFactory jpaQueryFactory;
    private final PriSalePriceAlterRepo priSalePriceAlterRepo;
    private final PriSalePriceAlterRepoProc priSalePriceAlterRepoProc;
    private final RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long id, ProcInstStatus procInstStatus) {
        Optional priSalePriceAlterDO = this.priSalePriceAlterRepo.findById(id);
        if (!priSalePriceAlterDO.isPresent()) {
            throw new BusinessException("\u5355\u636e(id:" + id + ")\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5ba1\u6279");
        }
        QPriSalePriceAlterDO qPriSalePriceAlterDO = QPriSalePriceAlterDO.priSalePriceAlterDO;
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qPriSalePriceAlterDO).set(qPriSalePriceAlterDO.procInstStatus, (Object)procInstStatus).where(new Predicate[]{qPriSalePriceAlterDO.id.eq((Object)id)});
        switch (procInstStatus) {
            case NOTSUBMIT: {
                jpaUpdateClause.set((Path)qPriSalePriceAlterDO.docStatus, (Object)UdcEnum.PRI_APPLY_STATUS_DR.getValueCode());
                break;
            }
            case INTERRUPT: {
                jpaUpdateClause.set((Path)qPriSalePriceAlterDO.docStatus, (Object)UdcEnum.PRI_APPLY_STATUS_DR.getValueCode());
                this.priSalePriceAlterRepo.updateProcInstId(id, null);
                break;
            }
            case REJECTED: {
                jpaUpdateClause.set((Path)qPriSalePriceAlterDO.docStatus, (Object)UdcEnum.PRI_APPLY_STATUS_RJ.getValueCode());
                break;
            }
            case INVALID: {
                jpaUpdateClause.set((Path)qPriSalePriceAlterDO.docStatus, (Object)UdcEnum.PRI_APPLY_STATUS_CL.getValueCode());
                break;
            }
            case APPROVING: {
                jpaUpdateClause.set((Path)qPriSalePriceAlterDO.docStatus, (Object)UdcEnum.PRI_APPLY_STATUS_APPING.getValueCode());
                break;
            }
            case APPROVED: {
                jpaUpdateClause.set((Path)qPriSalePriceAlterDO.docStatus, (Object)UdcEnum.PRI_APPLY_STATUS_CF.getValueCode()).set(qPriSalePriceAlterDO.approvedTime, (Object)LocalDateTime.now());
            }
        }
        jpaUpdateClause.execute();
        if (procInstStatus.equals((Object)ProcInstStatus.APPROVED)) {
            PriSalePriceApproveParam priSalePriceApproveParam = new PriSalePriceApproveParam();
            priSalePriceApproveParam.setDocId(Long.valueOf(id));
            priSalePriceApproveParam.setApprStatus(UdcEnum.COM_APPR_STATUS_APPROVED.getValueCode());
        }
    }

    @Override
    public List<String> taskAssignee(Long businessKey, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4:{},\u5165\u53c2:{}", (Object)LocalDateTime.now(), (Object)businessKey);
        Long ouId = this.priSalePriceAlterRepoProc.getOuIdById((long)businessKey);
        try {
            SysUserIdFlowRoleRpcParam sysUserIdFlowRoleRpcParam = new SysUserIdFlowRoleRpcParam();
            sysUserIdFlowRoleRpcParam.setOuIds(Collections.singletonList(ouId));
            List<String> flowRoleCodes = Arrays.asList(customParams.split(","));
            sysUserIdFlowRoleRpcParam.setFlowRoleCodes(flowRoleCodes);
            log.info("\u516c\u53f8\u89d2\u8272\u67e5\u8be2\u4fe1\u606f" + sysUserIdFlowRoleRpcParam);
            List userIdsByFlowRoles = this.rmiSysUserFlowRoleRpcService.findUserIdsByFlowRoles(sysUserIdFlowRoleRpcParam).stream().filter(Objects::nonNull).collect(Collectors.toList());
            List userIds = userIdsByFlowRoles.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIds)) {
                return CollUtil.newArrayList(userIds);
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u652f\u6491\u57df\u67e5\u8be2\u5ba1\u6279\u89d2\u8272\u5bf9\u5e94\u5ba1\u6279\u4eba\u5f02\u5e38" + e, (Throwable)e);
        }
        return null;
    }

    public PriSalePriceAlterProcessServiceImpl(JPAQueryFactory jpaQueryFactory, PriSalePriceAlterRepo priSalePriceAlterRepo, PriSalePriceAlterRepoProc priSalePriceAlterRepoProc, RmiSysUserFlowRoleRpcService rmiSysUserFlowRoleRpcService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.priSalePriceAlterRepo = priSalePriceAlterRepo;
        this.priSalePriceAlterRepoProc = priSalePriceAlterRepoProc;
        this.rmiSysUserFlowRoleRpcService = rmiSysUserFlowRoleRpcService;
    }
}

