package com.elitesland.yst.production.sale.cache.key;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.yst.production.sale.api.service.shop.BipCustUserBindService;
import com.elitesland.yst.production.sale.common.constant.ConstantsCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/09
 */
@Component(ConstantsCache.KEY_GENERATOR_CURRENT_USER_CUST_OU)
public class CurrentUserCustOuIdKeyGenerator implements KeyGenerator {

    @Autowired
    private BipCustUserBindService bipCustUserBindService;


    @Autowired
    private
    SysUserRpcService sysUserRpcService;

    @Override
    public Object generate(@NonNull Object target, @NonNull Method method, @NonNull Object... params) {
        if (ArrayUtil.isNotEmpty(params)) {
            for (Object p : params) {
                if (p instanceof Long && p != null) {
                    return p;
                }
            }
        }
        var user = sysUserRpcService.current();
        if (user == null) {
            return -1;
        }

//        var custResult = bipCustUserBindService.getCustOfUserBind(user.getUser().getId());
//        if (custResult.getData() != null && custResult.getData().getOuId() != null) {
//            return custResult.getData().getOuId();
//        }
        return user.getOuId();
//        return -1;
    }
}
