package com.elitesland.yst.production.sale.controller.crm;

import com.elitesland.yst.production.sale.api.service.CrmCustOuService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustOuParamVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuParamSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/27 12:18
 */
@RestController
@RequestMapping(value = "/crm/custOu", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "客户信息")
@ApiSupport(author = "zhao.zhi.hao", order = 1)
@Slf4j
public class CrmCustOuController extends BaseController {

    @Autowired
    private CrmCustOuService crmCustOuService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询拓展公司列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<List<CrmCustOuSaveVO>> search(@RequestBody CrmCustOuParamVO searchParam) {
        return ApiResult.ok(crmCustOuService.search(searchParam));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存数据")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> save(@RequestBody CrmCustOuParamSaveVO saveVo) {
        return crmCustOuService.save(saveVo);
    }

    @DeleteMapping(value = "/delete/{id}")
    @ApiOperation(value = "删除数据")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> deleteCustAndOu(@PathVariable Long id) {
        return ApiResult.ok(crmCustOuService.deleteById(id));
    }

}
