package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipFavoritesService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFavoritesQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFavoritesSaveParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFavoritesRespVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/30 09:34
 */
@RestController
@RequestMapping("/bip/favorites")
@Api(value = "我的收藏", tags = {"我的收藏"})
@RequiredArgsConstructor
public class BipFavoritesController {

    @Autowired
    private BipFavoritesService bipFavoritesService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询我的列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipFavoritesRespVO>> search(@RequestBody BipFavoritesQueryParamVO bipFavoritesQueryParamVO) {
        return ApiResult.ok(bipFavoritesService.search(bipFavoritesQueryParamVO));
    }

    @PostMapping(value = "/collect")
    @ApiOperation(value = "收藏/取消商品")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> collectBipCompany(@RequestBody BipFavoritesSaveParamVO bipFavoritesSaveParamVO) {
        bipFavoritesService.collectBipFavorites(bipFavoritesSaveParamVO);
        return ApiResult.ok();
    }

    @GetMapping(value = "/ifCollected/{itemId}")
    @ApiOperation(value = "商品是否被收藏")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> ifCollected(@PathVariable Long itemId){
       return ApiResult.ok(bipFavoritesService.ifCollected(itemId));
    }
}
