package a.entity;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.FileInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.FileInfoSaveVO;
import com.elitesland.yst.production.sale.entity.FileInfoDO;
import com.elitesland.yst.production.sale.service.FileInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 文件信息Service
 */
@RestController
@RequestMapping("/fileInfo")
@RequiredArgsConstructor
@Api(value = "文件信息", tags = {"文件信息"})
public class FileInfoController{

    private final FileInfoService fileInfoService;

    @GetMapping("get/{id}")
    @ApiOperation("详情-文件信息")
    public ApiResult<FileInfoRespVO> get(@PathVariable Long id) {
        FileInfoRespVO res = fileInfoService.get(id);
        return ApiResult.ok(res);
    }

    @PostMapping("save")
    @ApiOperation("新增-文件信息")
    public ApiResult<Long> save(@RequestBody FileInfoSaveVO fileInfoParam) {
        FileInfoDO res = fileInfoService.save(fileInfoParam);
        return ApiResult.ok(res.getId());
    }

    @PostMapping("update")
    @ApiOperation("修改-文件信息")
    public ApiResult<Long> update(@RequestBody FileInfoSaveVO fileInfoParam) {
        FileInfoDO res = fileInfoService.update(fileInfoParam);
        return ApiResult.ok(res.getId());
    }

    @PostMapping("del")
    @ApiOperation("删除-文件信息")
    public Long del(@RequestBody List<Long> ids) {
        Long res = fileInfoService.del(ids);
        return res;
    }

    @PostMapping("page")
    @ApiOperation("分页查询-文件信息")
    public ApiResult<PagingVO<FileInfoRespVO>> page(@RequestBody FileInfoQueryVO fileInfoPageParam) {
        PagingVO<FileInfoRespVO> res = fileInfoService.page(fileInfoPageParam);
        return ApiResult.ok(res);
    }
}