package com.elitesland.yst.production.sale.convert.shop;

import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/24/10:35
 * @Description:
 */
@Mapper(config = CustomMapperConfig.class,nullValueCheckStrategy = NullValueCheckStrategy.ALWAYS,
        nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface BipCartItemCovert {
    BipCartItemCovert INSTANCE = Mappers.getMapper(BipCartItemCovert.class);

    @Mappings({
            @Mapping(source = "itemId", target = "relateItemId"),
            @Mapping(source = "id", target = "itemId"),
            @Mapping(target = "id",ignore = true)
    })
    BipCartItemRespVO bipItemDetailRespVOToBipCartItemVo(BipItemDetailRespVO bipItemDetailRespVO, @MappingTarget BipCartItemRespVO bipCartItemRespVO);

    BipCartItemRespVO BipItemSkuRespVOToBipCartItemVo(BipItemSkuRespVO bipItemSkuRespVO, @MappingTarget BipCartItemRespVO bipCartItemRespVO);

    BipCartItemRespVO copy(BipCartItemRespVO sourceBipCartItemRespVO);
}
