package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/03/16:53
 * @Description:
 */

@Entity
@Table(name = "bip_coupon_cust", indexes = {
        @Index(name = "coupon_code", columnList = "coupon_code")
})
@org.hibernate.annotations.Table(appliesTo = "bip_coupon_cust", comment = "优惠券客户关联表")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipCouponCustDo extends BaseModel implements Serializable {

    @Column(name = "coupon_id", columnDefinition = "bigInt(20) not null  comment '优惠券id'", nullable = false)
    private Long couponId;


    @Column(name = "coupon_code", columnDefinition = "varchar(20)    comment '优惠券编码'", nullable = false)
    private String couponCode;

    @Column(name = "ou_id", columnDefinition = "varchar(20)    comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(20)    comment '公司编码'")
    private String ouCode;

    @Column(name = "cust_id", columnDefinition = "bigInt(20) comment '客户ID'")
    private Long custId;

    @Column(name = "cust_name", columnDefinition = "varchar(256)    comment '客户名称'")
    private String custName;

    @Column(name = "cust_code", columnDefinition = "varchar(64)    comment '客户编码'")
    private String custCode;


    @Column(name = "ou_name", columnDefinition = "varchar(20)    comment '公司名称'")
    private String ouName;

    @Column(name = "user_id", columnDefinition = "varchar(20)    comment '用户id'")
    private Long userId;


    @Column(name = "user_name", columnDefinition = "varchar(20)    comment '用户名'")
    private String userName;

    @Column(name = "use_status", columnDefinition = "varchar(20)    comment '优惠券使用状态'")
    private String useStatus;

    @Column(name = "valid_stime", columnDefinition = "datetime    comment '创建时间'")
    private LocalDateTime validStime;

    @Column(name = "valid_etime", columnDefinition = "datetime    comment '创建时间'")
    private LocalDateTime validEtime;

    //优惠券类型 满减 立减
    @Column(name = "type", columnDefinition = "varchar(128) not null  comment '优惠券类型 0满减 1立减'")
    private String type;

    // 优惠券使用类型，匹配品类  匹配商品
    @Column(name = "match_type",columnDefinition = "varchar(32)   comment '优惠券使用类型，匹配品类  匹配商品'")
    private String matchType;

    @Column(name="limit_amt",columnDefinition = "decimal(20, 2)   comment '满减最低金额'")
    private BigDecimal limitAmt;

    @Column(name="free_amt",columnDefinition = "decimal(20, 2)   comment '优惠金额'")
    private BigDecimal freeAmt;

    @Column(name = "detail_info",columnDefinition = "varchar(300)   comment '详细信息'")
    private String  detailInfo;


}
