package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/15:16
 */

@Entity
@Table(name = "bip_help_center")
@org.hibernate.annotations.Table(appliesTo = "bip_help_center", comment = "帮助中心")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipHelpCenterDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 5075018104705219079L;

    @Column(name = "file_code", columnDefinition = "varchar(20)   comment '文档编码'")
    private String fileCode;


    @Column(name = "title", columnDefinition = "varchar(64)   comment '标题'")
    private String title;

    @Column(name = "status", columnDefinition = "varchar(20)   comment '状态--是否启用'")
    private String status;

    @Column(name = "context", columnDefinition = "varchar(1024)   comment '内容'")
    private String context;

    @Column(name = "context_struct", columnDefinition = "varchar(1024)   comment '内容说明'")
    private String contestStruct;
}
