package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-09-06 11:15
 */

@Entity
@Table(name = "bip_inv")
@org.hibernate.annotations.Table(appliesTo = "bip_inv", comment = "发票明细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipInvDO extends BaseModel implements Serializable {


    private static final long serialVersionUID = 3198750723472583848L;
    @Column(name = "order_id", columnDefinition = "bigInt(20) comment '订单id'")
    private Long orderId;
    @Column(name = "doc_no", columnDefinition = "varchar(20) comment '订单单号'")
    private String docNo;

    @Column(name = "inv_no", columnDefinition = "varchar(32)   comment '发票代码'")
    private String invNo;

    @Column(name = "inv_code", columnDefinition = "varchar(32)   comment '发票编码'")
    private String invCode;

    @Column(name = "inv_type", columnDefinition = "varchar(32)   comment '发票类型-- 个人事业单位||企业'")
    private String invType;

    @Column(name = "inv_title", columnDefinition = "varchar(32)   comment '发票抬头'")
    private String invTitle;

    @Column(name = "inv_title_type", columnDefinition = "varchar(32)   comment '抬头类型'")
    private String invTitleType;

    @Column(name = "tax_no", columnDefinition = "varchar(32)   comment '税号'")
    private String taxNo;

    @Column(name = "bank", columnDefinition = "varchar(40)   comment '开户银行'")
    private String bank;

    @Column(name = "company_address", columnDefinition = "varchar(32)   comment '企业地址'")
    private String companyAddress;

    @Column(name = "company_tel", columnDefinition = "varchar(32)   comment '企业电话'")
    private String companyTel;

    @Column(name = "bank_account", columnDefinition = "varchar(32)   comment '银行账户'")
    private String bankAccount;

    @Column(name = "owned_company", columnDefinition = "varchar(32)   comment '所属公司'")
    private String ownedCompany;

    @Column(name = "total_amt", columnDefinition = "decimal(20,2)   comment '开票金额'")
    private BigDecimal totalAmt;

    @Column(name = "cust_account_id", columnDefinition = "bigInt(20) comment '用户id'")
    private Long custAccountId;

    @Column(name = "orde_time", columnDefinition = "datetime comment '下单时间'")
    private LocalDateTime orderTime;

    @Column(name = "file_code", columnDefinition = "varchar(1024) comment '发票文件编码'")
    private String fileCode;
    @Column(name = "inv_serial_num", columnDefinition = "varchar(32) comment '发票流水号'")
    private String invSerialNum;
    @Column(name = "status", columnDefinition = "varchar(32) comment '发票状态'")
    private String status;
    @Column(name = "is_red", columnDefinition = "varchar(32) comment '是否被红冲 1是 0否'")
    private String isRed;
    @Column(name = "red_inv_serial_num", columnDefinition = "varchar(32) comment '红冲发票流水号'")
    private String redInvSerialNum;
    @Column(name = "inv_multiple_tax", columnDefinition = "bigInt(32) comment '是否进行税率分组'")
    private Integer invMultipleTax;

}
