package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/16:07
 * @Description:
 */

@Entity
@Table(name = "bip_order", indexes = {
        @Index(name = "idx_bip_order_cust_account_id", columnList = "cust_account_id")
})
@org.hibernate.annotations.Table(appliesTo = "bip_order", comment = "订单表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")

public class BipOrderDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 8388823950023772824L;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;


    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigInt(20) comment '组织id'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '组织编码'")
    private String buCode;


    @Column(name = "bu_name", columnDefinition = "varchar(32) comment '组织名称'")
    private String buName;



    @Column(name = "doc_no", columnDefinition = "varchar(32) comment '订单单号'")
    private String docNo;

    @Column(name = "back_doc_no", columnDefinition = "varchar(32) comment '退货单单号'")
    private String backDocNo;

    @Column(name = "cust_account_id", columnDefinition = "bigInt(20) comment '下单人id'")
    private Long custAccountId;

    @Column(name = "cust_id", columnDefinition = "bigInt(20) comment '下单客户id'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(32) comment '下单客户编码'")
    private String custCode;

    @Column(name = "cust_code2", columnDefinition = "varchar(32) comment '下单客户编码'")
    private String custCode2;


    @Column(name = "cust_name", columnDefinition = "varchar(32) comment '下单客户姓名'")
    private String custName;



    @Column(name = "pay_amt", columnDefinition = "decimal(20,2) default 0 comment '应付金额'")
    private BigDecimal payAmt;

    @Column(name = "pay_done_amt", columnDefinition = "decimal(20,2) default 0 comment '已付金额'")
    private BigDecimal payDoneAmt;

    @Column(name = "total_amt", columnDefinition = "decimal(20,2) default 0 comment '总金额'")
    private BigDecimal totalAmt;


    @Column(name = "item_amt", columnDefinition = "decimal(20,2) default 0 comment '商品合计金额'")
    private BigDecimal itemAmt;

    @Column(name = "fare_amt", columnDefinition = "decimal(20,2) default 0 comment '运费金额'")
    private BigDecimal fareAmt;

    @Column(name = "fare_final_amt", columnDefinition = "decimal(20,2) default 0 comment '运费最终金额'")
    private BigDecimal fareFinalAmt;

    @Column(name = "coupon_amt", columnDefinition = "decimal(20,2) default 0 comment '优惠券金额'")
    private BigDecimal couponAmt;

    @Column(name = "discount_amt", columnDefinition = "decimal(20,2) default 0 comment '折扣金额'")
    private BigDecimal discountAmt;

    @Column(name = "score_amt", columnDefinition = "decimal(20,2) default 0 comment '积分抵扣金额'")
    private BigDecimal scoreAmt;

    @Column(name = "order_time", columnDefinition = "datetime comment '下单时间'")
    private LocalDateTime orderTime;

    @Column(name = "pay_method_id", columnDefinition = "varchar(20) comment '支付方式id'")
    private String payMethodId;

    @Column(name = "pay_method_name", columnDefinition = "varchar(32) comment '支付方式名称'")
    private String payMethodName;

    @Column(name = "status", columnDefinition = "varchar(32) comment '订单状态'")
    private String status;

    @Column(name = "pay_status", columnDefinition = "varchar(32) comment '支付状态'")
    private String payStatus;

    @Column(name = "pay_time", columnDefinition = "datetime comment '支付时间'")
    private LocalDateTime payTime;


    @Column(name = "pay_record_id", columnDefinition = "varchar(20) comment '支付记录id'")
    private String payRecordId;

    @Column(name = "invoice", columnDefinition = "tinyint(1) comment '是否开票'")
    private Boolean invoice;

    @Column(name = "invoice_id", columnDefinition = "varchar(20) comment '发票id'")
    private Long invoiceId;

    @Column(name = "delive_id", columnDefinition = "varchar(20) comment '发货id'")
    private Long deliveId;

    @Column(name = "delive_time", columnDefinition = "datetime comment '发货时间'")
    private LocalDateTime deliveTime;


    @Column(name = "finish_time", columnDefinition = "datetime comment '订单完成时间'")
    private LocalDateTime finishTime;

    @Column(name = "is_eval", columnDefinition = "tinyint(1) default 0 comment '是否已评价 0 未评价 1 已评价'")
    private Boolean isEval;

    @Column(name = "eval_time", columnDefinition = "datetime comment '订单评价时间'")
    private LocalDateTime evalTime;

    @Column(name = "delive_status", columnDefinition = "varchar(32) comment '发货状态'")
    private String deliveStatus;

    @Column(name = "demand_time", columnDefinition = "datetime comment '要求发货日期'")
    private LocalDateTime demandTime;

    @Column(name = "sign_time", columnDefinition = "datetime comment '签收日期'")
    private LocalDateTime signTime;

    @Column(name = "agent_emp_id", columnDefinition = "bigInt(20) comment '业务员员工id'")
    private Long agentEmpId;


    @Column(name = "agent_name", columnDefinition = "varchar(64)  comment '业务员员工名字'")
    private String agentName;

    @Column(name = "agent_code", columnDefinition = "varchar(64) comment '业务员编码'")
    private String agentCode ;

    @Column(name = "address_id", columnDefinition = "bigInt(20) comment '收货地址id'")
    private Long adressId ;

    @Column(name = "free_fare", columnDefinition = "tinyint(1) default 0  comment '是否免运费'")
    private Boolean freeFare;

    @Column(name = "coupon_id", columnDefinition = "varchar(1024) comment '优惠券id'")
    private Long couponId;
    @Column(name = "coupon_code", columnDefinition = "varchar(32) comment '优惠券编码'")
    private String couponCode;

    @Column(name = "txsn", columnDefinition = "varchar(32) comment '交易流水号'")
    private String txsn;



    @Column(name = "logic_eval_score", columnDefinition = "varchar(10) comment '物流评分'")
    private String logicEvalScore;

    @Column(name = "server_eval_score", columnDefinition = "varchar(32) comment '服务评分'")
    private String serverEvalScore;

    @Column(name = "off_flag", columnDefinition = "int(4) default 0 comment '是否红冲'")
    private Integer offFlag;


    @Column(name = "auto_sign_flag",columnDefinition = "tinyint(1) default 0  comment '是否自动签收成功'")
    private Boolean autoSignFlag;

    @Column(name = "sync_oms",columnDefinition = "tinyint(1) default 0  comment '是否自同步'")
    private Boolean syncOms;

    @Column(name = "city", columnDefinition = "varchar(256) comment '市代码'")
    private String city;

    @Column(name = "city_name", columnDefinition = "varchar(256) comment '市'")
    private String cityName;

    @Column(name = "cont_person", columnDefinition = "varchar(256) comment '联系人'")
    private String contPerson;

    @Column(name = "county", columnDefinition = "varchar(256) comment '区代码'")
    private String county;

    @Column(name = "county_name", columnDefinition = "varchar(256) comment '区'")
    private String countyName;

    @Column(name = "default_flag", columnDefinition = "tinyint(1) comment '是否默认：1是，0否'")
    private Boolean defaultFlag;

    @Column(name = "detail_addr", columnDefinition = "varchar(256) comment '详细地址'")
    private String detailAddr;

    @Column(name = "mobile", columnDefinition = "varchar(256) comment '电话'")
    private String mobile;

    @Column(name = "province", columnDefinition = "varchar(256) comment '省代码'")
    private String province;

    @Column(name = "province_name", columnDefinition = "varchar(256) comment '省'")
    private String provinceName;

    @Column(name = "is_send", columnDefinition = "tinyint(1) default 0 comment '是否发货'")
    private Boolean isSend;

    @Column(name = "is_create_receipt", columnDefinition = "tinyint(1) default 0 comment '是否生成收款单'")
    private Boolean isCreateReceipt;

}
