package com.elitesland.yst.production.sale.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * b2b小程序首页菜单配置
 */
@Entity
@Table(name = "bus_first_menu_conf")
@org.hibernate.annotations.Table(appliesTo = "bus_first_menu_conf", comment = "b2b销售附件信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BusFirstMenuConfDO extends BaseModel implements Serializable {

    @ApiModelProperty("菜单编码")
    @Column(name = "menu_no", columnDefinition = "varchar(64)  comment '菜单编码'")
    private String menuNo;

    @ApiModelProperty("菜单名称")
    @Column(name = "menu_name", columnDefinition = "varchar(64)  comment '菜单名称'")
    private String menuName;


    @ApiModelProperty("图标")
    @Column(name = "img_sign", columnDefinition = "varchar(256)  comment '图标'")
    private String imgSign;


    @ApiModelProperty("排序")
    @Column(name = "menu_sort", columnDefinition = "int(10)  comment '排序'")
    private Integer menuSort;


    @ApiModelProperty("所属公司")
    @Column(name = "ou_id", columnDefinition = "bigint(18)  comment '所属公司'")
    private Long ouId;


    @ApiModelProperty("所属公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(256)  comment '所属公司'")
    private String ouName;



    @ApiModelProperty("状态")
    @Column(name = "status", columnDefinition = "varchar(32)  comment '状态'")
    private String status;

}
