package com.elitesland.yst.production.sale.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity(name="custBelongOuDO")
@Table(name = "cust_belong_ou")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "cust_belong_ou", comment = "客户归属公司")
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Data
@ApiModel(value = "cust_belong_ou", description = "客户归属公司")
public class CustBelongOuDO extends BaseModel {

    @Column(name = "cust_code", columnDefinition = "varchar(255) comment '客户编码'")
    private String custCode;

    @Column(name = "ou_id", columnDefinition = "bigint(20) comment '所属公司ID'")
    private Long ouId;

    @Column(name = "ou_name", columnDefinition = "varchar(255) comment '所属公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(20) comment '所属buid'")
    private Long buId;

    @Column(name = "bu_name", columnDefinition = "varchar(255) comment '所属bu名称'")
    private String buName;

    @Column(name = "channel_type", columnDefinition = "varchar(255) comment '销售渠道'") // saleChannel
    private String channelType;

    @Column(name = "payment_term", columnDefinition = "varchar(255) comment '付款条款 udc值，K3传入'")
    private String paymentTerm;

    @Column(name = "status", columnDefinition = "varchar(255) comment '状态 0：启用，1禁用'")
    private String status;

}
