package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/21 18:26
 */
@Entity
@Table(name = "de_account_role", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "de_account_role", comment = "账户角色表")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class DeAccountRoleDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 7879600247310770197L;

    @ApiModelProperty("角色id")
    @Column(name = "role_id", columnDefinition = "bigint(20) comment '角色id'")
    private Long roleId;

    @ApiModelProperty("用户id")
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;

    @ApiModelProperty("角色编码")
    @Column(name = "role_code", columnDefinition = "varchar(64)   comment '角色编码'")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @Column(name = "role_name", columnDefinition = "varchar(128)   comment '角色名称'")
    private String roleName;

    @ApiModelProperty("经销商类型")
    @Column(name = "dealer_type", columnDefinition = "varchar(64)   comment '经销商类型'")
    private String dealerType;

    @ApiModelProperty("业务类型")
    @Column(name = "business_type", columnDefinition = "varchar(64)   comment '业务类型'")
    private String businessType;

    @ApiModelProperty("是否是子角色")
    @Column(name = "son_role_flag", columnDefinition = "int(1)   comment '是否是子角色'")
    private Boolean sonRoleFlag ;
}
