package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitesland.yst.production.support.provider.constant.SupportBusinessObjectConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 *  销售支持 - 价格
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 9:45 上午
 */
@Entity
@Table(name = "pri_sale_price", indexes = {
        @Index(name = "idx_ou_id", columnList = "ou_id"),
        @Index(name = "idx_item_id", columnList = "item_id")
})
@org.hibernate.annotations.Table(appliesTo = "pri_sale_price", comment = "品项销售价格")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class PriSalePriceDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -6064717561940898739L;

    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU)
    @ApiModelProperty(value = "公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20) default null  comment '公司ID'")
    private Long ouId;

    @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_ORG)
    @ApiModelProperty(value = "组织ID")
    @Column(name = "bu_id", columnDefinition = "bigint(20) default null  comment '组织ID'")
    private Long buId;

    //@BusinessParam(relatedBusinessObject = InvBusinessObjectConstants.INV_DESPATCH_CONFIG, relatedField = "des_code")
    @BusinessParam(relatedBusinessObject = BusinessObjectConstant.SYS_ORG, relatedField = "code")
    @ApiModelProperty("限定1")
    @Column(name = "deter1", columnDefinition = "varchar(40) comment '限定1'")
    private String deter1;

    @ApiModelProperty("限定2")
    @Column(name = "deter2", columnDefinition = "varchar(40) comment '限定2'")
    private String deter2;

    @ApiModelProperty("限定3")
    @Column(name = "deter3", columnDefinition = "varchar(40) comment '限定3'")
    private String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40) comment '限定4'")
    private String deter4;

    @BusinessParam(relatedBusinessObject = SupportBusinessObjectConstants.SUPPORT_OU, relatedField = "ou_code")
    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40) comment '限定5'")
    private String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40) comment '限定6'")
    private String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40) comment '限定7'")
    private String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40) comment '限定8'")
    private String deter8;

    @ApiModelProperty("库位")
    @Column(name = "wh_loc", columnDefinition = "varchar(40) comment '库位'")
    private String whLoc;

    @ApiModelProperty("货位")
    @Column(name = "wh_posi", columnDefinition = "varchar(40) comment '货位'")
    private String whPosi;

    @ApiModelProperty("批号")
    @Column(name = "lot_no", columnDefinition = "varchar(100) comment '批号'")
    private String lotNo;

    @ApiModelProperty(value = "价格类型")
    @Column(name = "price_type", columnDefinition = "varchar(40) comment '价格类型 [UDC]PRI:SALE_PRICE_TYPE'")
    private String priceType;

    @ApiModelProperty(value = "价格类型2")
    @Column(name = "price_type2", columnDefinition = "varchar(40) comment '价格类型2'")
    private String priceType2;

    @ApiModelProperty(value = "价格类型3")
    @Column(name = "price_type3", columnDefinition = "varchar(40) comment '价格类型3'")
    private String priceType3;

    @ApiModelProperty(value = "商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(20) default null  comment '商品ID'")
    private Long itemId;

    @ApiModelProperty(value = "商品编号")
    @Column(name = "item_code", columnDefinition = "varchar(40) default null  comment '商品编号'")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称'")
    private String itemName;

    @ApiModelProperty(value = "商品名称2")
    @Column(name = "item_name2", columnDefinition = "varchar(100) default null comment '商品名称2'")
    private String itemName2;

    @ApiModelProperty(value = "商品规格")
    @Column(name = "item_spec", columnDefinition = "varchar(255) default null comment '商品规格'")
    private String itemSpec;

    @ApiModelProperty(value = "SPU ID")
    @Column(name = "spu_id", columnDefinition = "bigint(20) default null comment 'SPU ID'")
    private Long spuId;

    @ApiModelProperty(value = "SPU CODE")
    @Column(name = "spu_code", columnDefinition = "varchar(40) default null comment 'SPU CODE'")
    private String spuCode;

    @ApiModelProperty(value = "SPU名称")
    @Column(name = "spu_name", columnDefinition = "varchar(100) default null comment 'SPU名称'")
    private String spuName;

    @ApiModelProperty(value = "条码")
    @Column(name = "barcode", columnDefinition = "varchar(100) default null comment '条码'")
    private String barcode;

    @ApiModelProperty(value = "客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) default null  comment '客户ID'")
    private Long custId;

    @ApiModelProperty("客户组(客户等级)")
    @Column(name = "cust_group", columnDefinition = "varchar(40) comment '客户组(客户等级) [UDC]CRM:CUST_GROUP'")
    private String custGroup;

    @ApiModelProperty("销售区域")
    @Column(name = "sale_region", columnDefinition = "varchar(40) comment '销售区域 [UDC]ORG:OU_REGION'")
    private String saleRegion;

    @ApiModelProperty("从数量")
    @Column(name = "from_qty", columnDefinition = "decimal(20,8) comment '从数量'")
    private BigDecimal fromQty;

    @ApiModelProperty("到数量")
    @Column(name = "to_qty", columnDefinition = "decimal(20,8) comment '到数量'")
    private BigDecimal toQty;

    @ApiModelProperty("含税价格")
    @Column(name = "price", columnDefinition = "decimal(20,8) comment '含税价格'")
    private BigDecimal price;

    @ApiModelProperty("不含税价格")
    @Column(name = "net_price", columnDefinition = "decimal(20,8) comment '不含税价格'")
    private BigDecimal netPrice;

    @ApiModelProperty("价格1")
    @Column(name = "price1", columnDefinition = "decimal(20,8) comment '价格1'")
    private BigDecimal price1;

    @ApiModelProperty("价格2")
    @Column(name = "price2", columnDefinition = "decimal(20,8) comment '价格2'")
    private BigDecimal price2;

    @ApiModelProperty("价格3")
    @Column(name = "price3", columnDefinition = "decimal(20,8) comment '价格3'")
    private BigDecimal price3;

    @ApiModelProperty("价格4")
    @Column(name = "price4", columnDefinition = "decimal(20,8) comment '价格4'")
    private BigDecimal price4;

    @ApiModelProperty("价格5")
    @Column(name = "price5", columnDefinition = "decimal(20,8) comment '价格5'")
    private BigDecimal price5;

    @ApiModelProperty("价格6")
    @Column(name = "price6", columnDefinition = "decimal(20,8) comment '价格6'")
    private BigDecimal price6;

    @ApiModelProperty("价格7")
    @Column(name = "price7", columnDefinition = "decimal(20,8) comment '价格7'")
    private BigDecimal price7;

    @ApiModelProperty("价格8")
    @Column(name = "price8", columnDefinition = "decimal(20,8) comment '价格8'")
    private BigDecimal price8;

    @ApiModelProperty("价格9")
    @Column(name = "price9", columnDefinition = "decimal(20,8) comment '价格9'")
    private BigDecimal price9;

    @ApiModelProperty("价格10")
    @Column(name = "price10", columnDefinition = "decimal(20,8) comment '价格10'")
    private BigDecimal price10;

    @ApiModelProperty("币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10) comment '币种'")
    private String currCode;

    @ApiModelProperty("税率编号")
    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) comment '税率编号'")
    private String taxRateNo;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20,8) comment '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(10) comment '单位'")
    private String uom;

    @ApiModelProperty("价格状态")
    @Column(name = "price_status", columnDefinition = "varchar(40) comment '价格状态 [UDC]COM:STATUS_ACTIVEORNO'")
    private String priceStatus;

    @ApiModelProperty("价格来源")
    @Column(name = "price_source", columnDefinition = "varchar(40) comment '价格来源'")
    private String priceSource;

    @ApiModelProperty("来源单据类别")
    @Column(name = "src_doc_cls", columnDefinition = "varchar(40) comment '来源单据类别 [UDC]DOC_CLS 如销售价格变更单'")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @Column(name = "src_doc_id", columnDefinition = "bigint(20) comment '来来源单据ID'")
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @Column(name = "src_d_id", columnDefinition = "bigint(20) comment '来源单据明细ID'")
    private Long srcDId;

    @ApiModelProperty(value = "生效时间")
    @Column(name = "valid_from", columnDefinition = "datetime  comment '生效时间'")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效时间")
    @Column(name = "valid_to", columnDefinition = "datetime  comment '失效时间'")
    private LocalDateTime validTo;

    // 活动价格新增
    @ApiModelProperty(value = "活动价生效日期")
    @Column(name = "prom_date_f", columnDefinition = "datetime  comment '活动价生效日期'")
    private LocalDateTime promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    @Column(name = "prom_date_t", columnDefinition = "datetime  comment '活动价失效日期'")
    private LocalDateTime promDateT;

    @ApiModelProperty(value = "SAP最近更新日期")
    @Comment("SAP最近更新日期")
    @Column(name = "sap_date",columnDefinition = "datetime(6)")
    private LocalDateTime sapDate;

    @ApiModelProperty("活动含税价格")
    @Column(name = "promotion_price", columnDefinition = "decimal(20,8) comment '活动含税价格'")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    @Column(name = "promotion_net_price", columnDefinition = "decimal(20,8) comment '活动不含税价格'")
    private BigDecimal promotionNetPrice;

    // 以下字段没有
    @ApiModelProperty(value = "商品分类码")
    @Column(name = "item_cate_code", columnDefinition = "varchar(40) default null  comment '商品分类码'")
    private String itemCateCode;

    @ApiModelProperty(value = "商品分类")
    @Column(name = "item_cate_path", columnDefinition = "varchar(80) default null  comment '商品分类全路径'")
    private String itemCatePath;

}
