package com.elitesland.yst.production.sale.ext.cpcn.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author Jason(zhao jun hui)
 * @date 2021/7/10
 */
@Data
@EqualsAndHashCode
@ApiModel(description = "中金流水下载参数")
public class CPCN4692Param implements Serializable {
    private static final long serialVersionUID = -61234287980373248L;

    @ApiModelProperty("用户ID")
    public String userId;

    @ApiModelProperty("开始日期")
    public LocalDate startDate;

    @ApiModelProperty("结束日期")
    public LocalDate endDate;

    @ApiModelProperty("分页号")
    public String pageIndex;

    @ApiModelProperty("分页大小（最大 100 条）")
    public String pageSize;

}
