package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateVO;
import com.elitesland.yst.production.sale.entity.QLogisticsTemplateDDO;
import com.elitesland.yst.production.sale.entity.QLogisticsTemplateDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import jodd.util.StringUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class LogisticsTemplateDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;

    public PagingVO<LogisticsTemplateDVO> findPagingDetailResult(LogisticsTemplateDetailParam param){
        JPAQuery<LogisticsTemplateDVO> query = selectFromWhere(LogisticsTemplateDVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qLogisticsTemplateDDO);
        return PagingVO.<LogisticsTemplateDVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, LogisticsTemplateDetailParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qLogisticsTemplateDDO.id,
                qLogisticsTemplateDDO.templateId,
                qLogisticsTemplateDDO.linNo,
                qLogisticsTemplateDDO.mode,
                qLogisticsTemplateDDO.area,
                qLogisticsTemplateDDO.provinceName,
                qLogisticsTemplateDDO.provinceCode,
                qLogisticsTemplateDDO.cityName,
                qLogisticsTemplateDDO.cityCode,
                qLogisticsTemplateDDO.pieceNumber,
                qLogisticsTemplateDDO.defFreight,
                qLogisticsTemplateDDO.continuypieceNumber,
                qLogisticsTemplateDDO.addFreight,
                qLogisticsTemplateDDO.remark)).from(qLogisticsTemplateDDO).where(where(param));
    }


    public Predicate where(LogisticsTemplateDetailParam param){
        List<Predicate> predicate = new ArrayList<>();
        predicate.add(qLogisticsTemplateDDO.templateId.eq(param.getTemplateId()));
        predicate.add(qLogisticsTemplateDDO.deleteFlag.isNull().or(qLogisticsTemplateDDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }

}
